/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.wbs;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.EnableEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsListPlugin;

public class WBSF7ListPlugin
extends AbstractPmbsListPlugin
implements CellClickListener {
    private static Log logger = LogFactory.getLog(WBSF7ListPlugin.class);
    public static final String KEY_TREEENTRYENTITY = "wbsentity";
    public static final String WBS_ID = "wbsid";
    public static final String SELECTED_FIELDS = "id,number,name,isleaf,enable,parent,level";
    private static final String OPERATE_CLOSE = "close";
    private static final String RETURN_DATA = "returnwbs";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getControl(KEY_TREEENTRYENTITY) != null) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
            grid.addCellClickListener((CellClickListener)this);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (this.getPageCache().get("initfilter") == null) {
            this.getPageCache().put("initfilter", SerializationUtils.toJsonString((Object)qFilters));
        } else {
            qFilters.addAll(SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("initfilter"), QFilter.class));
        }
        if (this.getView().getControl(KEY_TREEENTRYENTITY) != null) {
            this.initList(qFilters);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ((FilterColumn)commonFilterColumns.get(0)).setDefaultValue(null);
    }

    private void initList(List<QFilter> qFilters) {
        logger.info(String.format("wbs \u67e5\u8be2\u8fc7\u6ee4\u6761\u4ef6%s", qFilters));
        this.getModel().deleteEntryData(KEY_TREEENTRYENTITY);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.Enable.toString());
        qFilters.add(enableFilter);
        DynamicObject[] wbsArr = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)SELECTED_FIELDS, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"order");
        if (wbsArr == null || wbsArr.length == 0) {
            logger.info("\u65e0\u6cd5\u67e5\u8be2\u5230 wbs \u6570\u636e");
            this.getView().updateView(KEY_TREEENTRYENTITY);
            return;
        }
        logger.info(String.format("\u67e5\u8be2\u51fa\u6765\u7684 wbs \u6570\u636e\uff1a%s", wbsArr.length));
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        DynamicObjectType dt = entries.getDynamicObjectType();
        HashMap<Long, ArrayList<DynamicObject>> childMap = new HashMap<Long, ArrayList<DynamicObject>>();
        ArrayList<DynamicObject> firstLevelList = new ArrayList<DynamicObject>();
        this.buildDataRelationship(wbsArr, firstLevelList, childMap);
        for (DynamicObject firstLevelData : firstLevelList) {
            this.recursiveAddEntry(entries, dt, firstLevelData, childMap);
        }
        this.getModel().updateEntryCache(entries);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        this.getView().updateView(KEY_TREEENTRYENTITY);
    }

    private void recursiveAddEntry(DynamicObjectCollection entries, DynamicObjectType dt, DynamicObject data, Map<Long, ArrayList<DynamicObject>> childMap) {
        this.addEntryData(entries, dt, data);
        ArrayList<DynamicObject> childList = childMap.get(data.getLong("id"));
        if (childList != null && childList.size() > 0) {
            for (DynamicObject child : childList) {
                this.recursiveAddEntry(entries, dt, child, childMap);
            }
        }
    }

    private void addEntryData(DynamicObjectCollection entries, DynamicObjectType dt, DynamicObject data) {
        DynamicObject entry = new DynamicObject(dt);
        entry.set("id", data.getPkValue());
        entry.set("number", data.get("number"));
        entry.set("name", data.get("name"));
        entry.set("enable", data.get("enable"));
        DynamicObject parent = data.getDynamicObject("parent");
        entry.set("pid", parent == null ? Long.valueOf(0L) : parent.getPkValue());
        entries.add((Object)entry);
    }

    private void buildDataRelationship(DynamicObject[] wbsList, List<DynamicObject> firstLevelList, Map<Long, ArrayList<DynamicObject>> childMap) {
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject wbs : wbsList) {
            dataMap.put(wbs.getLong("id"), wbs);
        }
        HashSet<Long> hasAddedSet = new HashSet<Long>();
        for (DynamicObject wbs : wbsList) {
            this.recursiveAddData(wbs, firstLevelList, childMap, hasAddedSet, dataMap);
        }
    }

    private void recursiveAddData(DynamicObject wbs, List<DynamicObject> firstLevelList, Map<Long, ArrayList<DynamicObject>> childMap, Set<Long> hasAddedSet, Map<Long, DynamicObject> dataMap) {
        long id = wbs.getLong("id");
        if (!hasAddedSet.contains(id)) {
            long parentId;
            long l = parentId = wbs.getDynamicObject("parent") == null ? 0L : (Long)wbs.getDynamicObject("parent").getPkValue();
            if (parentId == 0L) {
                firstLevelList.add(wbs);
            } else {
                ArrayList<Object> childList = childMap.get(parentId);
                if (childList == null) {
                    childList = new ArrayList();
                    childMap.put(parentId, childList);
                }
                childList.add(wbs);
                DynamicObject parent = dataMap.get(parentId);
                if (parent == null) {
                    parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"pmbs_wbs");
                }
                this.recursiveAddData(parent, firstLevelList, childMap, hasAddedSet, dataMap);
            }
            hasAddedSet.add(wbs.getLong("id"));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (this.getView().getControl(KEY_TREEENTRYENTITY) != null) {
            ArrayList<Long> pkList = new ArrayList<Long>();
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
            int[] selectRows = grid.getSelectRows();
            DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
            if (selectRows != null && (selectRows.length != 1 || selectRows[0] != -1)) {
                for (int rowIndex : selectRows) {
                    pkList.add(((DynamicObject)gridRows.get(rowIndex)).getLong("id"));
                }
            }
            DynamicObject[] wbsArr = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
            switch (operateKey) {
                case "returnwbs": {
                    if (selectRows == null || selectRows.length == 0) {
                        this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"WBSF7ListPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                    boolean multiSelect = listShowParameter.isMultiSelect();
                    if (!multiSelect && selectRows.length > 1) {
                        this.getView().showMessage(ResManager.loadKDStringExt((String)"\u53ea\u80fd\u9009\u4e2d1\u884c\u3002", (String)"WBSF7ListPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    ListSelectedRowCollection returnData = new ListSelectedRowCollection();
                    for (DynamicObject row : wbsArr) {
                        ListSelectedRow returnProjectKind = new ListSelectedRow(row.getPkValue(), Boolean.TRUE);
                        returnData.add((Object)returnProjectKind);
                    }
                    this.getView().returnDataToParent((Object)returnData);
                    this.getView().invokeOperation(OPERATE_CLOSE);
                    break;
                }
            }
        }
    }

    public void cellClick(CellClickEvent arg0) {
        JSONArray excludeWbs;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isMultiSelect = listShowParameter.isMultiSelect();
        TreeEntryGrid grid = (TreeEntryGrid)arg0.getSource();
        int clickRow = arg0.getRow();
        int[] selectRows = grid.getSelectRows();
        if (!isMultiSelect && selectRows != null && selectRows.length > 0) {
            grid.selectRows(new int[]{clickRow}, clickRow);
        }
        if ((excludeWbs = (JSONArray)listShowParameter.getCustomParam("excludeWbs")) != null) {
            DynamicObjectCollection wbsEntity = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
            selectRows = grid.getSelectRows();
            ArrayList<Integer> newSelectRowsList = new ArrayList<Integer>(10);
            for (int selectRow : selectRows) {
                boolean addToNewSelectRowsList = true;
                for (Object exclude : excludeWbs) {
                    Object selectRowPK = ((DynamicObject)wbsEntity.get(selectRow)).getPkValue();
                    if (Long.parseLong(selectRowPK.toString()) != Long.parseLong(exclude.toString())) continue;
                    addToNewSelectRowsList = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5WBS\u6b63\u5728\u6c47\u62a5\uff0c\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u3002", (String)"WBSF7ListPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!addToNewSelectRowsList) continue;
                newSelectRowsList.add(selectRow);
            }
            int[] newSelectRows = newSelectRowsList.stream().mapToInt(Integer::intValue).toArray();
            grid.selectRows(newSelectRows, -1);
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

