/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;

public class ProjectValidateOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String operateKey = this.getOperateKey();
                    String result = null;
                    switch (operateKey) {
                        case "submit": {
                            result = ProjectValidateOp.this.validateSubmit(dataEntity);
                            break;
                        }
                        case "unsubmit": {
                            result = ProjectValidateOp.this.validateUnSubmit(dataEntity);
                            break;
                        }
                        case "audit": {
                            result = ProjectValidateOp.this.validateAudit(dataEntity);
                            break;
                        }
                        case "unaudit": {
                            result = ProjectValidateOp.this.validateUnAudit(dataEntity);
                            break;
                        }
                    }
                    if (!StringUtils.isNotBlank(result)) continue;
                    this.addErrorMessage(dataEntity, result);
                }
            }
        });
    }

    protected String validateUnAudit(ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        String result = this.validateProjectStatus(model);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this.validateEntryProjectStatus(null, model);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"ProjectValidateOp_0", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), result);
        }
        return null;
    }

    protected String validateAudit(ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        String result = this.validateProjectStatus(model);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this.validateEntryProjectStatus(null, model);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u52ff\u5ba1\u6838\u3002", (String)"ProjectValidateOp_1", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), result);
        }
        return null;
    }

    protected String validateUnSubmit(ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        String result = this.validateProjectStatus(model);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this.validateEntryProjectStatus(null, model);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u52ff\u64a4\u9500\u3002", (String)"ProjectValidateOp_2", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), result);
        }
        return null;
    }

    protected String validateSubmit(ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        String result = this.validateProjectStatus(model);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this.validateEntryProjectStatus(null, model);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u52ff\u63d0\u4ea4\u3002", (String)"ProjectValidateOp_3", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), result);
        }
        return null;
    }

    protected String validateProjectStatus(DynamicObject model) {
        if (null == model.getDynamicObjectType().getProperty("project")) {
            return null;
        }
        DynamicObject project = model.getDynamicObject("project");
        String number = model.getString("billno");
        if (null == project) {
            return null;
        }
        DynamicObject proStatus = project.getDynamicObject("prostatus");
        if (null != proStatus && StringUtils.equalsIgnoreCase((CharSequence)proStatus.getString("number"), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\uff0c\u5df2\u7ecf\u8d22\u52a1\u5173\u95ed\u3002", (String)"ProjectValidateOp_4", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), number, project.getString("name"));
        }
        if (null != proStatus && StringUtils.equalsIgnoreCase((CharSequence)proStatus.getString("number"), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue())) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\uff0c\u5df2\u7ecf\u4e1a\u52a1\u5173\u95ed\u3002", (String)"ProjectValidateOp_5", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), number, project.getString("name"));
        }
        return null;
    }

    protected String validateEntryProjectStatus(String entryFieldKey, DynamicObject model) {
        String number = model.getString("billno");
        if (StringUtils.isBlank((CharSequence)entryFieldKey)) {
            entryFieldKey = "projectentry";
        }
        if (null == model.getDynamicObjectType().getProperty(entryFieldKey)) {
            return null;
        }
        DynamicObjectCollection entrys = model.getDynamicObjectCollection(entryFieldKey);
        if (null == entrys.getDynamicObjectType().getProperty("project")) {
            return null;
        }
        for (DynamicObject entry : entrys) {
            DynamicObject project = entry.getDynamicObject("project");
            if (null == project) {
                return null;
            }
            DynamicObject proStatus = project.getDynamicObject("prostatus");
            if (null != proStatus && StringUtils.equalsIgnoreCase((CharSequence)proStatus.getString("number"), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\uff0c\u5df2\u7ecf\u8d22\u52a1\u5173\u95ed\u3002", (String)"ProjectValidateOp_4", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), number, project.getString("name"));
            }
            if (null == proStatus || !StringUtils.equalsIgnoreCase((CharSequence)proStatus.getString("number"), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue())) continue;
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\uff0c\u5df2\u7ecf\u4e1a\u52a1\u5173\u95ed\u3002", (String)"ProjectValidateOp_5", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), number, project.getString("name"));
        }
        return null;
    }
}

