/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.opplugin.budget;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class ReportOrfgOp
extends AbstractOperationServicePlugIn {
    private static final String OPERATE_DELETE = "delete";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("description");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("billcode");
        e.getFieldKeys().add("reportorg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey;
                switch (operateKey = this.getOperateKey()) {
                    case "save": {
                        this.validateAddGlobalConfig();
                        break;
                    }
                }
            }

            private void validateAddGlobalConfig() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Object billCode = dataEntity.getDataEntity().get("billcode");
                    if (billCode != null) continue;
                    QFilter billCodeFilter = new QFilter("billcode", "=", (Object)"");
                    QFilter idFilter = new QFilter("id", "!=", dataEntity.getBillPkId());
                    DynamicObject[] globalConfigList = BusinessDataServiceHelper.load((String)"pmbs_reqorgconf", (String)"id,name", (QFilter[])new QFilter[]{billCodeFilter, idFilter});
                    if (globalConfigList.length <= 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u8bbe\u7f6e\u8bb0\u5f55\uff0c\u8bf7\u8c03\u6574\u5df2\u6709\u8bbe\u7f6e\u8bb0\u5f55\u3002", (String)"ReportOrfgOp_0", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] dynamicObjects = e.getDataEntities();
        switch (operateKey) {
            case "delete": {
                Object[] datas = new Object[dynamicObjects.length];
                int i = 0;
                for (DynamicObject dy : dynamicObjects) {
                    datas[i] = dy.getPkValue();
                    ++i;
                }
                DeleteServiceHelper.delete((IDataEntityType)dynamicObjects[0].getDataEntityType(), (Object[])datas);
                break;
            }
        }
    }
}

