/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.opplugin.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;

public class ContractTaxRateHistoryDataUpgradeOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        if ("contracttaxrateupgrade".equals(operateKey)) {
            this.contractTaxRateUpgrade();
        }
    }

    private void contractTaxRateUpgrade() {
        BigDecimal settledamountoftax;
        BigDecimal taxRate;
        Object detailId;
        Object[] updateParams;
        String updateSql;
        Object[] params;
        Row row;
        SqlBuilder sqlBuilder;
        Object billId;
        Row row2;
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.1";
        String selectSql = "select fid from t_pmct_contract_s where flsttaxrateid = 0 and flstavgtaxrate = 0;";
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
        ArrayList<Object> idList = new ArrayList<Object>(10);
        while (dataSet.hasNext()) {
            row2 = dataSet.next();
            billId = row2.get(0);
            if (billId == null || Long.parseLong(String.valueOf(billId)) == 0L) continue;
            idList.add(billId);
        }
        if (!idList.isEmpty()) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,ftaxrateid,favgtaxrate from t_pmct_contract where", new Object[0]);
            sqlBuilder.appendIn("fid", idList);
            algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.2";
            dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (SqlBuilder)sqlBuilder);
            while (dataSet.hasNext()) {
                row = dataSet.next();
                params = new Object[3];
                Object billId2 = row.get(0);
                Object rate = row.get(1);
                Object avgRate = row.get(2);
                if (billId2 == null || Long.parseLong(String.valueOf(billId2)) == 0L) continue;
                params[0] = rate;
                params[1] = avgRate;
                params[2] = billId2;
                paramsList.add(params);
            }
        }
        if (paramsList.size() > 0) {
            updateSql = "update t_pmct_contract_s set flsttaxrateid = ?, flstavgtaxrate = ? where fid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, paramsList);
        }
        selectSql = "select fdetailid,flstoftaxamount,flstsettleoftaxamount,ftaxrate from t_pmct_listentry where flatestamount = 0;";
        algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.3";
        dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        paramsList.clear();
        while (dataSet.hasNext()) {
            row2 = dataSet.next();
            updateParams = new Object[3];
            detailId = row2.get(0);
            BigDecimal lstOfTaxAmount = row2.getBigDecimal(1);
            BigDecimal lstSettleOfTaxAmount = row2.getBigDecimal(2);
            taxRate = row2.getBigDecimal(3);
            if (detailId == null || Long.parseLong(String.valueOf(detailId)) == 0L) continue;
            updateParams[0] = lstOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP)), 10, RoundingMode.HALF_UP);
            BigDecimal lstSettleAmt = lstSettleOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP)), 10, RoundingMode.HALF_UP);
            updateParams[1] = lstSettleOfTaxAmount.subtract(lstSettleAmt);
            updateParams[2] = detailId;
            paramsList.add(updateParams);
        }
        if (paramsList.size() > 0) {
            updateSql = "update t_pmct_listentry set flatestamount = ?, flstsettletaxamt = ? where fdetailid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, paramsList);
        }
        selectSql = "select fdetailid,fentryid,ftaxrate1,fyijiesuanhsje from t_pmct_revisionsubentry;";
        algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.4";
        dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        paramsList.clear();
        idList.clear();
        while (dataSet.hasNext()) {
            row2 = dataSet.next();
            billId = row2.get(0);
            if (billId == null || Long.parseLong(String.valueOf(billId)) == 0L) continue;
            idList.add(billId);
        }
        if (!idList.isEmpty()) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fdetailid from t_pmct_revisionsubentry_a where", new Object[0]);
            sqlBuilder.appendIn("fdetailid", idList);
            algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.5";
            dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (SqlBuilder)sqlBuilder);
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Object billId3 = row.get(0);
                if (billId3 == null || Long.parseLong(String.valueOf(billId3)) == 0L) continue;
                idList.remove(billId3);
            }
        }
        if (!idList.isEmpty()) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fdetailid,fentryid,ftaxrate1,fyijiesuanhsje from t_pmct_revisionsubentry where", new Object[0]);
            sqlBuilder.appendIn("fdetailid", idList);
            algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.6";
            dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (SqlBuilder)sqlBuilder);
            while (dataSet.hasNext()) {
                row = dataSet.next();
                params = new Object[3];
                Object detailId2 = row.get(0);
                Object entryId = row.get(1);
                taxRate = row.getBigDecimal(2);
                BigDecimal settledAmountOfTax = row.getBigDecimal(3);
                if (detailId2 == null || Long.parseLong(String.valueOf(detailId2)) == 0L) continue;
                params[0] = detailId2;
                params[1] = entryId;
                BigDecimal settledAmount = settledAmountOfTax.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP)), 10, RoundingMode.HALF_UP);
                params[2] = settledAmountOfTax.subtract(settledAmount);
                paramsList.add(params);
            }
        }
        if (paramsList.size() > 0) {
            String insertSql = "insert into t_pmct_revisionsubentry_a(fdetailid,fentryid,fsettledtaxamt) values(?,?,?);";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)insertSql, paramsList);
        }
        selectSql = "select fdetailid,fsubtaxrate,fsettledamountoftax from t_pmct_addlistentry where fsettledamountoftax != 0 and fsettledtaxamt = 0;";
        algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.7";
        dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        paramsList.clear();
        while (dataSet.hasNext()) {
            row2 = dataSet.next();
            updateParams = new Object[2];
            detailId = row2.get(0);
            BigDecimal taxRate2 = row2.getBigDecimal(1);
            settledamountoftax = row2.getBigDecimal(2);
            if (detailId == null || Long.parseLong(String.valueOf(detailId)) == 0L) continue;
            BigDecimal settledAmount = settledamountoftax.divide(BigDecimal.ONE.add(taxRate2.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP)), 10, RoundingMode.HALF_UP);
            updateParams[0] = settledamountoftax.subtract(settledAmount);
            updateParams[1] = detailId;
            paramsList.add(updateParams);
        }
        if (paramsList.size() > 0) {
            updateSql = "update t_pmct_addlistentry set fsettledtaxamt = ? where fdetailid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, paramsList);
        }
        selectSql = "select fdetailid,fsubtaxrate,fsettledoftaxamount from t_pmct_claimsubentry where fsettledoftaxamount != 0 and fsettledtaxamt = 0;";
        algoKey = ((Object)((Object)this)).getClass().getName() + ".contractTaxRateUpgrade.8";
        dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        paramsList.clear();
        while (dataSet.hasNext()) {
            row2 = dataSet.next();
            updateParams = new Object[2];
            Object detailid = row2.get(0);
            BigDecimal taxrate = row2.getBigDecimal(1);
            settledamountoftax = row2.getBigDecimal(2);
            if (detailid == null || Long.parseLong(String.valueOf(detailid)) == 0L) continue;
            BigDecimal settledamount = settledamountoftax.divide(BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP)), 10, RoundingMode.HALF_UP);
            updateParams[0] = settledamountoftax.subtract(settledamount);
            updateParams[1] = detailid;
            paramsList.add(updateParams);
        }
        if (paramsList.size() > 0) {
            updateSql = "update t_pmct_claimsubentry set fsettledtaxamt = ? where fdetailid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, paramsList);
        }
    }
}

