/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.opplugin.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProBudgetRelationOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("controltype");
        e.getFieldKeys().add("budgetmappingdetail");
        e.getFieldKeys().add("probudget");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String operationKey = this.getOperateKey();
                for (ExtendedDataEntity dataEntry : dataEntities) {
                    DynamicObject project;
                    DynamicObject bill = dataEntry.getDataEntity();
                    if (!OperationEnum.SUBMIT.getValue().equals(operationKey) || (project = bill.getDynamicObject("project")) == null) continue;
                    Long projectId = Long.parseLong(project.getPkValue().toString());
                    QFilter qFilter = new QFilter("project", "=", (Object)projectId);
                    qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    qFilter.and("id", "!=", (Object)Long.parseLong(bill.getPkValue().toString()));
                    if (!QueryServiceHelper.exists((String)"pmbs_budgetrelationmap", (QFilter[])new QFilter[]{qFilter})) continue;
                    this.addErrorMessage(dataEntry, String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\u5df2\u5b58\u5728\u9879\u76ee\u9884\u7b97\u9879\u5173\u7cfb\u6620\u5c04\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6620\u5c04\u3002", (String)"ProBudgetRelationOpPlugin_0", (String)"pmgt-pmbs-opplugin", (Object[])new Object[0]), project.getString("name")));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)OperationEnum.AUDIT.getValue(), (CharSequence)operationKey) || StringUtils.equals((CharSequence)OperationEnum.UNAUDIT.getValue(), (CharSequence)operationKey)) {
            ArrayList<DynamicObject> updateBudgetBills = new ArrayList<DynamicObject>();
            for (DynamicObject bill : bills) {
                QFilter qFilter;
                DynamicObjectCollection details;
                DynamicObject project = bill.getDynamicObject("project");
                if (project == null || (details = bill.getDynamicObjectCollection("budgetmappingdetail")).isEmpty()) continue;
                String controlType = bill.getString("controltype");
                if (StringUtils.equals((CharSequence)controlType, (CharSequence)ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue()) || StringUtils.equals((CharSequence)controlType, (CharSequence)ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) {
                    DynamicObjectCollection treeEntityColl;
                    qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("isvalid", "=", (Object)true);
                    qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
                    DynamicObject totalBudgetBill = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudget", (QFilter[])new QFilter[]{qFilter});
                    if (totalBudgetBill == null || (treeEntityColl = totalBudgetBill.getDynamicObjectCollection("treeentryentity")).isEmpty()) continue;
                    for (DynamicObject treeEntity : treeEntityColl) {
                        if (StringUtils.equals((CharSequence)OperationEnum.AUDIT.getValue(), (CharSequence)operationKey)) {
                            String entryId = treeEntity.getPkValue().toString();
                            Optional<DynamicObject> first = details.stream().filter(o -> StringUtils.equals((CharSequence)o.getPkValue().toString(), (CharSequence)entryId)).findFirst();
                            if (!first.isPresent()) continue;
                            DynamicObject proBudget = first.get().getDynamicObject("probudget");
                            treeEntity.set("projectbudgetitem", (Object)proBudget);
                            continue;
                        }
                        treeEntity.set("projectbudgetitem", null);
                    }
                    updateBudgetBills.add(totalBudgetBill);
                    continue;
                }
                qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                qFilter.and("isvalid", "=", (Object)true);
                qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                DynamicObject[] outBudgetBills = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (outBudgetBills.length == 0) continue;
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_outbudget");
                for (DynamicObject outBudgetBill : outBudgetBills = BusinessDataServiceHelper.load((Object[])Arrays.stream(outBudgetBills).map(DataEntityBase::getPkValue).distinct().toArray(), (DynamicObjectType)dt)) {
                    DynamicObjectCollection treeEntityColl = outBudgetBill.getDynamicObjectCollection("treeentryentity");
                    if (treeEntityColl.isEmpty()) continue;
                    for (DynamicObject treeEntity : treeEntityColl) {
                        if (StringUtils.equals((CharSequence)OperationEnum.AUDIT.getValue(), (CharSequence)operationKey)) {
                            String entryId = treeEntity.getPkValue().toString();
                            Optional<DynamicObject> first = details.stream().filter(o -> StringUtils.equals((CharSequence)o.getPkValue().toString(), (CharSequence)entryId)).findFirst();
                            if (!first.isPresent()) continue;
                            DynamicObject proBudget = first.get().getDynamicObject("probudget");
                            treeEntity.set("projectbudgetitem", (Object)proBudget);
                            continue;
                        }
                        treeEntity.set("projectbudgetitem", null);
                    }
                    updateBudgetBills.add(outBudgetBill);
                }
            }
            if (updateBudgetBills.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateBudgetBills.toArray(new DynamicObject[0]));
            }
        }
    }
}

