/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.budget.BudgetRegModel;
import kd.pmgt.pmbs.common.budget.BudgetRegValue;
import kd.pmgt.pmbs.common.budget.CommonBudgetParam;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.IdentifyValueEnum;
import org.apache.commons.collections4.CollectionUtils;

public class BudgetParam
extends CommonBudgetParam {
    private static final Log logger = LogFactory.getLog(BudgetParam.class);
    public DynamicObject bill;
    public List<BudgetRegValue> budgetRegValues;
    public List<BudgetRegModel> budgetRegModels;
    public DynamicObject[] bgControlBizRegArray;
    public DynamicObject regBillInfo;

    public BudgetParam(DynamicObject regBillInfo, DynamicObject[] bgControlBizRegArray, DynamicObject bill, Operation operation, String budgetAction) {
        this.regBillInfo = regBillInfo;
        this.bgControlBizRegArray = bgControlBizRegArray;
        this.bill = bill;
        if (operation != null) {
            this.op = operation;
            this.operation = operation.getKey();
            this.budgetAction = budgetAction;
        }
    }

    public List<BudgetRegModel> getBudgetRegModels() {
        if (CollectionUtils.isEmpty(this.budgetRegModels)) {
            Optional<DynamicObject> first;
            this.budgetRegModels = new ArrayList<BudgetRegModel>(16);
            String projectFieldKey = null;
            if (this.bgControlBizRegArray.length > 0 && (first = Arrays.stream(this.bgControlBizRegArray).filter(o -> StringUtils.equals((CharSequence)o.getString("type"), (CharSequence)BillFieldTypeEnum.PROJECT.getNumber())).findFirst()).isPresent()) {
                projectFieldKey = first.get().getString("number");
            }
            String amtKey = null;
            String amtIdentify = null;
            String amtFormula = null;
            for (DynamicObject item : this.bgControlBizRegArray) {
                BudgetRegModel budgetRegModel = new BudgetRegModel();
                BillFieldTypeEnum fieldType = BillFieldTypeEnum.getEnumByNumber(item.getString("type"));
                budgetRegModel.setFieldType(fieldType);
                String identify = item.getString("identify");
                budgetRegModel.setIdentify(identify);
                if (BillFieldTypeEnum.AMOUNT.getNumber().equals(fieldType.getNumber())) {
                    amtIdentify = identify;
                    if (IdentifyValueEnum.SOURCEBILLFIELD.getValue().equals(identify)) {
                        amtKey = item.getString("number");
                    } else if (IdentifyValueEnum.FORMULA.getValue().equals(identify)) {
                        amtFormula = item.getString("fieldformula");
                    }
                }
                if (IdentifyValueEnum.SOURCEBILLFIELD.getValue().equals(identify)) {
                    String fieldKey = item.getString("number");
                    budgetRegModel.setFieldRegKey(fieldKey);
                } else if (IdentifyValueEnum.FORMULA.getValue().equals(identify)) {
                    String formula = item.getString("fieldformula");
                    budgetRegModel.setFormula(formula);
                }
                String value = item.getString("defaultvalue");
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)value, CRFormula.class);
                    budgetRegModel.setDefaultValue(formula.getExpression());
                }
                if (!StringUtils.isNotEmpty((CharSequence)projectFieldKey)) continue;
                this.setFieldRegValue(budgetRegModel, projectFieldKey);
                this.budgetRegModels.add(budgetRegModel);
            }
            if (StringUtils.isNotEmpty(amtIdentify)) {
                BudgetRegModel budgetRegModel = new BudgetRegModel();
                budgetRegModel.setFieldType(BillFieldTypeEnum.getEnumByNumber("ENTRYID"));
                budgetRegModel.setIdentify(amtIdentify);
                if (StringUtils.isNotEmpty(amtKey)) {
                    budgetRegModel.setFieldRegKey(amtKey);
                }
                if (StringUtils.isNotEmpty(amtFormula)) {
                    budgetRegModel.setFormula(amtFormula);
                }
                if (StringUtils.isNotEmpty((CharSequence)projectFieldKey)) {
                    this.setFieldRegValue(budgetRegModel, projectFieldKey);
                    this.budgetRegModels.add(budgetRegModel);
                }
            }
        }
        return this.budgetRegModels;
    }

    protected String getBizRegKey(BillFieldTypeEnum fieldType) {
        String bizFieldRegKey = null;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.bill.getDynamicObjectType().getName());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (StringUtils.equals((CharSequence)BillFieldTypeEnum.BILL_NAME.getNumber(), (CharSequence)fieldType.getNumber())) {
            for (IDataEntityProperty item : properties) {
                DynamicProperty property = (DynamicProperty)item;
                if (!Arrays.asList("billname", "name").contains(property.getName())) continue;
                bizFieldRegKey = property.getName();
                break;
            }
        } else if (StringUtils.equals((CharSequence)BillFieldTypeEnum.BILL_NO.getNumber(), (CharSequence)fieldType.getNumber())) {
            for (IDataEntityProperty item : properties) {
                DynamicProperty property = (DynamicProperty)item;
                if (!Arrays.asList("billno", "number").contains(property.getName())) continue;
                bizFieldRegKey = property.getName();
                break;
            }
        }
        if (StringUtils.equals((CharSequence)BillFieldTypeEnum.BILL_NAME.getNumber(), (CharSequence)fieldType.getNumber()) && bizFieldRegKey == null) {
            bizFieldRegKey = this.getBizRegKey(BillFieldTypeEnum.BILL_NO);
        }
        return bizFieldRegKey;
    }

    public List<BudgetRegValue> getBudgetRegValues() {
        if (CollectionUtils.isEmpty(this.budgetRegValues)) {
            DynamicObject projectBudget;
            DynamicObject project;
            BudgetRegValue budgetRegValue;
            Object budget;
            List<BudgetRegModel> budgetRegModels = this.getBudgetRegModels();
            List<Object> projectValueList = new ArrayList();
            int projectValueSize = 0;
            List<Object> budgetValueList = new ArrayList();
            int budgetValueSize = 0;
            List<Object> periodValueList = new ArrayList();
            int periodValueSize = 0;
            List<Object> currencyValueList = new ArrayList();
            int currencyValueSize = 0;
            List<Object> amountValueList = new ArrayList();
            int amountValueSize = 0;
            List<Object> entryIdValueList = new ArrayList();
            int entryIdValueSize = 0;
            List<Object> budgetTypeValueList = new ArrayList();
            int budgetTypeValueSize = 0;
            for (BudgetRegModel model : budgetRegModels) {
                if (model == null) continue;
                String fieldType = model.getFieldType().getNumber();
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.PROJECT.getNumber())) {
                    projectValueList = model.getFieldValue();
                    if (projectValueList == null || projectValueList.size() == 0) {
                        projectValueList = new ArrayList();
                        projectValueList.add(model.getDefaultValue());
                    }
                    projectValueSize = projectValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.BUDGET.getNumber())) {
                    budgetValueList = model.getFieldValue();
                    if (budgetValueList == null || budgetValueList.size() == 0) {
                        budgetValueList = new ArrayList();
                        budget = model.getDefaultValue();
                        QFilter filter = budget instanceof String ? new QFilter("budgetitem", "=", (Object)Long.parseLong(budget.toString())) : new QFilter("budgetitem", "=", budget);
                        DynamicObject projectBudget2 = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{filter});
                        if (projectBudget2 != null) {
                            budgetValueList.add(projectBudget2);
                        }
                    }
                    budgetValueSize = budgetValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.PERIOD.getNumber())) {
                    periodValueList = model.getFieldValue();
                    if (periodValueList == null || periodValueList.size() == 0) {
                        periodValueList = new ArrayList();
                        periodValueList.add(model.getDefaultValue());
                    }
                    periodValueSize = periodValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.CURRENCY.getNumber())) {
                    currencyValueList = model.getFieldValue();
                    if (currencyValueList == null || currencyValueList.size() == 0) {
                        currencyValueList = new ArrayList();
                        currencyValueList.add(model.getDefaultValue());
                    }
                    currencyValueSize = currencyValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.AMOUNT.getNumber())) {
                    amountValueList = model.getFieldValue();
                    if (amountValueList == null || amountValueList.size() == 0) {
                        amountValueList = new ArrayList();
                        amountValueList.add(model.getDefaultValue());
                    }
                    amountValueSize = amountValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.ENTRYID.getNumber())) {
                    entryIdValueList = model.getFieldValue();
                    if (entryIdValueList == null || entryIdValueList.size() == 0) {
                        entryIdValueList = new ArrayList();
                        entryIdValueList.add(model.getDefaultValue());
                    }
                    entryIdValueSize = entryIdValueList.size();
                }
                if (!fieldType.equalsIgnoreCase(BillFieldTypeEnum.BUDGETTYPE.getNumber())) continue;
                budgetTypeValueList = model.getFieldValue();
                if (budgetTypeValueList == null || budgetTypeValueList.size() == 0) {
                    budgetTypeValueList = new ArrayList();
                    budgetTypeValueList.add(model.getDefaultValue());
                }
                budgetTypeValueSize = budgetTypeValueList.size();
            }
            if (projectValueList.size() == 0) {
                return this.budgetRegValues;
            }
            this.budgetRegValues = new ArrayList<BudgetRegValue>();
            if (projectValueSize >= budgetValueSize) {
                for (int i = 0; i < projectValueSize; ++i) {
                    budgetRegValue = new BudgetRegValue();
                    project = (DynamicObject)projectValueList.get(i);
                    if (project == null) continue;
                    budgetRegValue.setProjectValue(project);
                    if (budgetValueSize == 0) {
                        budgetRegValue.setBudgetValue(null);
                    } else if (budgetValueSize == 1) {
                        budget = (DynamicObject)budgetValueList.get(0);
                        if (budget != null) {
                            projectBudget = this.getBudgetValue(budget, project);
                            budgetRegValue.setBudgetValue(projectBudget);
                        }
                    } else {
                        budget = (DynamicObject)budgetValueList.get(i);
                        if (budget != null) {
                            projectBudget = this.getBudgetValue(budget, project);
                            budgetRegValue.setBudgetValue(projectBudget);
                        }
                    }
                    this.budgetRegValues.add(budgetRegValue);
                }
            } else if (budgetValueList.size() > 0) {
                for (int i = 0; i < budgetValueSize; ++i) {
                    budgetRegValue = new BudgetRegValue();
                    budgetRegValue.setProjectValue((DynamicObject)projectValueList.get(0));
                    project = (DynamicObject)projectValueList.get(0);
                    if (project == null) continue;
                    budget = (DynamicObject)budgetValueList.get(i);
                    if (budget != null) {
                        projectBudget = this.getBudgetValue(budget, project);
                        budgetRegValue.setBudgetValue(projectBudget);
                    }
                    this.budgetRegValues.add(budgetRegValue);
                }
            }
            for (int i = 0; i < this.budgetRegValues.size(); ++i) {
                Object currencyObj;
                Object period;
                if (periodValueSize != 0 && (period = periodValueSize == 1 ? periodValueList.get(0) : periodValueList.get(i)) != null) {
                    Date bizDate;
                    if (period instanceof DynamicObject) {
                        period = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)period).getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((DynamicObject)period).getDataEntityType().getName()));
                        bizDate = ((DynamicObject)period).getDate("begindate");
                    } else if (period instanceof Date) {
                        bizDate = (Date)period;
                    } else {
                        period = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(period.toString()), (String)"bd_period");
                        bizDate = ((DynamicObject)period).getDate("begindate");
                    }
                    this.budgetRegValues.get(i).setBizDateValue(bizDate);
                }
                if (currencyValueList.size() > 0 && (currencyObj = currencyValueSize == 1 ? currencyValueList.get(0) : currencyValueList.get(i)) != null) {
                    DynamicObject currency = currencyObj instanceof DynamicObject ? (DynamicObject)currencyObj : BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(currencyObj.toString()), (String)"bd_currency");
                    this.budgetRegValues.get(i).setCurrencyValue(currency);
                }
                if (amountValueList.size() > 0) {
                    if (amountValueSize == 1) {
                        this.budgetRegValues.get(i).setAmountValue(amountValueList.get(0) == null || StringUtils.isEmpty((CharSequence)amountValueList.get(0).toString()) ? BigDecimal.ZERO : new BigDecimal(amountValueList.get(0).toString()));
                    } else {
                        this.budgetRegValues.get(i).setAmountValue(amountValueList.get(i) == null || StringUtils.isEmpty((CharSequence)amountValueList.get(i).toString()) ? BigDecimal.ZERO : new BigDecimal(amountValueList.get(i).toString()));
                    }
                }
                if (entryIdValueList.size() > 0) {
                    if (entryIdValueSize == 1) {
                        this.budgetRegValues.get(i).setEntryId(entryIdValueList.get(0) == null || StringUtils.isEmpty((CharSequence)entryIdValueList.get(0).toString()) ? 0L : Long.parseLong(entryIdValueList.get(0).toString()));
                    } else {
                        this.budgetRegValues.get(i).setEntryId(entryIdValueList.get(i) == null || StringUtils.isEmpty((CharSequence)entryIdValueList.get(i).toString()) ? 0L : Long.parseLong(entryIdValueList.get(i).toString()));
                    }
                }
                if (budgetTypeValueList.size() <= 0) continue;
                if (budgetTypeValueSize == 1) {
                    this.budgetRegValues.get(i).setBudgetTypeValue(BudgetSourceTypeEnum.getEnumByValue(budgetTypeValueList.get(0)));
                    continue;
                }
                this.budgetRegValues.get(i).setBudgetTypeValue(BudgetSourceTypeEnum.getEnumByValue(budgetTypeValueList.get(i)));
            }
        }
        return this.budgetRegValues;
    }

    protected DynamicObject getBudgetValue(Object dimMember, DynamicObject project) {
        DynamicObject dimMem = null;
        if (dimMember instanceof DynamicObject) {
            dimMem = (DynamicObject)dimMember;
            Long dimMemId = (Long)dimMem.getPkValue();
            for (DynamicObject bgControlBizReg : this.bgControlBizRegArray) {
                DynamicObject projectBudget;
                if (!StringUtils.equals((CharSequence)bgControlBizReg.getString("type"), (CharSequence)BillFieldTypeEnum.BUDGET.getNumber())) continue;
                DynamicObject budgetMapping = bgControlBizReg.getDynamicObject("budgetmapping");
                if (budgetMapping == null) break;
                QFilter filter = new QFilter("id", "=", budgetMapping.getPkValue()).and("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                if ((budgetMapping = BusinessDataServiceHelper.loadSingle((String)"pmbs_budgetmapping", (QFilter[])new QFilter[]{filter})) == null) break;
                if (project == null) continue;
                for (DynamicObject budgetMappingEntry : budgetMapping.getDynamicObjectCollection("budgetmappingentry")) {
                    DynamicObject stdBudget;
                    Long settingDimMemId = budgetMappingEntry.getLong("mappingvalue_id");
                    if (!dimMemId.equals(settingDimMemId) || (stdBudget = budgetMappingEntry.getDynamicObject("budgetitem")) == null) continue;
                    filter = new QFilter("project", "=", project.getPkValue()).and("budgetitem", "=", stdBudget.getPkValue());
                    projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (QFilter[])new QFilter[]{filter});
                    if (projectBudget == null) continue;
                    return projectBudget;
                }
                filter = new QFilter("project", "=", project.getPkValue()).and("billstatus", "=", (Object)BillStatus.C.name());
                DynamicObject projectBudgetMapping = BusinessDataServiceHelper.loadSingle((String)"pmco_probudgetmapping", (QFilter[])new QFilter[]{filter});
                if (projectBudgetMapping == null) break;
                for (DynamicObject projectBudgetMappingEntry : projectBudgetMapping.getDynamicObjectCollection("entryentity")) {
                    long projectSettingDimMemId = Long.parseLong(projectBudgetMappingEntry.getDynamicObject("mappingvalue").getPkValue().toString());
                    if (!dimMemId.equals(projectSettingDimMemId)) continue;
                    projectBudget = projectBudgetMappingEntry.getDynamicObject("probudget");
                    return projectBudget;
                }
            }
            logger.info("\u4e1a\u52a1\u5355\u636e\u7ef4\u5ea6\u6210\u5458\u3010{}\u3011\u5bf9\u5e94\u7684\u9879\u76ee\u9884\u7b97\u9879\u4e3a\u3010{}\u3011", new Object[]{dimMem.getDataEntityType().getName(), dimMem.getString("id"), dimMem.getString("name")});
        }
        return dimMem;
    }

    public CommonBudgetParam getCommonBudgetUpdateParam() {
        this.billNo = this.bill.getString(BillFieldTypeEnum.BILL_NO.getNumber());
        String billName = this.getBizRegKey(BillFieldTypeEnum.BILL_NAME);
        if (StringUtils.isNotEmpty((CharSequence)billName)) {
            this.billName = this.bill.getString(billName);
        }
        this.creator = this.bill.getDynamicObject(BillFieldTypeEnum.CREATOR.getNumber());
        this.createTime = this.bill.getDate(BillFieldTypeEnum.CREATE_TIME.getNumber());
        this.auditor = this.bill.getDynamicObject(BillFieldTypeEnum.AUDITOR.getNumber());
        this.auditTime = this.bill.getDate(BillFieldTypeEnum.AUDIT_TIME.getNumber());
        this.billId = (Long)this.bill.getPkValue();
        this.entityNumber = this.bill.getDynamicObjectType().getName();
        return this;
    }

    private void setFieldRegValue(BudgetRegModel budgetRegModel, String projectFieldKey) {
        ArrayList<Object> fieldRegValue = new ArrayList<Object>();
        String identify = budgetRegModel.getIdentify();
        String fieldType = budgetRegModel.getFieldType().getNumber();
        if (IdentifyValueEnum.SOURCEBILLFIELD.getValue().equals(identify)) {
            String fieldRegKey = budgetRegModel.getFieldRegKey();
            this.getCollectionValue(fieldRegKey, fieldRegValue, this.bill, projectFieldKey, fieldType);
            budgetRegModel.setFieldRegValue(fieldRegValue);
        } else if (IdentifyValueEnum.FORMULA.getValue().equals(identify)) {
            ArrayList<Object> values;
            String[] proFieldKeySplits = projectFieldKey.split("\\.");
            String formulaJson = budgetRegModel.getFormula();
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            String[] variables = CalcExprParser.getExprVariables((String)formula.getExpression());
            String entityId = this.bill.getDataEntityType().getName();
            boolean includeEntryField = false;
            boolean includeSubEntryField = false;
            IDataEntityType entryFather = null;
            IDataEntityType subEntryFather = null;
            for (String var : variables) {
                IDataEntityProperty property;
                IDataEntityType father;
                if (var.contains(".")) {
                    var = var.substring(0, var.indexOf("."));
                }
                if ((father = (property = EntityMetadataCache.getDataEntityType((String)entityId).findProperty(var)).getParent()).getName().equalsIgnoreCase(entityId)) continue;
                IDataEntityType grandpa = father.getParent();
                if (grandpa.getName().equalsIgnoreCase(entityId)) {
                    includeEntryField = true;
                    entryFather = father;
                    continue;
                }
                IDataEntityType grandpaFather = grandpa.getParent();
                if (!grandpaFather.getName().equalsIgnoreCase(entityId)) continue;
                includeSubEntryField = true;
                subEntryFather = father;
            }
            if (includeSubEntryField && subEntryFather != null) {
                String subEntryEntityId = subEntryFather.getName();
                String entryEntityId = subEntryFather.getParent().getName();
                DynamicObjectCollection rows = this.bill.getDynamicObjectCollection(entryEntityId);
                RowDataModel rowDataModel = new RowDataModel(subEntryEntityId, (MainEntityType)this.bill.getDataEntityType());
                values = new ArrayList<Object>();
                for (DynamicObject row : rows) {
                    Object projectValue;
                    if (proFieldKeySplits.length == 2 && (projectValue = row.get(proFieldKeySplits[1])) == null) continue;
                    DynamicObjectCollection subEntryData = row.getDynamicObjectCollection(subEntryEntityId);
                    int index = 0;
                    for (DynamicObject subEntry : subEntryData) {
                        Object projectValue2;
                        ExpressionParameter rowParameter = new ExpressionParameter(formula.getExpression(), rowDataModel);
                        rowParameter.setActiveRow((Object)subEntry);
                        rowParameter.setRowIndex(index++);
                        if (proFieldKeySplits.length == 3 && (projectValue2 = subEntry.get(proFieldKeySplits[2])) == null) continue;
                        if (BillFieldTypeEnum.ENTRYID.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                            values.add(subEntry.getPkValue());
                            continue;
                        }
                        if (BillFieldTypeEnum.BUDGET.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                            values.add(CalcExprParser.getExpressionValue((ExpressionParameter)rowParameter));
                            continue;
                        }
                        values.add(new BigDecimal(CalcExprParser.getExpressionValue((ExpressionParameter)rowParameter).toString()));
                    }
                }
                budgetRegModel.setFieldRegValue(values);
            } else if (includeEntryField && entryFather != null) {
                String entryEntityId = entryFather.getName();
                DynamicObjectCollection rows = this.bill.getDynamicObjectCollection(entryEntityId);
                RowDataModel rowDataModel = new RowDataModel(rows.getDynamicObjectType().getName(), (MainEntityType)this.bill.getDataEntityType());
                int index = 0;
                values = new ArrayList();
                for (DynamicObject row : rows) {
                    Object projectValue;
                    ExpressionParameter rowParameter = new ExpressionParameter(formula.getExpression(), rowDataModel);
                    rowParameter.setActiveRow((Object)row);
                    rowParameter.setRowIndex(index++);
                    if (proFieldKeySplits.length == 2 && (projectValue = row.get(proFieldKeySplits[1])) == null) continue;
                    if (BillFieldTypeEnum.ENTRYID.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                        values.add(row.getPkValue());
                        continue;
                    }
                    if (BillFieldTypeEnum.BUDGET.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                        values.add(CalcExprParser.getExpressionValue((ExpressionParameter)rowParameter));
                        continue;
                    }
                    values.add(new BigDecimal(CalcExprParser.getExpressionValue((ExpressionParameter)rowParameter).toString()));
                }
                budgetRegModel.setFieldRegValue(values);
            } else {
                RowDataModel dataModel = new RowDataModel(this.bill.getDynamicObjectType().getName(), (MainEntityType)this.bill.getDataEntityType());
                ExpressionParameter parameter = new ExpressionParameter(formula.getExpression(), dataModel);
                parameter.setActiveRow((Object)this.bill);
                Object v = CalcExprParser.getExpressionValue((ExpressionParameter)parameter);
                ArrayList<Object> values2 = new ArrayList<Object>();
                if (BillFieldTypeEnum.ENTRYID.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                    values2.add(0L);
                } else if (BillFieldTypeEnum.BUDGET.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                    values2.add(v);
                } else {
                    values2.add(new BigDecimal(v.toString()));
                }
                budgetRegModel.setFieldRegValue(values2);
            }
        } else if (IdentifyValueEnum.CONSTANT.getValue().equals(identify)) {
            ArrayList<Object> values = new ArrayList<Object>();
            Object value = budgetRegModel.getDefaultValue();
            if (BillFieldTypeEnum.BUDGETTYPE.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                values.add(value);
                budgetRegModel.setFieldValue(values);
            }
            if (BillFieldTypeEnum.BUDGET.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(value.toString()), (String)"pmas_projectbudget");
                values.add(budget);
                budgetRegModel.setFieldValue(values);
            }
            if (BillFieldTypeEnum.PERIOD.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(value.toString()), (String)"bd_period");
                values.add(period);
                budgetRegModel.setFieldValue(values);
            }
            if (BillFieldTypeEnum.AMOUNT.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                values.add(value);
                budgetRegModel.setFieldValue(values);
            }
            if (BillFieldTypeEnum.ENTRYID.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                values.add(0L);
                budgetRegModel.setFieldValue(values);
            }
        }
    }

    private void getCollectionValue(String fieldKey, List<Object> result, DynamicObject data, String projectFieldKey, String fieldType) {
        String[] splits = fieldKey.split("\\.");
        String[] proFieldKeySplits = projectFieldKey.split("\\.");
        if (splits.length == 1) {
            if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"ENTRYID")) {
                result.add(0L);
            } else if (StringUtils.isNotEmpty((CharSequence)splits[0])) {
                result.add(data.get(splits[0]));
            }
            return;
        }
        if (splits.length == 2) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection(splits[0]);
            for (DynamicObject entry : entries) {
                Object projectValue;
                if (proFieldKeySplits.length == 2 && (projectValue = entry.get(proFieldKeySplits[1])) == null) continue;
                if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"ENTRYID")) {
                    result.add(entry.getPkValue());
                    continue;
                }
                result.add(entry.get(splits[1]));
            }
            return;
        }
        if (splits.length == 3) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection(splits[0]);
            for (DynamicObject entry : entries) {
                Object projectValue;
                if (proFieldKeySplits.length == 2 && (projectValue = entry.get(proFieldKeySplits[1])) == null) continue;
                DynamicObjectCollection subEntries = entry.getDynamicObjectCollection(splits[1]);
                for (DynamicObject subEntry : subEntries) {
                    Object projectValue2;
                    if (proFieldKeySplits.length == 3 && (projectValue2 = subEntry.get(proFieldKeySplits[2])) == null) continue;
                    if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"ENTRYID")) {
                        result.add(subEntry.getPkValue());
                        continue;
                    }
                    result.add(subEntry.get(splits[2]));
                }
            }
        }
    }
}

