/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.enums.budgetreg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.pmgt.pmbs.common.enums.budgetreg.EnumMulHelper.BillFieldTypeEnumMulHelper;

public enum BillFieldTypeEnum {
    BUDGETTYPE(BillFieldTypeEnum.getBudgetType(), "BUDGETTYPE", 1, "field", true),
    PROJECT(BillFieldTypeEnum.getProject(), "PROJECT", 2, "field", true),
    BUDGET(BillFieldTypeEnum.getBudget(), "BUDGET", 3, "field", false),
    PERIOD(BillFieldTypeEnum.getPeriod(), "PERIOD", 4, "field", false),
    CURRENCY(BillFieldTypeEnum.getCurrency(), "CURRENCY", 5, "field", true),
    AMOUNT(BillFieldTypeEnum.getAmount(), "AMOUNT", 6, "field", true),
    ENTRYID(BillFieldTypeEnum.getEntryId(), "ENTRYID", 7, "field", false),
    BILL_NO(BillFieldTypeEnum.getBillNo(), "BILLNO", 10, "field", false),
    BILL_NAME(BillFieldTypeEnum.getBillName(), "BILLNAME", 11, "field", false),
    CREATOR(BillFieldTypeEnum.getCreator(), "CREATOR", 12, "field", false),
    CREATE_TIME(BillFieldTypeEnum.getCreateTime(), "CREATETIME", 13, "field", false),
    AUDITOR(BillFieldTypeEnum.getAuditor(), "AUDITOR", 14, "field", false),
    AUDIT_TIME(BillFieldTypeEnum.getAuditTime(), "AUDITDATE", 15, "field", false),
    CONTRACT(BillFieldTypeEnum.getContract(), "CONTRACT", 16, "field", false),
    TAKE_OPERATION(BillFieldTypeEnum.getTakeOperation(), "TAKEOPERATION", 20, "operation"),
    EXEC_OPERATION(BillFieldTypeEnum.getExecOperation(), "EXECOPERATION", 21, "operation"),
    TAKEANDEXEC_OPERATION(BillFieldTypeEnum.getTakeAndExecOperation(), "TAKEANDEXECOPERATION", 22, "operation"),
    RETURN_OPERATION(BillFieldTypeEnum.getReturnOperation(), "RETURNOPERATION", 23, "operation"),
    CLEAR_OPERATION(BillFieldTypeEnum.getClearOperation(), "CLEAROPERATION", 24, "operation"),
    RETURNANDCLEAR_OPERATION(BillFieldTypeEnum.getReturnAndClearOperation(), "RETURNANDCLEAROPERATION", 25, "operation");

    public static final String FIELD_TYPE = "field";
    public static final String OPERATION_TYPE = "operation";
    public static final String OTHER_TYPE = "other";
    private String name;
    private String number;
    private int index;
    private String type;
    private boolean necessary = true;

    private BillFieldTypeEnum(String name, String number, int index, String type) {
        this.name = name;
        this.number = number;
        this.index = index;
        this.type = type;
    }

    private BillFieldTypeEnum(String name, String number, int index, String type, boolean necessary) {
        this.name = name;
        this.number = number;
        this.index = index;
        this.type = type;
        this.necessary = necessary;
    }

    private static String getBudget() {
        return ResManager.loadKDString((String)"\u9884\u7b97\u9879", (String)"BillFieldTypeEnum_7", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getCurrency() {
        return ResManager.loadKDString((String)"\u5e01\u522b", (String)"BillFieldTypeEnum_8", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getProject() {
        return ResManager.loadKDString((String)"\u9879\u76ee", (String)"BillFieldTypeEnum_9", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getContract() {
        return ResManager.loadKDString((String)"\u5408\u540c", (String)"BillFieldTypeEnum_10", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getAmount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"BillFieldTypeEnum_11", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getEntryId() {
        return ResManager.loadKDString((String)"\u5206\u5f55ID", (String)"BillFieldTypeEnum_22", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getBillNo() {
        return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"BillFieldTypeEnum_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getBillName() {
        return ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"BillFieldTypeEnum_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getCreator() {
        return ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"BillFieldTypeEnum_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getCreateTime() {
        return ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"BillFieldTypeEnum_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getAuditor() {
        return ResManager.loadKDString((String)"\u5ba1\u6838\u4eba", (String)"BillFieldTypeEnum_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getAuditTime() {
        return ResManager.loadKDString((String)"\u5ba1\u6838\u65f6\u95f4", (String)"BillFieldTypeEnum_5", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getTakeOperation() {
        return ResManager.loadKDString((String)"\u5360\u7528", (String)"BillFieldTypeEnum_12", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getExecOperation() {
        return ResManager.loadKDString((String)"\u6267\u884c", (String)"BillFieldTypeEnum_13", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getReturnOperation() {
        return ResManager.loadKDString((String)"\u8fd4\u8fd8", (String)"BillFieldTypeEnum_14", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getClearOperation() {
        return ResManager.loadKDString((String)"\u91ca\u653e", (String)"BillFieldTypeEnum_17", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getReturnAndClearOperation() {
        return ResManager.loadKDString((String)"\u8fd4\u8fd8\u5e76\u91ca\u653e", (String)"BillFieldTypeEnum_18", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getTakeAndExecOperation() {
        return ResManager.loadKDString((String)"\u5360\u7528\u5e76\u6267\u884c", (String)"BillFieldTypeEnum_21", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getPeriod() {
        return ResManager.loadKDString((String)"\u671f\u95f4", (String)"BillFieldTypeEnum_19", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    private static String getBudgetType() {
        return ResManager.loadKDString((String)"\u9884\u7b97\u7c7b\u578b", (String)"BillFieldTypeEnum_20", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
    }

    public static List<String> getFieldNameByType(String type) {
        BillFieldTypeEnum[] values = BillFieldTypeEnum.values();
        ArrayList<String> fields = new ArrayList<String>(values.length);
        for (BillFieldTypeEnum value : values) {
            fields.add(value.getName());
        }
        return fields;
    }

    public static List<String> getFieldNumByType(String type) {
        BillFieldTypeEnum[] values = BillFieldTypeEnum.values();
        ArrayList<String> fields = new ArrayList<String>(values.length);
        for (BillFieldTypeEnum value : values) {
            fields.add(value.getNumber());
        }
        return fields;
    }

    public static BillFieldTypeEnum getBillFieldTypeEnumByIndex(int index) {
        for (BillFieldTypeEnum accountDataTypeEnum : BillFieldTypeEnum.values()) {
            if (accountDataTypeEnum.index != index) continue;
            return accountDataTypeEnum;
        }
        throw new KDBizException("error account data type : " + index);
    }

    public static String getNameByNumber(String number) {
        for (BillFieldTypeEnum accountDataTypeEnum : BillFieldTypeEnum.values()) {
            if (!accountDataTypeEnum.getNumber().equals(number)) continue;
            return accountDataTypeEnum.getName();
        }
        throw new KDBizException("error field number :" + number);
    }

    public static BillFieldTypeEnum getEnumByNumber(String number) {
        for (BillFieldTypeEnum accountDataTypeEnum : BillFieldTypeEnum.values()) {
            if (!accountDataTypeEnum.getNumber().equals(number)) continue;
            return accountDataTypeEnum;
        }
        throw new KDBizException("error field number :" + number);
    }

    public static List<BillFieldTypeEnum> getEnumsByType(String type) {
        return Arrays.stream(BillFieldTypeEnum.values()).filter(it -> StringUtils.equals((CharSequence)it.getType(), (CharSequence)type)).collect(Collectors.toList());
    }

    public String getName() {
        String number = this.number;
        String name = this.name;
        BillFieldTypeEnumMulHelper mulHelper = new BillFieldTypeEnumMulHelper();
        switch (number) {
            case "BUDGETTYPE": {
                name = mulHelper.getBudgetType();
                break;
            }
            case "PROJECT": {
                name = mulHelper.getProject();
                break;
            }
            case "BUDGET": {
                name = mulHelper.getBudget();
                break;
            }
            case "PERIOD": {
                name = mulHelper.getPeriod();
                break;
            }
            case "CURRENCY": {
                name = mulHelper.getCurrency();
                break;
            }
            case "AMOUNT": {
                name = mulHelper.getAmount();
                break;
            }
            case "ENTRYID": {
                name = mulHelper.getEntryId();
                break;
            }
            case "BILLNO": {
                name = mulHelper.getBillNo();
                break;
            }
            case "BILLNAME": {
                name = mulHelper.getBillName();
                break;
            }
            case "CREATOR": {
                name = mulHelper.getCreator();
                break;
            }
            case "CREATETIME": {
                name = mulHelper.getCreateTime();
                break;
            }
            case "AUDITDATE": {
                name = mulHelper.getAuditTime();
                break;
            }
            case "CONTRACT": {
                name = mulHelper.getContract();
                break;
            }
            case "TAKEOPERATION": {
                name = mulHelper.getTakeOperation();
                break;
            }
            case "EXECOPERATION": {
                name = mulHelper.getExecOperation();
                break;
            }
            case "TAKEANDEXECOPERATION": {
                name = mulHelper.getTakeAndExecOperation();
                break;
            }
            case "RETURNOPERATION": {
                name = mulHelper.getReturnOperation();
                break;
            }
            case "CLEAROPERATION": {
                name = mulHelper.getClearOperation();
                break;
            }
            case "RETURNANDCLEAROPERATION": {
                name = mulHelper.getReturnAndClearOperation();
                break;
            }
        }
        return name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isNecessary() {
        return this.necessary;
    }
}

