/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.excel;

import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.property.AmountProp;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.inte.InteServiceHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class CommonDataExporter
extends ExcelWriter {
    private static final Log logger = LogFactory.getLog(CommonDataExporter.class);
    private static final String[] sources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    protected List<String> columnKey = new ArrayList<String>(10);
    protected SXSSFSheet sheet;
    protected SXSSFSheet dropdownSheet;
    protected ExportSheetStyle styles;
    protected IFormView formView;
    protected IDataModel dataModel;

    public CommonDataExporter() {
    }

    public CommonDataExporter(IFormView formView, String sheetName, List<ExportWriterFormat> formats) {
        this.formView = formView;
        this.dataModel = formView.getModel();
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.sheet = this.wb.createSheet(sheetName);
        this.sheet.setColumnHidden(0, Boolean.TRUE.booleanValue());
        this.dropdownSheet = this.wb.createSheet("dropdown_items_sheet");
        this.styles = new ExportSheetStyle(this.wb);
        HashMap<Integer, String> propDisplayNames = new HashMap<Integer, String>();
        int headerOffset = 1;
        for (ExportWriterFormat format : formats) {
            headerOffset = this.writeHeader(this.wb, this.sheet, this.dropdownSheet, this.styles, format, headerOffset, propDisplayNames, this.columnKey);
        }
        int dropdownItemsSheetIndex = this.wb.getSheetIndex("dropdown_items_sheet");
        if (dropdownItemsSheetIndex >= 0) {
            this.wb.setSheetHidden(dropdownItemsSheetIndex, true);
        }
    }

    protected final int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportSheetStyle styles, ExportWriterFormat format, int preOffset, Map<Integer, String> propDisplayNames, List<String> columnKey) {
        SXSSFRow entityRow = CommonDataExporter.getRow((SXSSFSheet)sheet, (int)0);
        SXSSFRow commentRow = CommonDataExporter.getRow((SXSSFSheet)sheet, (int)1);
        SXSSFRow nameRow = CommonDataExporter.getRow((SXSSFSheet)sheet, (int)2);
        int titleRowIndex = 3;
        SXSSFRow titleRow = CommonDataExporter.getRow((SXSSFSheet)sheet, (int)titleRowIndex);
        CellStyle cellStyle = format.displayName != null && format.displayName.startsWith("*") ? styles.getTextHighLightStyle() : styles.getTitleStyle();
        CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)entityRow, (int)preOffset, (CellStyle)cellStyle).setCellValue(format.displayName + " # " + format.name);
        int offset = preOffset;
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            boolean mustInput = false;
            Object inputType = null;
            int defaultColWidth = 0;
            if (property != null) {
                mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                inputType = property.get("InputType");
                CellStyle cellStyle1 = this.wb.createCellStyle();
                if (!"id".equals(inputType) && !"pid".equals(inputType)) {
                    if (inputType instanceof JSONArray) {
                        ArrayList<String> items = new ArrayList<String>();
                        ((JSONArray)inputType).forEach(obj -> items.add(obj.toString().split(" # ", -1)[0]));
                        if (!items.isEmpty() && !"MulComboProp".equals(property.get("PropType"))) {
                            int currCol = offset;
                            for (int j = 0; j < items.size(); ++j) {
                                CommonDataExporter.getRow((SXSSFSheet)dropdownSheet, (int)j).createCell(currCol).setCellValue((String)items.get(j));
                            }
                            CommonDataExporter.createDropdownList(sheet, currCol, items);
                        }
                    } else if ("date".equals(inputType)) {
                        property.put("InputDesc", ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a2018/05/01", (String)"CommonDataExporter_0", (String)"pccs-placs-business", (Object[])new Object[0]));
                        defaultColWidth = 60;
                        cellStyle1.setDataFormat(this.wb.createDataFormat().getFormat("yyyy/mm/dd"));
                        sheet.setDefaultColumnStyle(offset, cellStyle1);
                    } else if ("datetime".equals(inputType)) {
                        defaultColWidth = 80;
                        cellStyle1.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-mm-dd H:mm:ss"));
                        sheet.setDefaultColumnStyle(offset, cellStyle1);
                    } else if ("decimal".equals(inputType)) {
                        sheet.setDefaultColumnStyle(offset, styles.getTextStyle());
                    } else {
                        if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                            offset = this.splitColumn(wb, sheet, nameRow, titleRow, commentRow, styles, format, property, fieldName, offset, titleRowIndex, propDisplayNames, mustInput, defaultColWidth, columnKey);
                            continue;
                        }
                        sheet.setDefaultColumnStyle(offset, styles.getTextStyle());
                    }
                } else {
                    fieldName = fieldName.replace('.', '_');
                }
                CommonDataExporter.writeComment(wb, commentRow, format, styles, property, offset);
            }
            String caption = "";
            if (property != null) {
                caption = (mustInput ? "*" : "") + property.get("DisplayName");
            }
            CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)nameRow, (int)offset, (CellStyle)styles.getTitleStyle()).setCellValue(fieldName);
            SXSSFCell cell = CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)titleRow, (int)offset, (CellStyle)(mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle("default")));
            cell.setCellValue(caption);
            sheet.setColumnWidth(offset, CommonDataExporter.calcColumnWidth(caption, caption, defaultColWidth));
            if (property != null && property.containsKey("InputDesc")) {
                String tip = property.getOrDefault("InputDesc", "");
                CommonDataExporter.bindCellTip(sheet, cell, offset, titleRowIndex, tip);
            }
            columnKey.add(fieldName);
            ++offset;
        }
        for (ExportWriterFormat wr : format.next) {
            offset = this.writeHeader(this.wb, sheet, dropdownSheet, styles, wr, offset, propDisplayNames, columnKey);
        }
        return offset;
    }

    public void columnHidden(SXSSFSheet sheet, int offset, String fieldName) {
    }

    private static void createDropdownList(SXSSFSheet sheet, int currCol, List<String> items) {
        String currColLabel = CommonDataExporter.getColumnLabel(currCol + 1);
        String strFormula = String.format("dropdown_items_sheet!$%s$%d:$%s$%d", currColLabel, 1, currColLabel, items.size());
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(4, 10000, currCol, currCol);
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public int splitColumn(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow nameRow, SXSSFRow titleRow, SXSSFRow commentRow, ExportSheetStyle styles, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, int titleRowIndex, Map<Integer, String> propDisplayNames, boolean mustInput, int defaultColWidth, List<String> columnKey) {
        ArrayList splitCols = (ArrayList)format.flexColumn.get(fieldName);
        List splitColDisplayNames = (List)format.flexColumnDisplay.get(fieldName);
        List splitColDesc = (List)format.flexColumnDesc.get(fieldName);
        if (splitCols != null) {
            if ("multilang".equals(property.get("InputType"))) {
                splitCols = new ArrayList();
                List multilang = (List)format.flexColumn.get(fieldName);
                splitCols.add(multilang.get(0));
            }
            for (int j = 0; j < splitCols.size(); ++j) {
                int colIndex = offset;
                propDisplayNames.put(colIndex, (String)splitColDisplayNames.get(j));
                String caption = (j == 0 && mustInput ? "*" : "") + (String)splitColDisplayNames.get(j);
                sheet.setDefaultColumnStyle(colIndex, styles.getTitleStyle());
                CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)nameRow, (int)offset, (CellStyle)styles.getTitleStyle()).setCellValue((String)splitCols.get(j));
                SXSSFCell cell = CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)titleRow, (int)colIndex, (CellStyle)(j == 0 && mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle("default")));
                cell.setCellValue(caption);
                if (j < splitColDesc.size()) {
                    CommonDataExporter.bindCellTip(sheet, cell, offset, titleRowIndex, (String)splitColDesc.get(j));
                }
                sheet.setColumnWidth(offset, CommonDataExporter.calcColumnWidth(caption, caption, defaultColWidth));
                if (j == 0) {
                    CommonDataExporter.writeComment(wb, commentRow, format, styles, property, offset);
                }
                columnKey.add((String)splitCols.get(j));
                sheet.setDefaultColumnStyle(offset, styles.getTextStyle());
                ++offset;
            }
        }
        return offset;
    }

    private static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append("Z");
            remainder = 26;
        } else {
            sb.append(sources[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(sources[remainder]);
        }
        return sb.reverse().toString();
    }

    private static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (!StringUtils.isBlank((CharSequence)tip)) {
            SXSSFDrawing p = sheet.createDrawingPatriarch();
            Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
            if (ResManager.loadKDString((String)"WBS\u540d\u79f0", (String)"CommonDataExporter_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]).equals(cell.getStringCellValue())) {
                comment.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (String)"CommonDataExporter_3", (String)"pmgt-pmbs-common", (Object[])new Object[0])));
            } else {
                comment.setString((RichTextString)new XSSFRichTextString(tip));
            }
            cell.setCellComment(comment);
        }
    }

    private static void writeComment(SXSSFWorkbook wb, SXSSFRow commentRow, ExportWriterFormat format, ExportSheetStyle styles, Map<String, Object> property, int offset) {
        String entityDesc = (String)property.get("EntityDescription");
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)commentRow, (int)offset, (CellStyle)styles.getTitleStyle("default")).setCellValue(entityDesc);
        } else if (offset == 0) {
            CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)commentRow, (int)0, (CellStyle)styles.getTextHighLightStyle()).setCellValue(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"CommonDataExporter_1", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
    }

    protected static int calcColumnWidth(String caption, String headName, int defColWidth) {
        int colWidth;
        boolean var2 = false;
        if (StringUtils.isEmpty((CharSequence)caption)) {
            caption = headName;
        }
        try {
            colWidth = Math.max(256 * defColWidth / 8 * 2, 256 * (caption.getBytes("GBK").length + 12));
        }
        catch (UnsupportedEncodingException var4) {
            colWidth = 256 * (caption.getBytes().length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    public void exportData(DynamicObjectCollection data, List<ExportWriterFormat> formats, Map<String, Object> params) {
        int startRow = 4;
        int currentCount = 4;
        int temCount = 4;
        HashMap<Integer, String> propDisplayNames = new HashMap<Integer, String>();
        int preOffset = 1;
        int temOffset = 1;
        int lastOffset = 1;
        CellStyle style = this.wb.createCellStyle();
        ExportWriterFormat format = formats.get(0);
        for (DynamicObject dt : data) {
            temOffset = preOffset = this.writeData(this.wb, this.sheet, style, format, preOffset, startRow, propDisplayNames, dt, data, params);
            ++temCount;
            if (format.next.size() > 0) {
                for (ExportWriterFormat subFormat : format.next) {
                    if (dt.getDynamicObjectCollection(subFormat.name).size() <= 0) continue;
                    for (DynamicObject suDt : dt.getDynamicObjectCollection(subFormat.name)) {
                        lastOffset = preOffset = this.writeData(this.wb, this.sheet, style, subFormat, preOffset, currentCount, propDisplayNames, suDt, dt.getDynamicObjectCollection(subFormat.name), params);
                        preOffset = temOffset;
                        ++currentCount;
                    }
                    if (currentCount > temCount) {
                        temCount = currentCount;
                    }
                    currentCount = startRow;
                    preOffset = lastOffset;
                    temOffset = lastOffset;
                }
            }
            if (temCount > startRow) {
                startRow = temCount;
            }
            currentCount = startRow;
            preOffset = 1;
        }
    }

    private int writeData(SXSSFWorkbook wb, SXSSFSheet sheet, CellStyle styles, ExportWriterFormat format, int offset, int startRow, Map<Integer, String> propDisplayNames, DynamicObject data, DynamicObjectCollection dataList, Map<String, Object> params) {
        SXSSFRow dataRow = CommonDataExporter.getRow((SXSSFSheet)sheet, (int)startRow);
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        for (int i = 0; i < format.fields.size(); ++i) {
            Object inputType;
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            int defaultColWidth = 0;
            SXSSFCell cell = CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)dataRow, (int)offset, null);
            CreationHelper creationHelper = this.wb.getCreationHelper();
            CellStyle cellStyle = this.wb.createCellStyle();
            if (property != null && !"id".equals(inputType = property.get("InputType")) && !"pid".equals(inputType)) {
                Date date;
                String timeStr;
                SimpleDateFormat sdf;
                if (inputType instanceof JSONArray) {
                    HashMap comboPropData = new HashMap(10);
                    ((JSONArray)inputType).forEach(obj -> {
                        if (obj.toString().split(" # ").length > 1) {
                            comboPropData.put(obj.toString().split(" # ", -1)[1], obj.toString().split(" # ", -1)[0]);
                        }
                    });
                    cell.setCellValue(comboPropData.size() > 0 ? (String)comboPropData.get(data.getString(fieldName)) : data.getString(fieldName));
                } else if ("date".equals(inputType)) {
                    if (data.getDate(fieldName) != null) {
                        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        cell.setCellStyle(cellStyle);
                        sdf = new SimpleDateFormat(formatObject.getDateFormat().getDateFormat());
                        timeStr = sdf.format(data.getDate(fieldName));
                        try {
                            sdf.parse(timeStr);
                            cell.setCellValue(timeStr);
                        }
                        catch (ParseException e) {
                            date = new Date(Long.parseLong(timeStr));
                            cell.setCellValue(sdf.format(date));
                        }
                    }
                } else if ("datetime".equals(inputType)) {
                    cell.setCellValue(data.getDate(fieldName));
                    sdf = new SimpleDateFormat(formatObject.getDateFormat().getDateFormat() + " " + formatObject.getTimeFormat().getTimeFormat());
                    if (data.getDate(fieldName) == null) continue;
                    timeStr = sdf.format(data.getDate(fieldName));
                    try {
                        sdf.parse(timeStr);
                        cell.setCellValue(timeStr);
                    }
                    catch (ParseException e) {
                        date = new Date(Long.parseLong(timeStr));
                        cell.setCellValue(sdf.format(date));
                    }
                } else if ("decimal".equals(inputType)) {
                    String currencyFormat = this.getCurrencyFormat(data, fieldName);
                    if (currencyFormat != null) {
                        cellStyle.setDataFormat(this.wb.createDataFormat().getFormat(currencyFormat));
                    }
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(data.getBigDecimal(fieldName).doubleValue());
                } else {
                    if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                        offset = this.splitColumnData(wb, sheet, dataRow, styles, format, property, fieldName, offset, propDisplayNames, defaultColWidth, inputType, data, dataList, creationHelper, cellStyle, params);
                        continue;
                    }
                    cell.setCellValue(data.getString(fieldName));
                }
            }
            ++offset;
        }
        return offset;
    }

    public String getCurrencyFormat(DynamicObject data, String fieldName) {
        String format = null;
        IDataEntityProperty entityProperty = (IDataEntityProperty)data.getDynamicObjectType().getProperties().get((Object)fieldName);
        if (entityProperty instanceof AmountProp) {
            String currencyFieldName = ((AmountProp)entityProperty).getControlPropName();
            boolean inEntry = data.getDynamicObjectType().getProperties().stream().anyMatch(property -> StringUtils.equals((CharSequence)property.getName(), (CharSequence)currencyFieldName));
            DynamicObject currency = inEntry ? data.getDynamicObject(currencyFieldName) : (DynamicObject)this.formView.getModel().getValue(currencyFieldName);
            if (currency != null) {
                format = this.getCurrencyFormat(currency);
            }
        }
        logger.info("CommonDataExporter#getCurrencyFormat format:{}", format);
        return format;
    }

    private String getCurrencyFormat(DynamicObject currency) {
        int amtPrecision = currency.getInt("amtprecision");
        String sign = currency.getString("sign");
        String symbol1 = "#,";
        String symbol2 = "0.";
        for (int i = 0; i < amtPrecision; ++i) {
            symbol1 = String.format("%s%s", symbol1, "#");
            symbol2 = String.format("%s%s", symbol2, "0");
        }
        return String.format("%s%s%s;%s-%s%s", sign, symbol1, symbol2, sign, symbol1, symbol2);
    }

    public int splitColumnData(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow dataRow, CellStyle styles, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, Map<Integer, String> propDisplayNames, int defaultColWidth, Object inputType, DynamicObject data, DynamicObjectCollection dataList, CreationHelper creationHelper, CellStyle cellStyle, Map<String, Object> params) {
        block16: {
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("@"));
            List splitCols = (List)format.flexColumn.get(fieldName);
            List splitColDisplayNames = (List)format.flexColumnDisplay.get(fieldName);
            List splitColDesc = (List)format.flexColumnDesc.get(fieldName);
            if ("multilang".equals(inputType)) {
                Lang lang = RequestContext.get().getLang();
                String value = "";
                if (data.getLong("pid") == 0L && "parent".equals(fieldName)) {
                    return ++offset;
                }
                if (data.getLong("pid") != 0L && "parent".equals(fieldName)) {
                    for (DynamicObject dt : dataList) {
                        if (Long.parseLong(dt.getPkValue().toString()) != data.getLong("pid")) continue;
                        if ("zh_CN".equals(lang.name())) {
                            value = dt.getLocaleString(params.get("name").toString()).getLocaleValue_zh_CN();
                            continue;
                        }
                        if ("zh_TW".equals(lang.name())) {
                            value = data.getLocaleString(params.get("name").toString()).getLocaleValue_zh_TW();
                            continue;
                        }
                        value = data.getLocaleString(params.get("name").toString()).getLocaleValue_en();
                    }
                } else {
                    value = "zh_CN".equals(lang.name()) ? data.getLocaleString(fieldName).getLocaleValue_zh_CN() : ("zh_TW".equals(lang.name()) ? data.getLocaleString(fieldName).getLocaleValue_zh_TW() : data.getLocaleString(fieldName).getLocaleValue_en());
                }
                SXSSFCell cell = CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)dataRow, (int)offset, (CellStyle)styles);
                cell.setCellValue(value);
                cell.setCellStyle(cellStyle);
                sheet.setColumnWidth(offset, CommonDataExporter.calcColumnWidth(value, (String)splitColDisplayNames.get(0), defaultColWidth));
                return ++offset;
            }
            if (splitCols == null) break block16;
            if (data.get(fieldName) instanceof DynamicObjectCollection) {
                DynamicObjectCollection dtColl = data.getDynamicObjectCollection(fieldName);
                String col = null;
                for (int j = 0; j < splitCols.size(); ++j) {
                    int colIndex = offset;
                    col = ((String)splitCols.get(j)).split("\\.")[1];
                    if (dtColl != null) {
                        StringBuilder value = new StringBuilder();
                        String finalCol = col;
                        if ("name".equals(finalCol)) {
                            dtColl.stream().map(o -> value.append(o == null ? "" : o.getDynamicObject("fbasedataid").getLocaleString(finalCol).getLocaleValue() + ";")).count();
                        } else {
                            dtColl.stream().map(o -> value.append(o == null ? "" : o.getDynamicObject("fbasedataid").getString(finalCol) + ";")).count();
                        }
                        if (value.length() > 0) {
                            value.deleteCharAt(value.length() - 1);
                        }
                        SXSSFCell cell = CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)dataRow, (int)colIndex, (CellStyle)styles);
                        cell.setCellValue(value.toString());
                        cell.setCellStyle(cellStyle);
                        sheet.setColumnWidth(offset, CommonDataExporter.calcColumnWidth(value.toString(), (String)splitColDisplayNames.get(j), defaultColWidth));
                    }
                    ++offset;
                }
            } else {
                DynamicObject dt = data.getDynamicObject(fieldName);
                for (int j = 0; j < splitCols.size(); ++j) {
                    int colIndex = offset;
                    if (dt != null) {
                        String value = String.valueOf(dt.get(((String)splitCols.get(j)).split("\\.")[1]));
                        SXSSFCell cell = CommonDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)dataRow, (int)colIndex, (CellStyle)styles);
                        cell.setCellValue(value);
                        cell.setCellStyle(cellStyle);
                        sheet.setColumnWidth(offset, CommonDataExporter.calcColumnWidth(value, (String)splitColDisplayNames.get(j), defaultColWidth));
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }
}

