/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.ext;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.ext.CallAfter;
import kd.pmgt.pmbs.common.ext.CallBefore;
import kd.pmgt.pmbs.common.ext.CallReplace;
import kd.pmgt.pmbs.common.ext.CallReplaceIfPresent;
import kd.pmgt.pmbs.common.ext.IExtPlugin;

public class ExtAnnotationParser {
    private static final Log log = LogFactory.getLog(ExtAnnotationParser.class);

    public static List<Object> supportExt(String caseName, IExtPlugin defExtPlugin, String methodName, Class<?>[] paramClasses, Object[] args) {
        PluginProxy pluginProxy = PluginProxy.create((Object)defExtPlugin, IExtPlugin.class, (String)caseName, null);
        try {
            Annotation annotation = ExtAnnotationParser.getAnnotation((PluginProxy<IExtPlugin>)pluginProxy, methodName, paramClasses);
            if (annotation == null) {
                throw new KDBizException("no ext annotation error.");
            }
            return ExtAnnotationParser.doSupportExt((PluginProxy<IExtPlugin>)pluginProxy, annotation, methodName, paramClasses, args);
        }
        catch (Exception e) {
            log.error("no ext annotation error.");
            throw new KDBizException(e.getMessage());
        }
    }

    private static Annotation getAnnotation(PluginProxy<IExtPlugin> pluginProxy, String methodName, Class<?>[] paramClasses) throws NoSuchMethodException {
        Annotation annotation = null;
        List plugins = pluginProxy.getPlugins();
        block0: for (IExtPlugin extPlugin : plugins) {
            if (annotation != null) break;
            Method method = paramClasses == null || paramClasses.length == 0 ? extPlugin.getClass().getDeclaredMethod(methodName, new Class[0]) : extPlugin.getClass().getDeclaredMethod(methodName, paramClasses);
            for (Annotation methodAnnotation : method.getAnnotations()) {
                if (!(methodAnnotation instanceof CallBefore) && !(methodAnnotation instanceof CallAfter) && !(methodAnnotation instanceof CallReplace) && !(methodAnnotation instanceof CallReplaceIfPresent)) continue;
                annotation = methodAnnotation;
                continue block0;
            }
        }
        return annotation;
    }

    private static List<Object> doSupportExt(PluginProxy<IExtPlugin> pluginProxy, Annotation annotation, String methodName, Class<?>[] paramClasses, Object[] args) {
        if (annotation instanceof CallBefore) {
            return pluginProxy.callBefore(p -> ExtAnnotationParser.call(methodName, p, paramClasses, args));
        }
        if (annotation instanceof CallAfter) {
            return pluginProxy.callAfter(p -> ExtAnnotationParser.call(methodName, p, paramClasses, args));
        }
        if (annotation instanceof CallReplace) {
            return pluginProxy.callReplace(p -> ExtAnnotationParser.call(methodName, p, paramClasses, args));
        }
        if (annotation instanceof CallReplaceIfPresent) {
            return pluginProxy.callReplaceIfPresent(p -> ExtAnnotationParser.call(methodName, p, paramClasses, args));
        }
        throw new KDBizException("please put ext method annotation");
    }

    private static Object call(String methodName, IExtPlugin p, Class<?>[] paramClasses, Object[] args) {
        String className = p.getClass().getName();
        try {
            Class<?> clazz = Class.forName(className);
            if (args == null || args.length == 0) {
                Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                return method.invoke(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
            }
            Method method = clazz.getDeclaredMethod(methodName, paramClasses);
            return method.invoke(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), args);
        }
        catch (Exception e) {
            log.error("please put ext method annotation.");
            throw new KDBizException("please put ext method annotation.");
        }
    }
}

