/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.http;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpClientUtils {
    private static final Log log = LogFactory.getLog(HttpClientUtils.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static SSLConnectionSocketFactory sslsf = null;
    private static PoolingHttpClientConnectionManager cm = null;
    private static SSLContextBuilder builder = null;

    public static CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).setConnectionManagerShared(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String json) {
        String returnValue = "";
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity requestEntity = new StringEntity(json, StandardCharsets.UTF_8);
            requestEntity.setContentEncoding(StandardCharsets.UTF_8.toString());
            httpPost.setHeader("Content-type", ContentType.APPLICATION_JSON.getMimeType());
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            log.error("http client post request exception info", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error("http client post request close IO exception info", (Throwable)e);
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, Object> data, File file) {
        String returnValue = null;
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        FileInputStream fis = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            fis = new FileInputStream(file);
            builder.addBinaryBody("file", (InputStream)fis, ContentType.DEFAULT_BINARY, file.getName());
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                StringBody value = new StringBody(entry.getValue().toString(), ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)Consts.UTF_8));
                builder.addPart(entry.getKey(), (ContentBody)value);
            }
            HttpEntity reqEntity = builder.build();
            httpPost.setEntity(reqEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            log.error("http client post request exception info", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                log.error("http client request close IO exception info", (Throwable)e);
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> data, InputStream fileInputStream, String fileName) {
        String returnValue = null;
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            HttpPost httpPost = new HttpPost(url);
            if (fileInputStream != null) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addBinaryBody("file", fileInputStream, ContentType.MULTIPART_FORM_DATA, fileName);
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    StringBody value = new StringBody(entry.getValue(), ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)Consts.UTF_8));
                    builder.addPart(entry.getKey(), (ContentBody)value);
                }
                HttpEntity requestEntity = builder.build();
                httpPost.setEntity(requestEntity);
            } else {
                JSONObject jsonData = new JSONObject();
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    jsonData.put(entry.getKey(), (Object)entry.getValue());
                }
                StringEntity requestEntity = new StringEntity(jsonData.toJSONString(), StandardCharsets.UTF_8);
                requestEntity.setContentEncoding(StandardCharsets.UTF_8.toString());
                httpPost.setHeader("Content-type", ContentType.APPLICATION_JSON.getMimeType());
                httpPost.setEntity((HttpEntity)requestEntity);
            }
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            log.error("http client post request exception info", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error("http client post request close IO exception info", (Throwable)e);
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> data) {
        String returnValue = null;
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            HttpGet httpGet = new HttpGet(url + HttpClientUtils.toUrlParamString(data));
            returnValue = (String)httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            log.error("http client get request exception info", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error("http client get request close IO exception info", (Throwable)e);
            }
        }
        return returnValue;
    }

    public static String toUrlParamString(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder paramsString = new StringBuilder();
        paramsString.append('?');
        int length = params.size();
        int index = 1;
        for (Map.Entry<String, String> param : params.entrySet()) {
            paramsString.append(param.getKey()).append('=').append(param.getValue());
            if (index < length) {
                paramsString.append('&');
            }
            ++index;
        }
        return paramsString.toString();
    }

    static {
        try {
            builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(x509Certificates, s) -> true));
            sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register(HTTP, (Object)new PlainConnectionSocketFactory()).register(HTTPS, (Object)sslsf).build();
            cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(200);
        }
        catch (Exception e) {
            log.error("info", (Throwable)e);
        }
    }
}

