/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.meta;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;

public class MetaDataHelper {
    public static String getFullMetaFieldName(String formId, String fieldName) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        return MetaDataHelper.getFullFieldName((DynamicObjectType)dt, fieldName);
    }

    public static String getFullFieldName(DynamicObjectType dt, String fieldName) {
        if (dt == null) {
            throw new KDBizException("dt is null");
        }
        ArrayDeque<String> stack = new ArrayDeque<String>();
        MetaDataHelper.find(stack, dt, fieldName);
        if (stack.isEmpty()) {
            throw new KDBizException("field not find");
        }
        return StringUtils.join((Object[])stack.toArray(), (String)".");
    }

    private static void find(Deque<String> pathQueue, DynamicObjectType dt, String target) {
        if (dt == null || pathQueue.contains(target)) {
            return;
        }
        boolean found = false;
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty iDataEntityProperty : properties) {
            DynamicProperty property = (DynamicProperty)iDataEntityProperty;
            if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)target)) {
                found = true;
                pathQueue.push(property.getName());
                break;
            }
            if (!(property instanceof EntryProp)) continue;
            pathQueue.push(property.getName());
            MetaDataHelper.find(pathQueue, ((EntryProp)property).getDynamicCollectionItemPropertyType(), target);
        }
        if (!found && !pathQueue.contains(target)) {
            pathQueue.pop();
        }
    }

    public static String getOrderByString(String entityId) {
        String orderBy = "";
        StringBuilder orderByBuilder = new StringBuilder();
        Map listMeta = FormMetadataCache.getListMeta((String)entityId);
        JSONObject listData = JSONObject.parseObject((String)listMeta.get("BillList").toString());
        JSONObject list = listData.getJSONArray("Items").getJSONObject(0);
        JSONArray fieldList = list.getJSONArray("Items");
        for (Object item : fieldList) {
            JSONObject field = JSONObject.parseObject((String)item.toString());
            String k = field.getString("Visible");
            String o = field.getString("Order");
            if (!"63".equals(k) || "NotOrder".equalsIgnoreCase(o)) continue;
            orderByBuilder.append(field.getString("ListFieldKey")).append(" ").append(field.getString("Order")).append(",");
        }
        if (orderByBuilder.length() > 0) {
            orderBy = orderByBuilder.substring(0, orderByBuilder.length() - 1);
        }
        return orderBy;
    }
}

