/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.spread;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.spread.domain.SpreadSelector;
import kd.pmgt.pmbs.common.spread.listener.ISpreadBaseSupport;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;

public class SpreadDataModelImpl
extends SpreadActionAdapter
implements ISpreadAction {
    private static final Log log = LogFactory.getLog(SpreadDataModelImpl.class);
    private static String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(.[0-9]{1,})?)\\)?$";

    public SpreadDataModelImpl(AbstractFormPlugin plugin) {
        super(plugin);
    }

    public void updateCellValue(SpreadEvent event) {
        super.updateCellValue(event);
    }

    public void selectedSpread(SpreadEvent event) {
        SpreadPostDataInfo data = event.getPostData();
        if (data.getSelRows() != null && data.getSelRows().size() > 0 && data.getSelCols() != null && data.getSelCols().size() > 0) {
            this.sortSelectData(data);
            int focusCellRow_st = (Integer)data.getSelRows().get(0);
            int focusCellRow_end = (Integer)data.getSelRows().get(data.getSelRows().size() - 1);
            int focusCellCol_st = (Integer)data.getSelCols().get(0);
            int focusCellCol_end = (Integer)data.getSelCols().get(data.getSelCols().size() - 1);
            if (this.plugin instanceof ISpreadBaseSupport) {
                SpreadSelector spreadSelector = new SpreadSelector(focusCellRow_st, focusCellCol_st, focusCellRow_end, focusCellCol_end);
                ((ISpreadBaseSupport)ISpreadBaseSupport.class.cast(this.plugin)).setSpreadSelector(spreadSelector);
            }
        }
    }

    public void invokePluginMethod(SpreadEvent event) {
        String methodname = (String)event.getPostData().getInvokeParams().get("invokemethod");
        this.callPluginMethod(methodname, event.getPostData().getInvokeParams());
    }

    private void callPluginMethod(String methodName, Object params) {
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, (Object)params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (e instanceof InvocationTargetException) {
                log.error(((InvocationTargetException)e).getTargetException());
            }
            throw new RuntimeException(e);
        }
    }

    public void showFormulaPanel(SpreadEvent event) {
        this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6682\u4e0d\u652f\u6301\u516c\u5f0f\u5411\u5bfc\u3002", (String)"SpreadDataModelImpl_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    private void sortSelectData(SpreadPostDataInfo data) {
        data.getSelRows().sort(this.sortSmallTobig());
        data.getSelCols().sort(this.sortSmallTobig());
        int rowindex = data.getSelRows().indexOf(-1);
        int colindex = data.getSelCols().indexOf(-1);
        if (rowindex != -1) {
            data.getSelRows().remove(rowindex);
        }
        if (colindex != -1) {
            data.getSelCols().remove(colindex);
        }
    }

    private Comparator<Integer> sortSmallTobig() {
        return (o1, o2) -> {
            if (o1 < o2) {
                return -1;
            }
            return 1;
        };
    }

    protected boolean isNotSupportExcelFormat(String data) {
        String vdata = this.removeAmountSign(data);
        return StringUtils.isNotEmpty((CharSequence)vdata) && Pattern.matches(AMOUNT_PATTERN, vdata.trim());
    }

    protected String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,US\\\\$,\u00a3,\u00a5]", "");
    }

    public void getLookupData(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null) {
            int r = (Integer)event.getPostData().getInvokeParams().get("r");
            int c = (Integer)event.getPostData().getInvokeParams().get("c");
            Map lookupDataInfo = (Map)event.getPostData().getInvokeParams().get("lookupInfo");
            LookUpDataArgs bean = new LookUpDataArgs();
            this.populateValues(bean, lookupDataInfo);
            bean.setR(r);
            bean.setC(c);
            if (bean.getValue() != null) {
                this.callPluginMethod("spreadF7LookUpData", bean);
            }
        }
    }

    protected void populateValues(Object populateBean, Map<String, ? extends Object> values) {
        try {
            BeanUtils.populate((Object)populateBean, values);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e instanceof InvocationTargetException) {
                log.error(((InvocationTargetException)e).getTargetException());
            }
            throw new RuntimeException(e);
        }
    }
}

