/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.spread.control;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.pmgt.pmbs.common.spread.command.AreasStyle;
import kd.pmgt.pmbs.common.spread.command.CellArea;
import kd.pmgt.pmbs.common.spread.command.CellStyleInfo;
import kd.pmgt.pmbs.common.spread.command.WorkbookOptions;
import kd.pmgt.pmbs.common.spread.common.ContextMenuWorkArea;
import kd.pmgt.pmbs.common.spread.control.ISpreadContainer;
import kd.pmgt.pmbs.common.spread.domain.SpreadProperties;
import kd.pmgt.pmbs.common.spread.spreadmanager.ECell;

public class SpreadContainer
implements ISpreadContainer,
Serializable {
    protected String spreadKey;
    protected transient IClientViewProxy clientViewProxy;

    public SpreadContainer(IFormView view, String spreadKey) {
        this.clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        this.spreadKey = spreadKey;
    }

    @Override
    public void callbackAction(String plugin_methodname) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", plugin_methodname);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.CallBackActionMethod.CALLBACKACTION.k(), new Object[]{params});
    }

    @Override
    public void rebuildSpread(String json) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetSpreadJsonMethod.SETSPREADJSON.k(), new Object[]{json});
    }

    @Override
    public void appendRowCols(int rows, int cols) {
        if (rows > 0) {
            HashMap<String, Integer> rowcounts = new HashMap<String, Integer>();
            rowcounts.put("count", rows);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "appendRows", new Object[]{rowcounts});
        }
        if (cols > 0) {
            HashMap<String, Integer> colcounts = new HashMap<String, Integer>();
            colcounts.put("count", cols);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "appendCols", new Object[]{colcounts});
        }
    }

    @Override
    public void deleteRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            rowindexs.sort((o1, o2) -> o2 - o1);
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "deleteRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            colindexs.sort((o1, o2) -> o2 - o1);
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "deleteCol", new Object[]{parasmap});
        }
    }

    @Override
    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "insertRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "insertCol", new Object[]{parasmap});
        }
    }

    @Override
    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs, boolean copyStyle) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "insertRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "insertCol", new Object[]{parasmap});
        }
    }

    @Override
    public void setColumnsWidth(List<Integer> colindexs, int width) {
        if (colindexs == null || colindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("index", colindexs);
        parasmap.put("num", width);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), new Object[]{parasmap});
    }

    @Override
    public void setRowsHeight(List<Integer> rowindexs, int height) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("index", rowindexs);
        parasmap.put("num", height);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k(), new Object[]{parasmap});
    }

    @Override
    public void lockCells(List<CellArea> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.LockCellMethod.LOACKCELL.k(), new Object[]{paras});
    }

    @Override
    public void lockECells(List<ECell> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        ArrayList<CellArea> areas = new ArrayList<CellArea>(paras.size());
        for (ECell para : paras) {
            areas.add(new CellArea(para.getRow(), para.getCol(), 1, 1));
        }
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.LockCellMethod.LOACKCELL.k(), new Object[]{areas});
    }

    @Override
    public void unlockCells(List<CellArea> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.UnlockCellMethod.UNLOACKCELL.k(), new Object[]{paras});
    }

    @Override
    public void lockSheets(List<String> sheetnames) {
        if (sheetnames != null && sheetnames.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.LockSheetMethod.LOACKSHEET.k(), new Object[]{sheetnames});
        }
    }

    @Override
    public void unlockSheets(List<String> sheetnames) {
        if (sheetnames != null && sheetnames.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.UnLockSheetMethod.UNLOACKSHEET.k(), new Object[]{sheetnames});
        }
    }

    @Override
    public void updateCellValue2(List<ECell> cells) {
        ArrayList parameters = new ArrayList(cells.size());
        for (ECell cell : cells) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put(SpreadProperties.UpdataValueMethod.R.k(), cell.getRow());
            valMap.put(SpreadProperties.UpdataValueMethod.C.k(), cell.getCol());
            valMap.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getValue());
            parameters.add(valMap);
        }
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), new Object[]{parameters});
    }

    @Override
    public void updateCellValue(List<Map<String, Object>> parameters) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), new Object[]{parameters});
    }

    @Override
    public void getRangeValue(Map<String, List<Map<String, Object>>> parameters) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.GetRangeValues.GETRANGEVALUES.k(), new Object[]{parameters});
    }

    @Override
    public void setSpan(List<CellArea> areas) {
        if (areas != null && areas.size() > 0) {
            HashMap<String, List<CellArea>> parasmap = new HashMap<String, List<CellArea>>();
            parasmap.put("range", areas);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "setSpan", new Object[]{parasmap});
        }
    }

    @Override
    public void setCellStyle(List<AreasStyle> areasStyles) {
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        Object paras = this.packageAreaStyles(areasStyles);
        if (paras != null) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), new Object[]{paras});
        }
    }

    @Override
    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow, boolean allowSize) {
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("range", range);
        parasmap.put("index", Integer.valueOf(index));
        parasmap.put("count", Integer.valueOf(count));
        parasmap.put("styleIndex", Integer.valueOf(styleIndex));
        parasmap.put("allowSize", Boolean.valueOf(allowSize));
        if (isrow) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.FieldInsertMethod.FIELDINSERTROW.k(), new Object[]{parasmap});
        } else {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.FieldInsertMethod.FIELDINSERTCOL.k(), new Object[]{parasmap});
        }
    }

    @Override
    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow) {
        this.fieldInsertRowCol(range, index, count, styleIndex, isrow, true);
    }

    @Override
    public void fieldDeleteRowCol(CellArea range, int index, int count, boolean isrow) {
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        CellArea range01 = new CellArea(range.getR(), range.getC(), range.getRc(), range.getCc());
        parasmap.put("range", range01);
        parasmap.put("index", Integer.valueOf(index));
        parasmap.put("count", Integer.valueOf(count));
        if (isrow) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.FieldDelMethod.FIELDDELROW.k(), new Object[]{parasmap});
        } else {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.FieldDelMethod.FIELDDELCOL.k(), new Object[]{parasmap});
        }
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox) {
        this.setFListCells(cells, fuzzyQuery, combobox, false);
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean quickAddNew) {
        ArrayList celllist = new ArrayList(cells.size());
        for (ECell cell : cells) {
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            cellmap.put("r", cell.getRow());
            cellmap.put("c", cell.getCol());
            celllist.add(cellmap);
        }
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("cell", celllist);
        parasmap.put("selectType", Integer.valueOf(fuzzyQuery ? 0 : 1));
        parasmap.put("dst", Integer.valueOf(combobox ? 1 : 0));
        parasmap.put("showAddBtnWhenNoData", Boolean.valueOf(quickAddNew));
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }

    @Override
    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("cell", cellAreas);
        parasmap.put("selectType", fuzzyQuery ? 0 : 1);
        parasmap.put("dst", combobox ? 1 : 0);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }

    @Override
    public void resetCell(List<CellArea> areas) {
        HashMap<String, List<CellArea>> parasmap = new HashMap<String, List<CellArea>>();
        parasmap.put("range", areas);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "resetCell", new Object[]{parasmap});
    }

    @Override
    public void getSpreadJson(String callBack_MethodName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", callBack_MethodName);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.GetSpreadJsonMethod.GETSPREADMETHOD.k(), new Object[]{params});
    }

    @Override
    public void getRangeStyles(List<Object> area, String si, String callBack_MethodName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("range", area);
        params.put("si", si);
        params.put("invokemethod", callBack_MethodName);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "getRangeStyles", new Object[]{Lists.newArrayList((Object[])new Map[]{params})});
    }

    @Override
    public void getLockedCells(boolean compression, String si, String callBack_MethodName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("compression", compression);
        params.put("si", si);
        params.put("invokemethod", callBack_MethodName);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "getLockedCells", new Object[]{Lists.newArrayList((Object[])new Map[]{params})});
    }

    @Override
    public void setLookupData(ECell cell, Object data) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("r", cell.getRow());
        parasmap.put("c", cell.getCol());
        parasmap.put("data", data);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setLookupData", new Object[]{parasmap});
    }

    @Override
    public void setCustomFormulaCell(List<ECell> cells) {
        ArrayList paraslist = new ArrayList(cells.size());
        for (ECell cell : cells) {
            LinkedHashMap<String, Integer> parasmap = new LinkedHashMap<String, Integer>();
            parasmap.put("r", cell.getRow());
            parasmap.put("c", cell.getCol());
            paraslist.add(parasmap);
        }
        if (paraslist.size() > 0) {
            HashMap cellsmap = new HashMap();
            cellsmap.put("cell", paraslist);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetCustomFormulaCellMethod.SETCUSTOMFORMULACELL.k(), new Object[]{cellsmap});
        }
    }

    @Override
    public void setAllCustomFormulaCell() {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setAllCustomFormulaCell", new Object[0]);
    }

    @Override
    public void setSelections(CellArea cellArea) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetSelectionsMethod.SETSELECTIONS.k(), new Object[]{cellArea});
    }

    @Override
    public void exportExcelFile(String fileName) {
        HashMap<String, String> parasmap = new HashMap<String, String>();
        parasmap.put("fileName", fileName);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.ExportExcelFileMethod.EXPORTEXCELFILE.k(), new Object[]{parasmap});
    }

    @Override
    public void hideContextMenuItemsByKey(List<String> hideItems, List<String> showItems) {
        LinkedHashMap<String, Object> lockmap;
        ArrayList paraslist = new ArrayList();
        if (showItems != null && showItems.size() > 0) {
            for (String showItem : showItems) {
                lockmap = new LinkedHashMap<String, Object>();
                lockmap.put("name", showItem);
                lockmap.put("isHide", 0);
                paraslist.add(lockmap);
            }
        }
        if (hideItems != null && hideItems.size() > 0) {
            for (String hideItem : hideItems) {
                lockmap = new LinkedHashMap();
                lockmap.put("name", hideItem);
                lockmap.put("isHide", 1);
                paraslist.add(lockmap);
            }
        }
        if (paraslist.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), new Object[]{paraslist});
        }
    }

    @Override
    public void addContextMenuItems(String callBackMethod, String title, ContextMenuWorkArea contextMenuWorkArea) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("callback", "invokeAction");
        ArrayList items = new ArrayList();
        HashMap<String, Object> items_map = new HashMap<String, Object>();
        paras.put("items", items);
        items.add(items_map);
        items_map.put("name", callBackMethod);
        items_map.put("text", title);
        items_map.put("workArea", contextMenuWorkArea.getList());
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "addContextMenuItems", new Object[]{paras});
    }

    @Override
    public void deleteContextMenuItems(String[] name) {
        if (name != null && name.length > 0) {
            LinkedList params = new LinkedList();
            for (int i = 0; i < name.length; ++i) {
                HashMap<String, String> para = new HashMap<String, String>(2);
                para.put("name", name[i]);
                params.add(para);
            }
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "deleteContextMenuItems", new Object[]{params});
        }
    }

    @Override
    public void setDisplayLeftText(String text) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setDisplayLeftText", new Object[]{text});
    }

    @Override
    public void setDisplayCenterText(String text) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setDisplayCenterText", new Object[]{text});
    }

    @Override
    public void clearCellsStyle(List<CellArea> cellAreas) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "clearCellsStyle", new Object[]{cellAreas});
    }

    @Override
    public void closeToolbar() {
        HashMap parasmap = new HashMap();
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.CloseToolBar.CLOSETOOLBAR.k(), new Object[]{parasmap});
    }

    @Override
    public void closeToolbar(Boolean showExpandBtnVisible) {
        HashMap parasmap = new HashMap();
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.CloseToolBar.CLOSETOOLBAR.k(), new Object[]{parasmap});
        this.setToolbarExpandBtnVisible(showExpandBtnVisible);
    }

    @Override
    public void setToolbarExpandBtnVisible(Boolean visible) {
        HashMap<String, Boolean> parasmap = new HashMap<String, Boolean>();
        parasmap.put("visible", visible);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setExpandBtnVisible", new Object[]{parasmap});
    }

    @Override
    public void setRowsAutoFit(List<Integer> rows) {
        HashMap<String, List<Integer>> paras = new HashMap<String, List<Integer>>();
        paras.put(SpreadProperties.AutoFitRows.R.k(), rows);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.AutoFitRows.AUTOFITROWS.k(), new Object[]{paras});
    }

    @Override
    public void setColsAutoFit(List<Integer> cols) {
        HashMap<String, List<Integer>> paras = new HashMap<String, List<Integer>>();
        paras.put(SpreadProperties.AutoFitColumns.C.k(), cols);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.AutoFitColumns.AUTOFITCOLUMNS.k(), new Object[]{paras});
    }

    private Object packageAreaStyles(List<AreasStyle> areasStyles) {
        ArrayList rangestyles = new ArrayList();
        for (AreasStyle areasStyle : areasStyles) {
            List<CellArea> areas;
            if (areasStyle == null || (areas = areasStyle.getRange()) == null || areas.size() == 0) continue;
            CellStyleInfo cellStyleInfo = areasStyle.getStyle();
            Field[] fields = cellStyleInfo.getClass().getDeclaredFields();
            LinkedHashMap<String, Object> style = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> bls = new LinkedHashMap<String, Object>();
            for (Field field : fields) {
                String fieldname = field.getName();
                Object value = null;
                try {
                    ReflectionUtils.makeAccessible((Field)field);
                    value = field.get(cellStyleInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) continue;
                if ("bls".equals(fieldname) || "blc".equals(fieldname)) {
                    bls.put(fieldname, value);
                    continue;
                }
                if ("ha".equals(fieldname) || "va".equals(fieldname)) {
                    if (!(value instanceof Integer) || (Integer)value < 0) continue;
                    style.put(fieldname, value);
                    continue;
                }
                style.put(fieldname, value);
            }
            if (bls.size() > 0) {
                style.put("bl", bls);
            }
            if (style.size() <= 0 || areas.size() <= 0) continue;
            LinkedHashMap<String, Object> rangestyle = new LinkedHashMap<String, Object>();
            rangestyle.put("range", areas);
            rangestyle.put("style", style);
            rangestyles.add(rangestyle);
        }
        if (rangestyles.size() > 0) {
            return rangestyles;
        }
        return null;
    }

    @Override
    public void setDisplayContent(String status, String cellMsg, String convertStatus) {
        this.setDisplayContent("", status, cellMsg, convertStatus);
    }

    @Override
    public void setDisplayContent(String attachement, String status, String cellMsg, String convertStatus) {
        Map<String, Object> attachementArea = SpreadContainer.getStatusBarArea("attachement", attachement, "60pt", "#000000", "flex-start");
        Map<String, Object> statusArea = SpreadContainer.getStatusBarArea("status", status, "8%", "#000000", "flex-grow");
        Map<String, Object> cellMsgArea = SpreadContainer.getStatusBarArea("cellMsg", cellMsg, "55%", "#000000", "flex-grow");
        Map<String, Object> convertStatusArea = SpreadContainer.getStatusBarArea("convertStatus", convertStatus, "15%", "#000000", "flex-grow");
        ArrayList<Map<String, Object>> areaList = new ArrayList<Map<String, Object>>();
        areaList.add(attachementArea);
        areaList.add(statusArea);
        areaList.add(convertStatusArea);
        areaList.add(cellMsgArea);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetDisplayContentMethod.SETDISPALYCONTENT.k(), new Object[]{areaList});
    }

    private static Map<String, Object> getStatusBarArea(String key, String text, String w, String fc, String gr) {
        LinkedHashMap<String, Object> area = new LinkedHashMap<String, Object>();
        area.put(SpreadProperties.SetDisplayContentMethod.key.k(), key);
        area.put(SpreadProperties.SetDisplayContentMethod.TEXT.k(), text);
        LinkedHashMap<String, String> areaStyle = new LinkedHashMap<String, String>();
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.w.k(), w);
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.fc.k(), fc);
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.gr.k(), gr);
        area.put(SpreadProperties.SetDisplayContentMethod.s.k(), areaStyle);
        return area;
    }

    @Override
    public void getColumnsWidth(Integer[] cols, String callBackMethodName) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("index", cols);
        paras.put("callback", "invokeAction");
        paras.put("invokemethod", callBackMethodName);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "getColumnsWidth", new Object[]{paras});
    }

    @Override
    public void getColumnsWidth(List<Integer> cols, String callBackMethodName) {
        this.getColumnsWidth(cols.toArray(new Integer[0]), callBackMethodName);
    }

    @Override
    public void getRowsHeight(Integer[] rows, String callBackMethodName) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("index", rows);
        paras.put("callback", "invokeAction");
        paras.put("invokemethod", callBackMethodName);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "getRowsHeight", new Object[]{paras});
    }

    @Override
    public void getRowsHeight(List<Integer> rows, String callBackMethodName) {
        this.getRowsHeight(rows.toArray(new Integer[0]), callBackMethodName);
    }

    @Override
    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, boolean default_collapsed) {
        HashMap<String, Serializable> datas = new HashMap<String, Serializable>();
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        if (showCheckBox != null) {
            options.put("showCheckBox", showCheckBox);
            options.put("maxLevel", maxLevel);
            options.put("collapsed", Boolean.valueOf(default_collapsed));
        }
        if (options.size() > 0) {
            datas.put("options", options);
        }
        datas.put("c", Integer.valueOf(col));
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setOutlineColumn", new Object[]{datas});
    }

    @Override
    public void setWorksheetOptions(boolean showVerticalGridLine, boolean showHorizontalGridLine) {
        HashMap datas = new HashMap();
        HashMap options = new HashMap();
        HashMap<String, Boolean> gridline = new HashMap<String, Boolean>();
        gridline.put("showVerticalGridline", showVerticalGridLine);
        gridline.put("showHorizontalGridline", showHorizontalGridLine);
        options.put("gridline", gridline);
        datas.put("options", options);
        ArrayList areaList = new ArrayList();
        areaList.add(datas);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setWorksheetOptions", new Object[]{areaList});
    }

    @Override
    public void setWorkbookOptions(WorkbookOptions workbookOptions) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setWorkbookOptions", new Object[]{workbookOptions});
    }

    @Override
    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, Map<Integer, Boolean> collapsedFlags) {
        HashMap<String, Serializable> datas = new HashMap<String, Serializable>();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (showCheckBox != null) {
            options.put("showCheckBox", showCheckBox);
            options.put("maxLevel", maxLevel);
            options.put("collapsed", collapsedFlags);
        }
        if (options.size() > 0) {
            datas.put("options", options);
        }
        datas.put("c", Integer.valueOf(col));
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setOutlineColumn", new Object[]{datas});
    }

    @Override
    public void getOutlineColumnNode(int si, String callbackMethod) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("si", si);
        params.put("callback", "invokeAction");
        params.put("invokemethod", callbackMethod);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "getOutlineColumnNode", new Object[]{params});
    }

    @Override
    public void setVirtualMode(String callbackMethod, boolean isopen) {
        this.setVirtualMode(callbackMethod, isopen, 100);
    }

    @Override
    public void setVirtualMode(String callbackMethod, boolean isopen, Integer delay) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", callbackMethod);
        params.put("isOpen", isopen);
        if (delay != null) {
            params.put("delay", delay);
        }
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setVirtualMode", new Object[]{params});
    }

    @Override
    public void addSheets(int index, String name, int rc, int cc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object[]> fea = new HashMap<String, Object[]>();
        Object[] objects = new Object[]{params};
        params.put("index", index);
        params.put("name", name);
        params.put("rc", rc);
        params.put("cc", cc);
        fea.put("sheets", objects);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "addSheets", new Object[]{fea});
    }

    @Override
    public void updateCellValueAddSheet(List<Map<String, Object>> parameters, int si) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("si", si);
        para.put("cells", parameters);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), new Object[]{para});
    }

    @Override
    public void setColumnsWidthAddSheet(Map<String, Object> parasmap) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), new Object[]{parasmap});
    }

    @Override
    public void appendRowColsAddSheet(int rows, int cols, int si) {
        if (rows > 0) {
            HashMap<String, Integer> rowcounts = new HashMap<String, Integer>();
            rowcounts.put("count", rows);
            rowcounts.put("si", si);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "appendRows", new Object[]{rowcounts});
        }
        if (cols > 0) {
            HashMap<String, Integer> colcounts = new HashMap<String, Integer>();
            colcounts.put("count", cols);
            colcounts.put("si", si);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "appendCols", new Object[]{colcounts});
        }
    }

    @Override
    public void setCol0rRowGroupbyOnesheet(int count, int index, int si, boolean isRow) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        LinkedHashMap<String, Integer> rowcounts = new LinkedHashMap<String, Integer>();
        Object[] objects = new Object[1];
        rowcounts.put("index", index);
        rowcounts.put("count", count);
        objects[0] = rowcounts;
        feature.put("groups", objects);
        feature.put("si", si);
        if (isRow) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "setRowOutlines", new Object[]{feature});
        } else {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "setColumnOutlines", new Object[]{feature});
        }
    }

    @Override
    public void expandRowOrColOutlines(int maxlevels, boolean expand, int si, boolean isRow) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        Integer[] levels = new Integer[maxlevels + 1];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = i;
        }
        feature.put("levels", levels);
        feature.put("expand", expand);
        feature.put("si", si);
        if (isRow) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "expandRowOutlines", new Object[]{feature});
        } else {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "expandColumnOutlines", new Object[]{feature});
        }
    }

    @Override
    public void insertRowColAddSheet(List<Integer> rowindexs, List<Integer> colindexs, int si) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            parasmap.put("si", si);
            parasmap.put("copyStyle", false);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "insertRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            parasmap.put("copyStyle", false);
            parasmap.put("si", si);
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "insertCol", new Object[]{parasmap});
        }
    }

    @Override
    public void setCellStyleAddSheet(List<AreasStyle> areasStyles, int si) {
        HashMap<String, Object> featuer = new HashMap<String, Object>();
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        Object paras = this.packageAreaStyles(areasStyles);
        featuer.put("si", si);
        featuer.put("data", paras);
        if (paras != null) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), new Object[]{featuer});
        }
    }

    @Override
    public void setCellTags(List<Map<String, Object>> cellTags) {
        if (cellTags == null || cellTags.size() == 0) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setCellTag", new Object[]{cellTags});
    }

    @Override
    public void setComment(List<Map<String, Object>> data, int si) {
        if (data == null || data.size() == 0) {
            return;
        }
        ArrayList data11 = new ArrayList();
        HashMap<String, Object> optionMap1 = new HashMap<String, Object>();
        optionMap1.put("si", si);
        optionMap1.put("options", data);
        data11.add(optionMap1);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setComment", new Object[]{data11});
    }

    @Override
    public void addContextMenuItems(String callBackMethod, String title, List<Map<String, Object>> subMenus, ContextMenuWorkArea contextMenuWorkArea) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("callback", "invokeAction");
        ArrayList items = new ArrayList();
        HashMap<String, Object> items_map = new HashMap<String, Object>();
        paras.put("items", items);
        items.add(items_map);
        items_map.put("name", callBackMethod);
        items_map.put("text", title);
        items_map.put("workArea", contextMenuWorkArea.getList());
        if (subMenus != null && !subMenus.isEmpty()) {
            items_map.put("subMenu", subMenus);
        }
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "addContextMenuItems", new Object[]{paras});
    }

    @Override
    public void insertRowsBelow(List<Integer> rowindexs, boolean copyStyle) {
        if (rowindexs != null && rowindexs.size() > 0) {
            HashMap<String, Object> parasmap = new HashMap<String, Object>();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            parasmap.put("dir", "bottom");
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "insertRow", new Object[]{parasmap});
        }
    }

    @Override
    public void insertRowsBelow(int rowIndex, int count, boolean copyStyle) {
        if (count > 0) {
            ArrayList<Integer> rowindexs = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                rowindexs.add(i + rowIndex);
            }
            this.insertRowsBelow(rowindexs, copyStyle);
        }
    }

    @Override
    public void setRowsVisible(List<Integer> rowindexs, boolean isVisible) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("rows", rowindexs);
        parasmap.put("value", isVisible);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setRowsVisible", new Object[]{parasmap});
    }

    @Override
    public void setColumnsVisible(List<Integer> colindexs, boolean isVisible) {
        if (colindexs == null || colindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("cols", colindexs);
        parasmap.put("value", isVisible);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setColumnsVisible", new Object[]{parasmap});
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        ArrayList celllist = new ArrayList(cells.size());
        for (ECell cell : cells) {
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            cellmap.put("r", cell.getRow());
            cellmap.put("c", cell.getCol());
            celllist.add(cellmap);
        }
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("cell", celllist);
        parasmap.put("selectType", Integer.valueOf(fuzzyQuery ? 0 : 1));
        parasmap.put("dst", Integer.valueOf(combobox ? 1 : 0));
        parasmap.put("showAddBtnWhenNoData", Boolean.valueOf(showAddBtnWhenNoData));
        parasmap.put("lockClickable", Boolean.valueOf(lockClickable));
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }

    @Override
    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("cell", cellAreas);
        parasmap.put("selectType", fuzzyQuery ? 0 : 1);
        parasmap.put("dst", combobox ? 1 : 0);
        parasmap.put("showAddBtnWhenNoData", showAddBtnWhenNoData);
        parasmap.put("lockClickable", lockClickable);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }
}

