/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.spread.domain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.pmgt.pmbs.common.spread.domain.ExprErr;
import kd.pmgt.pmbs.common.spread.domain.SyntaxErrorException;
import kd.pmgt.pmbs.common.spread.domain.Variant;

public final class Util {
    public static final int MAX_PRECISION = 15;
    public static final int MAX_DATE_PRECISION = 7;
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final BigInteger TEN = BigInteger.valueOf(10L);
    public static final BigDecimal MINI_SECS_OF_DAY = BigDecimal.valueOf(86400000L);
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final Locale[] locales = new Locale[]{Locale.getDefault(), Locale.US, Locale.UK, Locale.CHINA, Locale.TAIWAN, Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.CHINESE, Locale.PRC};
    private static final int[] styles = new int[]{3, 2, 1, 0};
    private static String[] weekPatternArray = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    private static String[] datePatternArray = new String[]{"", "", "", ""};
    private static final int QUICKPARSE = 0;
    private static final int FULLAFTERQUICK = 2;
    private static final int LOCALESNUMINQUICKPARSE = 4;
    private static final String[] weekFields = new String[]{"EEE", "EEEE"};
    private static final String[] yearFields = new String[]{"yy", "yyyy", "yyyy"};
    private static final String[] monthFields = new String[]{"MM", "MMM", "MMMM"};
    private static final String timeInAmpmFields = "K:m:s";
    private static final String timeInDayFields = "H:m:s";
    private static final String ampmFields = "aa";
    private static final String dayFields = "dd";
    private static final String defaultPattern = "EEE yy MM dd HH:mm:ss";
    private static final String[] timeFields = new String[]{"K:m:s aa", "H:m:s", "aaK:m:s"};
    private static final int[][] mix = new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 2, 0}, {2, 1, 0}, {1, 0, 2}, {2, 0, 1}};
    private static int flag = 0;
    private static Method method;

    static int booleanToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    static char booleanToChar(boolean val) {
        if (val) {
            return 'T';
        }
        return 'F';
    }

    static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    public static Number stringToNumber(String str) throws SyntaxErrorException {
        BigDecimal bd;
        BigDecimal ret = null;
        try {
            ret = StringUtils.isEmpty((CharSequence)str) ? new BigDecimal(0) : new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            boolean percent = false;
            int length = str.length();
            if (length > 1 && str.charAt(length - 1) == '%') {
                percent = true;
                str = str.substring(0, str.length() - 1);
            }
            int dotIndex = str.indexOf(46);
            StringBuilder sb = new StringBuilder(str.length());
            if (dotIndex >= 0) {
                for (int i = str.length() - 1; i >= dotIndex; --i) {
                    sb.append(str.charAt(i));
                }
            }
            if (dotIndex < 0) {
                dotIndex = str.length();
            }
            int kioIndex = dotIndex - 4;
            for (int i = dotIndex - 1; i >= 0; --i) {
                char c = str.charAt(i);
                if (i == kioIndex) {
                    if (c == ',') {
                        kioIndex -= 4;
                        continue;
                    }
                    kioIndex -= 3;
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
            String temp = sb.reverse().toString();
            try {
                BigDecimal bd2 = new BigDecimal(temp);
                if (percent) {
                    bd2 = bd2.divide(BigDecimal.valueOf(100.0), 16, 4);
                }
                ret = bd2;
            }
            catch (NumberFormatException e2) {
                ExprErr.goError(64L, String.format(str, ResManager.loadKDString((String)"%s->\u975e\u6570\u503c", (String)"Util_0", (String)"pmgt-pmbs-common", (Object[])new Object[0])));
            }
        }
        if (ret != null && (bd = ret).scale() != 0 && str.indexOf(69) == 0 && str.indexOf(101) == 0) {
            ret = bd.setScale(0);
        }
        return ret;
    }

    public static boolean stringToBoolean(String val) throws SyntaxErrorException {
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        ExprErr.goError(64L, ResManager.loadKDString((String)"\u65e0\u6cd5\u8f6c\u6362\u4e3aBoolean\u7c7b\u578b", (String)"Util_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        return false;
    }

    private static Date stringToDate(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getDateInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getTimeInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToDateTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                for (int k = 0; k < styles.length; ++k) {
                    df = DateFormat.getDateTimeInstance(styles[j], styles[k], locales[i]);
                    df.setLenient(false);
                    try {
                        ret = df.parse(src);
                        break block2;
                    }
                    catch (Exception e) {
                        ret = null;
                        continue;
                    }
                }
            }
        }
        return ret;
    }

    public static Date stringToDate(String src) {
        SimpleDateFormat FMT_DATE = new SimpleDateFormat("yyyy-M-d");
        SimpleDateFormat FMT_DATETIME = new SimpleDateFormat("yyyy-M-d H:mm");
        SimpleDateFormat FMT_FULLDATETIME = new SimpleDateFormat("yyyy-M-d H:mm:ss");
        Date ret = null;
        if (src.length() > 10) {
            try {
                ret = FMT_FULLDATETIME.parse(src);
            }
            catch (ParseException e) {
                try {
                    ret = FMT_DATETIME.parse(src);
                }
                catch (ParseException e2) {
                    try {
                        ret = FMT_DATE.parse(src);
                    }
                    catch (ParseException e3) {
                        ret = null;
                    }
                }
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
        }
        return ret;
    }

    static void add(byte left, byte right, Variant result) {
        int ret = left + right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void add(short left, short right, Variant result) {
        int ret = left + right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void add(int left, int right, Variant result) {
        long ret = (long)left + (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void add(long left, long right, Variant result) {
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    static void add(float left, float right, Variant result) {
        float ret = left + right;
        if (ret == Float.POSITIVE_INFINITY || ret == Float.NEGATIVE_INFINITY) {
            Util.add((double)left, (double)right, result);
        } else {
            result.setFloat(ret);
        }
    }

    static void add(double left, double right, Variant result) {
        double ret = left + right;
        result.setDouble(ret);
    }

    static void subtract(byte left, byte right, Variant result) {
        int ret = left - right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void subtract(short left, short right, Variant result) {
        int ret = left - right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void subtract(int left, int right, Variant result) {
        long ret = (long)left - (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void subtract(long left, long right, Variant result) {
        right = -right;
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    static void subtract(float left, float right, Variant result) {
        float ret = left - right;
        if (ret == Float.POSITIVE_INFINITY || ret == Float.NEGATIVE_INFINITY) {
            Util.subtract((double)left, (double)right, result);
        } else {
            result.setFloat(ret);
        }
    }

    static void subtract(double left, double right, Variant result) {
        double ret = left - right;
        result.setDouble(ret);
    }

    static void multiply(byte left, byte right, Variant result) {
        int ret = left * right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void multiply(short left, short right, Variant result) {
        int ret = left * right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void multiply(int left, int right, Variant result) {
        long ret = (long)left * (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void multiply(long left, long right, Variant result) {
        if (left == 1L) {
            result.setLong(right);
        } else if (right == 1L) {
            result.setLong(left);
        } else {
            double dfValue = (double)left * (double)right;
            long lValue = left * right;
            if (Math.abs(dfValue) > (double)Math.abs(lValue)) {
                result.setDouble(dfValue);
            } else {
                result.setLong(lValue);
            }
        }
    }

    static void multiply(float left, float right, Variant result) {
        float ret = left * right;
        result.setFloat(ret);
    }

    static void multiply(double left, double right, Variant result) {
        double ret = left * right;
        result.setDouble(ret);
    }

    static void divide(byte left, byte right, Variant result) {
        int ret = left / right;
        result.setByte((byte)ret);
    }

    static void divide(short left, short right, Variant result) {
        int ret = left / right;
        result.setShort((short)ret);
    }

    static void divide(int left, int right, Variant result) {
        int ret = left / right;
        result.setInt(ret);
    }

    static void divide(long left, long right, Variant result) {
        long ret = left / right;
        result.setLong(ret);
    }

    static void divide(float left, float right, Variant result) {
        float ret = left / right;
        result.setFloat(ret);
    }

    static void divide(double left, double right, Variant result) {
        double ret = left / right;
        result.setDouble(ret);
    }

    static void mod(byte left, byte right, Variant result) {
        result.setByte((byte)(left % right));
    }

    static void mod(short left, short right, Variant result) {
        result.setShort((short)(left % right));
    }

    static void mod(int left, int right, Variant result) {
        result.setInt(left % right);
    }

    static void mod(long left, long right, Variant result) {
        result.setLong(left % right);
    }

    static void mod(float left, float right, Variant result) {
        result.setFloat(left % right);
    }

    static void mod(double left, double right, Variant result) {
        result.setDouble(left % right);
    }

    static void and(byte left, byte right, Variant result) {
        result.setByte((byte)(left & right));
    }

    static void and(short left, short right, Variant result) {
        result.setShort((short)(left & right));
    }

    static void and(int left, int right, Variant result) {
        result.setInt(left & right);
    }

    static void and(long left, long right, Variant result) {
        result.setLong(left & right);
    }

    static void and(float left, float right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    static void and(double left, double right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    static void or(byte left, byte right, Variant result) {
        result.setByte((byte)(left | right));
    }

    static void or(short left, short right, Variant result) {
        result.setShort((short)(left | right));
    }

    static void or(int left, int right, Variant result) {
        result.setInt(left | right);
    }

    static void or(long left, long right, Variant result) {
        result.setLong(left | right);
    }

    static void or(float left, float right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    static void or(double left, double right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    static void xor(byte left, byte right, Variant result) {
        result.setByte((byte)(left ^ right));
    }

    static void xor(short left, short right, Variant result) {
        result.setShort((short)(left ^ right));
    }

    static void xor(int left, int right, Variant result) {
        result.setInt(left ^ right);
    }

    static void xor(long left, long right, Variant result) {
        result.setLong(left ^ right);
    }

    static void xor(float left, float right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }

    static void xor(double left, double right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }

    public static BigDecimal reduceScale(BigDecimal bd) {
        BigInteger intval = bd.unscaledValue();
        int ns = 0;
        int scale = bd.scale();
        if (intval.signum() != 0) {
            int i;
            String str = intval.toString();
            int len = str.length();
            int end = len - scale;
            for (i = len - 1; i >= end && str.charAt(i) == '0'; --i) {
            }
            ns = scale - (len - 1 - i);
        }
        if (ns != scale) {
            bd = bd.setScale(ns);
        }
        return bd;
    }

    public static void reduceScale(Variant var) {
        if (var.getVt() == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            BigInteger intval = bd.unscaledValue();
            int ns = 0;
            int scale = bd.scale();
            if (intval.signum() != 0) {
                int i;
                String str = intval.toString();
                int len = str.length();
                int end = len - scale;
                for (i = len - 1; i >= end && str.charAt(i) == '0'; --i) {
                }
                ns = scale - (len - 1 - i);
            }
            if (ns != scale) {
                bd = bd.setScale(ns);
                var.setObject(bd, 10);
            }
        }
    }

    public static String bigDecimalToPlainString(BigDecimal number) {
        if (flag == 0) {
            Class<?> cls = number.getClass();
            try {
                method = cls.getMethod("toPlainString", new Class[0]);
            }
            catch (SecurityException e) {
                method = null;
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            ++flag;
        }
        if (method != null) {
            try {
                return (String)method.invoke((Object)number, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                return number.toString();
            }
            catch (IllegalAccessException e) {
                return number.toString();
            }
            catch (InvocationTargetException e) {
                return number.toString();
            }
        }
        return number.toString();
    }
}

