/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.spread.domain;

import java.math.BigInteger;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.pmgt.pmbs.common.spread.domain.ExprErr;
import kd.pmgt.pmbs.common.spread.domain.SyntaxErrorException;
import kd.pmgt.pmbs.common.spread.domain.Util;
import kd.pmgt.pmbs.common.spread.domain.VarBase;
import kd.pmgt.pmbs.common.spread.domain.Variant;

class VarBoolean
extends VarBase {
    VarBoolean() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            if (right.getVt() == 8) {
                boolean rightval = (Boolean)right.getValue();
                result.setInt(leftval + Util.booleanToInt(rightval));
            } else {
                Variant temp = new Variant();
                temp.setInt(leftval);
                temp.add(right, result);
            }
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            if (right.getVt() == 8) {
                boolean rightval = (Boolean)right.getValue();
                result.setInt(leftval - Util.booleanToInt(rightval));
            } else {
                Variant temp = new Variant();
                temp.setInt(leftval);
                temp.subtract(right, result);
            }
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            int leftval = Util.booleanToInt((Boolean)left.getValue());
            if (right.getVt() == 8) {
                boolean rightval = (Boolean)right.getValue();
                result.setInt(leftval * Util.booleanToInt(rightval));
            } else {
                Variant temp = new Variant();
                temp.setInt(leftval);
                temp.multiply(right, result);
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            if (right.getVt() == 8) {
                int rightval = Util.booleanToInt((Boolean)right.getValue());
                if (rightval != 0) {
                    result.setInt(leftval / rightval);
                } else {
                    ExprErr.goError(2L, null);
                }
            } else {
                Variant temp = new Variant();
                temp.setInt(leftval);
                temp.divide(right, result);
            }
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.mod(leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.mod(leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).mod(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    Util.mod((double)leftval, right.doubleValue(), result);
                    break;
                }
                case 11: {
                    Variant vright = new Variant();
                    if (right.isNumeric(vright)) {
                        this.mod(left, vright, result);
                        break;
                    }
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                    break;
                }
                case 12: {
                    Util.mod((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.mod((double)leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.mod((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        boolean leftval = (Boolean)left.getValue();
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setBoolean(leftval && rightval);
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        boolean leftval = (Boolean)left.getValue();
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setBoolean(leftval || rightval);
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        boolean leftval = (Boolean)left.getValue();
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setBoolean(leftval ^ rightval);
        }
    }
}

