/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.spread.spreadmanager;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.util.StringUtils;
import kd.pmgt.pmbs.common.spread.domain.CellData;
import kd.pmgt.pmbs.common.spread.domain.Variant;
import kd.pmgt.pmbs.common.spread.spreadmanager.hander.ESpanInfo;
import kd.pmgt.pmbs.common.spread.utils.ExcelUtils;

public class ECell
implements Serializable {
    private static final long serialVersionUID = 1L;
    private volatile CellData cellData;
    private String formula;
    private ESpanInfo spanInfo;
    private boolean isChangeVal = false;
    private transient int row = -1;
    private transient int col = -1;
    private volatile transient Object newValue;
    private boolean isFloatCell;

    public ECell() {
        this.cellData = new CellData();
    }

    public ECell(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public void setRowAndCol(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public ECell(int row, int col, Object value) {
        this.row = row;
        this.col = col;
        this.cellData = new CellData();
        this.setValue(value);
    }

    public final boolean setValue(Object val) {
        boolean oldValIsNull;
        Variant temp = this.convert2Variant(val);
        Variant oldCellData = this.cellData.getData();
        this.isChangeVal = false;
        boolean bl = oldValIsNull = oldCellData == null || oldCellData.isNull() || oldCellData.isEmpty();
        if (oldValIsNull && val != null && StringUtils.isNotEmpty((String)val.toString()) || !oldValIsNull && val == null || !oldValIsNull && temp.compareTo(oldCellData) != 0) {
            this.isChangeVal = true;
            this.cellData.setData(temp);
        }
        return this.isChangeVal;
    }

    private Variant convert2Variant(Object val) {
        if (val instanceof BigDecimal) {
            return new Variant(val);
        }
        if (val instanceof Number) {
            return new Variant(new BigDecimal(val.toString()));
        }
        if (val instanceof Variant && Variant.encryptVariant.equals(val)) {
            return (Variant)val;
        }
        return new Variant(val);
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public Variant getVariant() {
        return this.cellData.getData();
    }

    public boolean isChangeVal() {
        return this.isChangeVal;
    }

    public void setChangeVal(boolean isChange) {
        this.isChangeVal = isChange;
    }

    public void setCellData(CellData cellData) {
        this.cellData = cellData;
    }

    public ESpanInfo getSpanInfo() {
        return this.spanInfo;
    }

    public void setSpanInfo(ESpanInfo spanInfo) {
        this.spanInfo = spanInfo;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean hasFormula() {
        return this.formula == null || StringUtils.isNotEmpty((String)this.formula);
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public Object getValue() {
        return this.cellData.getData().getValue();
    }

    public String getExcelAxis() {
        return ExcelUtils.xy2Pos(this.col, this.row);
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public boolean isFloatCell() {
        return this.isFloatCell;
    }

    public void setFloatCell(boolean floatCell) {
        this.isFloatCell = floatCell;
    }
}

