/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.spread.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.pmgt.pmbs.common.spread.utils.ExcelUtils;

public final class RangeModel {
    private int x_start = 0;
    private int x_end = 0;
    private int y_start = 0;
    private int y_end = 0;
    private static final int ZeroCharValue = 48;

    public void setXStart(int xStart) {
        this.x_start = xStart;
    }

    public int getXStart() {
        return this.x_start;
    }

    public void setXEnd(int xEnd) {
        this.x_end = xEnd;
    }

    public int getXEnd() {
        return this.x_end;
    }

    public void setYStart(int yStart) {
        this.y_start = yStart;
    }

    public int getYStart() {
        return this.y_start;
    }

    public void setYEnd(int yEnd) {
        this.y_end = yEnd;
    }

    public int getYEnd() {
        return this.y_end;
    }

    private static int getColAxisIndex(String pos, int start, int end) {
        if (end - start > 1 && Character.isLetter(pos.charAt(start)) && !Character.isLetter(pos.charAt(start + 1))) {
            return start + 1;
        }
        for (int index = start + 2; index < end; ++index) {
            if (Character.isLetter(pos.charAt(index))) continue;
            return index;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u533a\u57df\u5750\u6807\u65e0\u6548\u3002%s", (String)"RangeModel_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]), pos));
    }

    private static int pos2X(String pos, int start, int colAxisIndex) {
        int count = -1;
        for (int i = start; i < colAxisIndex; ++i) {
            char c = pos.charAt(i);
            count = c >= 'a' && c <= 'z' ? (int)((double)count + (double)(c - 96) * Math.pow(26.0, colAxisIndex - 1 - i)) : (int)((double)count + (double)(c - 64) * Math.pow(26.0, colAxisIndex - 1 - i));
        }
        return count;
    }

    private static int pos2Y(String pos, int colAxisIndex, int end) {
        int result = 0;
        int j = 1;
        for (int i = end - 1; i >= colAxisIndex; --i) {
            char c = pos.charAt(i);
            if (c >= '0' && c <= '9') {
                result += (c - 48) * j;
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\u3002%s", (String)"RangeModel_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]), pos));
            }
            j *= 10;
        }
        return result - 1;
    }

    public RangeModel(String area) {
        Objects.requireNonNull(area);
        int colonIndex = area.indexOf(58);
        if (colonIndex < 0) {
            int colAxisIndex = RangeModel.getColAxisIndex(area, 0, area.length());
            this.x_start = this.x_end = RangeModel.pos2X(area, 0, colAxisIndex);
            this.y_start = this.y_end = RangeModel.pos2Y(area, colAxisIndex, area.length());
        } else if (colonIndex > 0) {
            int colAxisIndex = RangeModel.getColAxisIndex(area, 0, colonIndex);
            this.x_start = RangeModel.pos2X(area, 0, colAxisIndex);
            this.y_start = RangeModel.pos2Y(area, colAxisIndex, colonIndex);
            colAxisIndex = RangeModel.getColAxisIndex(area, colonIndex + 1, area.length());
            this.x_end = RangeModel.pos2X(area, colonIndex + 1, colAxisIndex);
            this.y_end = RangeModel.pos2Y(area, colAxisIndex, area.length());
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u533a\u57df\u5750\u6807\u65e0\u6548\u3002%s", (String)"RangeModel_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]), area));
        }
    }

    public RangeModel(int x_start, int x_end, int y_start, int y_end) {
        this.x_start = x_start;
        this.x_end = x_end;
        this.y_start = y_start;
        this.y_end = y_end;
    }

    public boolean checkIsInArea(RangeModel range) {
        return this.x_start >= range.x_start && this.y_start >= range.y_start && this.x_end <= range.x_end && this.y_end <= range.y_end;
    }

    public boolean isRowInArea(int idx) {
        return this.y_start <= idx && this.y_end >= idx;
    }

    public boolean isColInArea(int idx) {
        return this.x_start <= idx && this.x_end >= idx;
    }

    public String getLeft_UpOne(int rowOffset, int colOffset) {
        if (this.x_start == this.x_end && this.y_start == this.y_end) {
            return ExcelUtils.xy2Pos(this.x_start - rowOffset, this.y_start - colOffset);
        }
        return ExcelUtils.xy2Pos(this.x_start - rowOffset, this.y_start - colOffset) + ":" + ExcelUtils.xy2Pos(this.x_end - rowOffset, this.y_end - colOffset);
    }

    public Set<String> getCombination() {
        HashSet<String> set = new HashSet<String>();
        for (int i = this.x_start; i <= this.x_end; ++i) {
            for (int j = this.y_start; j <= this.y_end; ++j) {
                set.add(i + "_" + j);
            }
        }
        return set;
    }

    public Collection<String> spiltToRow() {
        ArrayList<String> collection = new ArrayList<String>(this.y_end - this.y_start + 1);
        for (int i = this.y_start; i <= this.y_end; ++i) {
            collection.add(String.valueOf(i + 1));
        }
        return collection;
    }

    public Collection<String> spiltToCol() {
        ArrayList<String> collection = new ArrayList<String>(this.y_end - this.y_start + 1);
        for (int i = this.x_start; i <= this.x_end; ++i) {
            collection.add(ExcelUtils.int2pos(i));
        }
        return collection;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x_start;
        result = 31 * result + this.x_end;
        result = 31 * result + this.y_start;
        result = 31 * result + this.y_end;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangeModel) {
            RangeModel other = (RangeModel)obj;
            return other.x_start == this.x_start && other.x_end == this.x_end && other.y_start == this.y_start && other.y_end == this.y_end;
        }
        return false;
    }

    public String toString() {
        String b;
        String a = ExcelUtils.xy2Pos(this.x_start, this.y_start);
        if (a.equals(b = ExcelUtils.xy2Pos(this.x_end, this.y_end))) {
            return a;
        }
        return ExcelUtils.xy2Pos(this.x_start, this.y_start) + ":" + ExcelUtils.xy2Pos(this.x_end, this.y_end);
    }

    public int getX_start() {
        return this.x_start;
    }

    public int getX_end() {
        return this.x_end;
    }

    public int getY_start() {
        return this.y_start;
    }

    public int getY_end() {
        return this.y_end;
    }

    public void setX_start(int x_start) {
        this.x_start = x_start;
    }

    public void setX_end(int x_end) {
        this.x_end = x_end;
    }

    public void setY_start(int y_start) {
        this.y_start = y_start;
    }

    public void setY_end(int y_end) {
        this.y_end = y_end;
    }
}

