/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.tree;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import kd.pmgt.pmbs.common.tree.DynamicInfoCollection;
import org.apache.commons.io.IOUtils;

public class BillListUtil {
    private static final Log logger = LogFactory.getLog(BillListUtil.class);
    private static final long MAX_LOCK_TIME = 600000L;
    private static Map<String, String> fieldMap = new LinkedHashMap<String, String>(){};

    public DynamicInfoCollection checkFieldRef(List<Long> ids, Long billId, Long appId) {
        String refedDmr = "refed_dmr";
        String refedCp = "refed_cp";
        String refedNo = "refed_no";
        String writeoffSch = "refed_wo";
        String queryfield = "number";
        DynamicInfoCollection fieldInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5b57\u6bb5\u7684\u4fe1\u606f", (String)"BillListUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]), queryfield, "id", "name", refedDmr, refedCp, refedNo, writeoffSch);
        if (ids != null && !ids.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", (Object)ids.toArray());
            DynamicObjectCollection fields = QueryServiceHelper.query((String)"pmbs_bgcontrolbizreg", (String)"isprefab,id,number,name", (QFilter[])new QFilter[]{idFilter});
            if (fields.isEmpty()) {
                return fieldInfo;
            }
            for (DynamicObject field : fields) {
                String number = field.getString(queryfield);
                String info = field.getString("id");
                String name = field.getString("name");
                fieldInfo.addInfo(number, info, name, false, false, true, false);
            }
        }
        return fieldInfo;
    }

    public List<String> getRefedInfo(DynamicInfoCollection checkResult) {
        List<Object> refedDmr = checkResult.getAllValOfOnePropByAnotherProp("name", "refed_dmr", true);
        List<Object> refedCp = checkResult.getAllValOfOnePropByAnotherProp("name", "refed_cp", true);
        List<Object> refed_wo = checkResult.getAllValOfOnePropByAnotherProp("name", "refed_wo", true);
        ArrayList<String> warnInfos = new ArrayList<String>(16);
        if (!refedDmr.isEmpty()) {
            warnInfos.add(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"BillListUtil_44", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        if (!refedCp.isEmpty()) {
            warnInfos.add(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"BillListUtil_44", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        if (!refed_wo.isEmpty()) {
            warnInfos.add(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"BillListUtil_44", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        return warnInfos;
    }

    public static TreeNode getFirstBillNode(TreeNode currentNode) {
        TreeNode node = null;
        String billTreeType = BillListUtil.getNodeData41Key("billType", currentNode);
        if (!EventBillTreeTypeEnum.BILL.getNumber().equals(billTreeType)) {
            List children = currentNode.getChildren();
            if (children != null && !children.isEmpty()) {
                TreeNode child;
                Iterator iterator = children.iterator();
                while (iterator.hasNext() && (node = BillListUtil.getFirstBillNode(child = (TreeNode)iterator.next())) == null) {
                }
            }
        } else {
            node = currentNode;
        }
        return node;
    }

    public static String getNodeData41Key(String key, TreeNode node) {
        String value = null;
        Map data = (Map)node.getData();
        if (data != null) {
            value = (String)data.get(key);
        }
        return value;
    }

    public TreeNode getUserBillTree() {
        TreeNode node;
        String parentId;
        DynamicObjectCollection structOfBillObjects = BillListUtil.queryNodeBySys(null);
        if (structOfBillObjects == null || structOfBillObjects.isEmpty()) {
            BillListUtil.presetField();
            structOfBillObjects = BillListUtil.queryNodeBySys(null);
        }
        QFilter qBillNumFilter = new QFilter("number", "in", (Object)structOfBillObjects.stream().filter(it -> "bill".equals(it.getString("billtype"))).map(it -> it.getString("fieldtable")).toArray());
        DynamicObjectCollection billInfo = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number,name,bizappid", (QFilter[])new QFilter[]{qBillNumFilter});
        List appOrCloudInfo = billInfo.stream().map(it -> it.get("bizappid")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", appOrCloudInfo);
        DynamicObjectCollection appInfos = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name,bizcloud.number,bizcloud.name", (QFilter[])new QFilter[]{idFilter});
        for (DynamicObject structOfBillObject : structOfBillObjects) {
            Object number = structOfBillObject.get("number");
            if ("bill".equals(structOfBillObject.getString("billtype"))) {
                billInfo.stream().filter(it -> number.equals(it.get("number"))).findFirst().ifPresent(info -> structOfBillObject.set("name", info.get("name")));
                continue;
            }
            appInfos.stream().filter(it -> number.equals(it.get("number"))).findFirst().ifPresent(appInfo -> structOfBillObject.set("name", appInfo.get("name")));
        }
        TreeNode rootNode = new TreeNode(null, "0", "root");
        HashMap<String, String> rootData = new HashMap<String, String>(16);
        rootData.put("billType", "god");
        rootNode.setData(rootData);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        nodeMap.put("0", rootNode);
        for (DynamicObject childNode : structOfBillObjects) {
            parentId = childNode.getString("parent");
            if (parentId != null && !"0".equals(parentId)) {
                node = this.getChildNode(childNode);
                nodeMap.put(childNode.getString("id"), node);
                continue;
            }
            node = this.getLeftNode(childNode);
            nodeMap.put(childNode.getString("id"), node);
        }
        for (DynamicObject childNode : structOfBillObjects) {
            parentId = childNode.getString("parent");
            if (parentId == null || !nodeMap.containsKey(parentId)) continue;
            node = (TreeNode)nodeMap.get(childNode.getString("id"));
            TreeNode parentNode = (TreeNode)nodeMap.get(parentId);
            List children = parentNode.getChildren();
            if (children == null) {
                ArrayList<TreeNode> children1 = new ArrayList<TreeNode>(16);
                children1.add(node);
                parentNode.setChildren(children1);
                continue;
            }
            children.add(node);
        }
        return rootNode;
    }

    public static DynamicObjectCollection queryNodeBySys(Boolean isFromOuter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        if (isFromOuter != null) {
            enableFilter.and(new QFilter("isfromouter", "=", (Object)isFromOuter));
        }
        return QueryServiceHelper.query((String)"pmbs_structofbill", (String)"id,name,number,parent,fieldtable,level,isfromouter,isleaf,billtype,formulajson,controltarget,initstatus", (QFilter[])new QFilter[]{enableFilter}, (String)"id");
    }

    public DynamicObject queryFieldTableByID(Long selectedNodeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)selectedNodeId);
        return QueryServiceHelper.queryOne((String)"pmbs_structofbill", (String)"id,name,number,parent,level,fieldtable,billtype,formulajson,controltarget,initstatus", (QFilter[])new QFilter[]{qFilter});
    }

    private TreeNode getChildNode(DynamicObject structOfBill) {
        TreeNode node = new TreeNode();
        node.setId(structOfBill.getString("id"));
        node.setText(structOfBill.getString("name"));
        String parent = structOfBill.getString("parent");
        node.setParentid(parent);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("isNew", "1");
        data.put("name", structOfBill.getString("name"));
        data.put("number", structOfBill.getString("number"));
        data.put("id", structOfBill.getString("id"));
        data.put("isFromOuter", structOfBill.getString("isfromouter"));
        data.put("billType", structOfBill.getString("billtype"));
        data.put("formulajson", structOfBill.getString("formulajson"));
        data.put("controltarget", structOfBill.getString("controltarget"));
        data.put("initstatus", structOfBill.getString("initstatus"));
        data.put("fieldtable", structOfBill.getString("fieldtable"));
        node.setData(data);
        return node;
    }

    private TreeNode getLeftNode(DynamicObject structOfBill) {
        TreeNode rootLeft = new TreeNode();
        rootLeft.setId(structOfBill.getString("id"));
        rootLeft.setText(structOfBill.getString("name"));
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("isNew", "1");
        data.put("name", structOfBill.getString("name"));
        data.put("number", structOfBill.getString("number"));
        data.put("id", structOfBill.getString("id"));
        data.put("billType", structOfBill.getString("billtype"));
        data.put("isFromOuter", structOfBill.getString("isfromouter"));
        data.put("formulajson", structOfBill.getString("formulajson"));
        data.put("controltarget", structOfBill.getString("controltarget"));
        data.put("initstatus", structOfBill.getString("initstatus"));
        rootLeft.setData(data);
        return rootLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void presetField() {
        try (DLock lock = DLock.create((String)"pmgt/pmbs/bill/fieldpreset");){
            if (!lock.tryLock(600000L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u4e92\u65a5\uff1a\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u9884\u5236\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u5904\u7406\u3002", (String)"BillListUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            }
            try {
                DynamicObjectCollection dynamicObjects = BillListUtil.queryNodeBySys(null);
                if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                    return;
                }
                String resources = BillListUtil.getStringFromResources("resources/preset/fieldpreset.json");
                JSONObject jsonObject = JSONObject.parseObject((String)resources);
                ArrayList<DynamicObject> structOfBillObject = new ArrayList<DynamicObject>(16);
                ArrayList<DynamicObject> fieldObject = new ArrayList<DynamicObject>(16);
                ArrayList<DynamicObject> fieldShowObject = new ArrayList<DynamicObject>(16);
                BillListUtil.addToList(jsonObject, structOfBillObject, fieldObject, fieldShowObject);
                try (TXHandle tx = TX.required((String)"pmgt/pmbs/bill/fieldpreset");){
                    try {
                        SaveServiceHelper.save((DynamicObject[])structOfBillObject.toArray(new DynamicObject[0]));
                        SaveServiceHelper.save((DynamicObject[])fieldObject.toArray(new DynamicObject[0]));
                        SaveServiceHelper.save((DynamicObject[])fieldShowObject.toArray(new DynamicObject[0]));
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static String getStringFromResources(String path) {
        String var;
        InputStream in = null;
        try {
            in = BillListUtil.class.getClassLoader().getResourceAsStream(path);
            if (in == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"BillListUtil_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            }
            var = IOUtils.toString((InputStream)in, (String)"UTF-8");
        }
        catch (IOException var11) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"BillListUtil_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return var;
    }

    private static void addToList(JSONObject jsonObject, List<DynamicObject> structOfBillOjbect, List<DynamicObject> fieldObject, List<DynamicObject> fieldShowObject) {
        BillListUtil.addStructOfBillObject(jsonObject, "root", null, structOfBillOjbect, fieldObject, fieldShowObject);
    }

    private static void addStructOfBillObject(JSONObject jsonObject, String billtype, Object parentid, List<DynamicObject> structOfBillOjbect, List<DynamicObject> fieldObject, List<DynamicObject> fieldShowObject) {
        if (jsonObject != null && !StringUtils.isEmpty((String)billtype) && structOfBillOjbect != null && fieldObject != null && fieldShowObject != null && jsonObject.get((Object)billtype) != null) {
            JSONArray rootArray = jsonObject.getJSONArray(billtype);
            for (Object o : rootArray) {
                JSONObject jsonObject1 = (JSONObject)o;
                DynamicObject root = BusinessDataServiceHelper.newDynamicObject((String)"pmbs_structofbill");
                BillListUtil.createStructOfBill(jsonObject1, root, parentid, billtype);
                structOfBillOjbect.add(root);
                String billTypeAfter = BillListUtil.getBillTypeAfter(billtype);
                if (StringUtils.isEmpty((String)billTypeAfter)) {
                    BillListUtil.addFieldObject(jsonObject1, parentid, root.get("id"), root.getString("fieldtable"), fieldObject, fieldShowObject);
                    continue;
                }
                BillListUtil.addStructOfBillObject(jsonObject1, billTypeAfter, root.get("id"), structOfBillOjbect, fieldObject, fieldShowObject);
            }
        }
    }

    private static void addFieldObject(JSONObject jsonObject, Object bizSysid, Object bizUnitid, String fieldtable, List<DynamicObject> fieldObject, List<DynamicObject> fieldShowObject) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        HashSet<String> set = new HashSet<String>(16);
        MainEntityType dType = MetadataServiceHelper.getDataEntityType((String)fieldtable);
        DataEntityPropertyCollection properties = dType.getProperties();
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)dType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        MainEntity rootEntity = entityMeta.getRootEntity();
        List operations = rootEntity.getOperations();
        BillListUtil.addToMap(map, set, properties, null, null);
        operations.forEach(op -> map.put(op.getKey(), op.getName().getLocaleValue()));
        int i = 1;
        Iterator<Map.Entry<String, String>> var14 = fieldMap.entrySet().iterator();
        while (var14.hasNext()) {
            Map.Entry<String, String> entry = var14.next();
            if (jsonObject.get((Object)entry.getKey()) == null) continue;
            JSONArray array = jsonObject.getJSONArray(entry.getKey());
            DynamicObject showfield = BusinessDataServiceHelper.newDynamicObject((String)"pmbs_conbizregdata");
            showfield.set("id", (Object)DBServiceHelper.genGlobalLongId());
            showfield.set("fielddimension", (Object)entry.getValue());
            showfield.set("bill", bizUnitid);
            showfield.set("fieldtable", (Object)fieldtable);
            showfield.set("sequence", (Object)i++);
            DynamicObjectCollection entity = showfield.getDynamicObjectCollection("entryentity");
            int j = 1;
            for (Object o : array) {
                String number = (String)o;
                String name = (String)map.get(number);
                if (number == null || name == null) continue;
                DynamicObject field = BusinessDataServiceHelper.newDynamicObject((String)"pmbs_bgcontrolbizreg");
                DynamicObject show = entity.addNew();
                long id = DBServiceHelper.genGlobalLongId();
                show.set("id", (Object)id);
                show.set("number", (Object)number);
                show.set("name", (Object)name);
                show.set("isprefab", (Object)true);
                show.set("seq", (Object)j++);
                field.set("id", (Object)id);
                field.set("name", (Object)name);
                field.set("number", (Object)number);
                field.set("fieldalias", (Object)number);
                field.set("bizsystemid", bizSysid);
                field.set("bizunitid", bizUnitid);
                field.set("fieldtable", (Object)fieldtable);
                field.set("type", (Object)entry.getKey());
                field.set("typename", (Object)entry.getValue());
                field.set("isentryfield", (Object)set.contains(number));
                field.set("isprefab", (Object)true);
                BillListUtil.setDefaultValue(field);
                fieldObject.add(field);
            }
            fieldShowObject.add(showfield);
        }
        return;
    }

    private static void addToMap(Map<String, String> map, Set<String> set, DataEntityPropertyCollection properties, String parentName, String parentNumber) {
        for (IDataEntityProperty property : properties) {
            String number = property.getName();
            if (property.getDisplayName() == null) continue;
            String name = property.getDisplayName().getLocaleValue_zh_CN();
            if (name != null) {
                if (parentName != null && parentNumber != null) {
                    set.add(parentNumber + "." + number);
                    map.put(parentNumber + "." + number, parentName + "." + name);
                } else {
                    map.put(number, name);
                }
            }
            if (!(property instanceof EntryProp)) continue;
            IDataEntityType entryType = ((EntryProp)property).getItemType();
            DataEntityPropertyCollection entryTypeProperties = entryType.getProperties();
            BillListUtil.addToMap(map, set, entryTypeProperties, name, number);
        }
    }

    private static String getBillTypeAfter(String billtype) {
        switch (billtype) {
            case "root": {
                return "cloud";
            }
            case "cloud": {
                return "application";
            }
            case "application": {
                return "bill";
            }
        }
        return null;
    }

    public static String getResName(String number) {
        if ("INSIDE_NODE".equals(number)) {
            return ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf", (String)"BillListUtil_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("ESC".equals(number)) {
            return ResManager.loadKDString((String)"\u5458\u5de5\u670d\u52a1\u4e91", (String)"BillListUtil_5", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("exp".equals(number)) {
            return ResManager.loadKDString((String)"\u4eba\u4eba\u8d39\u7528", (String)"BillListUtil_6", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_dailyapplybill".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u7533\u8bf7\u5355", (String)"BillListUtil_7", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_dailyloanbill".equals(number)) {
            return ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"BillListUtil_8", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_dailyreimbursebill".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500\u5355", (String)"BillListUtil_9", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("tra".equals(number)) {
            return ResManager.loadKDString((String)"\u4eba\u4eba\u5dee\u65c5", (String)"BillListUtil_10", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_tripreqbill".equals(number)) {
            return ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"BillListUtil_11", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_tripreimbursebill".equals(number)) {
            return ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"BillListUtil_12", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("FI".equals(number)) {
            return ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"BillListUtil_13", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("em".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u6838\u7b97", (String)"BillListUtil_14", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_publicreimbursebill".equals(number)) {
            return ResManager.loadKDString((String)"\u5bf9\u516c\u62a5\u9500\u5355", (String)"BillListUtil_15", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("OUTER_NODE".equals(number)) {
            return ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf", (String)"BillListUtil_16", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_applyprojectbill".equals(number)) {
            return ResManager.loadKDString((String)"\u7acb\u9879\u5355", (String)"BillListUtil_17", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_withholdingbill".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u9884\u63d0\u5355", (String)"BillListUtil_18", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_costestimatebill".equals(number)) {
            return ResManager.loadKDString((String)"\u6682\u4f30\u5355", (String)"BillListUtil_19", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("cal".equals(number)) {
            return ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97", (String)"BillListUtil_20", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("er_prepaybill".equals(number)) {
            return ResManager.loadKDString((String)"\u9884\u4ed8\u5355", (String)"BillListUtil_21", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        return "er_expensesharebill".equals(number) ? ResManager.loadKDString((String)"\u8d39\u7528\u5206\u644a\u5355", (String)"BillListUtil_22", (String)"pmgt-pmbs-common", (Object[])new Object[0]) : "";
    }

    private static void createStructOfBill(JSONObject jsonObject, DynamicObject root, Object parentid, String billtype) {
        Long id = DBServiceHelper.genGlobalLongId();
        root.set("id", (Object)id);
        root.set("name", (Object)BillListUtil.getResName((String)jsonObject.get((Object)"number")));
        root.set("number", jsonObject.get((Object)"number"));
        root.set("status", (Object)"C");
        root.set("enable", (Object)"1");
        boolean isfromouter = jsonObject.get((Object)"isfromouter") == null ? false : jsonObject.getBoolean("isfromouter");
        root.set("isfromouter", (Object)isfromouter);
        root.set("level", jsonObject.get((Object)"level"));
        root.set("billtype", (Object)billtype);
        if (billtype.equals("bill")) {
            root.set("fieldtable", jsonObject.get((Object)"number"));
        }
        if (parentid != null) {
            root.set("parent", parentid);
        }
        BillListUtil.setDefaultValue(root);
    }

    private static void setDefaultValue(DynamicObject root) {
        try {
            Date time = TimeServiceHelper.parseUserTime((String)"2018-08-08 18:08:08", (Long)1L);
            root.set("creator", (Object)111111111111L);
            root.set("modifier", (Object)111111111111L);
            root.set("createtime", (Object)time);
            root.set("modifytime", (Object)time);
        }
        catch (ParseException var2) {
            throw new KDBizException(var2.getMessage());
        }
    }

    static {
        fieldMap.put("BILL_NO", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"BillListUtil_33", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("BILL_NAME", ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"BillListUtil_34", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("CREATOR", ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"BillListUtil_35", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("CREATE_TIME", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"BillListUtil_36", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("AUDITOR", ResManager.loadKDString((String)"\u5ba1\u6838\u4eba", (String)"BillListUtil_37", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("AUDIT_TIME", ResManager.loadKDString((String)"\u5ba1\u6838\u65f6\u95f4", (String)"BillListUtil_38", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("PROJECT", ResManager.loadKDString((String)"\u9879\u76ee", (String)"BillListUtil_39", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("CONTRACT", ResManager.loadKDString((String)"\u5408\u540c", (String)"BillListUtil_40", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("CURRENCY", ResManager.loadKDString((String)"\u5e01\u522b", (String)"BillListUtil_43", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("BUDGET", ResManager.loadKDString((String)"\u9884\u7b97", (String)"BillListUtil_41", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        fieldMap.put("AMOUNT", ResManager.loadKDString((String)"\u91d1\u989d", (String)"BillListUtil_42", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }
}

