/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.tree;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DynamicInfoCollection {
    private static final long serialVersionUID = 1L;
    private long accountId;
    private long datasetId;
    private List<String> props = new LinkedList<String>();
    private List<InfoObject> infos = new LinkedList<InfoObject>();
    private String name;

    public long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(long datasetId) {
        this.datasetId = datasetId;
    }

    public List<String> getProps() {
        return this.props;
    }

    public List<InfoObject> getValues() {
        if (this.infos == null) {
            this.infos = new LinkedList<InfoObject>();
        }
        return this.infos;
    }

    public String getName() {
        return this.name;
    }

    public DynamicInfoCollection(String name, String ... props) {
        this.name = name;
        this.props.addAll(Arrays.asList(props));
    }

    public boolean removeInfoByOneProp(String propName, Object propVal) {
        boolean result = false;
        int propIndex = this.getPropIndex(propName);
        Object val = null;
        if (propIndex != -1) {
            Iterator<InfoObject> iterator = this.infos.iterator();
            while (iterator.hasNext()) {
                InfoObject info = iterator.next();
                val = info.getValueByPropIndex(propIndex);
                if (val == null || !val.equals(propVal)) continue;
                iterator.remove();
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean removeInfo(InfoObject info) {
        boolean result = false;
        if (info != null) {
            Iterator<InfoObject> iterator = this.infos.iterator();
            while (iterator.hasNext()) {
                InfoObject infoObject = iterator.next();
                if (!info.equals(infoObject)) continue;
                iterator.remove();
                result = true;
                break;
            }
        }
        return result;
    }

    public void clearInfo() {
        this.infos = new LinkedList<InfoObject>();
    }

    public InfoObject addInfo(Object ... values) {
        InfoObject info = new InfoObject();
        List<Object> value = info.getValues();
        for (int i = 0; i < values.length && i < this.props.size(); ++i) {
            value.add(values[i]);
        }
        this.getValues().add(info);
        return info;
    }

    public InfoObject getInfoByOneProp(String propName, Object propValue) {
        if (propName != null && propValue != null) {
            int propIndex = this.getPropIndex(propName);
            if (propIndex != -1) {
                for (InfoObject info : this.infos) {
                    Object value = info.getValueByPropIndex(propIndex);
                    if (value == null || value.getClass() != propValue.getClass() || !value.equals(propValue)) continue;
                    return info;
                }
            }
            return null;
        }
        return null;
    }

    public List<InfoObject> getAllInfoByOneProp(String propName, Object propValue) {
        int propIndex;
        LinkedList<InfoObject> infos = new LinkedList<InfoObject>();
        if (propName != null && propValue != null && (propIndex = this.getPropIndex(propName)) != -1) {
            for (InfoObject info : this.getValues()) {
                Object value = info.getValueByPropIndex(propIndex);
                if (value == null || value.getClass() != propValue.getClass() || !value.equals(propValue)) continue;
                infos.add(info);
            }
        }
        return infos;
    }

    public List<Object> getAllValOfOneProp(String propName) {
        LinkedList<Object> propVals = new LinkedList<Object>();
        int propIndex = this.getPropIndex(propName);
        if (propIndex != -1) {
            this.getValues().forEach(val -> propVals.add(val.getValueByPropIndex(propIndex)));
        }
        return propVals;
    }

    public List<Object> getAllValOfOnePropByAnotherProp(String propName, String anotherProp, Object value) {
        LinkedList<Object> propVals = new LinkedList<Object>();
        List<InfoObject> infos = this.getAllInfoByOneProp(anotherProp, value);
        int propIndex = this.getPropIndex(propName);
        if (propIndex != -1) {
            for (InfoObject info : infos) {
                propVals.add(info.getValueByPropIndex(propIndex));
            }
        }
        return propVals;
    }

    public Object getValOfOnePropByAnotherProp(String propName, String anotherProp, Object value) {
        Object propVal = null;
        InfoObject info = this.getInfoByOneProp(anotherProp, value);
        if (info != null) {
            propVal = info.getValueByPropName(propName);
        }
        return propVal;
    }

    private int getPropIndex(String propName) {
        int index = -1;
        for (int i = 0; i < this.props.size(); ++i) {
            String prop = this.props.get(i);
            if (!prop.equals(propName)) continue;
            index = i;
            break;
        }
        return index;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.name);
        str.append("]");
        for (String prop : this.props) {
            str.append(prop);
            str.append(",");
        }
        if (!this.props.isEmpty()) {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    public class InfoObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Object> values = new LinkedList<Object>();

        private InfoObject() {
        }

        public List<Object> getValues() {
            return this.values;
        }

        public Object getValueByPropName(String propName) {
            int propIndex = DynamicInfoCollection.this.getPropIndex(propName);
            return this.getValueByPropIndex(propIndex);
        }

        public void setValueByPropName(String propName, Object value) {
            int propIndex = DynamicInfoCollection.this.getPropIndex(propName);
            if (this.values.size() > propIndex || propIndex > -1) {
                this.values.set(propIndex, value);
            }
        }

        public Object getValueByPropIndex(int index) {
            return this.values.size() > index && index > -1 ? this.values.get(index) : null;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("[");
            for (Object val : this.values) {
                str.append(val.toString());
                str.append(",");
            }
            if (!this.values.isEmpty()) {
                str.deleteCharAt(str.length() - 1);
            }
            str.append("]");
            return str.toString();
        }
    }
}

