/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.tree;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.pmgt.pmbs.common.hierarchy.DynamicObjectTreeNode;
import kd.pmgt.pmbs.common.hierarchy.Hierarchy;
import kd.pmgt.pmbs.common.hierarchy.Hierarchyable;
import kd.pmgt.pmbs.common.utils.EcSerializeHelper;

public class OrgProjectTreeHelper {
    private static final Log logger = LogFactory.getLog(OrgProjectTreeHelper.class);
    public static final String KEY_TREEVIEWAP = "treeview";
    public static final String KEY_TREESEARCHAP = "treesearchap";
    public static final String OLD_TREE_SEARCH_TEXT_KEY = "old_tree_search_text_key";
    public static final String SEARCH_TREE_RESULT_KEY = "search_tree_result_key";
    public static final String DEFAULT_VIEWTYPE = OrgViewTypeEnum.IS_ORGUNIT.getViewType();
    public static final String ORGPROJECT_TREE_KEY = "orgproject_tree_key";
    public static final String BOS_ORG = "bos_org";
    public static final String PARENT_ID = "parent.id";
    public static final String COLOR = "color";
    public static final String PROJECT = "project";
    public static final String PARENT = "parent";
    public static final String ORG_ID = "org.id";

    public static Hierarchy initNavTree(TreeView treeView, Long orgId, boolean isShowUnitProject, List<String> chargeProjIds) {
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)BOS_ORG);
        TreeNode root = new TreeNode("", orgObject.getString("id"), orgObject.getString("name"), true);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(DEFAULT_VIEWTYPE), orgIds, (boolean)true);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((Object[])orgList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BOS_ORG));
        HashMap<Long, Long> orgrelationsMap = new HashMap<Long, Long>(16);
        OrgProjectTreeHelper.setOrgRelationMap(orgObject, orgList, orgrelationsMap);
        Hierarchy tree = new Hierarchy();
        DynamicObjectTreeNode rootnode = new DynamicObjectTreeNode();
        OrgProjectTreeHelper.setTreeNodeByRelationMap(orgObject, orgs, orgrelationsMap, tree, rootnode);
        QFilter filterOrgId_1 = new QFilter("org", "in", (Object)orgList);
        QFilter[] filters_1 = new QFilter[]{filterOrgId_1};
        ArrayList<String> projectIds = new ArrayList<String>(10);
        Map projectMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"), (QFilter[])filters_1);
        OrgProjectTreeHelper.initTreeNodeByProjects(tree, projectIds, projectMap);
        OrgProjectTreeHelper.removeNodeWithNoProject(tree, rootnode, projectMap);
        root.setIsOpened(true);
        treeView.addNode(root);
        treeView.focusNode(root);
        List<Hierarchyable> treeNodes = tree.getAllChildren(tree.getRootNode());
        for (Hierarchyable hierarchyable : treeNodes) {
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)hierarchyable;
            treeNode.getId();
            OrgProjectTreeHelper.addNodeToTreeView(treeView, treeNode, false);
        }
        if (chargeProjIds != null) {
            OrgProjectTreeHelper.removeNodeWithNoPermProj(treeView, chargeProjIds, tree, projectIds, treeNodes);
        }
        return tree;
    }

    private static void removeNodeWithNoPermProj(TreeView treeView, List<String> chargeProjIds, Hierarchy tree, List<String> projectIds, List<Hierarchyable> treeNodes) {
        projectIds.removeAll(chargeProjIds);
        treeView.deleteNodes(projectIds);
        for (Hierarchyable hierarchyable : treeNodes) {
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)hierarchyable;
            if (!PROJECT.equals(treeNode.getType()) || !projectIds.contains(String.valueOf(treeNode.getId()))) continue;
            tree.removeObject(hierarchyable);
        }
    }

    private static void removeNodeWithNoProject(Hierarchy tree, DynamicObjectTreeNode rootnode, Map<Object, DynamicObject> projectMap) {
        HashSet<Long> idset = new HashSet<Long>(16);
        for (Map.Entry<Object, DynamicObject> entry : projectMap.entrySet()) {
            DynamicObject project = entry.getValue();
            idset.add((Long)project.getPkValue());
            List<Hierarchyable> parents = tree.getAllParent(tree.getObject((Long)project.getPkValue()));
            for (int i = 0; i < parents.size(); ++i) {
                idset.add(parents.get(i).getId());
            }
        }
        List<Hierarchyable> childrens = tree.getAllChildren(rootnode);
        for (int i = childrens.size() - 1; i >= 0; --i) {
            if (idset.contains(childrens.get(i).getId())) continue;
            tree.removeObject(childrens.get(i));
        }
    }

    private static void initTreeNodeByProjects(Hierarchy tree, List<String> projectIds, Map<Object, DynamicObject> projectMap) {
        DynamicObjectTreeNode node = null;
        for (Map.Entry<Object, DynamicObject> entry : projectMap.entrySet()) {
            node = new DynamicObjectTreeNode();
            DynamicObject project = entry.getValue();
            node.setId((Long)project.getPkValue());
            projectIds.add(project.getPkValue().toString());
            node.setName(project.getString("name"));
            node.setParentId(project.getLong(ORG_ID));
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put(COLOR, "blue");
            node.setData(data);
            node.setValue(project);
            node.setType(PROJECT);
            tree.addObject(node);
        }
    }

    private static void setTreeNodeByRelationMap(DynamicObject orgObject, DynamicObject[] orgs, Map<Long, Long> orgrelationsMap, Hierarchy tree, DynamicObjectTreeNode rootnode) {
        rootnode.setId((Long)orgObject.getPkValue());
        rootnode.setName(orgObject.getString("name"));
        rootnode.setValue(orgObject);
        tree.setRootNode(rootnode);
        for (int i = 0; i < orgs.length; ++i) {
            DynamicObject org = orgs[i];
            if (((Long)org.getPkValue()).longValue() == ((Long)orgObject.getPkValue()).longValue()) continue;
            DynamicObjectTreeNode node = new DynamicObjectTreeNode();
            node.setId((Long)org.getPkValue());
            node.setName(org.getString("name"));
            if (orgrelationsMap.get((Long)org.getPkValue()) != null) {
                node.setParentId(orgrelationsMap.get((Long)org.getPkValue()));
            }
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put(COLOR, "black");
            node.setData(data);
            node.setValue(org);
            node.setType(BOS_ORG);
            tree.addObject(node);
        }
    }

    private static void setOrgRelationMap(DynamicObject orgObject, List<Long> orgList, Map<Long, Long> orgrelationsMap) {
        QFilter filterOrgId = new QFilter(ORG_ID, "in", orgList);
        QFilter filterTreetype = new QFilter("view.treetype", "=", (Object)DEFAULT_VIEWTYPE);
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreetype};
        Map orgrelations = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org_structure"), (QFilter[])filters);
        for (Map.Entry entry : orgrelations.entrySet()) {
            DynamicObject relationInfo = (DynamicObject)entry.getValue();
            if (relationInfo.getLong(ORG_ID) == ((Long)orgObject.getPkValue()).longValue() || relationInfo.get(PARENT_ID) == null) continue;
            orgrelationsMap.put(relationInfo.getLong(ORG_ID), (Long)relationInfo.get(PARENT_ID));
        }
    }

    public static Hierarchy initOrgTree(TreeView treeView, Long orgId) {
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)BOS_ORG);
        TreeNode root = new TreeNode("", orgObject.getString("id"), orgObject.getString("name"), true);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(DEFAULT_VIEWTYPE), orgIds, (boolean)true);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((Object[])orgList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BOS_ORG));
        QFilter filterOrgId = new QFilter(ORG_ID, "in", (Object)orgList);
        QFilter filterTreetype = new QFilter("view.treetype", "=", (Object)DEFAULT_VIEWTYPE);
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreetype};
        Map orgrelations = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org_structure"), (QFilter[])filters);
        HashMap<Long, Long> orgrelationsMap = new HashMap<Long, Long>();
        for (Map.Entry entry : orgrelations.entrySet()) {
            DynamicObject relationInfo = (DynamicObject)entry.getValue();
            if (relationInfo.getLong(ORG_ID) == ((Long)orgObject.getPkValue()).longValue() || relationInfo.get(PARENT_ID) == null) continue;
            orgrelationsMap.put(relationInfo.getLong(ORG_ID), (Long)relationInfo.get(PARENT_ID));
        }
        Hierarchy tree = new Hierarchy();
        DynamicObjectTreeNode rootnode = new DynamicObjectTreeNode();
        rootnode.setId((Long)orgObject.getPkValue());
        rootnode.setName(orgObject.getString("name"));
        rootnode.setValue(orgObject);
        tree.setRootNode(rootnode);
        for (int i = 0; i < orgs.length; ++i) {
            DynamicObject org = orgs[i];
            if (((Long)org.getPkValue()).longValue() == ((Long)orgObject.getPkValue()).longValue()) continue;
            DynamicObjectTreeNode node = new DynamicObjectTreeNode();
            node.setId((Long)org.getPkValue());
            node.setName(org.getString("name"));
            if (orgrelationsMap.get((Long)org.getPkValue()) != null) {
                node.setParentId((Long)orgrelationsMap.get((Long)org.getPkValue()));
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(COLOR, "black");
            node.setData(data);
            node.setValue(org);
            node.setType(BOS_ORG);
            tree.addObject(node);
        }
        root.setIsOpened(true);
        treeView.addNode(root);
        treeView.focusNode(root);
        List<Hierarchyable> treeNodes = tree.getAllChildren(tree.getRootNode());
        for (Hierarchyable hierarchyable : treeNodes) {
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)hierarchyable;
            treeNode.getId();
            OrgProjectTreeHelper.addNodeToTreeView(treeView, treeNode, false);
        }
        return tree;
    }

    public static void addNodeToTreeView(TreeView treeView, DynamicObjectTreeNode treeNode, boolean isImportUnit) {
        String color = (String)treeNode.getData().get(COLOR);
        TreeNode node = treeNode.getTreeNode();
        node.setColor(color);
        if (isImportUnit) {
            treeView.deleteNode(node.getId());
        }
        treeView.addNode(node);
    }

    public static ArrayList<DynamicObjectTreeNode> getUnitProjectNodes(List<Long> projectIds) {
        QFilter unitProFilter = new QFilter(PARENT, "in", projectIds).and("isimport", "=", (Object)Boolean.TRUE);
        QFilter[] unitProFilters = new QFilter[]{unitProFilter};
        DynamicObject[] unitProjects = BusinessDataServiceHelper.load((String)"ec_unitproject", (String)"id,parent,name", (QFilter[])unitProFilters);
        ArrayList<DynamicObjectTreeNode> unitNodeList = new ArrayList<DynamicObjectTreeNode>();
        for (DynamicObject unitProject : unitProjects) {
            DynamicObjectTreeNode node = new DynamicObjectTreeNode();
            node.setId((Long)unitProject.getPkValue());
            DynamicObject parent = unitProject.getDynamicObject(PARENT);
            if (parent != null) {
                node.setParentId((Long)parent.getPkValue());
            }
            node.setName(unitProject.getString("name"));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(COLOR, "grey");
            node.setData(data);
            node.setType("unitProject");
            unitNodeList.add(node);
        }
        return unitNodeList;
    }

    public static void search(IFormView view, IPageCache pageCache, String searchText) {
        TreeView treeView = (TreeView)view.getControl(KEY_TREEVIEWAP);
        searchText = searchText.trim();
        JSONArray results = new JSONArray();
        JSONObject result = null;
        if ((result = OrgProjectTreeHelper.curResultFromResults(pageCache, searchText, result, results)) == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"OrgProjectTreeHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            String parentId = result.getString(PARENT);
            String nodeId = result.getString("id");
            String name = result.getString("name");
            TreeNode node = new TreeNode(parentId, nodeId, name);
            treeView.showNode(nodeId);
            treeView.focusNode(node);
            treeView.treeNodeClick(parentId, nodeId);
        }
    }

    private static JSONObject curResultFromResults(IPageCache pageCache, String searchText, JSONObject result, JSONArray results) {
        String oldSearchText = pageCache.get(OLD_TREE_SEARCH_TEXT_KEY);
        pageCache.put(OLD_TREE_SEARCH_TEXT_KEY, searchText);
        if (oldSearchText == null || !oldSearchText.equals(searchText)) {
            Hierarchy tree = (Hierarchy)EcSerializeHelper.unserialize(pageCache.get(ORGPROJECT_TREE_KEY));
            List<Hierarchyable> treeNodes = tree.getObjectByName(searchText);
            if (!treeNodes.isEmpty()) {
                for (Hierarchyable hierarchyable : treeNodes) {
                    DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)hierarchyable;
                    TreeNode node = treeNode.getTreeNode();
                    JSONObject jNode = new JSONObject();
                    jNode.put("id", (Object)node.getId());
                    jNode.put("name", (Object)node.getText());
                    jNode.put(PARENT, (Object)node.getParentid());
                    results.add((Object)jNode);
                }
            }
            result = OrgProjectTreeHelper.getResultFromSearchResults(pageCache, result, results);
        } else if (pageCache.get(SEARCH_TREE_RESULT_KEY) != null) {
            results = JSONArray.parseArray((String)pageCache.get(SEARCH_TREE_RESULT_KEY));
            result = OrgProjectTreeHelper.getResultFromSearchResults(pageCache, result, results);
        }
        return result;
    }

    private static JSONObject getResultFromSearchResults(IPageCache pageCache, JSONObject result, JSONArray results) {
        int size = results.size();
        if (size > 0) {
            result = results.getJSONObject(0);
            if (size == 1) {
                pageCache.put(OLD_TREE_SEARCH_TEXT_KEY, null);
            }
            results.remove((Object)result);
            pageCache.put(SEARCH_TREE_RESULT_KEY, results.toString());
        }
        return result;
    }

    public static boolean isProjectNode(Object nodeId) {
        boolean flag = false;
        Object[] pk = new Object[]{nodeId};
        try {
            DynamicObject[] project = BusinessDataServiceHelper.load((Object[])pk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"));
            if (project != null && project.length > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("get bd_project error!", (Throwable)e);
        }
        return flag;
    }

    public static boolean isOrgNode(Object nodeId) {
        boolean flag = false;
        Object[] pk = new Object[]{nodeId};
        DynamicObject[] org = null;
        try {
            org = BusinessDataServiceHelper.load((Object[])pk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BOS_ORG));
            if (org != null && org.length > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("get bos_org error!", (Throwable)e);
        }
        return flag;
    }

    public static boolean isUnitProjectNode(Object nodeId) {
        boolean flag = false;
        Object[] pk = new Object[]{nodeId};
        DynamicObject[] unitProject = null;
        try {
            unitProject = BusinessDataServiceHelper.load((Object[])pk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ec_unitproject"));
            if (unitProject.length > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("get ec_unitproject error!", (Throwable)e);
        }
        return flag;
    }

    public static QFilter genListFilter(Object nodeId) {
        if (StringUtils.isBlank((Object)nodeId)) {
            return null;
        }
        QFilter qFilter = null;
        if (OrgProjectTreeHelper.isOrgNode(nodeId)) {
            try {
                Long orgId = Long.valueOf((String)nodeId);
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                List allOrgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(DEFAULT_VIEWTYPE), orgIds, (boolean)true);
                qFilter = new QFilter("org", "in", (Object)allOrgIdList);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        } else if (OrgProjectTreeHelper.isProjectNode(nodeId)) {
            qFilter = new QFilter(PROJECT, "=", nodeId);
        } else {
            return null;
        }
        return qFilter;
    }
}

