/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.tree;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.pmgt.pmbs.common.tree.TreeNode;

public class Tree {
    private List<TreeNode> list;
    private TreeNode root;

    public Tree() {
    }

    public Tree(List<TreeNode> tree) {
        this.list = tree;
    }

    public List<TreeNode> getList() {
        return this.list;
    }

    public void setList(List<TreeNode> list) {
        this.list = list;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        if (this.list == null) {
            this.list = new ArrayList<TreeNode>();
        }
        this.root = root;
        this.list.add(root);
    }

    public void addNodeToListById(TreeNode addNode) {
        List<TreeNode> list = this.getList();
        for (TreeNode next : list) {
            if (!StringUtils.equals((CharSequence)addNode.getPid(), (CharSequence)next.getId())) continue;
            int level = next.getLevel();
            if (next.getChild() == null) {
                next.setChild(new ArrayList<TreeNode>());
            }
            addNode.setLevel(level + 1);
            addNode.setParent(next);
            next.getChild().add(addNode);
            return;
        }
    }

    public void addNodeToListByName(TreeNode addNode) {
        List<TreeNode> list = this.getList();
        boolean isExist = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            String name;
            TreeNode next = list.get(i);
            int parentLevel = next.getLevel();
            String parentName = next.getName() == null ? "" : next.getName().trim();
            int level = addNode.getLevel();
            String string = name = addNode.getParentName() == null ? "" : addNode.getParentName().trim();
            if (level - 1 != parentLevel || !parentName.equals(name)) continue;
            addNode.setParent(next);
            if (next.getChild() == null) {
                next.setChild(new ArrayList<TreeNode>());
            }
            next.getChild().add(addNode);
            isExist = true;
            break;
        }
        if (isExist) {
            list.add(addNode);
        }
    }

    public TreeNode getNodeById(String id) {
        List<TreeNode> list = this.getList();
        for (TreeNode treeNode : list) {
            if (!StringUtils.equals((CharSequence)id, (CharSequence)treeNode.getId())) continue;
            return treeNode;
        }
        return null;
    }

    public List<TreeNode> getAllRootNode() {
        List<TreeNode> list = this.getList();
        ArrayList<TreeNode> rootNodeList = new ArrayList<TreeNode>();
        for (TreeNode treeNode : list) {
            if (treeNode.getParent() != null && !StringUtils.equals((CharSequence)"0", (CharSequence)treeNode.getPid()) && !StringUtils.equals((CharSequence)"0", (CharSequence)treeNode.getParent().getId())) continue;
            rootNodeList.add(treeNode);
        }
        return rootNodeList.size() == 0 ? null : rootNodeList;
    }

    public static Tree buildTree(List<TreeNode> list) {
        TreeNode root = new TreeNode("0", "-1", -1, "", 0);
        Tree tree = new Tree();
        tree.setRoot(root);
        for (TreeNode addNode : list) {
            tree.addNodeToListByName(addNode);
        }
        tree.getList().remove(0);
        return tree;
    }

    public static Tree buildTreeByPid(List<TreeNode> list) {
        Tree tree = new Tree();
        TreeNode root = new TreeNode("0", "-1", -1, "", 0);
        tree.setRoot(root);
        tree.getList().addAll(list);
        for (TreeNode node : list) {
            tree.addNodeToListById(node);
        }
        tree.getList().remove(0);
        return tree;
    }
}

