/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;

public class TreeNodeUtils {
    public static TreeNode cloneNode(TreeNode node) {
        TreeNode newNode = new TreeNode();
        newNode.setId(node.getId());
        newNode.setParentid(node.getParentid());
        newNode.setText(node.getText());
        newNode.setLeaf(node.isLeaf());
        Object data = node.getData();
        if (data instanceof HashMap) {
            HashMap map = new HashMap((HashMap)data);
            newNode.setData(map);
        }
        return newNode;
    }

    public static TreeNode cloneTree(TreeNode node) {
        TreeNode treeNode = TreeNodeUtils.cloneNode(node);
        List children = node.getChildren();
        if (children != null) {
            ArrayList<TreeNode> newChilden = new ArrayList<TreeNode>(10);
            treeNode.setChildren(newChilden);
            for (TreeNode child : children) {
                newChilden.add(TreeNodeUtils.cloneTree(child));
            }
        }
        return treeNode;
    }

    public static Object getNodeProperties(String key, TreeNode node) {
        HashMap data = (HashMap)node.getData();
        return data.get(key);
    }

    public static void writeProperties(String key, Object value, TreeNode node) {
        HashMap data = (HashMap)node.getData();
        data.put(key, value);
    }

    public static void treeConvertList(TreeNode root, List<TreeNode> list) {
        list.add(root);
        List children = root.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if ("-2".equals(child.getId())) continue;
                TreeNodeUtils.treeConvertList(child, list);
            }
        }
    }

    public static TreeNode createTreeNodeByObject(DynamicObject object, String text, String ... properties) {
        TreeNode node = new TreeNode(object.getString("parent"), object.getString("id"), text);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        String[] var5 = properties;
        int var6 = properties.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            String property = var5[var7];
            String trim = property.trim();
            data.put(trim, object.get(trim));
        }
        node.setData(data);
        return node;
    }

    public static TreeNode createTree(Map<String, TreeNode> map, TreeNode root) {
        for (Map.Entry<String, TreeNode> entry : map.entrySet()) {
            ArrayList<TreeNode> children;
            TreeNode node;
            String parentid;
            if (entry.getKey().equals(root.getId()) || "0".equals(parentid = (node = entry.getValue()).getParentid())) continue;
            TreeNode parent = map.get(parentid);
            if (parent == null) {
                parent = root;
            }
            if ((children = parent.getChildren()) == null) {
                children = new ArrayList<TreeNode>(10);
                parent.setChildren(children);
            }
            children.add(node);
        }
        return root;
    }

    public static TreeNode createTreeContainShare(Map<String, TreeNode> members, TreeNode root, Map<String, List<TreeNode>> shareMemberGroupByParent) {
        for (Map.Entry<String, TreeNode> entry : members.entrySet()) {
            ArrayList<TreeNode> children;
            String parentId;
            String id = entry.getKey();
            TreeNode node = entry.getValue();
            List<TreeNode> shareNodes = shareMemberGroupByParent.get(id);
            if (shareNodes != null) {
                node.addChildren(shareNodes);
                TreeNodeUtils.writeProperties("isleaf", false, node);
            }
            if ("0".equals(parentId = node.getParentid())) continue;
            TreeNode parent = members.get(parentId);
            if (parent == null) {
                parent = root;
            }
            if ((children = parent.getChildren()) == null) {
                children = new ArrayList<TreeNode>(10);
                parent.setChildren(children);
            }
            children.add(node);
        }
        TreeNodeUtils.ListSortByDseq(root);
        return root;
    }

    public static void ListSortByDseq(TreeNode root) {
        List children = root.getChildren();
        if (children != null && children.size() > 0) {
            children.sort(TreeNodeUtils.getDseqComparator());
            for (TreeNode child : children) {
                TreeNodeUtils.ListSortByDseq(child);
            }
        }
    }

    public static int getTreeNodesCount(TreeNode root) {
        List children = root.getChildren();
        int count = 1;
        if (children != null) {
            for (TreeNode child : children) {
                count += TreeNodeUtils.getTreeNodesCount(child);
            }
        }
        return count;
    }

    public static Comparator getDseqComparator() {
        Comparator<TreeNode> comparator = new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                int dseq = (Integer)TreeNodeUtils.getNodeProperties("dseq", o1) - (Integer)TreeNodeUtils.getNodeProperties("dseq", o2);
                if (dseq == 0) {
                    Long id1 = Long.parseLong(o1.getId());
                    Long id2 = Long.parseLong(o2.getId());
                    return id1.compareTo(id2);
                }
                return dseq;
            }
        };
        return comparator;
    }

    public static List<? extends Object> getPropertiesFromTree(List<? extends Object> list, TreeNode root, String key) {
        List children;
        if (list == null) {
            list = new ArrayList<Object>(10);
        }
        if (TreeNodeUtils.getNodeProperties(key, root) != null) {
            list.add(TreeNodeUtils.getNodeProperties(key, root));
        }
        if ((children = root.getChildren()) != null) {
            for (TreeNode child : children) {
                TreeNodeUtils.getPropertiesFromTree(list, child, key);
            }
        }
        return list;
    }
}

