/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.pmgt.pmbs.common.tree.Recorder;

public class TreeSearchUtil {
    public static final String SEARCHCONTROL = "searchap";
    public static final String SEARCH_BEFORE = "searchbefore";
    public static final String SEARCH_NEXT = "searchnext";
    public static final int MAX_lEVEL = 20;
    public static final String TREE_KEY = "treeviewap";
    public static final String FOCUS = "focus";
    public static final String RESULT_LIST = "resultList";
    public static final String TREE_CACHE_NAME = "treeCacheName";
    public static final String OLD_NODE_CACHE_NAME = "oldNodeCacheName";

    public static void expand(String parentid, TreeView treeView, TreeNode root) {
        if (root != null && treeView != null && !StringUtils.isEmpty((CharSequence)parentid)) {
            TreeNode treeNode;
            HashMap<String, TreeNode> outRefMap = new HashMap<String, TreeNode>(16);
            TreeSearchUtil.getNode2Map(root, outRefMap);
            for (int i = 0; i < 20 && (treeNode = (TreeNode)outRefMap.get(parentid)) != null; ++i) {
                treeView.expand(treeNode.getId());
                parentid = treeNode.getParentid();
                if (parentid.equals(root.getId()) || StringUtils.isEmpty((CharSequence)parentid)) break;
            }
        }
    }

    public static void searchMember(String text, IFormView view, IPageCache pageCache, TreeSearchParam param) {
        if (text != null && !"".equals(text)) {
            String treeCache = pageCache.get(param.getTreeCacheName());
            if (treeCache == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeSearchUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            } else {
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
                List<TreeNode> nodes = TreeSearchUtil.seekChildrenIf(root, p -> p.getText().toLowerCase().contains(text.toLowerCase()));
                if (!nodes.isEmpty()) {
                    TreeSearchUtil.selectNode(nodes.get(0), TreeSearchUtil.getControl(view, param.getTreeKey()), root, pageCache, param.getOldNodeCacheName());
                    pageCache.put(param.getResultList(), SerializationUtils.serializeToBase64(nodes));
                    pageCache.put(param.getFocus(), "0");
                } else {
                    TreeNode old;
                    String oldnode = pageCache.get(param.getOldNodeCacheName());
                    TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
                    if (old != null) {
                        old.setColor("");
                        ((TreeView)view.getControl(param.getTreeKey())).updateNode(old);
                    }
                    TreeSearchUtil.clearSearchPageCache(pageCache, param);
                    view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeSearchUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
            }
        } else {
            pageCache.put(param.getResultList(), (String)null);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"TreeSearchUtil_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
    }

    public static void clearSearchPageCache(IPageCache cache, TreeSearchParam param) {
        cache.put(param.getResultList(), (String)null);
        cache.put(param.getFocus(), (String)null);
        cache.put(param.getOldNodeCacheName(), (String)null);
    }

    private static void selectNode(TreeNode fnode, TreeView tree, TreeNode root, IPageCache pageCache, String oldNodeCacheName) {
        TreeNode old;
        String oldnode = pageCache.get(oldNodeCacheName);
        TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
        if (old != null) {
            Object data = old.getData();
            if (data instanceof Map && ((Map)data).get("color") != null) {
                Object o = ((Map)data).get("color");
                if (o != null) {
                    old.setColor(o.toString());
                }
            } else {
                old.setColor("");
            }
            tree.updateNode(old);
        }
        fnode.setColor("red");
        tree.updateNode(fnode);
        pageCache.put(oldNodeCacheName, SerializationUtils.serializeToBase64((Object)fnode));
        tree.focusNode(fnode);
        TreeSearchUtil.expand(fnode.getParentid(), tree, root);
    }

    public static void getLeftOrRight(IPageCache pageCache, IFormView view, TreeSearchParam param) {
        String rowcache = pageCache.get(param.getResultList());
        if (rowcache == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"TreeSearchUtil_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        } else {
            List rowList = (List)SerializationUtils.deSerializeFromBase64((String)rowcache);
            int rowCount = Integer.parseInt(pageCache.get(param.getFocus()));
            if (SearchBtnStatus.LEFT == param.getStatus()) {
                if (0 == rowCount) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeSearchUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else {
                if (SearchBtnStatus.RIGHT != param.getStatus()) {
                    return;
                }
                if (rowList.size() - 1 == rowCount) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeSearchUtil_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            pageCache.put(param.getFocus(), String.valueOf(rowCount));
            TreeNode focusNode = (TreeNode)rowList.get(rowCount);
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(param.getTreeCacheName()), TreeNode.class);
            TreeSearchUtil.selectNode(focusNode, TreeSearchUtil.getControl(view, param.getTreeKey()), root, pageCache, param.getOldNodeCacheName());
        }
    }

    private static TreeView getControl(IFormView view, String treeKey) {
        return (TreeView)view.getControl(treeKey);
    }

    public static List<TreeNode> seekChildrenIf(TreeNode root, Predicate<TreeNode> p) {
        if (root == null) {
            return new ArrayList<TreeNode>(1);
        }
        Recorder<List<TreeNode>> r = new Recorder<List<TreeNode>>(new ArrayList(16));
        if (p.test(root)) {
            ((List)r.getRecord()).add(root);
        }
        if (root.getChildren() != null) {
            TreeSearchUtil.cycleSeekNodes(root, p, r);
        }
        return r.getRecord();
    }

    private static void cycleSeekNodes(TreeNode node, Predicate<TreeNode> p, Recorder<List<TreeNode>> r) {
        node.getChildren().forEach(t -> {
            if (p.test((TreeNode)t)) {
                ((List)r.getRecord()).add(t);
            }
            if (t.getChildren() != null) {
                TreeSearchUtil.cycleSeekNodes(t, p, r);
            }
        });
    }

    public static void getNode2Map(TreeNode root, Map<String, TreeNode> outRefMap) {
        outRefMap.put(root.getId(), root);
        if (root.getChildren() != null) {
            for (TreeNode treeNode : root.getChildren()) {
                TreeSearchUtil.getNode2Map(treeNode, outRefMap);
            }
        }
    }

    public static List<TreeNode> getNodeList(TreeNode root) {
        Recorder<List<TreeNode>> r = new Recorder<List<TreeNode>>(new ArrayList(16));
        ((List)r.getRecord()).add(root);
        if (root.getChildren() != null) {
            TreeSearchUtil.addChildren2List(root, r);
        }
        return r.getRecord();
    }

    private static void addChildren2List(TreeNode node, Recorder<List<TreeNode>> r) {
        node.getChildren().forEach(t -> {
            ((List)r.getRecord()).add(node);
            if (t.getChildren() != null) {
                TreeSearchUtil.addChildren2List(t, r);
            } else if (t != null) {
                ((List)r.getRecord()).add(t);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public static Queue<TreeNode> getQueue(TreeNode root) {
        queue = new LinkedList<TreeNode>();
        result = new LinkedList<TreeNode>();
        queue.add(root);
        block0: while (true) {
            if (queue.isEmpty()) {
                return result;
            }
            node = (TreeNode)queue.poll();
            result.add(node);
            children = node.getChildren();
            if (children == null) continue;
            var5 = children.iterator();
            while (true) {
                if (var5.hasNext()) ** break;
                continue block0;
                child = (TreeNode)var5.next();
                queue.add(child);
            }
            break;
        }
    }

    public static void allClear(TreeNode root, TreeView tree) {
        tree.uncheckNode(root.getId());
        if (root.getChildren() != null) {
            root.getChildren().forEach(t -> TreeSearchUtil.allClear(t, tree));
        }
    }

    public static class TreeSearchParam {
        private String treeKey;
        private String treeCacheName;
        private String resultList;
        private String focus;
        private String oldNodeCacheName;
        private SearchBtnStatus status = SearchBtnStatus.LEFT;

        public TreeSearchParam() {
            this(TreeSearchUtil.TREE_KEY, TreeSearchUtil.TREE_CACHE_NAME, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME);
        }

        @Deprecated
        public TreeSearchParam(String treeKey) {
            this(treeKey, TreeSearchUtil.TREE_CACHE_NAME, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME);
        }

        public TreeSearchParam(String treeKey, String treeCacheName) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME);
        }

        public TreeSearchParam(String treeKey, SearchBtnStatus status) {
            this(treeKey, TreeSearchUtil.TREE_CACHE_NAME, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME, status);
        }

        public TreeSearchParam(String treeKey, String treeCacheName, String suffix) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST + suffix, TreeSearchUtil.FOCUS + suffix, TreeSearchUtil.OLD_NODE_CACHE_NAME + suffix);
        }

        public TreeSearchParam(String treeKey, String treeCacheName, String suffix, SearchBtnStatus status) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST + suffix, TreeSearchUtil.FOCUS + suffix, TreeSearchUtil.OLD_NODE_CACHE_NAME + suffix, status);
        }

        @Deprecated
        public TreeSearchParam(String treeKey, String treeCacheName, SearchBtnStatus status) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME, status);
        }

        @Deprecated
        public TreeSearchParam(String treeKey, String treeCacheName, String resultList, String focus, String oldNodeCacheName) {
            this.treeKey = treeKey;
            this.treeCacheName = treeCacheName;
            this.resultList = resultList;
            this.focus = focus;
            this.oldNodeCacheName = oldNodeCacheName;
        }

        @Deprecated
        public TreeSearchParam(String treeKey, String treeCacheName, String resultList, String focus, String oldNodeCacheName, SearchBtnStatus status) {
            this(treeKey, treeCacheName, resultList, focus, oldNodeCacheName);
            this.status = status;
        }

        public String getTreeKey() {
            return this.treeKey;
        }

        public SearchBtnStatus getStatus() {
            return this.status;
        }

        public String getTreeCacheName() {
            return this.treeCacheName;
        }

        public String getResultList() {
            return this.resultList;
        }

        public String getFocus() {
            return this.focus;
        }

        public String getOldNodeCacheName() {
            return this.oldNodeCacheName;
        }
    }

    public static enum SearchBtnStatus {
        LEFT,
        RIGHT;

    }
}

