/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ControlStrategyEnum;
import kd.pmgt.pmbs.common.enums.ControlTypeEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;

public class BudgetControlHelper {
    public static final String KEY_PROBUDGETITEM_MAP = "proBudgetItemMap";
    public static final String KEY_BUDGETITEM_MAP = "budgetItemMap";
    public static final String KEY_CONTROLRATE = "controlrate";
    public static final String KEY_REMINDRATE = "remindrate";

    public static Map<String, Map<String, DynamicObject>> getControlRateMap(Long projectId) {
        HashMap<String, Map<String, DynamicObject>> controlRateMap = new HashMap<String, Map<String, DynamicObject>>(16);
        DynamicObject bdProject = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"id,pmascreateorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        DynamicObject budgetControlObj = BudgetControlHelper.getBudgetControlObj(bdProject);
        if (budgetControlObj == null) {
            return controlRateMap;
        }
        DynamicObjectCollection budgetControlEntryCol = budgetControlObj.getDynamicObjectCollection("budgetcontrolentry");
        HashMap<String, DynamicObject> proBudgetItemIdMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> budgetItemIdMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject budgetControlEntry : budgetControlEntryCol) {
            DynamicObject proBudgetItem = budgetControlEntry.getDynamicObject("probudgetitem");
            DynamicObject orgBudgetItem = budgetControlEntry.getDynamicObject("orgbudgetitem");
            if (proBudgetItem != null) {
                proBudgetItemIdMap.put(proBudgetItem.getString("id"), budgetControlEntry);
            }
            if (orgBudgetItem == null) continue;
            budgetItemIdMap.put(orgBudgetItem.getString("id"), budgetControlEntry);
        }
        controlRateMap.put(KEY_PROBUDGETITEM_MAP, proBudgetItemIdMap);
        controlRateMap.put(KEY_BUDGETITEM_MAP, budgetItemIdMap);
        return controlRateMap;
    }

    public static Map<String, BigDecimal> getControlRate(DynamicObject proBudget) {
        HashMap<String, BigDecimal> controlRateMap = new HashMap<String, BigDecimal>();
        DynamicObject project = proBudget.getDynamicObject("project");
        DynamicObject budgetControlObj = BudgetControlHelper.getBudgetControlObj(project);
        DynamicObject budgetItem = proBudget.getDynamicObject("budgetitem");
        Object proBudgetPk = proBudget.getPkValue();
        if (budgetControlObj != null) {
            DynamicObjectCollection budgetControlEntryCol = budgetControlObj.getDynamicObjectCollection("budgetcontrolentry");
            String controlType = budgetControlObj.getString("controltype");
            if (StringUtils.equals((CharSequence)ControlTypeEnum.PROJECT.getValue(), (CharSequence)controlType)) {
                for (DynamicObject budgetControlEntry : budgetControlEntryCol) {
                    DynamicObject proBudgetItem = budgetControlEntry.getDynamicObject("probudgetitem");
                    if (proBudgetItem == null || !proBudgetItem.getPkValue().equals(proBudgetPk)) continue;
                    controlRateMap.put(KEY_CONTROLRATE, budgetControlEntry.getBigDecimal(KEY_CONTROLRATE));
                    controlRateMap.put(KEY_REMINDRATE, budgetControlEntry.getBigDecimal(KEY_REMINDRATE));
                    return controlRateMap;
                }
                if (BudgetControlHelper.getBudgetRateByOrgBudgetItem(controlRateMap, budgetItem, budgetControlEntryCol)) {
                    return controlRateMap;
                }
            } else if (StringUtils.equals((CharSequence)ControlTypeEnum.ORG.getValue(), (CharSequence)controlType) && BudgetControlHelper.getBudgetRateByOrgBudgetItem(controlRateMap, budgetItem, budgetControlEntryCol)) {
                return controlRateMap;
            }
        }
        return controlRateMap;
    }

    private static boolean getBudgetRateByOrgBudgetItem(Map<String, BigDecimal> controlRateMap, DynamicObject budgetItem, DynamicObjectCollection budgetControlEntryCol) {
        if (budgetItem == null) {
            return true;
        }
        for (DynamicObject budgetControlEntry : budgetControlEntryCol) {
            DynamicObject orgBudgetItem = budgetControlEntry.getDynamicObject("orgbudgetitem");
            if (orgBudgetItem == null || !orgBudgetItem.getPkValue().equals(budgetItem.getPkValue())) continue;
            controlRateMap.put(KEY_CONTROLRATE, budgetControlEntry.getBigDecimal(KEY_CONTROLRATE));
            controlRateMap.put(KEY_REMINDRATE, budgetControlEntry.getBigDecimal(KEY_REMINDRATE));
            return true;
        }
        return false;
    }

    public static DynamicObject getBudgetControlObj(DynamicObject project) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        DynamicObject budgetControl = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (String)"budgetcontrolentry,orgbudgetitem,probudgetitem,remindrate,controlrate", (QFilter[])new QFilter[]{projectFilter, enableFilter});
        if (budgetControl == null) {
            DynamicObject proCreateOrg = project.getDynamicObject("pmascreateorg");
            budgetControl = BudgetControlHelper.getBudgetControlObjByOrg(proCreateOrg.getLong("id"));
        }
        return budgetControl;
    }

    public static DynamicObject getBudgetControlObjByOrg(Long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.ORG.getValue());
        DynamicObject budgetControl = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (String)"controltype,budgetcontrolentry,orgbudgetitem,probudgetitem,remindrate,controlrate", (QFilter[])new QFilter[]{orgFilter, enableFilter, controlTypeFilter});
        return BudgetControlHelper.getSupBudget(orgId, budgetControl);
    }

    private static DynamicObject getSupBudget(Long orgId, DynamicObject budgetControl) {
        List superiorOrgs;
        if (budgetControl == null && !(superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)"15", (long)orgId)).isEmpty() && (Long)superiorOrgs.get(0) != 0L) {
            return BudgetControlHelper.getBudgetControlObjBySuperOrg((Long)superiorOrgs.get(0));
        }
        return budgetControl;
    }

    public static DynamicObject getBudgetControlObjBySuperOrg(Long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.ORG.getValue());
        QFilter controlStrategyFilter = new QFilter("controlstrategy", "=", (Object)ControlStrategyEnum.SELFANDSUB.getValue());
        DynamicObject budgetControl = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (String)"controltype,budgetcontrolentry,orgbudgetitem,probudgetitem,remindrate,controlrate", (QFilter[])new QFilter[]{orgFilter, enableFilter, controlStrategyFilter, controlTypeFilter});
        return BudgetControlHelper.getSupBudget(orgId, budgetControl);
    }

    public static void updateProBudgetItem(Object budgetControlId, int enable) {
        DynamicObject budgetControl = BusinessDataServiceHelper.loadSingle((Object)budgetControlId, (String)"pmco_budgetcontrol");
        String controlType = budgetControl.getString("controltype");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (StringUtils.equals((CharSequence)ControlTypeEnum.ORG.getValue(), (CharSequence)controlType)) {
            String controlStrategy = budgetControl.getString("controlstrategy");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
            DynamicObject org = budgetControl.getDynamicObject("org");
            Long orgId = org.getLong("id");
            DynamicObjectCollection projectCol = new DynamicObjectCollection();
            if (StringUtils.equals((CharSequence)ControlStrategyEnum.SELF.getValue(), (CharSequence)controlStrategy)) {
                QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.PROJECT.getValue());
                DynamicObjectCollection proBudgetControlObjCol = QueryServiceHelper.query((String)"pmco_budgetcontrol", (String)"id,project", (QFilter[])new QFilter[]{controlTypeFilter, enableFilter});
                Set alreadyProjectIdSet = proBudgetControlObjCol.stream().map(pbco -> pbco.getLong("project")).collect(Collectors.toSet());
                QFilter notInProIdSetFilter = new QFilter("id", "not in", alreadyProjectIdSet);
                QFilter orgFilter = new QFilter("pmascreateorg", "=", (Object)orgId);
                projectCol = QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])new QFilter[]{orgFilter, statusFilter, notInProIdSetFilter});
            } else if (StringUtils.equals((CharSequence)ControlStrategyEnum.SELFANDSUB.getValue(), (CharSequence)controlStrategy)) {
                ArrayList<Long> orgIdList = new ArrayList<Long>(10);
                orgIdList.add(orgId);
                List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgIdList, (boolean)false);
                QFilter orgFilter = new QFilter("org", "in", (Object)allSubordinateOrgs);
                QFilter controlStrategyFilter = new QFilter("controlstrategy", "=", (Object)ControlStrategyEnum.SELFANDSUB.getValue());
                DynamicObjectCollection budgetControlObjCol = QueryServiceHelper.query((String)"pmco_budgetcontrol", (String)"id,org,project", (QFilter[])new QFilter[]{orgFilter, controlStrategyFilter, enableFilter});
                List alreadyOrgIdList = budgetControlObjCol.stream().map(bco -> bco.getLong("org")).collect(Collectors.toList());
                List allSubordinateOrgs1 = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), alreadyOrgIdList, (boolean)true);
                allSubordinateOrgs.removeAll(allSubordinateOrgs1);
                controlStrategyFilter = new QFilter("controlstrategy", "=", (Object)ControlStrategyEnum.SELF.getValue());
                DynamicObjectCollection orgSelfbudgetControlObjCol = QueryServiceHelper.query((String)"pmco_budgetcontrol", (String)"id,org,project", (QFilter[])new QFilter[]{orgFilter, controlStrategyFilter, enableFilter});
                Set alreadySelfOrgIdList = orgSelfbudgetControlObjCol.stream().map(bco -> bco.getLong("org")).collect(Collectors.toSet());
                allSubordinateOrgs.removeAll(alreadySelfOrgIdList);
                allSubordinateOrgs.add(orgId);
                QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.PROJECT.getValue());
                DynamicObjectCollection proBudgetControlObjCol = QueryServiceHelper.query((String)"pmco_budgetcontrol", (String)"id,project", (QFilter[])new QFilter[]{controlTypeFilter, enableFilter});
                Set alreadyProjectIdSet = proBudgetControlObjCol.stream().map(pbco -> pbco.getLong("project")).collect(Collectors.toSet());
                QFilter notInProIdSetFilter = new QFilter("id", "not in", alreadyProjectIdSet);
                QFilter bdProOrgFilter = new QFilter("pmascreateorg", "in", (Object)allSubordinateOrgs);
                projectCol = QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])new QFilter[]{bdProOrgFilter, statusFilter, notInProIdSetFilter});
            }
            Set projectIdSet = projectCol.stream().map(project -> project.get("id")).collect(Collectors.toSet());
            QFilter projectFilter = new QFilter("project", "in", projectIdSet);
            qFilters.add(projectFilter);
        } else if (StringUtils.equals((CharSequence)ControlTypeEnum.PROJECT.getValue(), (CharSequence)controlType)) {
            DynamicObject project2 = budgetControl.getDynamicObject("project");
            QFilter projectFilter = new QFilter("project", "=", project2.getPkValue());
            qFilters.add(projectFilter);
        }
        DynamicObject[] proBudgetItemArr = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"controltype,id,sourcetype,remindrate,controlrate,remindamt,controlamt,budgetitem,currency,budgetamount", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (1 == enable) {
            BudgetControlHelper.updateProBudgetItem(budgetControl, proBudgetItemArr);
        } else {
            BudgetControlHelper.cancelProBudgetItemArrControl(proBudgetItemArr);
        }
    }

    public static void updateProBudgetItemWhenDisable(Object budgetControlId) {
        DynamicObject budgetControl = BusinessDataServiceHelper.loadSingle((Object)budgetControlId, (String)"pmco_budgetcontrol");
        String controlType = budgetControl.getString("controltype");
        DynamicObject org = budgetControl.getDynamicObject("org");
        if (StringUtils.equals((CharSequence)ControlTypeEnum.ORG.getValue(), (CharSequence)controlType)) {
            DynamicObject supOrgBudget = null;
            List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)"15", (long)org.getLong("id"));
            if (!superiorOrgs.isEmpty() && (Long)superiorOrgs.get(0) != 0L) {
                supOrgBudget = BudgetControlHelper.getBudgetControlObjBySuperOrg((Long)superiorOrgs.get(0));
            }
            if (supOrgBudget != null) {
                BudgetControlHelper.updateProBudgetItem(supOrgBudget.getPkValue(), 1);
            } else {
                BudgetControlHelper.updateProBudgetItem(budgetControlId, 0);
            }
        } else if (StringUtils.equals((CharSequence)ControlTypeEnum.PROJECT.getValue(), (CharSequence)controlType)) {
            QFilter projectFilter = new QFilter("project", "=", budgetControl.get("project_id"));
            DynamicObject[] proBudgetItemArr = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"controltype,sourcetype,id,remindrate,controlrate,remindamt,controlamt,budgetitem,budgetamount,currency", (QFilter[])new QFilter[]{projectFilter});
            if (org != null) {
                DynamicObject orgBudgetControl = BudgetControlHelper.getBudgetControlObjByOrg(org.getLong("id"));
                if (orgBudgetControl != null) {
                    BudgetControlHelper.updateProBudgetItem(orgBudgetControl, proBudgetItemArr);
                } else {
                    BudgetControlHelper.cancelProBudgetItemArrControl(proBudgetItemArr);
                }
            }
        }
    }

    public static void updateProBudgetItemWhenEnable(Object budgetControlId) {
        BudgetControlHelper.updateProBudgetItem(budgetControlId, 1);
    }

    private static void updateProBudgetItem(DynamicObject budgetControl, DynamicObject[] proBudgetItemArr) {
        DynamicObjectCollection budgetControlEntryCol = budgetControl.getDynamicObjectCollection("budgetcontrolentry");
        String controlType = budgetControl.getString("controltype");
        if (StringUtils.equals((CharSequence)ControlTypeEnum.ORG.getValue(), (CharSequence)controlType)) {
            HashMap<String, DynamicObject> budgetItemParamMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject budgetEntry : budgetControlEntryCol) {
                DynamicObject budgetItem = budgetEntry.getDynamicObject("orgbudgetitem");
                if (budgetItem == null) continue;
                budgetItemParamMap.put(budgetItem.getString("id"), budgetEntry);
            }
            for (DynamicObject proBudgetItem : proBudgetItemArr) {
                String budgetItemId = proBudgetItem.getString("budgetitem_id");
                DynamicObject budgetParam = (DynamicObject)budgetItemParamMap.get(budgetItemId);
                BudgetControlHelper.updateProBudgetItemByParam(proBudgetItem, budgetParam);
            }
        } else if (StringUtils.equals((CharSequence)ControlTypeEnum.PROJECT.getValue(), (CharSequence)controlType)) {
            HashMap<String, DynamicObject> proBudgetItemParamMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject budgetEntry : budgetControlEntryCol) {
                DynamicObject proBudgetItem = budgetEntry.getDynamicObject("probudgetitem");
                if (proBudgetItem == null) continue;
                proBudgetItemParamMap.put(proBudgetItem.getString("id"), budgetEntry);
            }
            HashMap<String, DynamicObject> budgetItemParamMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject budgetEntry : budgetControlEntryCol) {
                DynamicObject budgetItem = budgetEntry.getDynamicObject("orgbudgetitem");
                if (budgetItem == null) continue;
                budgetItemParamMap.put(budgetItem.getString("id"), budgetEntry);
            }
            for (DynamicObject proBudgetItem : proBudgetItemArr) {
                DynamicObject budgetItem;
                String proBudgetItemId = proBudgetItem.getString("id");
                DynamicObject budgetParam = (DynamicObject)proBudgetItemParamMap.get(proBudgetItemId);
                if (budgetParam == null && (budgetItem = proBudgetItem.getDynamicObject("budgetitem")) != null) {
                    budgetParam = (DynamicObject)budgetItemParamMap.get(budgetItem.getString("id"));
                }
                if (budgetParam == null) {
                    BudgetControlHelper.cancelProBudgetItemControl(proBudgetItem);
                    continue;
                }
                BudgetControlHelper.updateProBudgetItemByParam(proBudgetItem, budgetParam);
            }
        }
        SaveServiceHelper.save((DynamicObject[])proBudgetItemArr);
    }

    public static void updateProBudgetItemByParam(DynamicObject proBudgetItem, DynamicObject budgetParam) {
        if (budgetParam == null) {
            BudgetControlHelper.cancelProBudgetItemControl(proBudgetItem);
            return;
        }
        if (!StringUtils.equals((CharSequence)proBudgetItem.getString("sourcetype"), (CharSequence)BudgetSourceTypeEnum.IN.getValue())) {
            proBudgetItem.set(KEY_REMINDRATE, (Object)budgetParam.getBigDecimal(KEY_REMINDRATE).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP));
            proBudgetItem.set(KEY_CONTROLRATE, (Object)budgetParam.getBigDecimal(KEY_CONTROLRATE).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP));
        }
        DynamicObject currency = proBudgetItem.getDynamicObject("currency");
        int amtPrecision = 10;
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        proBudgetItem.set("remindamt", (Object)proBudgetItem.getBigDecimal(KEY_REMINDRATE).multiply(proBudgetItem.getBigDecimal("budgetamount")).setScale(amtPrecision, RoundingMode.HALF_UP));
        proBudgetItem.set("controlamt", (Object)proBudgetItem.getBigDecimal(KEY_CONTROLRATE).multiply(proBudgetItem.getBigDecimal("budgetamount")).setScale(amtPrecision, RoundingMode.HALF_UP));
    }

    private static void cancelProBudgetItemArrControl(DynamicObject[] proBudgetItemArr) {
        for (DynamicObject proBudgetItem : proBudgetItemArr) {
            BudgetControlHelper.cancelProBudgetItemControl(proBudgetItem);
        }
        SaveServiceHelper.save((DynamicObject[])proBudgetItemArr);
    }

    public static void cancelProBudgetItemControl(DynamicObject proBudgetItem) {
        proBudgetItem.set(KEY_REMINDRATE, (Object)0);
        proBudgetItem.set(KEY_CONTROLRATE, (Object)0);
        proBudgetItem.set("remindamt", (Object)0);
        proBudgetItem.set("controlamt", (Object)0);
    }

    public static Map<String, BigDecimal> getControlByOrgAndBudgetItem(Long org, Long budgetItemId) {
        HashMap<String, BigDecimal> ctrlMap = null;
        QFilter statusFilter = new QFilter("enable", "=", (Object)true);
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.ORG.getValue());
        QFilter controlStrategyFilter = new QFilter("controlstrategy", "in", (Object)new String[]{ControlStrategyEnum.SELF.getValue(), ControlStrategyEnum.SELFANDSUB.getValue()});
        QFilter budgetItemFilter = new QFilter("budgetcontrolentry.orgbudgetitem", "in", (Object)budgetItemId);
        DynamicObject control = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (QFilter[])new QFilter[]{statusFilter, controlTypeFilter, orgFilter, controlStrategyFilter, budgetItemFilter});
        if (control != null) {
            DynamicObjectCollection entry = control.getDynamicObjectCollection("budgetcontrolentry");
            for (DynamicObject dyn2 : entry) {
                DynamicObject orgBudgetItem = dyn2.getDynamicObject("orgbudgetitem");
                if (budgetItemId.longValue() != orgBudgetItem.getLong("id")) continue;
                ctrlMap = new HashMap<String, BigDecimal>(16);
                ctrlMap.put(KEY_REMINDRATE, dyn2.getBigDecimal(KEY_REMINDRATE));
                ctrlMap.put(KEY_CONTROLRATE, dyn2.getBigDecimal(KEY_CONTROLRATE));
                return ctrlMap;
            }
        }
        List<Long> parentOrgList = OrgTreeUtils.getParentByOrgId(org, "15");
        orgFilter = new QFilter("org", "in", parentOrgList);
        controlStrategyFilter = new QFilter("controlstrategy", "=", (Object)ControlStrategyEnum.SELFANDSUB.getValue());
        DynamicObject[] budgetCtlList = BusinessDataServiceHelper.load((String)"pmco_budgetcontrol", (String)"id", (QFilter[])new QFilter[]{statusFilter, controlTypeFilter, orgFilter, controlStrategyFilter, budgetItemFilter});
        Object[] ids = Arrays.stream(budgetCtlList).map(dyn -> dyn.get("id")).toArray();
        for (DynamicObject ctrl : budgetCtlList = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmco_budgetcontrol"))) {
            DynamicObjectCollection entry = ctrl.getDynamicObjectCollection("budgetcontrolentry");
            for (DynamicObject dyn3 : entry) {
                DynamicObject orgBudgetItem = dyn3.getDynamicObject("orgbudgetitem");
                if (budgetItemId.longValue() != orgBudgetItem.getLong("id")) continue;
                ctrlMap = new HashMap(16);
                ctrlMap.put(KEY_REMINDRATE, dyn3.getBigDecimal(KEY_REMINDRATE));
                ctrlMap.put(KEY_CONTROLRATE, dyn3.getBigDecimal(KEY_CONTROLRATE));
                return ctrlMap;
            }
        }
        return ctrlMap;
    }
}

