/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.param.BudgetExportParam;
import kd.pmgt.pmbs.common.param.PermCheckParam;
import kd.pmgt.pmbs.common.tree.Tree;
import kd.pmgt.pmbs.common.tree.TreeNode;
import kd.pmgt.pmbs.common.utils.CheckPermissionHelper;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jetbrains.annotations.NotNull;

public class BudgetEntryOperateHelper {
    private static final Log logger = LogFactory.getLog(BudgetEntryOperateHelper.class);
    public static final String PMBS_BUDGETITEM = "pmbs_budgetitem";
    public static final String ID = "id";
    public static final String PID = "pid";
    public static final String NAME = "name";
    public static final String SEQ = "seq";
    public static final String PARENT = "parent";
    public static final String DESCRIPTION = "description";
    public static final String NUMBER = "number";
    public static final String DESCRIPTIONENTRY = "descriptionentry";
    public static final String BUDGETITEM = "budgetitem";
    public static final String BUDGETAMOUNT = "budgetamount";
    private static final String FORMID_IMPORTEXCEL = "pmbs_importbudgetexcel";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_SHEETNAME = "sheetname";
    public static final String CURRENT_INDEX = "currentIndex";
    public static final String BUDGET = "budget";
    public static final String BUDGETITEMNUM = "budgetitemnum";
    public static final String OPERATION_ADDSUBORDINATE = "addsubordinate";
    public static final String OPERATION_OUTADDSUBORDINATE = "outaddsubordinate";
    public static final String OPERATION_INADDSUBORDINATE = "inaddsubordinate";

    public static int addRow(IFormView formView, String entryId, String amountId, boolean hasAmountColumn) {
        int newRowIndex = -1;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl(entryId);
        int count = formView.getModel().getEntryRowCount(entryId);
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (selectRows == null) {
            return newRowIndex;
        }
        if (selectRows.length > 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u7ed9\u591a\u4e2a\u9884\u7b97\u9879\u6dfb\u52a0\u5b50\u7ea7\u3002", (String)"BudgetEntryOperateHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return newRowIndex;
        }
        int len = selectRows.length;
        int index = formView.getModel().getEntryCurrentRowIndex(entryId);
        newRowIndex = count == 0 || index == -1 || len == 0 ? formView.getModel().createNewEntryRow(entryId) : formView.getModel().insertEntryRow(entryId, index);
        treeEntryGrid.expand(index);
        treeEntryGrid.getModel().updateCache();
        if (hasAmountColumn) {
            BudgetEntryOperateHelper.setAmountColumnEnable(entryId, amountId, formView);
            if ("pmas_pro_approval".equals(formView.getEntityId())) {
                String sumAmountId = "budgetout".equals(entryId) ? "prooutbudgetsumamt" : "proinbudgetsumamt";
                BudgetEntryOperateHelper.setAmountColumnEnable(entryId, sumAmountId, formView);
            }
        }
        return newRowIndex;
    }

    public static int addRow(IFormView formView, String entryId, String amountId, boolean hasAmountColumn, String operation) {
        int newRowIndex = -1;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl(entryId);
        int index = formView.getModel().getEntryCurrentRowIndex(entryId);
        if (!(StringUtils.equals((CharSequence)operation, (CharSequence)OPERATION_ADDSUBORDINATE) || StringUtils.equals((CharSequence)operation, (CharSequence)OPERATION_OUTADDSUBORDINATE) || StringUtils.equals((CharSequence)operation, (CharSequence)OPERATION_INADDSUBORDINATE))) {
            newRowIndex = formView.getModel().createNewEntryRow(entryId);
        } else {
            int[] selectRows = treeEntryGrid.getSelectRows();
            if (selectRows.length < 1) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BudgetEntryOperateHelper_18", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                return newRowIndex;
            }
            if (selectRows.length > 1) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u7ed9\u591a\u4e2a\u9884\u7b97\u9879\u6dfb\u52a0\u5b50\u7ea7\u3002", (String)"BudgetEntryOperateHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                return newRowIndex;
            }
            newRowIndex = formView.getModel().insertEntryRow(entryId, index);
        }
        treeEntryGrid.expand(index);
        treeEntryGrid.getModel().updateCache();
        if (hasAmountColumn) {
            BudgetEntryOperateHelper.setAmountColumnEnable(entryId, amountId, formView);
        }
        return newRowIndex;
    }

    private static void addChildRowIndex(Object pkValue, HashSet<Integer> childSet, Map<Object, Set<Integer>> childEntryIndex, DynamicObjectCollection entryEntity, HashSet<Object> delEntryIds) {
        Set<Integer> childEntryIndexSet = childEntryIndex.get(pkValue);
        if (childEntryIndexSet != null) {
            for (Integer index : childEntryIndexSet) {
                childSet.add(index);
                DynamicObject deleteRow = (DynamicObject)entryEntity.get(index.intValue());
                if (delEntryIds.contains(deleteRow.getPkValue())) continue;
                BudgetEntryOperateHelper.addChildRowIndex(deleteRow.getPkValue(), childSet, childEntryIndex, entryEntity, delEntryIds);
            }
        }
    }

    public static Tree buildTree(DynamicObjectCollection collection, String budgetNameId) {
        ArrayList<TreeNode> nodesList = new ArrayList<TreeNode>();
        for (DynamicObject rowObj : collection) {
            String id = rowObj.getString(ID);
            String name = rowObj.getString(budgetNameId);
            String pid = rowObj.getString(PID);
            nodesList.add(new TreeNode(id, pid, name, rowObj));
        }
        return Tree.buildTreeByPid(nodesList);
    }

    public static Tree buildBudgetItemTree(Object[] primaryKeyValues) {
        DynamicObject[] budgetItems = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PMBS_BUDGETITEM));
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (Object pk : primaryKeyValues) {
            idList.add(pk);
        }
        for (DynamicObject budgetItem : budgetItems) {
            DynamicObject currentBudgetItem = null;
            DynamicObject parent = budgetItem.getDynamicObject(PARENT);
            while (parent != null && !idList.contains(parent.getPkValue())) {
                currentBudgetItem = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PMBS_BUDGETITEM));
                parent = currentBudgetItem.getDynamicObject(PARENT);
            }
            if (parent == null) {
                treeNodeList.add(new TreeNode(budgetItem.getPkValue().toString(), "0", budgetItem.getString(NAME), budgetItem));
                continue;
            }
            treeNodeList.add(new TreeNode(budgetItem.getPkValue().toString(), parent.getPkValue().toString(), budgetItem.getString(NAME), budgetItem));
        }
        return Tree.buildTreeByPid(treeNodeList);
    }

    public static Tree buildTreeFromExcel(String url, IFormView formView, String type) {
        Tree tree = new Tree();
        String formId = formView.getFormShowParameter().getFormId();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                Workbook wb = WorkbookFactory.create((InputStream)in);
                Sheet sheet = wb.getSheetAt(0);
                StringBuffer message = new StringBuffer();
                int messageNum = 0;
                int rowNum = sheet.getLastRowNum();
                Row columnKeyHashRow = sheet.getRow(0);
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                for (int i = 0; i < rowNum; ++i) {
                    String name;
                    Row row = sheet.getRow(i + 1);
                    if (row == null || row.getCell(1) == null || CellType.BLANK.equals((Object)row.getCell(1).getCellType()) || (name = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(1))) == null) continue;
                    String parentName = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(2));
                    int level = BudgetEntryOperateHelper.calculate(list, parentName);
                    if (level == -1 && messageNum < 5) {
                        int rowN = i + 2;
                        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u627e\u5230\u4e0a\u7ea7\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f55\u5165\u4e0a\u7ea7\u6216\u662f\u5426\u6309\u7167\u7236\u5b50\u7ed3\u6784\u987a\u5e8f\u5f55\u5165\u3002", (String)"BudgetEntryOperateHelper_22", (String)"pmgt-pmbs-common", (Object[])new Object[0]), rowN, name);
                        message.append(msg);
                        ++messageNum;
                    }
                    DynamicObject data = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                    TreeNode node = new TreeNode(name.trim(), parentName, level);
                    DynamicObject entryData = BudgetEntryOperateHelper.getTreeentryentity(row, data, type);
                    if (entryData == null) {
                        return null;
                    }
                    node.setData(entryData);
                    list.add(node);
                }
                tree = Tree.buildTree(list);
                String sameNumberMessage = BudgetEntryOperateHelper.checkSameNumber(tree, type);
                if (sameNumberMessage != null) {
                    formView.showTipNotification(sameNumberMessage);
                    return null;
                }
                String sameNameMessage = BudgetEntryOperateHelper.checkSameName(tree);
                if (sameNameMessage != null) {
                    formView.showTipNotification(sameNameMessage);
                    return null;
                }
                if (message.length() > 0) {
                    formView.showMessage(ResManager.loadKDStringExt((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"BudgetEntryOperateHelper_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
                    return null;
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return tree;
    }

    public static boolean checkFirstNode(IFormView formView, String entryId, int index) {
        DynamicObject preRowObj;
        DynamicObject curRowObj;
        String pid;
        int beginSeq = index;
        if (beginSeq == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e3a\u540c\u5c42\u7ea7\u4e0b\u7684\u9996\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"BudgetEntryOperateHelper_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return true;
        }
        if (beginSeq > 0 && (pid = (curRowObj = formView.getModel().getEntryRowEntity(entryId, beginSeq)).getString(PID)).equals((preRowObj = formView.getModel().getEntryRowEntity(entryId, beginSeq - 1)).getString(ID))) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e3a\u540c\u5c42\u7ea7\u4e0b\u7684\u9996\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"BudgetEntryOperateHelper_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean checkNameIsRepeat(int rowIndex, String entryId, String budgetNameId, IFormView formView) {
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(entryId);
        DynamicObject currentRowEntity = (DynamicObject)entryEntity.get(rowIndex);
        String currentPid = currentRowEntity.getString(PID);
        String currentBudgetName = currentRowEntity.getString(budgetNameId);
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject rowEntity;
            String budgetName;
            if (i == rowIndex || (budgetName = (rowEntity = (DynamicObject)entryEntity.get(i)).getString(budgetNameId)) == null || StringUtils.equals((CharSequence)budgetName, (CharSequence)"") || !StringUtils.equals((CharSequence)rowEntity.getString(PID), (CharSequence)currentPid) || !StringUtils.equals((CharSequence)budgetName, (CharSequence)currentBudgetName)) continue;
            formView.showTipNotification(ResManager.loadKDString((String)"\u540c\u7ea7\u6b21\u5185\u8be5\u9884\u7b97\u9879\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"BudgetEntryOperateHelper_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static String checkSameName(Tree tree) {
        List<TreeNode> list = tree.getList();
        HashMap pidNameMap = new HashMap();
        String name = null;
        String pid = null;
        for (int i = 0; i < list.size(); ++i) {
            TreeNode treeNode = list.get(i);
            TreeNode parent = treeNode.getParent();
            pid = parent == null ? "0" : parent.toString();
            name = treeNode.getName().trim();
            if (!pidNameMap.containsKey(pid)) {
                HashSet<String> set = new HashSet<String>();
                set.add(name);
                pidNameMap.put(pid, set);
                continue;
            }
            if (((Set)pidNameMap.get(pid)).contains(name)) {
                String msg = String.format(ResManager.loadKDString((String)"\u540c\u7ea7\u9884\u7b97\u9879\u4e2d\u540d\u79f0\u5b58\u5728\u91cd\u540d\uff1a\u7b2c%1$s\u884c\uff0c\u540d\u79f0\u4e3a\u201c%2$s\u201d\u3002", (String)"BudgetEntryOperateHelper_23", (String)"pmgt-pmbs-common", (Object[])new Object[0]), i + 2, name);
                return msg;
            }
            ((Set)pidNameMap.get(pid)).add(name);
        }
        return null;
    }

    public static String checkSameNumber(Tree tree, String type) {
        List<TreeNode> list = tree.getList();
        HashMap pidNumberMap = new HashMap();
        String number = null;
        String pid = null;
        String numberId = "";
        if (StringUtils.equals((CharSequence)"template", (CharSequence)type)) {
            numberId = BUDGETITEMNUM;
        } else if (StringUtils.equals((CharSequence)"budgetout", (CharSequence)type)) {
            numberId = "outitemnumber";
        } else if (StringUtils.equals((CharSequence)"budgetin", (CharSequence)type)) {
            numberId = "initemnumber";
        }
        for (int i = 0; i < list.size(); ++i) {
            TreeNode treeNode = list.get(i);
            TreeNode parent = treeNode.getParent();
            pid = parent == null ? "0" : parent.toString();
            number = treeNode.getData().getString(numberId);
            if (!pidNumberMap.containsKey(pid)) {
                HashSet<String> set = new HashSet<String>();
                set.add(number);
                pidNumberMap.put(pid, set);
                continue;
            }
            if (((Set)pidNumberMap.get(pid)).contains(number)) {
                String msg = String.format(ResManager.loadKDString((String)"\u540c\u7ea7\u9884\u7b97\u9879\u4e2d\u540d\u79f0\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff1a\u7b2c%1$s\u884c\uff0c\u7f16\u7801\u4e3a\u4e3a\u201c%2$s\u201d\u3002", (String)"BudgetEntryOperateHelper_24", (String)"pmgt-pmbs-common", (Object[])new Object[0]), i + 2, number);
                return msg;
            }
            ((Set)pidNumberMap.get(pid)).add(number);
        }
        return null;
    }

    public static int calculate(List<TreeNode> list, String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return 1;
        }
        for (int i = list.size(); i > 0; --i) {
            TreeNode node = list.get(i - 1);
            if (!str.equals(node.getName())) continue;
            return node.getLevel() + 1;
        }
        return -1;
    }

    public static boolean checkHasChildRows(IDataModel dataModel, int[] selectRows, String entryId) {
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(entryId);
        return !TreeEntryProp.canDeleteTreeEntryRows((DynamicObjectCollection)entryEntity, (int[])selectRows);
    }

    public static boolean checkTitle(List<String> list, String[] title) {
        if (list == null || list.size() != title.length) {
            return false;
        }
        for (int i = 0; i < title.length; ++i) {
            if (StringUtils.equals((CharSequence)list.get(i), (CharSequence)title[i])) continue;
            return false;
        }
        return true;
    }

    public static void createSubTree(IDataModel dataModel, String entryId, String budgetItemId, String budgetNameId, String amountId, String sumAmountId, String budgetNumberId, String descrptionId, List<DynamicObject> treeData, int insertIndex, DynamicObject parent, int begin) {
        int fixIndex = insertIndex;
        String parentId = parent.getString(ID);
        for (int i = begin + 1; i < treeData.size(); ++i) {
            DynamicObject cur = treeData.get(i);
            String pid = cur.getString(PID);
            if (!StringUtils.equals((CharSequence)pid, (CharSequence)parentId)) continue;
            insertIndex = dataModel.insertEntryRow(entryId, fixIndex);
            dataModel.updateCache();
            dataModel.setValue(budgetNameId, cur.get(budgetNameId), insertIndex);
            dataModel.setValue(budgetItemId, cur.get(budgetItemId), insertIndex);
            dataModel.setValue(descrptionId, cur.get(descrptionId), insertIndex);
            dataModel.setValue(budgetNumberId, cur.get(budgetNumberId), insertIndex);
            if (amountId != null) {
                dataModel.setValue(amountId, cur.get(amountId), insertIndex);
            }
            if (sumAmountId != null) {
                dataModel.setValue(sumAmountId, cur.get(sumAmountId), insertIndex);
            }
            BudgetEntryOperateHelper.createSubTree(dataModel, entryId, budgetItemId, budgetNameId, amountId, sumAmountId, budgetNumberId, descrptionId, treeData, insertIndex, cur, i);
        }
    }

    public static BigDecimal countTotalAmount(DynamicObjectCollection entryEntity, String amountId) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (entryEntity != null && entryEntity.size() > 0) {
            for (DynamicObject entry : entryEntity) {
                String parentId = entry.getString(PID);
                if (parentId != null && !StringUtils.equals((CharSequence)"0", (CharSequence)parentId)) continue;
                totalAmount = totalAmount.add(entry.getBigDecimal(amountId));
            }
        }
        return totalAmount;
    }

    public static void downgrade(IFormView formView, String entryId, String budgetItemId, String budgetNameId, String amountId, String totalAmountId, String budgetNumberId, String descriptionId, boolean hasAmountColumn) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl(entryId);
        int[] index = treeEntryGrid.getSelectRows();
        if (index.length != 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BudgetEntryOperateHelper_20", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return;
        }
        int selectIndex = formView.getModel().getEntryCurrentRowIndex(entryId);
        boolean isFirstNode = BudgetEntryOperateHelper.checkFirstNode(formView, entryId, selectIndex);
        if (!isFirstNode) {
            int i;
            DynamicObject selectRow = formView.getModel().getEntryRowEntity(entryId, selectIndex);
            DynamicObject brother = BudgetEntryOperateHelper.getBrother(selectRow, formView.getModel().getEntryEntity(entryId));
            String parentId = brother != null ? brother.getString(ID) : "0";
            DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(entryId);
            String currentRowName = selectRow.getString(budgetNameId);
            if (StringUtils.isNotEmpty((CharSequence)currentRowName)) {
                for (DynamicObject entity : entryEntity) {
                    if (!StringUtils.equals((CharSequence)entity.getString(PID), (CharSequence)parentId) || !StringUtils.equals((CharSequence)entity.getString(budgetNameId), (CharSequence)currentRowName)) continue;
                    formView.showTipNotification(ResManager.loadKDString((String)"\u964d\u7ea7\u540e\uff0c\u540c\u7ea7\u522b\u5185\u9884\u7b97\u9879\u540d\u79f0\u5c06\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"BudgetEntryOperateHelper_7", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                    return;
                }
            }
            int lastChildSeq = BudgetEntryOperateHelper.findLastChildSeq(formView.getModel(), entryId, selectIndex);
            ArrayList<DynamicObject> treeData = new ArrayList<DynamicObject>(10);
            for (i = selectIndex; i <= lastChildSeq; ++i) {
                treeData.add(formView.getModel().getEntryRowEntity(entryId, i));
            }
            for (i = lastChildSeq; i >= selectIndex; --i) {
                formView.getModel().deleteEntryRow(entryId, i);
                formView.getModel().updateCache();
            }
            String sumAmountId = null;
            String proTotalAmtId = null;
            String entityId = formView.getEntityId();
            if ("pmas_pro_approval".equals(entityId)) {
                proTotalAmtId = "budgetout".equals(entryId) ? "prooutbudgetsumamt" : "proinbudgetsumamt";
                sumAmountId = "budgetout".equals(entryId) ? "outbudsumamount" : "inbudsumamount";
            }
            DynamicObject parent = BudgetEntryOperateHelper.getBrother(selectRow, formView.getModel().getEntryEntity(entryId));
            int focusIndex = BudgetEntryOperateHelper.insertTreeData(formView.getModel(), entryId, budgetItemId, budgetNameId, amountId, sumAmountId, budgetNumberId, descriptionId, treeData, parent, true);
            treeEntryGrid.focus(focusIndex - 1, focusIndex);
            treeEntryGrid.collapse(focusIndex);
            treeEntryGrid.selectRows(focusIndex);
            formView.getModel().setEntryCurrentRowIndex(entryId, focusIndex);
            formView.getModel().updateCache();
            if (hasAmountColumn) {
                BudgetEntryOperateHelper.setAmountColumnEnable(entryId, amountId, formView);
                BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue(formView, entryId, amountId);
                BudgetEntryOperateHelper.setTotalAmount(totalAmount, formView, totalAmountId);
                if ("pmas_pro_approval".equals(entityId)) {
                    BudgetEntryOperateHelper.setAmountColumnEnable(entryId, sumAmountId, formView);
                    BigDecimal proTotalAmount = BudgetEntryOperateHelper.setAmountColumnValue(formView, entryId, sumAmountId);
                    BudgetEntryOperateHelper.setTotalAmount(proTotalAmount, formView, proTotalAmtId);
                }
            }
        }
    }

    public static void deleteRow(AbstractBillPlugIn formPlugin, String entryId, String amountId, String totalAmountId, String callBackId, boolean hasAmountColumn) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formPlugin.getControl(entryId);
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u5220\u9664\u7684\u884c\u3002", (String)"BudgetEntryOperateHelper_8", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return;
        }
        boolean hasChildRows = BudgetEntryOperateHelper.checkHasChildRows(formPlugin.getView().getModel(), selectRows, entryId);
        if (hasChildRows) {
            formPlugin.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u975e\u660e\u7ec6\u8282\u70b9\uff0c\u5c06\u4f1a\u540c\u65f6\u5220\u9664\u5176\u4e0b\u7ea7\u8282\u70b9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetEntryOperateHelper_9", (String)"pmgt-pmbs-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(callBackId, (IFormPlugin)formPlugin));
        } else {
            IDataModel entryOperate = formPlugin.getView().getModel();
            Set<Object> parentIdSet = BudgetEntryOperateHelper.getSelectRowParents(formPlugin.getView().getModel(), selectRows, entryId);
            entryOperate.deleteEntryRows(entryId, selectRows);
            formPlugin.getView().getModel().updateCache();
            if (hasAmountColumn) {
                BudgetEntryOperateHelper.resetParentAmountValue(formPlugin.getView().getModel(), parentIdSet, entryId, amountId);
                BudgetEntryOperateHelper.setAmountColumnEnable(entryId, amountId, formPlugin.getView());
                BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue(formPlugin.getView(), entryId, amountId);
                BudgetEntryOperateHelper.setTotalAmount(totalAmount, formPlugin.getView(), totalAmountId);
                BudgetEntryOperateHelper.setTotalAmountEnable(formPlugin.getView(), entryId, totalAmountId);
                String entityId = formPlugin.getView().getEntityId();
                if ("pmas_pro_approval".equals(entityId)) {
                    amountId = "budgetout".equals(entryId) ? "outbudsumamount" : "inbudsumamount";
                    totalAmountId = "budgetout".equals(entryId) ? "prooutbudgetsumamt" : "proinbudgetsumamt";
                    BudgetEntryOperateHelper.resetParentAmountValue(formPlugin.getView().getModel(), parentIdSet, entryId, amountId);
                    BudgetEntryOperateHelper.setAmountColumnEnable(entryId, amountId, formPlugin.getView());
                    totalAmount = BudgetEntryOperateHelper.setAmountColumnValue(formPlugin.getView(), entryId, amountId);
                    BudgetEntryOperateHelper.setTotalAmount(totalAmount, formPlugin.getView(), totalAmountId);
                    BudgetEntryOperateHelper.setTotalAmountEnable(formPlugin.getView(), entryId, totalAmountId);
                }
            }
        }
    }

    public static void exportExcel(IFormView formView, String entryId, String sheetName, String budgetNameId, String budgetAmountId, String budgetItemId, String budgetNumberId, String descriptionId, String[] title, boolean isTemplate, boolean hasAmountColumn) {
        HSSFWorkbook wb;
        String entityId = formView.getEntityId();
        if ("pmas_pro_approval".equals(entityId)) {
            String sumBudgetAmtId = "budgetout".equals(entryId) ? "outbudsumamount" : "inbudsumamount";
            wb = BudgetEntryOperateHelper.setWorkbook(formView, entryId, sheetName, budgetNameId, budgetAmountId, sumBudgetAmtId, budgetItemId, budgetNumberId, descriptionId, title, isTemplate, hasAmountColumn);
        } else {
            wb = BudgetEntryOperateHelper.setWorkbook(formView, entryId, sheetName, budgetNameId, budgetAmountId, null, budgetItemId, budgetNumberId, descriptionId, title, isTemplate, hasAmountColumn);
        }
        String fileName = BudgetEntryOperateHelper.buildFileName(sheetName, isTemplate);
        BudgetEntryOperateHelper.writeAndDownLoad(formView, wb, fileName);
    }

    public static void exportExcel(BudgetExportParam budgetExportParam, String sheetName, String[] columnKeys, String[] title) {
        HSSFWorkbook wb = BudgetEntryOperateHelper.setWorkbook(budgetExportParam, sheetName, columnKeys, title);
        String fileName = BudgetEntryOperateHelper.buildFileName(sheetName, budgetExportParam.isTemplate());
        BudgetEntryOperateHelper.writeAndDownLoad(budgetExportParam.getFormView(), wb, fileName);
    }

    private static HSSFWorkbook setWorkbook(BudgetExportParam budgetExportParam, String sheetName, String[] columnKeys, String[] title) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < title.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle(style);
            sheet.setColumnWidth(i, 4024);
        }
        if (!budgetExportParam.isTemplate()) {
            DynamicObjectCollection collection = budgetExportParam.getFormView().getModel().getEntryEntity(budgetExportParam.getEntryId());
            Tree tree = BudgetEntryOperateHelper.buildTree(collection, budgetExportParam.getNodeName());
            BudgetEntryOperateHelper.handleExportData(budgetExportParam, tree, sheet, columnKeys, title);
        }
        return wb;
    }

    private static void handleExportData(BudgetExportParam budgetExportParam, Tree tree, HSSFSheet sheet, String[] columnKeys, String[] title) {
        HashSet<String> addedNodeSet = new HashSet<String>();
        List<TreeNode> treeNodeList = tree.getList();
        int index = 1;
        for (int i = 0; i < treeNodeList.size(); ++i) {
            TreeNode node = treeNodeList.get(i);
            if (addedNodeSet.contains(node.getId())) continue;
            addedNodeSet.add(node.getId());
            BudgetEntryOperateHelper.setExportRowData(budgetExportParam, node, sheet, index, columnKeys, title);
            ++index;
            index = BudgetEntryOperateHelper.setChild(budgetExportParam, node, sheet, index, addedNodeSet, columnKeys, title);
        }
    }

    private static int setChild(BudgetExportParam budgetExportParam, TreeNode node, HSSFSheet sheet, int index, Set<String> set, String[] columnKeys, String[] title) {
        List<TreeNode> childs = node.getChild();
        if (childs != null) {
            for (TreeNode child : childs) {
                if (set.contains(child.getId())) continue;
                set.add(child.getId());
                BudgetEntryOperateHelper.setExportRowData(budgetExportParam, child, sheet, index, columnKeys, title);
                ++index;
                index = BudgetEntryOperateHelper.setChild(budgetExportParam, node, sheet, index, set, columnKeys, title);
            }
        }
        return index;
    }

    private static void setExportRowData(BudgetExportParam budgetExportParam, TreeNode node, HSSFSheet sheet, int index, String[] columnKeys, String[] title) {
        String[] rowData = new String[title.length];
        HSSFRow cur = sheet.createRow(index);
        StringBuilder blank = new StringBuilder();
        int level = node.getLevel();
        while (--level > 0) {
            blank.append("    ");
        }
        int count = 0;
        DynamicObject nodeData = node.getData();
        IDataModel model = budgetExportParam.getFormView().getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        DynamicObject currency = budgetExportParam.getCurrency();
        int amtprecision = currency != null ? currency.getInt("amtprecision") : 10;
        for (String columnKey : columnKeys) {
            if (StringUtils.equals((CharSequence)columnKey, (CharSequence)budgetExportParam.getNodeName())) {
                rowData[count++] = blank + nodeData.getString(columnKey);
                rowData[count++] = String.valueOf(node.getParent() == null ? "" : node.getParent().getName());
                continue;
            }
            IDataEntityProperty property = dataEntityType.findProperty(columnKey);
            if (property instanceof AmountProp) {
                BigDecimal amount = nodeData.getBigDecimal(columnKey);
                if (amount != null) {
                    String value = amount.setScale(amtprecision, RoundingMode.HALF_UP).toString();
                    if ("0E-10".equals(value)) {
                        value = BigDecimal.ZERO.setScale(amtprecision).toString();
                    }
                    rowData[count++] = value;
                    continue;
                }
                rowData[count++] = BigDecimal.ZERO.setScale(amtprecision).toString();
                continue;
            }
            if (property instanceof BasedataProp) {
                rowData[count++] = String.valueOf(nodeData.getDynamicObject(columnKey) == null ? "" : nodeData.getDynamicObject(columnKey).getString(NAME));
                continue;
            }
            rowData[count++] = nodeData.get(columnKey) != null ? nodeData.get(columnKey).toString() : null;
        }
        HSSFDataFormat format = sheet.getWorkbook().createDataFormat();
        for (int j = 0; j < title.length; ++j) {
            Cell cell = cur.createCell(j);
            cell.getCellStyle().setDataFormat(format.getFormat("TEXT"));
            cell.setCellValue(rowData[j]);
        }
    }

    public static void exportExcel(IFormView formView, String entryId, String sheetName, String budgetNameId, String budgetAmountId, String budgetItemId, String budgetNumberId, String descriptionId, String[] title, boolean isTemplate, boolean hasAmountColumn, boolean needTextColumn) {
        HSSFWorkbook wb = BudgetEntryOperateHelper.setWorkbook(formView, entryId, sheetName, budgetNameId, budgetAmountId, null, budgetItemId, budgetNumberId, descriptionId, title, isTemplate, hasAmountColumn);
        if (needTextColumn) {
            HSSFCellStyle cellStyle = wb.createCellStyle();
            HSSFDataFormat dataFormat = wb.createDataFormat();
            cellStyle.setDataFormat(dataFormat.getFormat("TEXT"));
            for (Sheet sheet : wb) {
                for (int i = 0; i < title.length; ++i) {
                    for (int j = 0; j < title.length; ++j) {
                        sheet.setDefaultColumnStyle(i, (CellStyle)cellStyle);
                    }
                }
            }
        }
        String fileName = BudgetEntryOperateHelper.buildFileName(sheetName, isTemplate);
        BudgetEntryOperateHelper.writeAndDownLoad(formView, wb, fileName);
    }

    private static void writeAndDownLoad(IFormView formView, HSSFWorkbook wb, String fileName) {
        PermCheckParam permCheckParam;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (FORMID_IMPORTEXCEL.equals(formView.getEntityId())) {
            permCheckParam = new PermCheckParam(url, formView.getParentView().getEntityId(), formView.getParentView().getFormShowParameter().getAppId(), "47150e89000000ac");
            CheckPermissionHelper.setFileUrlPermCheckParam(permCheckParam);
        } else {
            permCheckParam = new PermCheckParam(url, formView.getEntityId(), formView.getFormShowParameter().getAppId(), "47150e89000000ac");
            CheckPermissionHelper.setFileUrlPermCheckParam(permCheckParam);
        }
        formView.download(url);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @NotNull
    private static HSSFWorkbook setWorkbook(IFormView formView, String entryId, String sheetName, String budgetNameId, String budgetAmountId, String sumBudgetAmtId, String budgetItemId, String budgetNumberId, String descriptionId, String[] title, boolean isTemplate, boolean hasAmountColumn) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < title.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle(style);
            sheet.setColumnWidth(i, 4024);
        }
        if (!isTemplate) {
            DynamicObjectCollection collection = formView.getModel().getEntryEntity(entryId);
            Tree tree = BudgetEntryOperateHelper.buildTree(collection, budgetNameId);
            BudgetEntryOperateHelper.handleExportData(budgetNameId, budgetAmountId, sumBudgetAmtId, budgetItemId, budgetNumberId, descriptionId, tree, (Sheet)sheet, title, hasAmountColumn);
        }
        return wb;
    }

    @NotNull
    private static String buildFileName(String sheetName, boolean isTemplate) {
        Calendar cal = Calendar.getInstance();
        int y = cal.get(1);
        int m = cal.get(2) + 1;
        int d = cal.get(5);
        String fileName = null;
        fileName = isTemplate ? String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5bfc\u5165\u6a21\u677f%1$s%2$s%3$s.xls\u3002", (String)"BudgetEntryOperateHelper_16", (String)"pmgt-pmbs-common", (Object[])new Object[0]), y, m, d) : sheetName + "-" + y + "-" + m + "-" + d + ".xls";
        return fileName;
    }

    public static void fillTreeEntryByTemplate(DynamicObject tpl, String fillEntryId, IFormView formView, String budgetNameId, String budgetNumId, String descriptionId, String budgetItemId) {
        IDataModel dataModel = formView.getModel();
        dataModel.deleteEntryData(fillEntryId);
        DynamicObjectCollection tplEntry = tpl.getDynamicObjectCollection("treeentryentity");
        BudgetEntryOperateHelper.fillTreeEntryByEntryEntity(tplEntry, true, false, formView, fillEntryId, budgetNameId, budgetNumId, descriptionId, budgetItemId);
    }

    public static void fillTreeEntryByEntryEntity(DynamicObjectCollection entryEntity, boolean isTemplateEntry, boolean isAdjust, IFormView formView, String fillEntryId, String budgetNameId, String budgetNumId, String descriptionId, String budgetItemId) {
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        IDataModel dataModel = formView.getModel();
        DynamicObjectCollection entryDatas = dataModel.getEntryEntity(fillEntryId);
        DynamicObjectType dt = entryDatas.getDynamicObjectType();
        HashMap<Long, Long> mapedNewPk = new HashMap<Long, Long>(16);
        ORM orm = ORM.create();
        long[] newIds = orm.genLongIds((IDataEntityType)dt, entryEntity.size());
        int index = 0;
        for (DynamicObject entry : entryEntity) {
            mapedNewPk.put((Long)entry.getPkValue(), newIds[index++]);
        }
        for (DynamicObject entry : entryEntity) {
            DynamicObject budgetItem;
            DynamicObject newTreeEntryData = new DynamicObject(dt);
            if (isTemplateEntry) {
                newTreeEntryData.set(budgetNameId, entry.get("budgetitemname"));
                newTreeEntryData.set(budgetNumId, entry.get(BUDGETITEMNUM));
                newTreeEntryData.set(descriptionId, entry.get(DESCRIPTIONENTRY));
                budgetItem = entry.getDynamicObject(BUDGETITEM);
                if (budgetItem != null) {
                    newTreeEntryData.set(budgetItemId, (Object)budgetItem);
                }
            } else {
                DynamicObject projectBudgetItem;
                newTreeEntryData.set("budgetitemname", entry.get("budgetitemname"));
                newTreeEntryData.set(BUDGETITEMNUM, entry.get(BUDGETITEMNUM));
                newTreeEntryData.set(DESCRIPTIONENTRY, entry.get(DESCRIPTIONENTRY));
                if (isAdjust) {
                    BigDecimal prevamount = (BigDecimal)entry.get(BUDGETAMOUNT);
                    newTreeEntryData.set("viamount", (Object)prevamount);
                    newTreeEntryData.set("isprev", (Object)Boolean.TRUE);
                    newTreeEntryData.set(BUDGETAMOUNT, (Object)prevamount);
                    BigDecimal siamount = (BigDecimal)entry.get("siamount");
                    if (BigDecimal.ZERO.compareTo(siamount) != 0) {
                        newTreeEntryData.set("siamount", (Object)siamount);
                        newTreeEntryData.set("ispres", (Object)Boolean.TRUE);
                    }
                } else {
                    newTreeEntryData.set("siamount", entry.get(BUDGETAMOUNT));
                    if (BigDecimal.ZERO.compareTo(entry.getBigDecimal(BUDGETAMOUNT)) != 0) {
                        newTreeEntryData.set("ispres", (Object)Boolean.TRUE);
                    } else {
                        newTreeEntryData.set("ispres", (Object)Boolean.FALSE);
                    }
                    newTreeEntryData.set(BUDGETAMOUNT, entry.get(BUDGETAMOUNT));
                }
                budgetItem = entry.getDynamicObject(BUDGETITEM);
                if (budgetItem != null) {
                    newTreeEntryData.set(BUDGETITEM, (Object)budgetItem);
                }
                if ((projectBudgetItem = entry.getDynamicObject("projectbudgetitem")) != null) {
                    newTreeEntryData.set("projectbudgetitem", (Object)projectBudgetItem);
                } else if (QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)entry.getLong(ID))) {
                    projectBudgetItem = BusinessDataServiceHelper.loadSingle((Object)entry.getLong(ID), (String)"pmas_projectbudget");
                    newTreeEntryData.set("projectbudgetitem", (Object)projectBudgetItem);
                }
            }
            Long pid = (Long)entry.get(PID);
            Long newpid = 0L;
            if (pid != null && !pid.equals(0L)) {
                newpid = (Long)mapedNewPk.get(pid);
            }
            newTreeEntryData.set(PID, (Object)newpid);
            newTreeEntryData.set(ID, mapedNewPk.get(entry.getPkValue()));
            entryDatas.add((Object)newTreeEntryData);
        }
        dataModel.updateEntryCache(entryDatas);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl(fillEntryId);
        treeEntryGrid.setCollapse(false);
        formView.updateView(fillEntryId);
    }

    public static int findRowIndexById(Object rowId, DynamicObjectCollection entryEntity) {
        int count = entryEntity.size();
        for (int i = 0; i < count; ++i) {
            if (!rowId.equals(((DynamicObject)entryEntity.get(i)).getPkValue())) continue;
            return i;
        }
        return -1;
    }

    public static void fillRootNode(IFormView formView, String entryId, String budgetItemId, String budgetNameId, String budgetNumId, String descriptionId, TreeNode rootNode) {
        IDataModel dataModel = formView.getModel();
        int index = BudgetEntryOperateHelper.findSameNameBrotherIndex(dataModel, entryId, budgetNameId, "0", rootNode.getName());
        if (index == -1) {
            int rootRow;
            index = rootRow = dataModel.createNewEntryRow(entryId);
        }
        dataModel.updateCache();
        dataModel.setValue(budgetItemId, (Object)rootNode.getId(), index);
        dataModel.setValue(budgetNameId, (Object)rootNode.getName(), index);
        dataModel.setValue(budgetNumId, (Object)rootNode.getData().getString(NUMBER), index);
        dataModel.setValue(descriptionId, (Object)rootNode.getData().getString(DESCRIPTION), index);
        BudgetEntryOperateHelper.fillChildNodes(formView, entryId, budgetItemId, budgetNameId, budgetNumId, descriptionId, rootNode, index);
    }

    public static int findSameNameBrotherIndex(IDataModel dataModel, String entryId, String budgetNameId, String parentId, String name) {
        int count = dataModel.getEntryRowCount(entryId);
        for (int i = 0; i < count; ++i) {
            DynamicObject rowEntity = dataModel.getEntryRowEntity(entryId, i);
            if (!StringUtils.equals((CharSequence)parentId, (CharSequence)rowEntity.getString(PID)) || !StringUtils.equals((CharSequence)name, (CharSequence)rowEntity.getString(budgetNameId))) continue;
            return i;
        }
        return -1;
    }

    public static void fillEntryData(IFormView formView, String entryId, String budgetNameId, Tree tree, String type) {
        List<TreeNode> list = tree.getList();
        if (list != null && list.size() > 0) {
            formView.getModel().deleteEntryData(entryId);
            int returnIndex = -1;
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            indexMap.put(CURRENT_INDEX, -1);
            for (int i = 0; i < list.size(); ++i) {
                if (returnIndex >= i) continue;
                int index = formView.getModel().createNewEntryRow(entryId);
                indexMap.put(CURRENT_INDEX, (Integer)indexMap.get(CURRENT_INDEX) + 1);
                formView.getModel().updateCache();
                if (StringUtils.equals((CharSequence)"budgetin", (CharSequence)type)) {
                    formView.getModel().setValue("initemnumber", list.get(i).getData().get("initemnumber"), index);
                    formView.getModel().setValue("initem", list.get(i).getData().get("initem"), index);
                    formView.getModel().setValue("indescription", list.get(i).getData().get("indescription"), index);
                } else if (StringUtils.equals((CharSequence)"budgetout", (CharSequence)type)) {
                    formView.getModel().setValue("outitemnumber", list.get(i).getData().get("outitemnumber"), index);
                    formView.getModel().setValue("outitem", list.get(i).getData().get("outitem"), index);
                    formView.getModel().setValue("outdescription", list.get(i).getData().get("outdescription"), index);
                } else if (StringUtils.equals((CharSequence)"template", (CharSequence)type)) {
                    formView.getModel().setValue(BUDGETITEMNUM, list.get(i).getData().get(BUDGETITEMNUM), index);
                    formView.getModel().setValue(BUDGETITEM, list.get(i).getData().get(BUDGETITEM), index);
                    formView.getModel().setValue(DESCRIPTIONENTRY, list.get(i).getData().get(DESCRIPTIONENTRY), index);
                } else {
                    formView.getModel().setValue(BUDGETITEM, list.get(i).getData().get(BUDGETITEM), index);
                    formView.getModel().setValue(DESCRIPTIONENTRY, list.get(i).getData().get(DESCRIPTIONENTRY), index);
                }
                formView.getModel().setValue(budgetNameId, (Object)list.get(i).getName(), index);
                if (list.get(i).getChild() != null) {
                    returnIndex = BudgetEntryOperateHelper.fillEntryRow(formView.getModel(), entryId, budgetNameId, list.get(i).getChild(), index, indexMap, type).get(CURRENT_INDEX);
                    continue;
                }
                if (StringUtils.equals((CharSequence)BUDGET, (CharSequence)type)) {
                    formView.getModel().setValue(BUDGETAMOUNT, list.get(i).getData().get(BUDGETAMOUNT), index);
                    continue;
                }
                if (StringUtils.equals((CharSequence)"budgetout", (CharSequence)type)) {
                    formView.getModel().setValue("outbudsumamount", list.get(i).getData().get("outbudsumamount"), index);
                    formView.getModel().setValue("bdoutamount", list.get(i).getData().get("bdoutamount"), index);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"budgetin", (CharSequence)type)) continue;
                formView.getModel().setValue("inbudsumamount", list.get(i).getData().get("inbudsumamount"), index);
                formView.getModel().setValue("bdinamount", list.get(i).getData().get("bdinamount"), index);
            }
        }
        TreeEntryGrid grid = (TreeEntryGrid)formView.getControl(entryId);
        grid.setCollapse(false);
        formView.getModel().updateCache();
    }

    public static Map<String, Integer> fillEntryRow(IDataModel dataModel, String entryId, String budgetNameId, List<TreeNode> listNode, int index, Map<String, Integer> indexMap, String type) {
        for (int i = 0; i < listNode.size(); ++i) {
            int returnIndex = dataModel.insertEntryRow(entryId, index);
            indexMap.put(CURRENT_INDEX, indexMap.get(CURRENT_INDEX) + 1);
            dataModel.updateCache();
            if (StringUtils.equals((CharSequence)"budgetin", (CharSequence)type)) {
                dataModel.setValue("initem", listNode.get(i).getData().get("initem"), returnIndex);
                dataModel.setValue("indescription", listNode.get(i).getData().get("indescription"), returnIndex);
            } else if (StringUtils.equals((CharSequence)"budgetout", (CharSequence)type)) {
                dataModel.setValue("outitem", listNode.get(i).getData().get("outitem"), returnIndex);
                dataModel.setValue("outdescription", listNode.get(i).getData().get("outdescription"), returnIndex);
            } else {
                dataModel.setValue(BUDGETITEM, listNode.get(i).getData().get(BUDGETITEM), returnIndex);
                dataModel.setValue(DESCRIPTIONENTRY, listNode.get(i).getData().get(DESCRIPTIONENTRY), returnIndex);
            }
            dataModel.setValue(budgetNameId, (Object)listNode.get(i).getName(), returnIndex);
            if (listNode.get(i).getChild() != null) {
                indexMap.put("returnIndex", returnIndex);
                returnIndex = BudgetEntryOperateHelper.fillEntryRow(dataModel, entryId, budgetNameId, listNode.get(i).getChild(), returnIndex, indexMap, type).get("returnIndex");
                continue;
            }
            if (StringUtils.equals((CharSequence)BUDGET, (CharSequence)type)) {
                dataModel.setValue(BUDGETAMOUNT, listNode.get(i).getData().get(BUDGETAMOUNT), returnIndex);
                continue;
            }
            if (StringUtils.equals((CharSequence)"budgetout", (CharSequence)type)) {
                dataModel.setValue("outbudsumamount", listNode.get(i).getData().get("outbudsumamount"), returnIndex);
                dataModel.setValue("bdoutamount", listNode.get(i).getData().get("bdoutamount"), returnIndex);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"budgetin", (CharSequence)type)) continue;
            dataModel.setValue("inbudsumamount", listNode.get(i).getData().get("inbudsumamount"), returnIndex);
            dataModel.setValue("bdinamount", listNode.get(i).getData().get("bdinamount"), returnIndex);
        }
        return indexMap;
    }

    public static void fillChildNodes(IFormView formView, String entryId, String budgetItemId, String budgetNameId, String budgetNumId, String descriptionId, TreeNode parentNode, int parentRow) {
        IDataModel dataModel = formView.getModel();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl(entryId);
        List<TreeNode> childs = parentNode.getChild();
        if (childs != null && childs.size() > 0) {
            for (TreeNode child : childs) {
                String parentId = dataModel.getEntryRowEntity(entryId, parentRow).getPkValue().toString();
                int index = BudgetEntryOperateHelper.findSameNameBrotherIndex(dataModel, entryId, budgetNameId, parentId, child.getName());
                if (index == -1) {
                    index = dataModel.insertEntryRow(entryId, parentRow);
                }
                dataModel.updateCache();
                dataModel.setValue(budgetItemId, (Object)child.getId(), index);
                dataModel.setValue(budgetNameId, (Object)child.getName(), index);
                dataModel.setValue(budgetNumId, (Object)child.getData().getString(NUMBER), index);
                dataModel.setValue(descriptionId, (Object)child.getData().getString(DESCRIPTION), index);
                BudgetEntryOperateHelper.fillChildNodes(formView, entryId, budgetItemId, budgetNameId, budgetNumId, descriptionId, child, index);
            }
            treeEntryGrid.expand(parentRow);
        }
    }

    public static int findLastChildSeq(IDataModel dataModel, String entryId, int beginSeq) {
        int endSeq = beginSeq;
        boolean currentIsParent = false;
        int count = dataModel.getEntryRowCount(entryId);
        String currentId = dataModel.getEntryRowEntity(entryId, beginSeq).getString(ID);
        String pid = null;
        if (beginSeq == count - 1) {
            currentIsParent = false;
        } else {
            pid = dataModel.getEntryRowEntity(entryId, beginSeq + 1).getString(PID);
            if (StringUtils.equals((CharSequence)currentId, (CharSequence)pid)) {
                currentIsParent = true;
            }
        }
        if (currentIsParent) {
            HashSet<String> parents = new HashSet<String>();
            parents.add(currentId);
            while (endSeq < count - 1) {
                String nextPid;
                if (!parents.contains(nextPid = dataModel.getEntryRowEntity(entryId, ++endSeq).getString(PID))) {
                    --endSeq;
                    break;
                }
                parents.add(dataModel.getEntryRowEntity(entryId, endSeq).getString(ID));
            }
        }
        return endSeq;
    }

    public static String getExcelCellStringValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case BLANK: {
                return null;
            }
            case _NONE: {
                return null;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case ERROR: {
                return null;
            }
            case FORMULA: {
                return null;
            }
            case NUMERIC: {
                String doubleValue = String.valueOf(Double.toString(cell.getNumericCellValue()));
                if (doubleValue.length() > 2 && ".0".equals(doubleValue.substring(doubleValue.length() - 2, doubleValue.length()))) {
                    return doubleValue.substring(0, doubleValue.length() - 2);
                }
                return doubleValue;
            }
            case STRING: {
                return cell.getStringCellValue().trim();
            }
        }
        return null;
    }

    public static DynamicObject getTreeentryentity(Row row, DynamicObject data, String type) {
        DynamicObject object;
        String amount = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(3));
        String budget = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(4));
        String remark = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(5));
        if (StringUtils.equals((CharSequence)"template", (CharSequence)type)) {
            QFilter qFilter;
            DynamicObject[] budgets;
            DynamicObjectCollection test = (DynamicObjectCollection)data.get("treeentryentity");
            object = test.addNew();
            String number = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(0));
            String templateBudget = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(3));
            String templateRemark = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(4));
            if (StringUtils.isNotBlank((CharSequence)number)) {
                object.set(BUDGETITEMNUM, (Object)number);
            }
            if (StringUtils.isNotBlank((CharSequence)templateRemark)) {
                object.set(DESCRIPTIONENTRY, (Object)templateRemark);
            }
            if ((budgets = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)ID, (QFilter[])new QFilter[]{qFilter = new QFilter(NAME, "=", (Object)templateBudget)})) != null && budgets.length > 0) {
                object.set(BUDGETITEM, budgets[0].getPkValue());
            }
        } else if (StringUtils.equals((CharSequence)BUDGET, (CharSequence)type)) {
            QFilter qFilter;
            DynamicObject[] budgets;
            DynamicObjectCollection test = (DynamicObjectCollection)data.get("treeentryentity");
            object = test.addNew();
            if (StringUtils.isNotBlank((CharSequence)amount)) {
                object.set(BUDGETAMOUNT, (Object)amount);
            }
            if (StringUtils.isNotBlank((CharSequence)remark)) {
                object.set(DESCRIPTIONENTRY, (Object)remark);
            }
            if ((budgets = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)ID, (QFilter[])new QFilter[]{qFilter = new QFilter(NAME, "=", (Object)budget)})) != null && budgets.length > 0) {
                object.set(BUDGETITEM, budgets[0].getPkValue());
            }
        } else {
            String number = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(0));
            String sumAmount = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(3));
            amount = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(4));
            budget = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(5));
            remark = BudgetEntryOperateHelper.getExcelCellStringValue(row.getCell(6));
            DynamicObjectCollection test = (DynamicObjectCollection)data.get(type);
            object = test.addNew();
            if (StringUtils.equals((CharSequence)"budgetin", (CharSequence)type)) {
                QFilter qFilter;
                DynamicObject[] budgets;
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    object.set("initemnumber", (Object)number);
                }
                if (StringUtils.isNotBlank((CharSequence)sumAmount)) {
                    object.set("inbudsumamount", (Object)sumAmount);
                }
                if (StringUtils.isNotBlank((CharSequence)amount)) {
                    object.set("bdinamount", (Object)amount);
                }
                if (StringUtils.isNotBlank((CharSequence)remark)) {
                    object.set("indescription", (Object)remark);
                }
                if ((budgets = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)ID, (QFilter[])new QFilter[]{qFilter = new QFilter(NAME, "=", (Object)budget)})) != null && budgets.length > 0) {
                    object.set("initem", budgets[0].getPkValue());
                }
            } else {
                QFilter qFilter;
                DynamicObject[] budgets;
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    object.set("outitemnumber", (Object)number);
                }
                if (StringUtils.isNotBlank((CharSequence)sumAmount)) {
                    object.set("outbudsumamount", (Object)sumAmount);
                }
                if (StringUtils.isNotBlank((CharSequence)amount)) {
                    object.set("bdoutamount", (Object)amount);
                }
                if (StringUtils.isNotBlank((CharSequence)remark)) {
                    object.set("outdescription", (Object)remark);
                }
                if ((budgets = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)ID, (QFilter[])new QFilter[]{qFilter = new QFilter(NAME, "=", (Object)budget)})) != null && budgets.length > 0) {
                    object.set("outitem", budgets[0].getPkValue());
                }
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Integer> getAllChildRowIndex(int[] selectRows, DynamicObjectCollection entryEntity) {
        void var7_10;
        HashSet<Integer> childSet = new HashSet<Integer>();
        HashMap<Object, Set<Integer>> childEntryIndex = new HashMap<Object, Set<Integer>>();
        HashSet<Object> delEntryIds = new HashSet<Object>();
        int[] nArray = selectRows;
        int n = nArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            int i = nArray[var7_10];
            Object entryId = ((DynamicObject)entryEntity.get(i)).getPkValue();
            delEntryIds.add(entryId);
            childSet.add(i);
            ++var7_10;
        }
        int i = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            Object pid = dynamicObject.get(PID);
            if (!childEntryIndex.containsKey(pid)) {
                childEntryIndex.put(pid, new HashSet());
            }
            ((Set)childEntryIndex.get(pid)).add(i);
            ++i;
        }
        for (Object e : delEntryIds) {
            BudgetEntryOperateHelper.addChildRowIndex(e, childSet, childEntryIndex, entryEntity, delEntryIds);
        }
        return childSet;
    }

    public static DynamicObject getBudgetTemplateByKindId(Object sourceType, Object projectKindId) {
        DynamicObject tpl = null;
        DynamicObject[] projectKindSettings = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"id,outbudgettpl,inbudgettpl,ismajortype,enable,budgetcontrolmode,projectcostcontrol,entryentity.id,entryentity.fieldname,entryentity.showname,entryentity.fieldtype,entryentity.ismustinput,entryentity.fieldkey,entryentity.assistgroup,projectkind,projectstageentry.id,projectstageentry.projectstage,budgetstageentry.id,budgetstageentry.budgetstage,outtreeentryentity.id,outtreeentryentity.outbudgetitem,outtreeentryentity.outbudgetname,intreeentryentity.id,intreeentryentity.inbudgetitem,intreeentryentity.inbudgetname,attachtypeentry.id,attachtypeentry.attachtype,attachtypeentry.necessary,filetypeentry.id,filetypeentry.filetype,filetypeentry.mustrecord,filetypeentry.moreuploads", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", projectKindId)}, (String)ID, (int)1);
        if (projectKindSettings != null && projectKindSettings.length > 0) {
            if (BudgetSourceTypeEnum.OUT.getValue().equals(sourceType) || BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType)) {
                tpl = projectKindSettings[0].getDynamicObject("outbudgettpl");
            } else if (BudgetSourceTypeEnum.IN.getValue().equals(sourceType)) {
                tpl = projectKindSettings[0].getDynamicObject("inbudgettpl");
            }
            if (tpl != null) {
                tpl = BusinessDataServiceHelper.loadSingle((Object)tpl.getPkValue(), (String)"pmbs_budgettpl");
            }
        }
        return tpl;
    }

    public static DynamicObject getBrother(DynamicObject currentNode, DynamicObjectCollection collection) {
        DynamicObject brother = null;
        for (int i = currentNode.getInt(SEQ) - 2; i >= 0; --i) {
            if (!StringUtils.equals((CharSequence)currentNode.getString(PID), (CharSequence)((DynamicObject)collection.get(i)).getString(PID))) continue;
            brother = (DynamicObject)collection.get(i);
            break;
        }
        return brother;
    }

    public static Set<Object> getSelectRowParents(IDataModel model, int[] selectRows, String entryId) {
        HashSet<Object> parentIdSet = new HashSet<Object>();
        for (int row : selectRows) {
            String parentId = model.getEntryRowEntity(entryId, row).getString(PID);
            if (parentId == null || "".equals(parentId) || "0".equals(parentId)) continue;
            parentIdSet.add(parentId);
        }
        return parentIdSet.size() == 0 ? null : parentIdSet;
    }

    public static List<String> getHeadByExcel(String url) {
        ArrayList<String> reurnArray = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                Workbook wb = WorkbookFactory.create((InputStream)in);
                Sheet sheet = wb.getSheetAt(0);
                Row columnKeyRow = sheet.getRow(0);
                int columnNum = columnKeyRow.getLastCellNum();
                for (int i = 0; i < columnNum; ++i) {
                    columnKeyRow.getCell(i).setCellType(CellType.STRING);
                    String headkey = columnKeyRow.getCell(i).getStringCellValue();
                    if ("".equals(columnKeyRow.getCell(i).getStringCellValue())) continue;
                    reurnArray.add(headkey);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return reurnArray;
    }

    public static void handleExportData(String budgetNameId, String budgetAmountId, String sumBudgetAmtId, String budgetItemId, String budgetNumberId, String descriptionId, Tree tree, Sheet sheet, String[] title, boolean hasAmountColumn) {
        HashSet<String> addedNodeSet = new HashSet<String>();
        List<TreeNode> treeNodeList = tree.getList();
        int index = 1;
        for (int i = 0; i < treeNodeList.size(); ++i) {
            TreeNode node = treeNodeList.get(i);
            if (addedNodeSet.contains(node.getId())) continue;
            addedNodeSet.add(node.getId());
            BudgetEntryOperateHelper.setExportRowData(budgetNameId, budgetAmountId, sumBudgetAmtId, budgetItemId, budgetNumberId, descriptionId, node, sheet, index, title, hasAmountColumn);
            ++index;
            index = BudgetEntryOperateHelper.setChild(budgetNameId, budgetAmountId, sumBudgetAmtId, budgetItemId, budgetNumberId, descriptionId, node, sheet, index, addedNodeSet, title, hasAmountColumn);
        }
    }

    public static void insertSonEntry(int row, String parentId, HashMap<String, List<DynamicObject>> sonListMap, boolean isTemplate, boolean isAdjust, IFormView formView, String entryId, String budgetNameId, String descriptionId, String budgetItemId) {
        IDataModel dataModel = formView.getModel();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl(entryId);
        List<DynamicObject> list = sonListMap.get(parentId);
        for (DynamicObject dynamicObject : list) {
            int insertEntryRow = dataModel.insertEntryRow(entryId, row);
            dataModel.updateCache();
            if (isTemplate) {
                BudgetEntryOperateHelper.setEntryRowDataByTemplate(dynamicObject, insertEntryRow, dataModel, budgetNameId, descriptionId, budgetItemId);
            } else {
                BudgetEntryOperateHelper.setBudgetEntryRowDataByBuget(dynamicObject, insertEntryRow, dataModel, isAdjust);
            }
            if (sonListMap.get(dynamicObject.getPkValue().toString()) == null) continue;
            BudgetEntryOperateHelper.insertSonEntry(insertEntryRow, dynamicObject.getPkValue().toString(), sonListMap, isTemplate, isAdjust, formView, entryId, budgetNameId, descriptionId, budgetItemId);
        }
        treeEntryGrid.expand(row);
    }

    public static void importBudgetItem(AbstractBillPlugIn formPlugin, String callBackId) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)PMBS_BUDGETITEM, (boolean)true, (int)3, (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, callBackId);
        listShowParameter.setCloseCallBack(closeCallBack);
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)true));
        formPlugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    public static void importExcel(AbstractBillPlugIn plugin, String name, String[] title, String callBackKey) {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(FORMID_IMPORTEXCEL);
        Map params = importExcelFormParameter.getCustomParams();
        params.put(PARAM_SHEETNAME, name);
        params.put(PARAM_TITLE, title);
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackKey));
        plugin.getView().showForm(importExcelFormParameter);
    }

    public static void importTemplate(AbstractBillPlugIn formPlugin, Object sourceType, String callBackId) {
        String formId = BudgetSourceTypeEnum.OUT.getValue().equals(sourceType) || BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType) ? "pmbs_outbudgettpl" : "pmbs_inbudgettpl";
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)false, (int)0);
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, callBackId);
        listShowParameter.setCloseCallBack(closeCallBack);
        formPlugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    public static void insertBudgetItemTree(IFormView formView, String entryId, String budgetItemId, String budgetNameId, String budgetNumId, String descriptionId, Tree budgetItemTree, int row) {
        List<TreeNode> allRootNode = budgetItemTree.getAllRootNode();
        if (allRootNode != null) {
            for (TreeNode rootNode : allRootNode) {
                BudgetEntryOperateHelper.insertRootNode(formView, entryId, budgetItemId, budgetNameId, budgetNumId, descriptionId, rootNode, row);
            }
        }
    }

    public static int insertTreeData(IDataModel dataModel, String entryId, String budgetItemId, String budgetNameId, String amountId, String sumAmountId, String budgetNumberId, String descrptionId, List<DynamicObject> treeData, DynamicObject parent, boolean insert) {
        int insertIndex = parent != null ? parent.getInt(SEQ) - 1 : 0;
        Iterator<DynamicObject> iterator = treeData.iterator();
        DynamicObject root = iterator.next();
        String parentId = root.getString(ID);
        iterator.remove();
        insertIndex = insert ? dataModel.insertEntryRow(entryId, insertIndex) : dataModel.appendEntryRow(entryId, insertIndex, 1)[0];
        dataModel.updateCache();
        dataModel.setValue(budgetNameId, root.get(budgetNameId), insertIndex);
        dataModel.setValue(budgetItemId, root.get(budgetItemId), insertIndex);
        dataModel.setValue(descrptionId, root.get(descrptionId), insertIndex);
        dataModel.setValue(budgetNumberId, root.get(budgetNumberId), insertIndex);
        if (amountId != null) {
            dataModel.setValue(amountId, root.get(amountId), insertIndex);
        }
        if (sumAmountId != null) {
            dataModel.setValue(sumAmountId, root.get(sumAmountId), insertIndex);
        }
        int fixIndex = insertIndex;
        for (int i = 0; i < treeData.size(); ++i) {
            DynamicObject cur = treeData.get(i);
            String pid = cur.getString(PID);
            if (!StringUtils.equals((CharSequence)pid, (CharSequence)parentId)) continue;
            insertIndex = dataModel.insertEntryRow(entryId, fixIndex);
            dataModel.updateCache();
            dataModel.setValue(budgetNameId, cur.get(budgetNameId), insertIndex);
            dataModel.setValue(budgetItemId, cur.get(budgetItemId), insertIndex);
            dataModel.setValue(descrptionId, root.get(descrptionId), insertIndex);
            dataModel.setValue(budgetNumberId, root.get(budgetNumberId), insertIndex);
            if (amountId != null) {
                dataModel.setValue(amountId, root.get(amountId), insertIndex);
            }
            if (sumAmountId != null) {
                dataModel.setValue(sumAmountId, root.get(sumAmountId), insertIndex);
            }
            BudgetEntryOperateHelper.createSubTree(dataModel, entryId, budgetItemId, budgetNameId, amountId, sumAmountId, budgetNumberId, descrptionId, treeData, insertIndex, cur, i);
        }
        return fixIndex;
    }

    public static void insertRootNode(IFormView formView, String entryId, String budgetItemId, String budgetNameId, String budgetNumId, String descriptionId, TreeNode rootNode, int row) {
        String parentId;
        IDataModel dataModel = formView.getModel();
        int index = BudgetEntryOperateHelper.findSameNameBrotherIndex(dataModel, entryId, budgetNameId, parentId = dataModel.getEntryRowEntity(entryId, row).getPkValue().toString(), rootNode.getName());
        if (index == -1) {
            index = dataModel.insertEntryRow(entryId, row);
        }
        dataModel.updateCache();
        dataModel.setValue(budgetItemId, (Object)rootNode.getId(), index);
        dataModel.setValue(budgetNameId, (Object)rootNode.getName(), index);
        dataModel.setValue(budgetNumId, (Object)rootNode.getData().getString(NUMBER), index);
        dataModel.setValue(descriptionId, (Object)rootNode.getData().getString(DESCRIPTION), index);
        BudgetEntryOperateHelper.fillChildNodes(formView, entryId, budgetItemId, budgetNameId, budgetNumId, descriptionId, rootNode, index);
    }

    public static boolean isAllowMoveDown(IDataModel dataModel, int[] selectRows, String entryId) {
        boolean bAllowMove = true;
        int maxRow = Integer.MIN_VALUE;
        for (int i : selectRows) {
            if (maxRow >= i) continue;
            maxRow = i;
        }
        int rowCount = dataModel.getEntryRowCount(entryId);
        if (maxRow >= rowCount - 1) {
            bAllowMove = false;
        } else {
            bAllowMove = false;
            Object pid = dataModel.getEntryRowEntity(entryId, maxRow).get(PID);
            int j = 1;
            while (dataModel.getEntryRowEntity(entryId, maxRow + j) != null) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, maxRow + j).get(PID))) {
                    bAllowMove = true;
                    break;
                }
                ++j;
            }
            for (int i : selectRows) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, i).get(PID))) continue;
                bAllowMove = false;
            }
        }
        return bAllowMove;
    }

    public static boolean isAllowMoveUp(IDataModel dataModel, int[] selectRows, String entryId) {
        boolean bAllowMove = true;
        int minRow = Integer.MAX_VALUE;
        for (int i : selectRows) {
            if (minRow <= i) continue;
            minRow = i;
        }
        if (minRow <= 0) {
            bAllowMove = false;
        } else {
            Object pid = dataModel.getEntryRowEntity(entryId, minRow).get(PID);
            for (int i : selectRows) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, i).get(PID))) continue;
                bAllowMove = false;
            }
            if (pid != null && !pid.toString().equals("0") && pid.equals(dataModel.getEntryRowEntity(entryId, minRow - 1).getPkValue())) {
                bAllowMove = false;
            }
        }
        return bAllowMove;
    }

    public static boolean isBudgetNumberRepeat(Object sourceType, Object number, Object id) {
        ORM orm = ORM.create();
        QFilter numberFilter = new QFilter("sourcetype", "=", sourceType);
        numberFilter.and(new QFilter("billno", "=", number));
        numberFilter.and(new QFilter(ID, "!=", id));
        boolean isNumberExist = orm.exists("pmas_budget", new QFilter[]{numberFilter});
        return isNumberExist;
    }

    public static void resetParentAmountValue(IDataModel model, Set<Object> parentIdSet, String entryId, String amountId) {
        if (parentIdSet != null) {
            int entryRowCount = model.getEntryRowCount(entryId);
            for (int i = 0; i < entryRowCount; ++i) {
                if (!parentIdSet.contains(model.getEntryRowEntity(entryId, i).getPkValue().toString())) continue;
                model.setValue(amountId, (Object)BigDecimal.ZERO, i);
            }
        }
    }

    public static void setBudgetEntryRowDataByBuget(DynamicObject entity, int row, IDataModel dataModel, boolean isAdjust) {
        DynamicObject projectBudgetItem;
        dataModel.setValue("budgetitemname", entity.get("budgetitemname"), row);
        dataModel.setValue(DESCRIPTIONENTRY, entity.get(DESCRIPTIONENTRY), row);
        if (isAdjust) {
            BigDecimal prevamount = (BigDecimal)entity.get(BUDGETAMOUNT);
            dataModel.setValue("viamount", entity.get(BUDGETAMOUNT), row);
            dataModel.setValue("isprev", (Object)Boolean.TRUE, row);
            dataModel.setValue(BUDGETAMOUNT, (Object)prevamount, row);
            BigDecimal siamount = (BigDecimal)entity.get("siamount");
            if (BigDecimal.ZERO.compareTo(siamount) != 0) {
                dataModel.setValue("siamount", entity.get("siamount"), row);
                dataModel.setValue("ispres", (Object)entity.getBoolean("ispres"), row);
                dataModel.setValue("ispres", (Object)Boolean.TRUE, row);
            }
        } else {
            dataModel.setValue("siamount", entity.get(BUDGETAMOUNT), row);
            dataModel.setValue("ispres", (Object)Boolean.TRUE, row);
            dataModel.setValue(BUDGETAMOUNT, entity.get(BUDGETAMOUNT), row);
        }
        DynamicObject budgetItem = entity.getDynamicObject(BUDGETITEM);
        if (budgetItem != null) {
            dataModel.setValue(BUDGETITEM, (Object)budgetItem, row);
        }
        if ((projectBudgetItem = entity.getDynamicObject("projectbudgetitem")) != null) {
            dataModel.setValue("projectbudgetitem", (Object)projectBudgetItem, row);
        }
    }

    public static void setEntryRowDataByTemplate(DynamicObject entity, int row, IDataModel dataModel, String budgetNameId, String descriptionId, String budgetItemId) {
        dataModel.setValue(budgetNameId, entity.get("budgetitemname"), row);
        dataModel.setValue(descriptionId, entity.get(DESCRIPTIONENTRY), row);
        DynamicObject budgetItem = entity.getDynamicObject(BUDGETITEM);
        if (budgetItem != null) {
            dataModel.setValue(budgetItemId, (Object)budgetItem, row);
        }
    }

    public static int setChild(String budgetNameId, String budgetAmountId, String sumBudgetAmtId, String budgetItemId, String budgetNumberId, String descriptionId, TreeNode node, Sheet sheet, int index, Set<String> set, String[] title, boolean hasAmountColumn) {
        List<TreeNode> childs = node.getChild();
        if (childs != null) {
            for (TreeNode child : childs) {
                if (set.contains(child.getId())) continue;
                set.add(child.getId());
                BudgetEntryOperateHelper.setExportRowData(budgetNameId, budgetAmountId, sumBudgetAmtId, budgetItemId, budgetNumberId, descriptionId, child, sheet, index, title, hasAmountColumn);
                ++index;
                index = BudgetEntryOperateHelper.setChild(budgetNameId, budgetAmountId, sumBudgetAmtId, budgetItemId, budgetNumberId, descriptionId, child, sheet, index, set, title, hasAmountColumn);
            }
        }
        return index;
    }

    public static void setExportRowData(String budgetNameId, String budgetAmountId, String sumBudgetAmtId, String budgetItemId, String budgetNumberId, String descriptionId, TreeNode node, Sheet sheet, int index, String[] title, boolean hasAmountColumn) {
        String[] rowData = new String[title.length];
        Row cur = sheet.createRow(index);
        StringBuilder blank = new StringBuilder();
        int level = node.getLevel();
        while (--level > 0) {
            blank.append("    ");
        }
        int count = 0;
        DynamicObject nodeData = node.getData();
        rowData[count++] = blank + nodeData.getString(budgetNumberId);
        rowData[count++] = blank + nodeData.getString(budgetNameId);
        rowData[count++] = String.valueOf(node.getParent() == null ? "" : node.getParent().getName());
        if (hasAmountColumn) {
            if (StringUtils.isNotBlank((CharSequence)sumBudgetAmtId)) {
                rowData[count++] = String.valueOf(nodeData.getBigDecimal(sumBudgetAmtId).longValue() == 0L ? "" : nodeData.getBigDecimal(sumBudgetAmtId).toString());
            }
            rowData[count++] = String.valueOf(nodeData.getBigDecimal(budgetAmountId).longValue() == 0L ? "" : nodeData.getBigDecimal(budgetAmountId).toString());
        }
        rowData[count++] = String.valueOf(nodeData.getDynamicObject(budgetItemId) == null ? "" : nodeData.getDynamicObject(budgetItemId).getString(NAME));
        rowData[count++] = String.valueOf(nodeData.getString(descriptionId) == null ? "" : nodeData.getString(descriptionId));
        DataFormat format = sheet.getWorkbook().createDataFormat();
        for (int j = 0; j < title.length; ++j) {
            Cell cell = cur.createCell(j);
            cell.getCellStyle().setDataFormat(format.getFormat("TEXT"));
            cell.setCellValue(rowData[j]);
        }
    }

    public static void setAmountColumnEnable(String treeEntryId, String amountColumnId, IFormView formView) {
        HashSet<String> parentIdSet = new HashSet<String>();
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(treeEntryId);
        for (DynamicObject entry : entryEntity) {
            String parentId = entry.getString(PID);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)parentId)) continue;
            parentIdSet.add(parentId);
        }
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            if (parentIdSet.contains(((DynamicObject)entryEntity.get(i)).getPkValue().toString())) {
                formView.setEnable(Boolean.FALSE, i, new String[]{amountColumnId});
                continue;
            }
            formView.setEnable(Boolean.TRUE, i, new String[]{amountColumnId});
        }
    }

    public static BigDecimal setAmountColumnValue(IFormView formView, String entryId, String amountId) {
        HashSet<String> parentIdSet = new HashSet<String>();
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(entryId);
        for (DynamicObject entry : entryEntity) {
            String parentId = entry.getString(PID);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)parentId)) continue;
            parentIdSet.add(parentId);
        }
        HashMap<String, BigDecimal> rowAmountMap = new HashMap<String, BigDecimal>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        int size = entryEntity.size();
        for (int i = size - 1; i >= 0; --i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String id = entry.getPkValue().toString();
            String parentId = entry.getString(PID);
            BigDecimal amount = entry.getBigDecimal(amountId);
            BigDecimal amountValue = (BigDecimal)rowAmountMap.get(id);
            boolean isLeaf = false;
            if (parentIdSet.contains(id)) {
                BigDecimal siAmount;
                BigDecimal viAmount;
                formView.getModel().beginInit();
                if (amountValue != null && amountValue.compareTo(BigDecimal.ZERO) != 0) {
                    if (StringUtils.equals((CharSequence)"vichangeamount", (CharSequence)amountId)) {
                        BigDecimal budgetAmount = entry.getBigDecimal(BUDGETAMOUNT);
                        viAmount = entry.getBigDecimal("viamount");
                        amountValue = budgetAmount.subtract(viAmount);
                        formView.getModel().setValue(amountId, (Object)amountValue, i);
                    } else if (StringUtils.equals((CharSequence)"sichangeamount", (CharSequence)amountId)) {
                        BigDecimal budgetAmount = entry.getBigDecimal(BUDGETAMOUNT);
                        siAmount = entry.getBigDecimal("siamount");
                        amountValue = budgetAmount.subtract(siAmount);
                        formView.getModel().setValue(amountId, (Object)amountValue, i);
                    } else if (StringUtils.equals((CharSequence)"itemtotalamount", (CharSequence)amountId)) {
                        boolean isTotal = entry.getBoolean("istotal");
                        if (!isTotal) {
                            formView.getModel().setValue(amountId, (Object)amountValue, i);
                        }
                    } else {
                        formView.getModel().setValue(amountId, (Object)amountValue, i);
                    }
                } else if (StringUtils.equals((CharSequence)"vichangeamount", (CharSequence)amountId)) {
                    BigDecimal budgetAmount = entry.getBigDecimal(BUDGETAMOUNT);
                    viAmount = entry.getBigDecimal("viamount");
                    amountValue = budgetAmount.subtract(viAmount);
                    formView.getModel().setValue(amountId, (Object)amountValue, i);
                } else if (StringUtils.equals((CharSequence)"sichangeamount", (CharSequence)amountId)) {
                    BigDecimal budgetAmount = entry.getBigDecimal(BUDGETAMOUNT);
                    siAmount = entry.getBigDecimal("siamount");
                    amountValue = budgetAmount.subtract(siAmount);
                    formView.getModel().setValue(amountId, (Object)amountValue, i);
                } else if (StringUtils.equals((CharSequence)"itemtotalamount", (CharSequence)amountId)) {
                    boolean isTotal = entry.getBoolean("istotal");
                    if (!isTotal) {
                        formView.getModel().setValue(amountId, (Object)BigDecimal.ZERO, i);
                        amountValue = BigDecimal.ZERO;
                    }
                } else {
                    amountValue = amount;
                }
                amount = amountValue;
                formView.getModel().endInit();
                formView.setEnable(Boolean.FALSE, i, new String[]{amountId});
                formView.updateView(amountId, i);
            } else {
                isLeaf = true;
                formView.setEnable(Boolean.TRUE, i, new String[]{amountId});
            }
            if (parentId == null || StringUtils.equals((CharSequence)"0", (CharSequence)parentId)) {
                if (isLeaf) {
                    totalAmount = totalAmount.add(amount);
                    continue;
                }
                amountValue = amountValue == null ? BigDecimal.ZERO : amountValue;
                totalAmount = totalAmount.add(amountValue);
                continue;
            }
            if (rowAmountMap.get(parentId) == null) {
                rowAmountMap.put(parentId, amount);
                continue;
            }
            if (amount == null) {
                amount = BigDecimal.ZERO;
            }
            BigDecimal addValue = amount.add((BigDecimal)rowAmountMap.get(parentId));
            rowAmountMap.put(parentId, addValue);
        }
        formView.getModel().updateCache();
        return totalAmount;
    }

    public static void setTotalAmount(BigDecimal totalAmount, IFormView formView, String totalAmountId) {
        if (totalAmount == null || BigDecimal.ZERO.compareTo(totalAmount) == 0) {
            formView.getModel().setValue(totalAmountId, (Object)BigDecimal.ZERO);
        } else {
            formView.getModel().setValue(totalAmountId, (Object)totalAmount);
        }
        formView.updateView(totalAmountId);
    }

    public static void setTotalAmountEnable(IFormView formView, String entryId, String totalAmountId) {
        int entryRowCount = formView.getModel().getEntryRowCount(entryId);
        if (entryRowCount > 0) {
            formView.setEnable(Boolean.FALSE, new String[]{totalAmountId});
        } else {
            formView.setEnable(Boolean.TRUE, new String[]{totalAmountId});
        }
    }

    public static void upgrade(IFormView formView, String entryId, String budgetItemId, String budgetNameId, String amountId, String totalAmountId, String budgetNumberId, String descriptionId, boolean hasAmountColumn) {
        int i;
        String currentRowName;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl(entryId);
        int[] index = treeEntryGrid.getSelectRows();
        if (index.length != 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BudgetEntryOperateHelper_20", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return;
        }
        int selectIndex = formView.getModel().getEntryCurrentRowIndex(entryId);
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(entryId);
        DynamicObject selectRow = (DynamicObject)entryEntity.get(selectIndex);
        long pid = selectRow.getLong(PID);
        if (pid == 0L) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"BudgetEntryOperateHelper_21", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return;
        }
        long upgradePid = 0L;
        for (Object entity : entryEntity) {
            if (!StringUtils.equals((CharSequence)entity.getString(ID), (CharSequence)String.valueOf(pid))) continue;
            upgradePid = entity.getLong(PID);
            break;
        }
        if (StringUtils.isNotEmpty((CharSequence)(currentRowName = selectRow.getString(budgetNameId)))) {
            for (DynamicObject entity : entryEntity) {
                if (!StringUtils.equals((CharSequence)entity.getString(PID), (CharSequence)String.valueOf(upgradePid)) || !StringUtils.equals((CharSequence)entity.getString(budgetNameId), (CharSequence)currentRowName)) continue;
                formView.showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u540e\uff0c\u540c\u7ea7\u522b\u5185\u9884\u7b97\u9879\u540d\u79f0\u5c06\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"BudgetEntryOperateHelper_15", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                return;
            }
        }
        int lastChildSeq = BudgetEntryOperateHelper.findLastChildSeq(formView.getModel(), entryId, selectIndex);
        ArrayList<DynamicObject> treeDataList = new ArrayList<DynamicObject>(10);
        for (i = selectIndex; i <= lastChildSeq; ++i) {
            treeDataList.add(formView.getModel().getEntryRowEntity(entryId, i));
        }
        for (i = lastChildSeq; i >= selectIndex; --i) {
            formView.getModel().deleteEntryRow(entryId, i);
            formView.getModel().updateCache();
        }
        int count = formView.getModel().getEntryRowCount(entryId);
        entryEntity = formView.getModel().getEntryEntity(entryId);
        DynamicObject parent = null;
        String entityId = formView.getEntityId();
        String sumAmountId = null;
        String proTotalAmtId = null;
        if ("pmas_pro_approval".equals(entityId)) {
            proTotalAmtId = "budgetout".equals(entryId) ? "prooutbudgetsumamt" : "proinbudgetsumamt";
            sumAmountId = "budgetout".equals(entryId) ? "outbudsumamount" : "inbudsumamount";
        }
        for (int i2 = 0; i2 < count; ++i2) {
            if (!StringUtils.equals((CharSequence)((DynamicObject)entryEntity.get(i2)).getString(ID), (CharSequence)String.valueOf(pid))) continue;
            parent = (DynamicObject)entryEntity.get(i2);
            if (!hasAmountColumn) break;
            formView.getModel().setValue(amountId, (Object)BigDecimal.ZERO, i2);
            if (!"pmas_pro_approval".equals(entityId)) break;
            formView.getModel().setValue(sumAmountId, (Object)BigDecimal.ZERO, i2);
            break;
        }
        if (parent == null) {
            return;
        }
        if (lastChildSeq == selectIndex) {
            parent.set("isGroupNode", null);
        }
        int focusIndex = BudgetEntryOperateHelper.insertTreeData(formView.getModel(), entryId, budgetItemId, budgetNameId, amountId, sumAmountId, budgetNumberId, descriptionId, treeDataList, parent, false);
        treeEntryGrid.focus(parent.getInt(SEQ) - 1, focusIndex);
        treeEntryGrid.selectRows(focusIndex);
        formView.getModel().setEntryCurrentRowIndex(entryId, focusIndex);
        formView.getModel().updateCache();
        formView.updateView(entryId);
        if (hasAmountColumn) {
            BudgetEntryOperateHelper.setAmountColumnEnable(entryId, amountId, formView);
            BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue(formView, entryId, amountId);
            BudgetEntryOperateHelper.setTotalAmount(totalAmount, formView, totalAmountId);
            if ("pmas_pro_approval".equals(entityId)) {
                BudgetEntryOperateHelper.setAmountColumnEnable(entryId, sumAmountId, formView);
                BigDecimal proTotalAmount = BudgetEntryOperateHelper.setAmountColumnValue(formView, entryId, sumAmountId);
                BudgetEntryOperateHelper.setTotalAmount(proTotalAmount, formView, proTotalAmtId);
            }
        }
    }
}

