/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CheckBudgetBalanceHelper {
    private static final List<String> statusList = Stream.of("B", "C").collect(Collectors.toList());
    private static final QFilter statusFilter = new QFilter("billstatus", "in", statusList);
    private static final List<String> contStatusList = Stream.of("03", "04").collect(Collectors.toList());
    private static final QFilter contStatusFilter = new QFilter("contstatus", "not in", contStatusList);

    public static BigDecimal getBudgetBalanceAmount(DynamicObject projectBudget) {
        BigDecimal budgetAmount = projectBudget.getBigDecimal("budgetamount");
        budgetAmount = budgetAmount == null ? BigDecimal.ZERO : budgetAmount;
        return budgetAmount.subtract(CheckBudgetBalanceHelper.getBudgetUsedAmount(projectBudget));
    }

    public static BigDecimal getBudgetUsedAmount(DynamicObject projectBudget) {
        DynamicObject[] outRevisionArr;
        DynamicObject[] outContractArr;
        DynamicObject[] outFinalSettleArr;
        BigDecimal usedAmount = BigDecimal.ZERO;
        if (projectBudget == null) {
            return usedAmount;
        }
        QFilter budgetFilter = new QFilter("budgetitem", "=", projectBudget.getPkValue());
        QFilter contractBudgetFilter = new QFilter("contract.budgetitem", "=", projectBudget.getPkValue());
        for (DynamicObject outFinalSettle : outFinalSettleArr = BusinessDataServiceHelper.load((String)"pmct_outfinalsettle", (String)"id,contract,apptaxamount", (QFilter[])new QFilter[]{statusFilter, contractBudgetFilter})) {
            BigDecimal ofTaxAmount = outFinalSettle.getBigDecimal("apptaxamount");
            usedAmount = usedAmount.add(ofTaxAmount);
        }
        for (DynamicObject outContract : outContractArr = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"id,originaloftaxamount", (QFilter[])new QFilter[]{statusFilter, budgetFilter, contStatusFilter})) {
            BigDecimal ofTaxAmount = outContract.getBigDecimal("originaloftaxamount");
            usedAmount = usedAmount.add(ofTaxAmount);
        }
        QFilter contractStatusFilter = new QFilter("contract.contstatus", "not in", contStatusList);
        for (DynamicObject outRevision : outRevisionArr = BusinessDataServiceHelper.load((String)"pmct_outcontractrevision", (String)"id,revisionoftaxamount", (QFilter[])new QFilter[]{statusFilter, contractBudgetFilter, contractStatusFilter})) {
            BigDecimal ofTaxAmount = outRevision.getBigDecimal("revisionoftaxamount");
            usedAmount = usedAmount.add(ofTaxAmount);
        }
        return usedAmount.add(CheckBudgetBalanceHelper.getProjectSpiltBudgetAmount(projectBudget));
    }

    public static BigDecimal getProjectSpiltBudgetAmount(DynamicObject projectBudget) {
        BigDecimal proSpiltAmount = BigDecimal.ZERO;
        QFilter entryBudgetFilter = new QFilter("procostsplitentry.budgetitem", "=", projectBudget.getPkValue());
        DynamicObject[] costBills = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"id,procostsplitentry,procostsplitentry.budgetitem,procostsplitentry.costamt", (QFilter[])new QFilter[]{entryBudgetFilter, statusFilter});
        if (costBills != null && costBills.length > 0) {
            for (DynamicObject bill : costBills) {
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("procostsplitentry");
                if (entries == null || entries.size() <= 0) continue;
                for (DynamicObject entry : entries) {
                    DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                    if (projectBudget.getLong("id") != budgetItem.getLong("id")) continue;
                    proSpiltAmount = proSpiltAmount.add(entry.getBigDecimal("costamt"));
                }
            }
        }
        return proSpiltAmount;
    }
}

