/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;

public class CurrencyFormatUtil {
    public static String getAfterFormatString(DynamicObject currency, Object value) {
        return FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(CurrencyFormatUtil.getFormatObject(currency)).format(value);
    }

    private static FormatObject getFormatObject(DynamicObject currency) {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map fmt = inteService.getUserFormat(Long.valueOf(RequestContext.get().getUserId()));
        return CurrencyFormatUtil.getFormat(fmt, currency);
    }

    private static FormatObject getFormat(Map<String, Object> userFormat, DynamicObject currency) {
        String fmt;
        FormatObject result = new FormatObject();
        Map numberFormat = (Map)userFormat.get("numberFormat");
        Map timeFormat = (Map)userFormat.get("timeFormat");
        Map currencyFormat = (Map)userFormat.get("currencyFormat");
        if (!numberFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)numberFormat);
            result.setNumberFormat((NumberFormatObject)SerializationUtils.fromJsonString((String)fmt, NumberFormatObject.class));
        }
        if (!timeFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)timeFormat);
            result.setTimeFormat((TimeFormatObject)SerializationUtils.fromJsonString((String)fmt, TimeFormatObject.class));
        }
        if (!currencyFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)currencyFormat);
            result.setCurrencyFormat((CurrencyFormatObject)SerializationUtils.fromJsonString((String)fmt, CurrencyFormatObject.class));
        }
        if (currency != null) {
            String currencySymbol = currency.getString("sign");
            int minimumFractionDigits = currency.getInt("amtprecision");
            result.getCurrencyFormat().setCurrencySymbols(currencySymbol);
            result.getCurrencyFormat().setMinimumFractionDigits(minimumFractionDigits);
        }
        result.setDateFormat(new DateFormatObject(userFormat.get("dateFormat").toString()));
        return result;
    }
}

