/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class CurrencyHelper {
    private static final Log log = LogFactory.getLog(CurrencyHelper.class);
    private static String CURRENCY_DT = "bd_currency";
    private static String EXRATETABLE_DT = "bd_exratetable";
    private static String BASECURRRENCY = "baseCurrencyID";
    private static String EXRATETABLE = "exchangeRateTableID";

    public static DynamicObject getCurrency(Long orgId) {
        Map<String, Long> map;
        if (orgId != 0L && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null && !map.isEmpty()) {
            try {
                return BusinessDataServiceHelper.loadSingle((Object)map.get(BASECURRRENCY), (String)CURRENCY_DT);
            }
            catch (Exception e) {
                log.info(String.format("\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01,\u5bfc\u81f4\u67e5\u8be2\u672c\u4f4d\u5e01\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", orgId));
            }
        }
        return null;
    }

    public static DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null && !map.isEmpty()) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(EXRATETABLE), (String)EXRATETABLE_DT);
        }
        return null;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && !mapOrg.isEmpty() && mapOrg.get("id") != null) {
            log.info("Get the organization's accounting entity list through the interface:" + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && !map.isEmpty()) {
                log.info("Obtain the functional currency and exchange rate table of the accounting entity through the interface:" + map);
                return map;
            }
        }
        return null;
    }

    public static Map<String, Object> getAccountOrg(Long orgId) {
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null) {
            return mapOrg;
        }
        return null;
    }

    public static BigDecimal getExChangeRate(Long srcCurId, Long targCurId, Long exRateTableId, Date date) {
        BigDecimal exChangeRate = srcCurId.equals(targCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targCurId, (Date)date);
        return exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exChangeRate;
    }

    public static BigDecimal getExchangeRateByContract(DynamicObject contract, DynamicObject desCurrency, DynamicObject table) {
        DynamicObject contractCurrency;
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (desCurrency != null && (contractCurrency = contract.getDynamicObject("currency")) != null && desCurrency.getLong("id") != contractCurrency.getLong("id")) {
            DynamicObject contractStdCurrency = contract.getDynamicObject("stdcurrency");
            if (contractStdCurrency != null && contractStdCurrency.getLong("id") == desCurrency.getLong("id")) {
                exchangeRate = contract.getBigDecimal("exchangerate");
            } else {
                Long exTableId = table == null ? 0L : table.getLong("id");
                exchangeRate = CurrencyHelper.getExChangeRate(contractCurrency.getLong("id"), desCurrency.getLong("id"), exTableId, new Date());
            }
        }
        if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        return exchangeRate;
    }

    public static int getAmountAccuracy(DynamicObject currency) {
        if (currency != null) {
            return currency.getInt("amtprecision");
        }
        return 4;
    }

    public static int getPriceAccuracy(DynamicObject currency) {
        if (currency != null) {
            return currency.getInt("priceprecision");
        }
        return 4;
    }
}

