/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public class EcArrayUtil {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];

    public static boolean isAllNull(Object[] objectArr) {
        boolean flag = true;
        if (null != objectArr) {
            int length = objectArr.length;
            for (int i = 0; i < length; ++i) {
                if (null == objectArr[i]) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    public static boolean isSomeNull(Object[] objectArr) {
        boolean flag = false;
        if (null != objectArr) {
            int length = objectArr.length;
            for (int i = 0; i < length; ++i) {
                if (null != objectArr[i]) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static Object[] add(Object[] objectArr, Object object) {
        Object[] newObjectArr = null;
        int length = objectArr.length;
        newObjectArr = new Object[length + 1];
        System.arraycopy(objectArr, 0, newObjectArr, 0, length);
        newObjectArr[length] = object;
        return newObjectArr;
    }

    public static Object[] add(Object[] objectArr, Object object, Object[] castArr) {
        Object[] newObjectArr = null;
        int length = objectArr.length;
        newObjectArr = new Object[length + 1];
        System.arraycopy(objectArr, 0, newObjectArr, 0, length);
        newObjectArr[length] = object;
        List<Object> list = Arrays.asList(newObjectArr);
        castArr = list.toArray(castArr);
        return castArr;
    }

    public static Object[] addAll(Object[] objectArr1, Object[] objectArr2) {
        Object[] newObjectArr = null;
        int length1 = objectArr1.length;
        int length2 = objectArr2.length;
        newObjectArr = new Object[length1 + length2];
        System.arraycopy(objectArr1, 0, newObjectArr, 0, length1);
        System.arraycopy(objectArr2, 0, newObjectArr, length1, length2);
        return newObjectArr;
    }

    public static Object[] addAll(Object[] objectArr1, Object[] objectArr2, Object[] castArr) {
        Object[] newObjectArr = null;
        int length1 = objectArr1.length;
        int length2 = objectArr2.length;
        newObjectArr = new Object[length1 + length2];
        System.arraycopy(objectArr1, 0, newObjectArr, 0, length1);
        System.arraycopy(objectArr2, 0, newObjectArr, length1, length2);
        List<Object> list = Arrays.asList(newObjectArr);
        castArr = list.toArray(castArr);
        return castArr;
    }

    public static void debugPrint(PrintStream pr, Object[] arr) {
        if (null != arr) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
            pr.println(list);
        }
    }

    public static Object[] cast(Object[] origArr, Object[] destArr) {
        Object[] arrRs = null;
        if (null != origArr) {
            Class<?> destCmpType;
            Class<?> origCmpType = origArr.getClass().getComponentType();
            if (origCmpType.equals(destCmpType = destArr.getClass().getComponentType())) {
                arrRs = origArr;
            } else {
                List<Object> list = Arrays.asList(origArr);
                arrRs = list.toArray(destArr);
            }
        }
        return arrRs;
    }

    public static Object[] cast(Object[] origArr, Class destArrCmpType) {
        Object[] destArr = (Object[])Array.newInstance(destArrCmpType, 0);
        destArr = EcArrayUtil.cast(origArr, destArr);
        return destArr;
    }

    public static Class[] toClassArr(Object[] origArr) {
        Object[] destArr = EMPTY_CLASS_ARRAY;
        destArr = (Class[])EcArrayUtil.cast(origArr, destArr);
        return destArr;
    }

    public static String[] toStringArr(Object[] origArr) {
        Object[] destArr = EMPTY_STRING_ARRAY;
        destArr = (String[])EcArrayUtil.cast(origArr, destArr);
        return destArr;
    }

    public static Long[] toLongArr(Object[] origArr) {
        Object[] castArr = EMPTY_LONG_OBJECT_ARRAY;
        castArr = (Long[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static Integer[] toIntegerArr(Object[] origArr) {
        Object[] castArr = EMPTY_INTEGER_OBJECT_ARRAY;
        castArr = (Integer[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static Short[] toShortArr(Object[] origArr) {
        Object[] castArr = EMPTY_SHORT_OBJECT_ARRAY;
        castArr = (Short[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static Byte[] toByteArr(Object[] origArr) {
        Object[] castArr = EMPTY_BYTE_OBJECT_ARRAY;
        castArr = (Byte[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static Double[] toDoubleArr(Object[] origArr) {
        Object[] castArr = EMPTY_DOUBLE_OBJECT_ARRAY;
        castArr = (Double[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static Float[] toFloatArr(Object[] origArr) {
        Object[] castArr = EMPTY_FLOAT_OBJECT_ARRAY;
        castArr = (Float[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static Boolean[] toBooleanArr(Object[] origArr) {
        Object[] castArr = EMPTY_BOOLEAN_OBJECT_ARRAY;
        castArr = (Boolean[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static Character[] toCharacterArr(Object[] origArr) {
        Object[] castArr = EMPTY_CHARACTER_OBJECT_ARRAY;
        castArr = (Character[])EcArrayUtil.cast(origArr, castArr);
        return castArr;
    }

    public static String toString(Object[] array) {
        String stringResonse = null;
        if (null == array) {
            stringResonse = "null";
        } else if (0 == array.length) {
            stringResonse = "[]";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String joinFrag = ", ";
            stringBuilder.append('[');
            Object object2 = null;
            for (Object object2 : array) {
                stringBuilder.append(object2).append(joinFrag);
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            stringBuilder.append(']');
            stringResonse = stringBuilder.toString();
        }
        return stringResonse;
    }

    public static String toString(Object[] array, String leftFrag, String rightFrag, String joinFrag) {
        String stringResonse = null;
        leftFrag = null == leftFrag ? "null" : leftFrag;
        rightFrag = null == rightFrag ? "null" : rightFrag;
        String string = joinFrag = null == joinFrag ? "null" : joinFrag;
        if (null == array) {
            stringResonse = "null";
        } else if (0 == array.length) {
            stringResonse = leftFrag + rightFrag;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(leftFrag);
            Object object2 = null;
            for (Object object2 : array) {
                stringBuilder.append(object2).append(joinFrag);
            }
            stringBuilder.delete(stringBuilder.length() - joinFrag.length(), stringBuilder.length());
            stringBuilder.append(rightFrag);
            stringResonse = stringBuilder.toString();
        }
        return stringResonse;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return EcArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object objectToFind) {
        return EcArrayUtil.lastIndexOf(array, objectToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i >= 0; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i >= 0; --i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return EcArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static int indexOf(long[] array, long valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long valueToFind) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(long[] array, long valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(int[] array, int valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int valueToFind) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] array, int valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(short[] array, short valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short valueToFind) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(short[] array, short valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(char[] array, char valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char valueToFind) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(char[] array, char valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(byte[] array, byte valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte valueToFind) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(double[] array, double valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind, 0.0);
    }

    public static int indexOf(double[] array, double valueToFind, double tolerance) {
        return EcArrayUtil.indexOf(array, valueToFind, 0, tolerance);
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (EcArrayUtil.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, 2.147483647E9);
    }

    public static int lastIndexOf(double[] array, double valueToFind, double tolerance) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (EcArrayUtil.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(double[] array, double valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind) != -1;
    }

    public static boolean contains(double[] array, double valueToFind, double tolerance) {
        return EcArrayUtil.indexOf(array, valueToFind, 0, tolerance) != -1;
    }

    public static int indexOf(boolean[] array, boolean valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (EcArrayUtil.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind) {
        return EcArrayUtil.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (EcArrayUtil.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean valueToFind) {
        return EcArrayUtil.indexOf(array, valueToFind) != -1;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] objectArr) {
        return !EcArrayUtil.isEmpty(objectArr);
    }

    public static int indexOf(String[] array, String stringToFind, boolean isEqualsIgnoreCase) {
        return EcArrayUtil.indexOf(array, stringToFind, 0, isEqualsIgnoreCase);
    }

    public static int indexOf(String[] array, String stringToFind, int startIndex, boolean isEqualsIgnoreCase) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (stringToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else if (!isEqualsIgnoreCase) {
            for (int i = startIndex; i < array.length; ++i) {
                if (!stringToFind.equals(array[i])) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!stringToFind.equalsIgnoreCase(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(String[] array, String stringToFind, boolean isEqualsIgnoreCase) {
        return EcArrayUtil.indexOf(array, stringToFind, isEqualsIgnoreCase) != -1;
    }

    public static Object[] clearDuplicate(Object[] array) {
        if (EcArrayUtil.isNotEmpty(array)) {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>(Arrays.asList(array));
            array = set.toArray(array);
        }
        return array;
    }

    public static Object[] clearNull(Object[] array) {
        if (EcArrayUtil.isNotEmpty(array)) {
            List<Object> list = Arrays.asList(array);
            ArrayList<Object> nullList = new ArrayList<Object>();
            nullList.add(null);
            list.removeAll(nullList);
            array = list.toArray(array);
        }
        return array;
    }

    public static Object[] clearDuplicateAndNull(Object[] array) {
        if (EcArrayUtil.isNotEmpty(array)) {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>(Arrays.asList(array));
            set.remove(null);
            array = set.toArray(array);
        }
        return array;
    }
}

