/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class EcPeriodUtils {
    public static final String PERIODYEAR = "periodyear";
    public static final String BD_PERIOD = "bd_period";
    public static final String NUMBER = "number";

    public static List<String> getPeriodNumberList(DynamicObject startPeriod, DynamicObject endPeriod) {
        if (startPeriod == null && endPeriod == null) {
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            QFilter yearFilter = new QFilter(PERIODYEAR, "=", (Object)year);
            QFilter monthFilter = new QFilter("periodnumber", "=", (Object)month);
            DynamicObject period1 = BusinessDataServiceHelper.loadSingle((String)BD_PERIOD, (String)"id,number", (QFilter[])new QFilter[]{yearFilter, monthFilter});
            QFilter yearFilter1 = new QFilter(PERIODYEAR, "=", (Object)(year - 1));
            DynamicObject period2 = BusinessDataServiceHelper.loadSingle((String)BD_PERIOD, (String)"id,number", (QFilter[])new QFilter[]{yearFilter1, monthFilter});
            QFilter numberFilter = new QFilter(NUMBER, "<=", period1.get(NUMBER));
            QFilter numberFilter1 = new QFilter(NUMBER, ">", period2.get(NUMBER));
            DynamicObject[] periodArr = BusinessDataServiceHelper.load((String)BD_PERIOD, (String)"id,number", (QFilter[])new QFilter[]{numberFilter, numberFilter1});
            List<String> periodNumberList1 = Arrays.stream(periodArr).map(period -> period.getString(NUMBER)).distinct().sorted().collect(Collectors.toList());
            return periodNumberList1;
        }
        QFilter periodFilter = EcPeriodUtils.getPeriodNumberFilter(startPeriod, endPeriod);
        DynamicObject[] periodArr = BusinessDataServiceHelper.load((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{periodFilter});
        List<String> periodNumberList = Arrays.stream(periodArr).map(period -> period.getString(NUMBER)).distinct().sorted().collect(Collectors.toList());
        return periodNumberList;
    }

    public static QFilter getPeriodFilter(DynamicObject startPeriod, DynamicObject endPeriod) {
        List<Object> periodIdList = new ArrayList();
        QFilter periodFilter = EcPeriodUtils.getPeriodNumberFilter(startPeriod, endPeriod);
        if (periodFilter == null) {
            return periodFilter;
        }
        DynamicObject[] periodArr = BusinessDataServiceHelper.load((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{periodFilter});
        periodIdList = Arrays.stream(periodArr).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter periodIdFilter = new QFilter("period", "in", periodIdList);
        return periodIdFilter;
    }

    private static QFilter getPeriodNumberFilter(DynamicObject startPeriod, DynamicObject endPeriod) {
        QFilter periodFilter = null;
        if (startPeriod != null || endPeriod != null) {
            if (startPeriod != null && endPeriod == null) {
                String startPeriodNum = startPeriod.getString(NUMBER);
                periodFilter = new QFilter(NUMBER, ">=", (Object)startPeriodNum);
            } else if (startPeriod == null && endPeriod != null) {
                String endPeriodNum = endPeriod.getString(NUMBER);
                periodFilter = new QFilter(NUMBER, "<=", (Object)endPeriodNum);
            } else if (startPeriod != null && endPeriod != null) {
                String startPeriodNum = startPeriod.getString(NUMBER);
                String endPeriodNum = endPeriod.getString(NUMBER);
                periodFilter = new QFilter(NUMBER, ">=", (Object)startPeriodNum).and(new QFilter(NUMBER, "<=", (Object)endPeriodNum));
            } else {
                return periodFilter;
            }
        }
        return periodFilter;
    }

    public static DynamicObject getCurrentPeriod() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        QFilter yearFilter = new QFilter(PERIODYEAR, "=", (Object)year);
        QFilter monthFilter = new QFilter("periodnumber", "=", (Object)month);
        DynamicObject period = BusinessDataServiceHelper.loadSingle((String)BD_PERIOD, (String)"number,name,periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{yearFilter, monthFilter});
        return period;
    }

    public static DynamicObject getPeriodByYear(int year, int month) {
        QFilter yearFilter = new QFilter(PERIODYEAR, "=", (Object)year);
        QFilter monthFilter = new QFilter("periodnumber", "=", (Object)month);
        return BusinessDataServiceHelper.loadSingle((String)BD_PERIOD, (String)"number,name,periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{yearFilter, monthFilter});
    }
}

