/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.utils.EcArrayUtil;
import kd.pmgt.pmbs.common.utils.EcConstant;

public class NumberHelper {
    private static final Log logger = LogFactory.getLog(NumberHelper.class);
    public static final BigDecimal ZERO = new BigDecimal("0.0");
    public static final BigDecimal ONE = new BigDecimal("1.0");
    public static final BigDecimal _ONE = new BigDecimal("-1");
    public static final BigDecimal TEN = new BigDecimal("10");
    public static final BigDecimal _TEN = new BigDecimal("-10");
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    public static final BigDecimal _ONE_HUNDRED = new BigDecimal("-100");
    public static final BigDecimal ONE_THOUSAND = new BigDecimal("1000");
    public static final BigDecimal _ONE_THOUSAND = new BigDecimal("-1000");
    public static final BigDecimal TEN_THOUSAND = new BigDecimal("10000");
    public static final BigDecimal _TEN_THOUSAND = new BigDecimal("-10000");
    public static final BigDecimal ONE_HUNDRED_MILLION = new BigDecimal("100000000");
    public static final BigDecimal _ONE_HUNDRED_MILLION = new BigDecimal("-100000000");

    public static BigDecimal toBigDecimal(Object obj) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (null != obj) {
            if (obj instanceof BigDecimal) {
                bigDecimal = (BigDecimal)obj;
            } else {
                NumberFormat numberFormat = NumberFormat.getInstance();
                String str = obj.toString().trim();
                Number number = null;
                try {
                    number = numberFormat.parse(str);
                }
                catch (ParseException e) {
                    logger.error("parse number error!", (Throwable)e);
                }
                if (null != number) {
                    try {
                        str = number.toString();
                        bigDecimal = new BigDecimal(str);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        return bigDecimal;
    }

    public static BigDecimal add(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return NumberHelper.toBigDecimal(dec1).add(NumberHelper.toBigDecimal(dec2));
    }

    public static BigDecimal add(Object[] objArr) {
        BigDecimal rs = null;
        if (!EcArrayUtil.isAllNull(objArr)) {
            rs = EcConstant.ZERO;
            int len = objArr.length;
            for (int i = 0; i < len; ++i) {
                rs = rs.add(NumberHelper.toBigDecimal(objArr[i]));
            }
        }
        return rs;
    }

    public static BigDecimal subtract(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return NumberHelper.toBigDecimal(dec1).subtract(NumberHelper.toBigDecimal(dec2));
    }

    public static BigDecimal divide(Object dec1, Object dec2, int scale, RoundingMode roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (NumberHelper.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return NumberHelper.toBigDecimal(dec1).divide(NumberHelper.toBigDecimal(dec2), scale, roundingMode);
    }

    public static BigDecimal divide(Object dec1, Object dec2) {
        return NumberHelper.divide(dec1, dec2, 10, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal multiply(Object dec1, Object dec2) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        return NumberHelper.toBigDecimal(dec1).multiply(NumberHelper.toBigDecimal(dec2));
    }

    public static boolean isNullZero(BigDecimal bd) {
        boolean b = false;
        if (bd == null) {
            b = true;
        }
        if (bd != null && bd.compareTo(BigDecimal.ZERO) == 0) {
            b = true;
        }
        return b;
    }

    public static int compareValue(Object obj1, Object obj2) {
        return NumberHelper.toBigDecimal(obj1).compareTo(NumberHelper.toBigDecimal(obj2));
    }

    public static boolean isGreaterThan(Object obj1, Object obj2) {
        return 1 == NumberHelper.compareValue(obj1, obj2);
    }

    public static boolean isLessThan(Object obj1, Object obj2) {
        return -1 == NumberHelper.compareValue(obj1, obj2);
    }

    public static boolean isEqual(Object obj1, Object obj2) {
        return 0 == NumberHelper.compareValue(obj1, obj2);
    }

    public static BigDecimal getMaxBigDecimal(BigDecimal a, BigDecimal b, BigDecimal c) {
        BigDecimal max = a.compareTo(b) >= 0 && a.compareTo(c) >= 0 ? a : (b.compareTo(a) >= 0 && b.compareTo(c) >= 0 ? b : c);
        return max;
    }

    public static BigDecimal getMaxBigDecimal(List<BigDecimal> bigDecimalList) {
        return (BigDecimal)bigDecimalList.stream().max(BigDecimal::compareTo).get();
    }

    public static BigDecimal abs(Object obj) {
        return NumberHelper.toBigDecimal(obj).abs();
    }

    public static BigDecimal multiply(Object dec1, Object dec2, int scale) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = NumberHelper.toBigDecimal(dec1).multiply(NumberHelper.toBigDecimal(dec2));
        return obj.setScale(scale, 4);
    }

    public static BigDecimal getBigDecimalDivideTenthousand(BigDecimal bigDecimal) {
        return bigDecimal.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
    }
}

