/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.utils.OrgViewUtils;

public class OrgTreeUtils {
    public static final String CACHE_KEY_LONGNUMBER = "_longNumberCacheKey";
    public static final String CACHE_KEY_SEARCH_NODES = "_searchNodes";
    public static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText";
    public static final String CACHE_KEY_PARENTID = "_parentIdCacheKey";
    public static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    public static final String LONGNUMBER = "longnumber";
    public static final String PARENT = "parent";
    public static final String ISFREEZE = "isfreeze";
    private static final Long[] companyPatternIds = new Long[]{1L, 2L};

    public static String getOrgNameByNodeId(long nodeId) {
        String selectFields = "id,name";
        QFilter idFilter = new QFilter("id", "=", (Object)nodeId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)selectFields, (QFilter[])filters);
        return Utils.isListEmpty((List)orgCol) ? ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]) : ((DynamicObject)orgCol.get(0)).getString("name");
    }

    public static TreeNode genRootNodeByNodeId(String nodeId, String orgViewType) {
        String selectFields = "id,org.name name,longnumber";
        QFilter idFilter = new QFilter("org", "=", (Object)Long.parseLong(nodeId));
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{idFilter, viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            return new TreeNode("", nodeId, text.getLocaleValue());
        }
        DynamicObject org = (DynamicObject)orgCol.get(0);
        TreeNode root = new TreeNode("", nodeId, org.getString("name"));
        root.setLongNumber(org.getString(LONGNUMBER));
        root.setIsOpened(true);
        return root;
    }

    public static TreeNode queryRootNode(String parentId, String orgViewType) {
        TreeNode root = null;
        List<TreeNode> rootNodeList = OrgTreeUtils.queryChildNodes(parentId, orgViewType, null, "level");
        if (Utils.isListNotEmpty(rootNodeList)) {
            root = rootNodeList.get(0);
            root.setParentid("");
            root.setIsOpened(true);
        } else {
            LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            root = new TreeNode("", "-1", text.getLocaleValue());
        }
        return root;
    }

    public static List<TreeNode> queryChildNodes(String parentId, String orgViewType, QFilter otherFilter, String orderBy) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection subOrgCol = OrgTreeUtils.getSubOrgByParentId(parentId, orgViewType, otherFilter, orderBy, false);
        if (Utils.isListEmpty((List)subOrgCol)) {
            return childNodes;
        }
        for (DynamicObject orgObj : subOrgCol) {
            childNodes.add(OrgTreeUtils.genTreeNode(orgObj));
        }
        return childNodes;
    }

    public static List<TreeNode> queryChildNodes(String parentId, String orgViewType, QFilter otherFilter, String orderBy, TreeNode parentNode) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection subOrgCol = OrgTreeUtils.getSubOrgByParentId(parentId, orgViewType, otherFilter, orderBy, true);
        if (Utils.isListEmpty((List)subOrgCol)) {
            return childNodes;
        }
        for (DynamicObject orgObj : subOrgCol) {
            if (parentNode != null && parentId.equals(orgObj.getString("org"))) {
                OrgTreeUtils.genTreeNode(orgObj, parentNode);
                continue;
            }
            childNodes.add(OrgTreeUtils.genTreeNode(orgObj));
        }
        return childNodes;
    }

    public static DynamicObjectCollection getSubOrgByParentId(String parentId, String orgViewType, QFilter otherFilter, String orderBy, boolean isIncludeCur) {
        QFilter viewFilter;
        long parentOrgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            parentOrgId = Long.parseLong(parentId);
        }
        String selectFields = "id,org.id org,org.name name,parent.id parent,longNumber,isleaf,isfreeze";
        QFilter parentFilter = new QFilter(PARENT, "=", (Object)parentOrgId);
        if (isIncludeCur) {
            viewFilter = new QFilter("org", "=", (Object)parentOrgId);
            parentFilter = parentFilter.or(viewFilter);
        }
        viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{parentFilter, viewFilter, otherFilter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = "level,longNumber";
        }
        DynamicObjectCollection subOrgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters, (String)orderBy);
        return subOrgCol;
    }

    private static TreeNode genTreeNode(DynamicObject orgObj) {
        TreeNode node = new TreeNode();
        OrgTreeUtils.genTreeNode(orgObj, node);
        return node;
    }

    private static void genTreeNode(DynamicObject orgObj, TreeNode node) {
        node.setId(orgObj.getString("org"));
        String name = orgObj.getString("name");
        if (orgObj.getBoolean(ISFREEZE)) {
            name = String.format(ResManager.loadKDString((String)"%s\uff08\u5c01\u5b58\uff09", (String)"OrgTreeUtils_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]), name);
        }
        node.setText(name);
        String parentId = orgObj.getString(PARENT);
        if ("0".equals(parentId)) {
            parentId = "";
        }
        node.setParentid(parentId);
        node.setLongNumber(orgObj.getString(LONGNUMBER));
        if (!orgObj.getBoolean("isleaf")) {
            node.setChildren(new ArrayList());
        }
    }

    public static void searchTreeNode(String searchText, IFormView formView, ITreeListView treeListView, String orgViewType, boolean isOrgId) {
        if (!StringUtils.isBlank((CharSequence)searchText) && formView != null && treeListView != null) {
            OrgTreeUtils.searchTreeNode(searchText, formView, treeListView.getTreeView(), treeListView.getTreeModel(), orgViewType, isOrgId);
        }
    }

    public static void searchTreeNode(String searchText, IFormView formView, TreeView treeView, ITreeModel treeModel, String orgViewType, boolean isOrgId) {
        if (!StringUtils.isBlank((CharSequence)searchText) && formView != null && treeView != null) {
            String parentIdCache;
            Map<String, String> longNumMap = new HashMap<String, String>();
            List<Object> treeNodes = new ArrayList<TreeNode>();
            IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
            String longNumberCacheKey = formView.getPageId() + CACHE_KEY_LONGNUMBER;
            String searchNodesCacheKey = formView.getPageId() + CACHE_KEY_SEARCH_NODES;
            String oldSearchTextCacheKey = formView.getPageId() + CACHE_KEY_OLD_SEARCH_TEXT;
            String parentIdCacheKey = formView.getPageId() + CACHE_KEY_PARENTID;
            String oldSearchText = pageCache.get(oldSearchTextCacheKey);
            pageCache.put(oldSearchTextCacheKey, searchText);
            if (searchText.equals(oldSearchText)) {
                parentIdCache = pageCache.get(searchNodesCacheKey);
                if (StringUtils.isNotBlank((CharSequence)parentIdCache)) {
                    treeNodes = SerializationUtils.fromJsonStringToList((String)parentIdCache, TreeNode.class);
                    String longNumCache = pageCache.get(longNumberCacheKey);
                    longNumMap = StringUtils.isBlank((CharSequence)longNumCache) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)longNumCache, Map.class);
                }
                if (Utils.isListEmpty(treeNodes)) {
                    pageCache.put(searchNodesCacheKey, "");
                    if (!isOrgId) {
                        formView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"OrgTreeUtils_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                        return;
                    }
                }
            } else {
                OrgTreeUtils.searchTreeNode(searchText, treeNodes, orgViewType, isOrgId, longNumMap);
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
                pageCache.put(longNumberCacheKey, SerializationUtils.toJsonString(longNumMap));
            }
            if (Utils.isListNotEmpty(treeNodes)) {
                TreeNode node;
                parentIdCache = pageCache.get(parentIdCacheKey);
                ArrayList<String> parentIds = null;
                if (StringUtils.isNotBlank((CharSequence)parentIdCache)) {
                    parentIds = (ArrayList<String>)SerializationUtils.fromJsonString((String)parentIdCache, List.class);
                }
                if (parentIds == null) {
                    parentIds = new ArrayList<String>();
                }
                if (parentIds.contains((node = (TreeNode)treeNodes.get(0)).getParentid())) {
                    treeView.focusNode(node);
                } else {
                    OrgTreeUtils.queryTreeNodeWithParent(formView, treeView, treeModel, longNumMap, node, parentIds);
                    pageCache.put(parentIdCacheKey, SerializationUtils.toJsonString(parentIds));
                }
                if (!isOrgId) {
                    treeNodes.remove(0);
                    pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
                }
            }
        }
    }

    private static void searchTreeNode(String searchText, List<TreeNode> treeNodes, String orgViewType, boolean isOrgId, Map<String, String> longNumMap) {
        QFilter idFilter;
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        if (isOrgId) {
            boolean isNumeric = OrgTreeUtils.isNumeric(searchText);
            if (isNumeric) {
                idFilter = new QFilter("org", "=", (Object)Long.parseLong(searchText));
                viewFilter = viewFilter.and(idFilter);
            }
        } else {
            idFilter = new QFilter("org.name", "like", (Object)("%" + searchText + "%"));
            QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
            QFilter freezeFilter = new QFilter(ISFREEZE, "=", (Object)Boolean.FALSE);
            viewFilter = viewFilter.and(idFilter).and(enableFilter).and(freezeFilter);
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters, (String)LONGNUMBER);
        if (!Utils.isListEmpty((List)orgCol)) {
            for (DynamicObject org : orgCol) {
                String orgId = org.getString("org");
                TreeNode treeNode = new TreeNode(org.getString(PARENT), orgId, org.getString("name"));
                treeNode.setExpend(true);
                treeNodes.add(treeNode);
                longNumMap.put(orgId, org.getString(LONGNUMBER));
            }
        }
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void queryTreeNodeWithParent(IFormView formView, TreeView treeView, ITreeModel treeModel, Map<String, String> longNumMap, TreeNode node, List<String> parentIds) {
        String nodeId = node.getId();
        String longNumber = longNumMap.get(nodeId);
        ArrayList<String> longNumList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            longNumList.add(longNumber);
        }
        OrgTreeUtils.getParentLongNumber(longNumber, longNumList);
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter longNumberFilter = new QFilter(LONGNUMBER, "in", longNumList);
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter freezeFilter = new QFilter(ISFREEZE, "=", (Object)Boolean.FALSE);
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("15");
        QFilter[] filters = new QFilter[]{longNumberFilter, enableFilter, freezeFilter, viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters, (String)LONGNUMBER);
        if (!Utils.isListEmpty((List)orgCol)) {
            for (DynamicObject org : orgCol) {
                String parentId = org.getString(PARENT);
                String orgId = org.getString("org");
                if (parentIds.contains(orgId)) continue;
                parentIds.add(parentId);
                if (treeModel == null) {
                    treeView.treeNodeClick(parentId, orgId);
                    continue;
                }
                if (OrgTreeUtils.getNode(orgId, treeModel) == null) continue;
                treeView.queryTreeNodeChildren(parentId, orgId);
            }
            treeView.focusNode(node);
        }
    }

    public static TreeNode getNode(Object nodeId, ITreeModel treeModel) {
        if (treeModel == null) {
            return null;
        }
        TreeNode rootNode = treeModel.getRoot();
        return rootNode != null && nodeId != null ? rootNode.getTreeNode(nodeId.toString(), 20) : null;
    }

    private static void getParentLongNumber(String longNumber, List<String> longNumList) {
        if (!StringUtils.isBlank((CharSequence)longNumber) && longNumber.indexOf(33) != -1) {
            String parentLongNumber = StringUtils.substringBeforeLast((String)longNumber, (String)"!");
            longNumList.add(parentLongNumber);
            OrgTreeUtils.getParentLongNumber(parentLongNumber, longNumList);
        }
    }

    public static List<Long> getParentByOrgIds(List<Long> orgUnitIds, String orgViewType) {
        HashSet<Long> orgSet = new HashSet<Long>(16);
        orgSet.addAll(orgUnitIds);
        OrgTreeUtils.getParentByOrgId(orgUnitIds, orgSet, orgViewType);
        return new ArrayList<Long>(orgSet);
    }

    private static void getParentByOrgId(List<Long> orgUnitIds, Set<Long> parentOrgSet, String orgViewType) {
        String selectFields = "id,org.id org,parent";
        QFilter qFilter = new QFilter("org.id", "in", orgUnitIds);
        qFilter.and("view", "=", (Object)Long.parseLong(orgViewType));
        DynamicObjectCollection structures = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (structures.size() > 0) {
            Set parentsId = structures.stream().filter(o -> o.getLong(PARENT) != 0L).map(o -> o.getLong(PARENT)).collect(Collectors.toSet());
            parentOrgSet.addAll(parentsId);
            OrgTreeUtils.getParentByOrgId(new ArrayList<Long>(parentsId), parentOrgSet, orgViewType);
        }
    }

    public static DynamicObject getParentCompanyOrg(long orgId) {
        List<Long> patternNumberList = Arrays.asList(companyPatternIds);
        Object parentOrgId = OrgTreeUtils.getParentOrgByPattern(patternNumberList, orgId);
        if (parentOrgId != null) {
            return BusinessDataServiceHelper.loadSingle((Object)parentOrgId, (String)"bos_org");
        }
        return null;
    }

    public static DynamicObject getSuperCompanyOrg(long orgId) {
        DynamicObject parentCompanyOrg = OrgTreeUtils.getParentCompanyOrg(orgId);
        if (parentCompanyOrg == null) {
            return BusinessDataServiceHelper.loadSingle((Object)OrgUnitServiceHelper.getRootOrgId(), (String)"bos_org");
        }
        return parentCompanyOrg;
    }

    public static Object getParentOrgByPattern(List<Long> patternNumberList, long orgId) {
        QFilter qFilter = new QFilter("org.id", "=", (Object)orgId);
        qFilter.and("view", "=", (Object)Long.parseLong("01"));
        Map structureObjMap = BusinessDataServiceHelper.loadFromCache((String)BOS_ORG_STRUCTURE, (String)"parent,parent.orgpattern", (QFilter[])new QFilter[]{qFilter});
        if (structureObjMap != null && !structureObjMap.isEmpty()) {
            for (Map.Entry entry : structureObjMap.entrySet()) {
                DynamicObject parent = ((DynamicObject)entry.getValue()).getDynamicObject(PARENT);
                if (parent == null) continue;
                long orgPatternId = parent.getDynamicObject("orgpattern").getLong("id");
                if (patternNumberList.contains(orgPatternId)) {
                    return parent.getPkValue();
                }
                return OrgTreeUtils.getParentOrgByPattern(patternNumberList, (Long)parent.getPkValue());
            }
        }
        return null;
    }

    public static List<Long> getParentByOrgId(Long orgUnitId, String orgViewType) {
        ArrayList<Long> orgList = new ArrayList<Long>(16);
        OrgTreeUtils.getParentListByOrgId(orgUnitId, orgList, orgViewType);
        return orgList;
    }

    private static void getParentListByOrgId(Long orgUnitId, List<Long> orgList, String orgViewType) {
        String selectFields = "id,org.id org,parent";
        QFilter qFilter = new QFilter("org.id", "=", (Object)orgUnitId);
        qFilter.and("view", "=", (Object)Long.parseLong(orgViewType));
        DynamicObject structures = QueryServiceHelper.queryOne((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (structures != null) {
            long parent = structures.getLong(PARENT);
            OrgTreeUtils.getParentListByOrgId(parent, orgList, orgViewType);
            orgList.add(parent);
        }
    }
}

