/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgViewUtils {
    private static final Log log = LogFactory.getLog(OrgViewUtils.class);
    public static final String ISFREEZE = "isfreeze";
    public static final String LEVEL = "level";
    public static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    public static final String PARENT = "parent";
    public static final String LONGNUMBER = "longnumber";
    public static final String FULLNAME = "fullname";
    public static final String BOS_ORG = "bos_org";
    public static final String ISLEAF = "isleaf";
    public static final String YZJPARENTORGID = "yzjparentorgid";
    public static final String NUMBER = "number";

    public static List<Long> getAllOrgId(String orgViewType, boolean isAllEnable, boolean isUnFreeze) {
        String selectFields = "org";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        if (isAllEnable) {
            viewFilter = viewFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
            viewFilter = viewFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (isUnFreeze) {
            viewFilter = viewFilter.and(new QFilter(ISFREEZE, "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters, (String)LEVEL);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (Utils.isListEmpty((List)orgCol)) {
            return orgIds;
        }
        for (DynamicObject org : orgCol) {
            orgIds.add(org.getLong("org"));
        }
        return orgIds;
    }

    public static List<Long> getSubOrgId(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeGrand, QFilter otherFilter) {
        return isIncludeGrand ? OrgViewUtils.getSubOrgIdIncludeGrand(orgViewType, orgIds, isIncludeCurOrg, otherFilter) : OrgViewUtils.getSubOrgId(orgViewType, orgIds, isIncludeCurOrg, otherFilter);
    }

    public static List<Long> getSubOrgId(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (Utils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        QFilter parentFilter = new QFilter(PARENT, "in", orgIds);
        if (otherFilter != null) {
            parentFilter = parentFilter.and(otherFilter);
        }
        OrgViewUtils.queryOrgId(subOrgList, orgViewType, parentFilter);
        if (isIncludeCurOrg) {
            subOrgList.addAll(orgIds);
        }
        return subOrgList;
    }

    private static void queryOrgId(List<Long> subOrgList, String orgViewType, QFilter filter) {
        QFilter[] filters;
        DynamicObjectCollection orgCol;
        String selectFields = "org";
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter == null ? OrgViewUtils.getOrgViewFilter(orgViewType) : filter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        if (Utils.isListNotEmpty((List)(orgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])(filters = new QFilter[]{filter}), (String)LEVEL)))) {
            for (DynamicObject org : orgCol) {
                subOrgList.add(org.getLong("org"));
            }
        }
    }

    public static List<Long> getSubOrgIdIncludeGrand(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (Utils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        return OrgViewUtils.getSubOrgIdByLongNumber(orgViewType, OrgViewUtils.getOrgLongNumberById(orgViewType, orgIds), isIncludeCurOrg, otherFilter);
    }

    private static List<String> getOrgLongNumberById(String orgViewType, List<Long> orgIds) {
        String selectFields = LONGNUMBER;
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            orgFilter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters, (String)LONGNUMBER);
        ArrayList<String> longNumberList = new ArrayList<String>();
        if (Utils.isListEmpty((List)orgCol)) {
            return longNumberList;
        }
        ArrayList<String> tempLongNumberList = new ArrayList<String>();
        for (DynamicObject org : orgCol) {
            String longNumber = org.getString(LONGNUMBER);
            if (!StringUtils.isNotBlank((CharSequence)longNumber)) continue;
            longNumberList.add(longNumber);
            tempLongNumberList.add(longNumber);
        }
        ArrayList<String> duplicateList = new ArrayList<String>();
        for (String longNumber : longNumberList) {
            for (String tempLongNumber : tempLongNumberList) {
                if (!longNumber.startsWith(tempLongNumber + "!")) continue;
                duplicateList.add(longNumber);
            }
        }
        longNumberList.removeAll(duplicateList);
        return longNumberList;
    }

    public static List<Long> getSubOrgIdByLongNumber(String orgViewType, List<String> longNumberList, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (Utils.isListEmpty(longNumberList)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u957f\u7f16\u7801\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        QFilter filter = OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
        if (otherFilter != null) {
            filter = filter == null ? otherFilter : filter.and(otherFilter);
        }
        OrgViewUtils.queryOrgId(subOrgList, orgViewType, filter);
        return subOrgList;
    }

    public static QFilter genSoleLongNumberFilter(List<String> longNumberList, boolean isIncludeCurOrg) {
        if (Utils.isListEmpty(longNumberList)) {
            return null;
        }
        ArrayList<String> tempLongNumberList = new ArrayList<String>();
        tempLongNumberList.addAll(longNumberList);
        ArrayList<String> duplicateList = new ArrayList<String>();
        for (String longNumber : longNumberList) {
            for (String tempLongNumber : tempLongNumberList) {
                if (!longNumber.startsWith(tempLongNumber + "!")) continue;
                duplicateList.add(longNumber);
            }
        }
        longNumberList.removeAll(duplicateList);
        return OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
    }

    public static QFilter genLongNumberFilter(List<String> longNumberList, boolean isIncludeCurOrg) {
        QFilter filter = null;
        if (Utils.isListEmpty(longNumberList)) {
            return null;
        }
        QFilter curFilter = null;
        boolean isFirst = true;
        for (String longNumber : longNumberList) {
            String likeLongNumber = longNumber + "!%";
            if (isFirst) {
                isFirst = false;
                filter = new QFilter(LONGNUMBER, "like", (Object)likeLongNumber);
                curFilter = new QFilter(LONGNUMBER, "=", (Object)longNumber);
                continue;
            }
            filter = filter == null ? new QFilter(LONGNUMBER, "like", (Object)likeLongNumber) : filter.or(new QFilter(LONGNUMBER, "like", (Object)likeLongNumber));
            if (curFilter == null) continue;
            curFilter = curFilter.or(new QFilter(LONGNUMBER, "=", (Object)longNumber));
        }
        if (isIncludeCurOrg) {
            filter = filter == null ? curFilter : filter.or(curFilter);
        }
        return filter;
    }

    public static DynamicObject[] getSubOrg(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg, boolean isIncludeGrand) {
        return isIncludeGrand ? OrgViewUtils.getSubOrgIncludeGrand(orgViewType, orgIds, selectProperties, orderBy, isIncludeCurOrg) : OrgViewUtils.getSubOrg(orgViewType, orgIds, selectProperties, orderBy, isIncludeCurOrg);
    }

    public static DynamicObject[] getSubOrg(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        DynamicObject[] orgArr;
        if (Utils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter(PARENT, "in", orgIds);
        if (isIncludeCurOrg) {
            filter = filter.or(new QFilter("org", "in", orgIds));
        }
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = LEVEL;
        }
        return (orgArr = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)selectProperties, (QFilter[])filters, (String)orderBy)) == null ? new DynamicObject[]{} : orgArr;
    }

    public static DynamicObject[] getSubOrgIncludeGrand(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        if (Utils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        return OrgViewUtils.getSubOrgByLongNumber(orgViewType, OrgViewUtils.getOrgLongNumberById(orgViewType, orgIds), selectProperties, orderBy, isIncludeCurOrg);
    }

    public static DynamicObject[] getSubOrgByLongNumber(String orgViewType, List<String> longNumberList, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        DynamicObject[] subOrgArr;
        if (Utils.isListEmpty(longNumberList)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        QFilter filter = OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter == null ? OrgViewUtils.getOrgViewFilter(orgViewType) : filter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = LEVEL;
        }
        return (subOrgArr = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)selectProperties, (QFilter[])filters, (String)orderBy)) == null ? new DynamicObject[]{} : subOrgArr;
    }

    public static Map<Long, String> getOrgYzjFullname(List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return new HashMap<Long, String>(0);
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("01");
        QFilter orgFilter = new QFilter("org", "=", (Object)rootOrgId);
        String selectProperties = "id,org,fullname";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter = orgFilter.or(new QFilter("org", "in", orgIds))};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)selectProperties, (QFilter[])filters, (String)LONGNUMBER);
        if (Utils.isListEmpty((List)orgCol)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> fullNameMap = new HashMap<Long, String>();
        if (orgCol.size() == 1) {
            fullNameMap.put(rootOrgId, "\\");
            return fullNameMap;
        }
        String rootFullname = "";
        for (DynamicObject org : orgCol) {
            Long curOrgId = org.getLong("org");
            String fullName = org.getString(FULLNAME);
            if (curOrgId == rootOrgId) {
                rootFullname = fullName;
                if (!orgIds.contains(curOrgId)) continue;
                fullNameMap.put(curOrgId, "\\");
                continue;
            }
            String orgFullname = "";
            orgFullname = (fullName = fullName.replaceFirst(rootFullname + "_", "")).indexOf(95) != -1 ? fullName.replace('_', '\\') : fullName;
            fullNameMap.put(curOrgId, orgFullname);
        }
        return fullNameMap;
    }

    public static Map<Long, String> getOrgYzjId(List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return new HashMap<Long, String>(0);
        }
        QFilter viewFilter = OrgUnitServiceHelper.getBizOrgFilter((String)"01");
        QFilter orgFilter = new QFilter("id", "in", orgIds);
        String selectProperties = "id,fyzjorgid";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)BOS_ORG, (String)selectProperties, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> yzjorgIdMap = new HashMap<Long, String>();
        for (DynamicObject org : orgCol) {
            yzjorgIdMap.put(org.getLong("id"), org.getString("fyzjorgid"));
        }
        return yzjorgIdMap;
    }

    public static void updateParentIsLeaf(List<Long> orgIds) {
        String selectFields = "id,parent";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] orgList = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters);
        if (orgList != null && orgList.length != 0) {
            int parentCount = orgList.length;
            ArrayList<Long> parentIdList = new ArrayList<Long>(parentCount);
            DynamicObject[] var7 = orgList;
            int var8 = orgList.length;
            for (int var9 = 0; var9 < var8; ++var9) {
                DynamicObject org = var7[var9];
                DynamicObject parentOrg = org.getDynamicObject(PARENT);
                if (parentOrg == null) continue;
                parentIdList.add(parentOrg.getLong("id"));
            }
            OrgViewUtils.updateParentIsLeaf(parentIdList, orgIds, false);
        }
    }

    public static void updateParentIsLeaf(List<Long> parentIds, List<Long> orgIds, boolean isIncludeCurOrg) {
        if (parentIds != null && parentIds.size() != 0 && orgIds != null && orgIds.size() != 0) {
            QFilter[] filters;
            String selectFields;
            DynamicObject[] allSubOrgList;
            QFilter parentFilter = new QFilter(PARENT, "in", parentIds);
            if (!isIncludeCurOrg) {
                QFilter curOrgFilter = new QFilter("org", "not in", orgIds);
                parentFilter.and(curOrgFilter);
            }
            if ((allSubOrgList = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)(selectFields = "id,parent"), (QFilter[])(filters = new QFilter[]{parentFilter}))) != null && allSubOrgList.length > 0) {
                DynamicObject[] var7 = allSubOrgList;
                int var8 = allSubOrgList.length;
                for (int var9 = 0; var9 < var8; ++var9) {
                    DynamicObject org = var7[var9];
                    DynamicObject parentOrg = org.getDynamicObject(PARENT);
                    if (parentOrg == null) continue;
                    parentIds.remove(parentOrg.getLong("id"));
                    if (parentIds.size() != 0) continue;
                    return;
                }
            }
            OrgViewUtils.doUpdateParentIsLeaf(parentIds, true);
        }
    }

    public static void doUpdateParentIsLeaf(List<Long> parentIds, boolean isLeaf) {
        QFilter updateParentFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject[] updateOrgArr;
        if (!Utils.isListEmpty(parentIds) && (updateOrgArr = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)(selectFields = "id,org,isleaf"), (QFilter[])(filters = new QFilter[]{updateParentFilter = new QFilter("org", "in", parentIds)}))) != null && updateOrgArr.length != 0) {
            DynamicObject[] var6 = updateOrgArr;
            int var7 = updateOrgArr.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                DynamicObject updateOrg = var6[var8];
                updateOrg.set(ISLEAF, (Object)isLeaf);
            }
            SaveServiceHelper.save((DynamicObject[])updateOrgArr);
        }
    }

    private static DynamicObject[] queryAllFreezeOrg(List<Long> orgIdList) {
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("01");
        QFilter isFreezeFilter = new QFilter(ISFREEZE, "=", (Object)Boolean.FALSE);
        isFreezeFilter.or(QFilter.isNull((String)ISFREEZE));
        QFilter[] filters = new QFilter[]{orgFilter, viewFilter, isFreezeFilter};
        String selectFields = "id,org,isfreeze,sealuptime";
        DynamicObject[] orgStructureArr = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters);
        return orgStructureArr;
    }

    private static void deleteYzjInfoOfOrg(List<Long> orgIdList) {
        String selectFields = "id,fyzjorgid,fyzjimorted,fisadministrative";
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)BOS_ORG, (String)selectFields, (QFilter[])filters);
        if (orgArr != null && orgArr.length != 0) {
            DynamicObject[] var5 = orgArr;
            int var6 = orgArr.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                DynamicObject org = var5[var7];
                org.set("fyzjorgid", (Object)"");
                org.set("fyzjimorted", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.save((DynamicObject[])orgArr);
        }
    }

    private static boolean deleteUserPosition(List<Long> orgIdList) {
        String selectProperties = "id,entryentity,entryentity.dpt";
        QFilter orgFilter = new QFilter("entryentity.dpt", "in", orgIdList);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)selectProperties, (QFilter[])filters);
        if (userArr != null && userArr.length != 0) {
            DynamicObject[] var5 = userArr;
            int var6 = userArr.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                DynamicObject user = var5[var7];
                DynamicObjectCollection entityCol = user.getDynamicObjectCollection("entryentity");
                if (Utils.isListEmpty((List)entityCol)) continue;
                Iterator entityItr = entityCol.iterator();
                while (entityItr.hasNext()) {
                    DynamicObject entity = (DynamicObject)entityItr.next();
                    DynamicObject org = entity.getDynamicObject("dpt");
                    if (org == null || !orgIdList.contains(org.getLong("id"))) continue;
                    entityItr.remove();
                }
            }
            SaveServiceHelper.save((DynamicObject[])userArr);
            return true;
        }
        return true;
    }

    public static void updateOrgName(List<Long> orgIds, Map<Long, String> newNameMap) {
        if (Utils.isListEmpty(orgIds)) {
            log.error("\u7ec4\u7ec7ID\u7684\u53c2\u6570\u4e3a\u7a7a");
        } else if (newNameMap != null && newNameMap.size() != 0) {
            String selectProperties = "id,name";
            QFilter idFilter = new QFilter("id", "in", orgIds);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject[] orgNameArr = BusinessDataServiceHelper.load((String)BOS_ORG, (String)selectProperties, (QFilter[])filters);
            if (orgNameArr != null && orgNameArr.length > 0) {
                DynamicObject[] var6 = orgNameArr;
                int var7 = orgNameArr.length;
                for (int var8 = 0; var8 < var7; ++var8) {
                    DynamicObject org = var6[var8];
                    String orgName = newNameMap.get(org.getLong("id"));
                    if (!StringUtils.isNotBlank((CharSequence)orgName)) continue;
                    org.set("name", (Object)orgName);
                }
                SaveServiceHelper.save((DynamicObject[])orgNameArr);
            }
            OrgViewUtils.updateOrgFullName(orgIds, newNameMap);
        } else {
            log.error("\u7ec4\u7ec7\u540d\u79f0\u96c6\u5408\u7684\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    public static void updateOrgFullName(List<Long> orgIds, Map<Long, String> newNameMap) {
        if (Utils.isListEmpty(orgIds)) {
            log.error("\u7ec4\u7ec7ID\u7684\u53c2\u6570\u4e3a\u7a7a");
        } else if (newNameMap != null && newNameMap.size() != 0) {
            String selectProperties = "id,view,org,parent,name,fullname";
            DynamicObject[] orgArr = OrgViewUtils.getSubOrg(null, orgIds, selectProperties, null, true, true);
            if (orgArr != null && orgArr.length != 0) {
                HashMap parentFullNameMap = new HashMap();
                DynamicObject[] var5 = orgArr;
                int var6 = orgArr.length;
                for (int var7 = 0; var7 < var6; ++var7) {
                    DynamicObject org;
                    DynamicObject orgObj = var5[var7];
                    DynamicObject view = orgObj.getDynamicObject("view");
                    if (view == null) continue;
                    long viewType = view.getLong("id");
                    HashMap<Long, String> fullNameMap = (HashMap<Long, String>)parentFullNameMap.get(viewType);
                    if (fullNameMap == null) {
                        fullNameMap = new HashMap<Long, String>(1);
                        parentFullNameMap.put(viewType, fullNameMap);
                    }
                    if ((org = orgObj.getDynamicObject("org")) == null) continue;
                    long orgId = org.getLong("id");
                    String fullName = orgObj.getString(FULLNAME);
                    DynamicObject parent = orgObj.getDynamicObject(PARENT);
                    if (parent != null) {
                        String name = "";
                        boolean isNewName = false;
                        String newName = newNameMap.get(orgId);
                        if (StringUtils.isNotBlank((CharSequence)newName)) {
                            isNewName = true;
                            name = newName;
                        } else {
                            name = org.getString("name");
                        }
                        long parentId = parent.getLong("id");
                        String curFullName = (String)fullNameMap.get(parentId);
                        if (curFullName != null) {
                            fullName = curFullName + "_" + name;
                        } else if (isNewName) {
                            curFullName = orgObj.getString(FULLNAME);
                            if (StringUtils.isNotBlank((CharSequence)curFullName)) {
                                int curNameIndex = curFullName.lastIndexOf(95);
                                if (curNameIndex == -1) {
                                    fullName = name;
                                } else {
                                    String parentFullName = curFullName.substring(0, curNameIndex);
                                    fullName = parentFullName + "_" + name;
                                }
                            }
                        } else {
                            fullName = orgObj.getString(FULLNAME);
                        }
                        orgObj.set("name", (Object)name);
                        orgObj.set(FULLNAME, (Object)fullName);
                    }
                    fullNameMap.put(orgId, fullName);
                }
                SaveServiceHelper.save((DynamicObject[])orgArr);
            }
        } else {
            log.error("\u7ec4\u7ec7\u540d\u79f0\u96c6\u5408\u7684\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    public static void updateAdminOrgStructure(List<Long> orgIds, Map<Long, DynamicObject> newParentMap) {
        ArrayList<Long> oldParentIds = new ArrayList<Long>(orgIds.size());
        oldParentIds.addAll(orgIds);
        ArrayList<DynamicObject> subOrgList = new ArrayList<DynamicObject>();
        OrgViewUtils.querySubAdminOrgList(subOrgList, orgIds, newParentMap);
        int count = subOrgList.size();
        if (count > 0) {
            SaveServiceHelper.save((DynamicObject[])subOrgList.toArray(new DynamicObject[count]));
            OrgViewUtils.doUpdateParentIsLeaf(oldParentIds, false);
        }
    }

    private static void querySubAdminOrgList(List<DynamicObject> subOrgList, List<Long> orgIds, Map<Long, DynamicObject> newParentMap) {
        QFilter parentFilter;
        QFilter viewFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject[] orgCol;
        if (!Utils.isListEmpty(orgIds) && (orgCol = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)(selectFields = "id,org,parent,yzjorgid,yzjparentorgid,longnumber,fullname,level,isleaf"), (QFilter[])(filters = new QFilter[]{viewFilter = OrgViewUtils.getOrgViewFilter("01"), parentFilter = new QFilter(PARENT, "in", orgIds)}))) != null && orgCol.length != 0) {
            ArrayList<Long> parentIds = new ArrayList<Long>(orgCol.length);
            DynamicObject[] var9 = orgCol;
            int var10 = orgCol.length;
            for (int var11 = 0; var11 < var10; ++var11) {
                long orgId;
                DynamicObject subOrg = var9[var11];
                DynamicObject org = subOrg.getDynamicObject("org");
                if (org == null || newParentMap.containsKey(orgId = org.getLong("id"))) continue;
                DynamicObject parentOrg = null;
                DynamicObject parent = subOrg.getDynamicObject(PARENT);
                if (parent != null) {
                    parentOrg = newParentMap.get(parent.getLong("id"));
                }
                OrgViewUtils.generateNewOrgStructure(subOrg, parentOrg, org);
                subOrgList.add(subOrg);
                parentIds.add(orgId);
                newParentMap.put(orgId, subOrg);
            }
            OrgViewUtils.querySubAdminOrgList(subOrgList, parentIds, newParentMap);
        }
    }

    public static void generateNewOrgStructure(DynamicObject saveOrg, DynamicObject parentOrg, DynamicObject org) {
        String name = org.getString("name");
        saveOrg.set("name", (Object)name);
        if (parentOrg == null) {
            saveOrg.set(PARENT, (Object)0);
            saveOrg.set(YZJPARENTORGID, (Object)"");
            saveOrg.set(LONGNUMBER, (Object)saveOrg.getString(NUMBER));
            saveOrg.set(FULLNAME, (Object)saveOrg.getString(FULLNAME));
            saveOrg.set(LEVEL, (Object)1);
            saveOrg.set(ISLEAF, (Object)Boolean.FALSE);
        } else {
            saveOrg.set(PARENT, (Object)parentOrg.getDynamicObject("org"));
            saveOrg.set(YZJPARENTORGID, (Object)parentOrg.getString("yzjorgid"));
            saveOrg.set(LONGNUMBER, (Object)(parentOrg.getString(LONGNUMBER) + "!" + org.getString(NUMBER)));
            saveOrg.set(FULLNAME, (Object)(parentOrg.getString(FULLNAME) + "_" + name));
            saveOrg.set(LEVEL, (Object)(parentOrg.getInt(LEVEL) + 1));
            parentOrg.set(ISLEAF, (Object)Boolean.FALSE);
            saveOrg.set(ISLEAF, (Object)Boolean.TRUE);
        }
    }

    public static QFilter getOrgViewFilter(String orgViewType) {
        QFilter filter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("view.treetype", "=", (Object)orgViewType));
        return filter;
    }

    public static String getRootOrgFullName() {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        QFilter orgFilter = new QFilter("id", "=", (Object)rootOrgId);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject org = QueryServiceHelper.queryOne((String)BOS_ORG, (String)"id,name", (QFilter[])filters);
        return org == null ? OrgViewUtils.getRootOrgFullNameByParentId() : org.getString("name");
    }

    public static String getRootOrgFullNameByParentId() {
        QFilter orgFilter = new QFilter(PARENT, "=", (Object)0);
        orgFilter.or(QFilter.isNull((String)PARENT));
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject org = QueryServiceHelper.queryOne((String)BOS_ORG_STRUCTURE, (String)"id,fullname", (QFilter[])filters);
        return org == null ? "" : org.getString(FULLNAME);
    }

    public static int getOrgSortCode(int level, int sort) {
        int sortCode = level * 1000000 + sort;
        return sortCode;
    }

    public static void genCommonField(DynamicObject obj, boolean isHasCreator) {
        if (obj != null) {
            if (isHasCreator) {
                String userId = RequestContext.get().getUserId();
                obj.set("creator", (Object)userId);
                obj.set("modifier", (Object)userId);
            }
            Date dateTime = new Date();
            obj.set("createtime", (Object)dateTime);
            obj.set("enable", (Object)1);
            obj.set("status", (Object)"C");
            obj.set("modifytime", (Object)dateTime);
        }
    }

    public static DynamicObject getOrgBiz(String orgViewType) {
        String selectFields = "id,fnumber,fname,ffieldname,propertyname,fuserdefine,isbasetype";
        QFilter defaultFilter = new QFilter("isbasetype", "=", (Object)Boolean.TRUE);
        QFilter viewFilter = new QFilter("fnumber", "=", (Object)orgViewType);
        QFilter[] filters = new QFilter[]{defaultFilter, viewFilter};
        DynamicObject orgBiz = QueryServiceHelper.queryOne((String)"bos_org_biz", (String)selectFields, (QFilter[])filters);
        return orgBiz;
    }

    public static String getOrgBizProName(String orgViewType) {
        DynamicObject orgBiz = OrgViewUtils.getOrgBiz(orgViewType);
        return orgBiz == null ? "" : orgBiz.getString("propertyname");
    }

    public static void updateViewParent(String orgViewType) {
        if (!StringUtils.isBlank((CharSequence)orgViewType)) {
            String viewProName = OrgViewUtils.getOrgBizProName(orgViewType);
            LinkedHashMap<Long, DynamicObject> viewMap = new LinkedHashMap<Long, DynamicObject>();
            OrgViewUtils.getOrgLevelMap(orgViewType, viewProName, viewMap);
            if (viewMap.size() != 0) {
                LinkedHashMap<Long, DynamicObject> orgUnitMap = new LinkedHashMap<Long, DynamicObject>();
                OrgViewUtils.getOrgLevelMap("15", viewProName, orgUnitMap);
                if (orgUnitMap.size() != 0) {
                    int viewCount = viewMap.size();
                    ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>(viewCount);
                    for (Map.Entry entry : viewMap.entrySet()) {
                        long parentId;
                        DynamicObject org = (DynamicObject)entry.getValue();
                        orgList.add(org);
                        DynamicObject parent = org.getDynamicObject(PARENT);
                        if (parent == null || (parentId = parent.getLong("id")) == 0L) continue;
                        OrgViewUtils.genOrgViewParent(viewProName, parentId, orgUnitMap, viewMap, org);
                    }
                    SaveServiceHelper.save((DynamicObject[])orgList.toArray(new DynamicObject[viewCount]));
                }
            }
        }
    }

    private static void getOrgLevelMap(String orgViewType, String viewProName, Map<Long, DynamicObject> viewMap) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("id,org,parent,yzjorgid,yzjparentorgid,level,longnumber,fullname,isleaf");
        if (StringUtils.isNotBlank((CharSequence)viewProName)) {
            selectFields.append(',');
            selectFields.append(viewProName);
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)selectFields.toString(), (QFilter[])filters, (String)LONGNUMBER);
        if (orgArr != null && orgArr.length != 0) {
            DynamicObject[] var7 = orgArr;
            int var8 = orgArr.length;
            for (int var9 = 0; var9 < var8; ++var9) {
                DynamicObject orgObj = var7[var9];
                DynamicObject org = orgObj.getDynamicObject("org");
                if (org == null) continue;
                long orgId = org.getLong("id");
                viewMap.put(orgId, orgObj);
            }
        }
    }

    private static void genOrgViewParent(String viewProName, long parentId, Map<Long, DynamicObject> orgUnitMap, Map<Long, DynamicObject> viewMap, DynamicObject org) {
        if (parentId == 0L) {
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            DynamicObject levelOrg = viewMap.get(rootOrgId);
            if (levelOrg != null) {
                OrgViewUtils.genOrgViewNewParent(parentId, levelOrg, org);
            }
        } else {
            DynamicObject levelOrg = orgUnitMap.get(parentId);
            if (levelOrg != null) {
                DynamicObject orgUnit = levelOrg.getDynamicObject("org");
                boolean isSelectedView = orgUnit.getBoolean(viewProName);
                if (isSelectedView) {
                    DynamicObject parent = viewMap.get(parentId);
                    if (parent != null) {
                        OrgViewUtils.genOrgViewNewParent(parentId, parent, org);
                        return;
                    }
                    DynamicObject levelParent = levelOrg.getDynamicObject(PARENT);
                    OrgViewUtils.genOrgViewParent(viewProName, levelParent.getLong("id"), orgUnitMap, viewMap, org);
                } else {
                    DynamicObject parent = levelOrg.getDynamicObject(PARENT);
                    OrgViewUtils.genOrgViewParent(viewProName, parent.getLong("id"), orgUnitMap, viewMap, org);
                }
            }
        }
    }

    private static void genOrgViewNewParent(long parentId, DynamicObject parentObj, DynamicObject orgObj) {
        parentObj.set(ISLEAF, (Object)Boolean.FALSE);
        DynamicObject org = orgObj.getDynamicObject("org");
        orgObj.set(ISLEAF, (Object)Boolean.TRUE);
        orgObj.set(PARENT, (Object)parentId);
        orgObj.set(YZJPARENTORGID, parentObj.get("yzjorgid"));
        orgObj.set(LEVEL, (Object)(parentObj.getInt(LEVEL) + 1));
        orgObj.set(LONGNUMBER, (Object)(parentObj.getString(LONGNUMBER) + "!" + org.getString(NUMBER)));
        orgObj.set(FULLNAME, (Object)(parentObj.getString(FULLNAME) + "_" + org.getString("name")));
    }

    public static boolean isOrgNameValid(IFormView view, String str) {
        String msg = OrgViewUtils.isOrgNameValid(str);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            view.showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public static String isOrgNameValid(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return ResManager.loadKDStringExt((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u540d\u79f0\u3002", (String)"OrgViewUtils_7", (String)"pmgt-pmbs-common", (Object[])new Object[0]);
        }
        if ("null".equalsIgnoreCase(str)) {
            return String.format(ResManager.loadKDStringExt((String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u662f%s\u3002", (String)"OrgViewUtils_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]), str);
        }
        if (str.indexOf(95) != -1) {
            return String.format(ResManager.loadKDStringExt((String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u5305\u542b%s\u5b57\u7b26\u3002", (String)"OrgViewUtils_5", (String)"pmgt-pmbs-common", (Object[])new Object[0]), "_");
        }
        return str.indexOf(92) != -1 ? String.format(ResManager.loadKDStringExt((String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u5305\u542b%s\u5b57\u7b26", (String)"OrgViewUtils_6", (String)"pmgt-pmbs-common", (Object[])new Object[0]), "\\") : "";
    }
}

