/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProPermissionHelper {
    private static final String ORG = "pmascreateorg";
    private static final String DEPORG = "department";
    private static final String SELECTORS1 = Stream.of("org", "issubordinate", "excluprojstr", "rolesstr", "exclusionproj").collect(Collectors.joining(","));
    private static final List<String> ExluproStatusInit = Stream.of(ProjectStatusEnum.APPROVAL_IN.getValue(), ProjectStatusEnum.APPROVAL_FAIL.getValue(), ProjectStatusEnum.BUSSINESS_CLOSE.getValue(), ProjectStatusEnum.FINANCIAL_CLOSE.getValue()).collect(Collectors.toList());
    public static final String PMAS_NOWTEAM = "pmas_nowteam";
    public static final String MEMBER = "member";
    public static final String PROJECT = "project";
    public static final String STATUS = "status";
    public static final String ENABLE = "enable";
    public static final String NUMBER = "number";
    public static final String PROSTATUS = "prostatus";
    public static final String FBASEDATA_ID = "fbasedataId";
    public static final String PROSTATUS_NUMBER = "proStatus.number";
    public static final String BD_PROJECT = "bd_project";
    public static final String BD_PROJECTSTATUS = "bd_projectstatus";

    public static Map<Object, String> getPermProj(Object orgId, boolean isSubordinate, List<String> excluprojStatus, boolean isExclusion) {
        List<Long> orgList = Stream.of(Long.valueOf(orgId.toString())).collect(Collectors.toList());
        return ProPermissionHelper.getPermProjByOrgList(orgList, isSubordinate, excluprojStatus, isExclusion);
    }

    public static Map<Object, String> getPermProjByOrgList(List<Long> orgList, boolean isSubordinate, List<String> excluprojStatus, boolean isExclusion) {
        String userId = RequestContext.get().getUserId();
        HashMap<Object, String> chargeProMap = new HashMap<Object, String>();
        Map<Object, String> chargerProj = ProPermissionHelper.getChargerProjByOrgList(orgList, userId, excluprojStatus, isExclusion);
        if (chargerProj.size() > 0) {
            chargeProMap.putAll(chargerProj);
        }
        Map<Object, String> additionProj = ProPermissionHelper.getAdditionProjByOrgList(orgList, userId, excluprojStatus, isExclusion);
        chargeProMap.putAll(additionProj);
        Map<Object, String> teamMemberProj = ProPermissionHelper.getTeamMemberProjByOrgList(orgList, userId, excluprojStatus, isExclusion);
        chargeProMap.putAll(teamMemberProj);
        return chargeProMap;
    }

    public static Map<Object, String> getPermProjNoAddition(Object orgId, List<String> excluprojStatus, boolean isExclusion) {
        List<Long> orgList = Stream.of(Long.valueOf(orgId.toString())).collect(Collectors.toList());
        return ProPermissionHelper.getPermProjNoAdditionByOrgList(orgList, excluprojStatus, isExclusion);
    }

    public static Map<Object, String> getPermProjNoAdditionByOrgList(List<Long> orgIds, List<String> excluprojStatus, boolean isExclusion) {
        String userId = RequestContext.get().getUserId();
        HashMap<Object, String> chargePromap = new HashMap<Object, String>();
        Map<Object, String> chargerProj = ProPermissionHelper.getChargerProjByOrgList(orgIds, userId, excluprojStatus, isExclusion);
        if (chargerProj.size() > 0) {
            chargePromap.putAll(chargerProj);
        }
        Map<Object, String> teamMemberProj = ProPermissionHelper.getTeamMemberProjByOrgList(orgIds, userId, excluprojStatus, isExclusion);
        chargePromap.putAll(teamMemberProj);
        return chargePromap;
    }

    private static Map<Object, String> getTeamMemberProjByOrgList(List<Long> orgIds, String userId, List<String> excluprojStatus, boolean isExclusion) {
        if (orgIds == null) {
            orgIds = new ArrayList<Long>();
        }
        if (excluprojStatus == null) {
            excluprojStatus = new ArrayList<String>();
        }
        List<Long> orgList = orgIds;
        List<String> status = excluprojStatus;
        HashMap<Object, String> chargePromap = new HashMap<Object, String>();
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)PMAS_NOWTEAM, (String)PROJECT, (QFilter[])new QFilter[]{new QFilter(MEMBER, "=", (Object)userId)});
        Map<Object, String> projectIds = null;
        projectIds = isExclusion ? Arrays.stream(projects).filter(obj -> obj.get(PROJECT) != null && obj.getDynamicObject(PROJECT).getDynamicObject(ORG) != null && orgList.contains(obj.getDynamicObject(PROJECT).getDynamicObject(ORG).getPkValue()) && obj.getDynamicObject(PROJECT).getString(STATUS) != null && obj.getDynamicObject(PROJECT).getString(STATUS).equals(StatusEnum.CHECKED.getValue()) && obj.getDynamicObject(PROJECT).getString(ENABLE) != null && obj.getDynamicObject(PROJECT).getString(ENABLE).equals(EnableEnum.ENABLE.getValue()) && obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS) != null && !status.contains(obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS).getString(NUMBER))).map(obj -> obj.getDynamicObject(PROJECT)).distinct().collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name"))) : Arrays.stream(projects).filter(obj -> obj.get(PROJECT) != null && obj.getDynamicObject(PROJECT).getDynamicObject(ORG) != null && orgList.contains(obj.getDynamicObject(PROJECT).getDynamicObject(ORG).getPkValue()) && obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS) != null && obj.getDynamicObject(PROJECT).getString(STATUS) != null && obj.getDynamicObject(PROJECT).getString(STATUS).equals(StatusEnum.CHECKED.getValue()) && obj.getDynamicObject(PROJECT).getString(ENABLE) != null && obj.getDynamicObject(PROJECT).getString(ENABLE).equals(EnableEnum.ENABLE.getValue()) && status.contains(obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS).getString(NUMBER))).map(obj -> obj.getDynamicObject(PROJECT)).distinct().collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")));
        if (projectIds.size() > 0) {
            chargePromap.putAll(projectIds);
        }
        return chargePromap;
    }

    public static Map<Object, String> getTeamManagerProj(Object orgId, String userId, List<String> excluprojStatus, boolean isExclusion) {
        List<Long> orgList = Stream.of(Long.valueOf(orgId.toString())).collect(Collectors.toList());
        return ProPermissionHelper.getTeamManagerProjByOrgList(orgList, userId, excluprojStatus, isExclusion);
    }

    private static Map<Object, String> getTeamManagerProjByOrgList(List<Long> orgIds, String userId, List<String> excluprojStatus, boolean isExclusion) {
        if (orgIds == null) {
            orgIds = new ArrayList<Long>();
        }
        if (excluprojStatus == null) {
            excluprojStatus = new ArrayList<String>();
        }
        List<Long> orgList = orgIds;
        List<String> status = excluprojStatus;
        HashMap<Object, String> chargePromap = new HashMap<Object, String>();
        QFilter filter = new QFilter(MEMBER, "=", (Object)userId);
        filter.and("ischarge", "=", (Object)"1");
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)PMAS_NOWTEAM, (String)PROJECT, (QFilter[])new QFilter[]{filter});
        Map<Object, Object> projectIds = new HashMap();
        projectIds = isExclusion ? Arrays.stream(projects).filter(obj -> obj.get(PROJECT) != null && obj.getDynamicObject(PROJECT).getDynamicObject(ORG) != null && orgList.contains(obj.getDynamicObject(PROJECT).getDynamicObject(ORG).getPkValue()) && obj.getDynamicObject(PROJECT).getString(STATUS) != null && obj.getDynamicObject(PROJECT).getString(STATUS).equals(StatusEnum.CHECKED.getValue()) && obj.getDynamicObject(PROJECT).getString(ENABLE) != null && obj.getDynamicObject(PROJECT).getString(ENABLE).equals(EnableEnum.ENABLE.getValue()) && obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS) != null && !status.contains(obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS).getString(NUMBER))).map(obj -> obj.getDynamicObject(PROJECT)).distinct().collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name"))) : Arrays.stream(projects).filter(obj -> obj.get(PROJECT) != null && obj.getDynamicObject(PROJECT).getDynamicObject(ORG) != null && orgList.contains(obj.getDynamicObject(PROJECT).getDynamicObject(ORG).getPkValue()) && obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS) != null && obj.getDynamicObject(PROJECT).getString(STATUS) != null && obj.getDynamicObject(PROJECT).getString(STATUS).equals(StatusEnum.CHECKED.getValue()) && obj.getDynamicObject(PROJECT).getString(ENABLE) != null && obj.getDynamicObject(PROJECT).getString(ENABLE).equals(EnableEnum.ENABLE.getValue()) && status.contains(obj.getDynamicObject(PROJECT).getDynamicObject(PROSTATUS).getString(NUMBER))).map(obj -> obj.getDynamicObject(PROJECT)).distinct().collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")));
        if (projectIds.size() > 0) {
            chargePromap.putAll(projectIds);
        }
        return chargePromap;
    }

    private static Map<Object, String> getAdditionProjByOrgList(List<Long> orgList, String userId, List<String> projStatusList, boolean isExclusion) {
        if (orgList == null) {
            orgList = new ArrayList<Long>();
        }
        if (projStatusList == null) {
            projStatusList = new ArrayList<String>();
        }
        HashMap<Object, String> chargeProMap = new HashMap<Object, String>();
        HashSet<Long> allChargeSubordinateOrgs = new HashSet<Long>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
        DynamicObject[] perms = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)SELECTORS1, (QFilter[])new QFilter[]{userFilter, enableFilter});
        HashSet excluProjs = new HashSet();
        for (DynamicObject obj : perms) {
            DynamicObjectCollection exclusProCols = obj.getDynamicObjectCollection("exclusionproj");
            Object pkValue = obj.getDynamicObject("org").getPkValue();
            boolean objIsSubordinate = obj.getBoolean("issubordinate");
            Set excluProjIds = exclusProCols.stream().map(pro -> pro.getDynamicObject(FBASEDATA_ID).getPkValue()).collect(Collectors.toSet());
            excluProjs.addAll(excluProjIds);
            if (objIsSubordinate) {
                List allSubOrges = OrgServiceHelper.getAllSubordinateOrgs((String)"01", Stream.of(Long.valueOf(pkValue.toString())).collect(Collectors.toList()), (boolean)true);
                allChargeSubordinateOrgs.addAll(allSubOrges);
                continue;
            }
            allChargeSubordinateOrgs.add(Long.valueOf(pkValue.toString()));
        }
        if (allChargeSubordinateOrgs.size() > 0) {
            QFilter orgFilter1 = new QFilter(DEPORG, "in", allChargeSubordinateOrgs);
            orgFilter1.and(ORG, "in", orgList);
            orgFilter1.and(STATUS, "=", (Object)StatusEnum.CHECKED.getValue());
            orgFilter1.and(ENABLE, "=", (Object)EnableEnum.ENABLE.getValue());
            QFilter excluFilter1 = new QFilter("id", "not in", excluProjs);
            if (projStatusList != null && projStatusList.size() > 0) {
                if (isExclusion) {
                    excluFilter1.and(PROSTATUS_NUMBER, "not in", projStatusList);
                } else {
                    excluFilter1.and(PROSTATUS_NUMBER, "in", projStatusList);
                }
            }
            DynamicObject[] permProjs = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"id,name", (QFilter[])new QFilter[]{orgFilter1, excluFilter1});
            Map<Object, String> perProj = Arrays.stream(permProjs).collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")));
            chargeProMap.putAll(perProj);
        }
        return chargeProMap;
    }

    private static Map<Object, String> getChargerProjByOrgList(List<Long> orgIds, String userId, List<String> excluprojStatus, boolean isExclusion) {
        if (orgIds == null) {
            orgIds = new ArrayList<Long>();
        }
        Map<Object, String> chargePromap = new HashMap<Object, String>();
        Set<Long> chargerOrgIds = ProPermissionHelper.getChargerOrgIds(userId);
        if (chargerOrgIds.size() > 0) {
            QFilter filter = new QFilter(ORG, "in", orgIds);
            filter.and(DEPORG, "in", chargerOrgIds);
            filter.and(STATUS, "=", (Object)StatusEnum.CHECKED.getValue());
            filter.and(ENABLE, "=", (Object)EnableEnum.ENABLE.getValue());
            DynamicObject[] chargeProjects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"id,name", (QFilter[])new QFilter[]{filter});
            if (chargeProjects != null && chargeProjects.length != 0) {
                chargePromap = Stream.of(chargeProjects).collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")));
            }
        }
        return chargePromap;
    }

    public static Set<Long> getChargerOrgIds(String userId) {
        ArrayList<Long> userids = new ArrayList<Long>(10);
        userids.add(Long.valueOf(userId));
        List position = UserServiceHelper.getPosition(userids);
        HashSet<Long> charOrgIds = new HashSet<Long>();
        for (Object o : position) {
            ArrayList entries = (ArrayList)((HashMap)o).get("entryentity");
            if (entries == null) continue;
            for (HashMap map : entries) {
                Boolean isInCharge = (Boolean)map.get("isincharge");
                DynamicObject org = (DynamicObject)map.get("dpt");
                if (org == null || !isInCharge.booleanValue()) continue;
                List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)"01", Stream.of(Long.valueOf(org.getPkValue().toString())).collect(Collectors.toList()), (boolean)true);
                charOrgIds.addAll(allSubordinateOrgs);
            }
        }
        return charOrgIds;
    }

    public static Map<Object, String> getUserChargeProjsNoPermSetting(String userId) {
        DynamicObject[] projects;
        Map<Object, String> projectIds;
        HashMap<Object, String> chargeProjIds = new HashMap<Object, String>();
        List allSubordinateOrgs = UserServiceHelper.getInchargeOrgs((long)Long.parseLong(userId), (boolean)true);
        QFilter filter = new QFilter(ORG, "in", (Object)allSubordinateOrgs);
        filter.and("proStatus", "!=", null);
        filter.and(PROSTATUS_NUMBER, "not in", Arrays.asList(ProjectStatusEnum.APPROVAL_IN.getValue(), ProjectStatusEnum.APPROVAL_FAIL.getValue()));
        DynamicObject[] chargeProjects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"id,name", (QFilter[])new QFilter[]{filter});
        Map<Object, String> chargeProjs = Stream.of(chargeProjects).collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")));
        if (chargeProjs.size() > 0) {
            chargeProjIds.putAll(chargeProjs);
        }
        if ((projectIds = Arrays.stream(projects = BusinessDataServiceHelper.load((String)PMAS_NOWTEAM, (String)PROJECT, (QFilter[])new QFilter[]{new QFilter(MEMBER, "=", (Object)userId)})).filter(obj -> obj.get(PROJECT) != null).map(obj -> obj.getDynamicObject(PROJECT)).distinct().collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")))).size() > 0) {
            chargeProjIds.putAll(projectIds);
        }
        return chargeProjIds;
    }

    public static List<ComboItem> buildProComboItems(long orgId, List<String> exluproStatus, boolean isExclusion) {
        Map<Object, String> permProjs = ProPermissionHelper.getPermProj(orgId, true, exluproStatus, isExclusion);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (Map.Entry<Object, String> entry : permProjs.entrySet()) {
            ComboItem item = new ComboItem();
            item.setId(entry.getKey().toString());
            item.setCaption(new LocaleString(entry.getValue()));
            item.setValue(entry.getKey().toString());
            combos.add(item);
        }
        return combos;
    }

    public static List<ComboItem> buildProComboItems(long orgId, List<String> exluproStatus, boolean isExclusion, String entityNum, String operateNum) {
        Map<Object, String> entityPermProj = ProPermissionHelper.getEntityPermProj(orgId, true, exluproStatus, isExclusion, entityNum, operateNum);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (Map.Entry<Object, String> entry : entityPermProj.entrySet()) {
            ComboItem item = new ComboItem();
            item.setId(entry.getKey().toString());
            item.setCaption(new LocaleString(entry.getValue()));
            item.setValue(entry.getKey().toString());
            combos.add(item);
        }
        return combos;
    }

    public static List<ComboItem> buildProComboItemsWithoutPerm(long orgId, List<String> exluproStatus, boolean isExclusion) {
        Map<Object, String> permProjs = ProPermissionHelper.getProjWithoutPerm(orgId, true, exluproStatus, isExclusion);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (Map.Entry<Object, String> entry : permProjs.entrySet()) {
            ComboItem item = new ComboItem();
            item.setId(entry.getKey().toString());
            item.setCaption(new LocaleString(entry.getValue()));
            item.setValue(entry.getKey().toString());
            combos.add(item);
        }
        return combos;
    }

    public static List<ComboItem> buildProComboItemsWithProMnager(long orgId, List<String> exluproStatus, boolean isExclusion) {
        String userId = RequestContext.get().getUserId();
        Map<Object, String> permProjs = ProPermissionHelper.getTeamManagerProj(orgId, userId, exluproStatus, isExclusion);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (Map.Entry<Object, String> entry : permProjs.entrySet()) {
            ComboItem item = new ComboItem();
            item.setId(entry.getKey().toString());
            item.setCaption(new LocaleString(entry.getValue()));
            item.setValue(entry.getKey().toString());
            combos.add(item);
        }
        return combos;
    }

    public static Map<Object, String> getProjWithoutPerm(long orgId, boolean isSubordinate, List<String> exluproStatus, boolean isExclusion) {
        HashMap<Object, String> chargePromap = new HashMap();
        QFilter filter = new QFilter(ORG, "=", (Object)orgId);
        filter.and(ENABLE, "=", (Object)EnableEnum.ENABLE.getValue());
        filter.and(STATUS, "=", (Object)StatusEnum.CHECKED.getValue());
        if (exluproStatus != null && exluproStatus.size() > 0) {
            if (isExclusion) {
                filter.and(PROSTATUS_NUMBER, "not in", exluproStatus);
            } else {
                filter.and(PROSTATUS_NUMBER, "in", exluproStatus);
            }
        }
        DynamicObject[] chargeProjects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"id,name", (QFilter[])new QFilter[]{filter});
        chargePromap = Stream.of(chargeProjects).collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")));
        return chargePromap;
    }

    public static QFilter getAllChargeProIdsFilter(long orgId, List<String> exluproStatus, boolean isExclusion) {
        Map<Object, String> permProj = ProPermissionHelper.getPermProj(orgId, true, exluproStatus, isExclusion);
        return new QFilter("id", "in", permProj.keySet());
    }

    public static List<ComboItem> buildProStatusComboItems(List<String> exluprojStatus) {
        DynamicObject[] bd_proStatus;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        QFilter filter = new QFilter(NUMBER, "not in", exluprojStatus);
        QFilter filter1 = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
        for (DynamicObject entry : bd_proStatus = BusinessDataServiceHelper.load((String)BD_PROJECTSTATUS, (String)"id,name", (QFilter[])new QFilter[]{filter, filter1})) {
            ComboItem item = new ComboItem();
            item.setId(entry.getPkValue().toString());
            item.setCaption(new LocaleString(entry.getString("name")));
            item.setValue(entry.getPkValue().toString());
            combos.add(item);
        }
        return combos;
    }

    public static List<ComboItem> buildeabStatusComboItems() {
        DynamicObject[] bd_proStatus;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        QFilter filter = new QFilter(ENABLE, "=", (Object)Boolean.FALSE);
        for (DynamicObject entry : bd_proStatus = BusinessDataServiceHelper.load((String)BD_PROJECTSTATUS, (String)"id,name", (QFilter[])new QFilter[]{filter})) {
            ComboItem item = new ComboItem();
            item.setId(entry.getPkValue().toString());
            item.setCaption(new LocaleString(entry.getString("name")));
            item.setValue(entry.getPkValue().toString());
            combos.add(item);
        }
        return combos;
    }

    public static List<String> proStatusIdToNumber(List<Object> proStatusIds) {
        List<String> number = new ArrayList<String>();
        if (proStatusIds.size() > 0) {
            DynamicObject[] bd_projectstatuses = BusinessDataServiceHelper.load((Object[])proStatusIds.toArray(new Object[proStatusIds.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BD_PROJECTSTATUS));
            number = Arrays.stream(bd_projectstatuses).map(o -> o.getString(NUMBER)).collect(Collectors.toList());
        }
        return number;
    }

    public static List<Object> getCustomFilterValue(List<Map<String, List<Object>>> customFilters, String FieldName) {
        List<Object> value = null;
        if (customFilters == null) {
            return value;
        }
        for (Map<String, List<Object>> entry : customFilters) {
            List<Object> fieldName = entry.get("FieldName");
            if (fieldName == null || fieldName.size() <= 0 || !FieldName.equals(fieldName.get(0).toString())) continue;
            value = entry.get("Value");
            break;
        }
        return value;
    }

    public static Map<Object, String> getEntityPermProj(Object orgId, boolean isSubordinate, List<String> excluprojStatus, boolean isExclusion, String entityNum, String operateNum) {
        List<Long> orgList = Stream.of(Long.valueOf(orgId.toString())).collect(Collectors.toList());
        return ProPermissionHelper.getEntityPermProjByOrgList(orgList, isSubordinate, excluprojStatus, isExclusion, entityNum, operateNum);
    }

    public static Map<Object, String> getEntityPermProjByOrgList(List<Long> orgIdList, boolean isSubordinate, List<String> excluprojStatus, boolean isExclusion, String entityNum, String operateNum) {
        HashMap<Object, String> permProj = new HashMap<Object, String>();
        String userId = RequestContext.get().getUserId();
        Map<Object, String> chargerProj = ProPermissionHelper.getChargerProjByOrgList(orgIdList, userId, excluprojStatus, isExclusion);
        if (chargerProj.size() > 0) {
            permProj.putAll(chargerProj);
        }
        Map<Object, String> additionProj = ProPermissionHelper.getAdditionProjByOrgList(orgIdList, userId, excluprojStatus, isExclusion);
        Map<Object, String> teamMemberProj = ProPermissionHelper.getTeamMemberProjByOrgList(orgIdList, userId, excluprojStatus, isExclusion);
        Map<Object, Set<Object>> teamProjRoles = ProPermissionHelper.getTeamProjRoles(userId);
        Map<Object, Set<Object>> additionProjRoles = ProPermissionHelper.getAdditionProjRoles(orgIdList, excluprojStatus, isExclusion, userId);
        HashSet<Object> allRolesId = new HashSet<Object>();
        for (Map.Entry<Object, Set<Object>> entry : teamProjRoles.entrySet()) {
            allRolesId.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<Object>> entry : additionProjRoles.entrySet()) {
            allRolesId.addAll((Collection)entry.getValue());
        }
        String permNumber = ProPermissionHelper.getPermNum(entityNum, operateNum);
        if (!StringUtils.isBlank((CharSequence)permNumber)) {
            HashSet<Object> noPermRoles = ProPermissionHelper.getNoPermRoles(entityNum, allRolesId, permNumber);
            HashSet<Object> result = new HashSet<Object>();
            HashSet<Object> teamnoPermProjs = new HashSet<Object>();
            for (Map.Entry<Object, Set<Object>> entry : teamProjRoles.entrySet()) {
                Set<Object> set = entry.getValue();
                result.clear();
                result.addAll(set);
                result.removeAll(noPermRoles);
                if (result.size() >= 1) continue;
                teamnoPermProjs.add(entry.getKey());
            }
            HashSet<Object> addtionNopermObjs = new HashSet<Object>();
            for (Map.Entry<Object, Set<Object>> entry : additionProjRoles.entrySet()) {
                Set<Object> roles = entry.getValue();
                result.clear();
                result.addAll(roles);
                result.removeAll(noPermRoles);
                if (result.size() >= 1) continue;
                addtionNopermObjs.add(entry.getKey());
            }
            Iterator<Map.Entry<Object, String>> iterator = teamMemberProj.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, String> entry = iterator.next();
                if (!teamnoPermProjs.contains(entry.getKey())) continue;
                iterator.remove();
            }
            Iterator<Map.Entry<Object, String>> iterator2 = additionProj.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Object, String> entry = iterator2.next();
                if (!addtionNopermObjs.contains(entry.getKey())) continue;
                iterator2.remove();
            }
        }
        permProj.putAll(teamMemberProj);
        permProj.putAll(additionProj);
        return permProj;
    }

    private static HashSet<Object> getNoPermRoles(String entityNum, HashSet<Object> allRolesId, String permNumber) {
        HashSet<Object> hasPermRoles = new HashSet<Object>();
        block0: for (Object id : allRolesId) {
            DynamicObject[] rightPermData;
            for (DynamicObject obj : rightPermData = PermissionServiceHelper.getRightPermDataByRoleId((String)id.toString())) {
                DynamicObjectCollection roleperms = obj.getDynamicObjectCollection("roleperm");
                if (roleperms == null) continue;
                for (DynamicObject perm : roleperms) {
                    DynamicObject entity = perm.getDynamicObject("entity");
                    DynamicObject perItem = perm.getDynamicObject("permitem");
                    String entityNumber = "";
                    String perItemNumber = "";
                    if (entity != null) {
                        entityNumber = entity.getString(NUMBER);
                    }
                    if (perItem != null) {
                        perItemNumber = perItem.getString(NUMBER);
                    }
                    if (!entityNumber.equals(entityNum) || !perItemNumber.equals(permNumber)) continue;
                    hasPermRoles.add(id);
                    continue block0;
                }
            }
        }
        HashSet<Object> noPermRoles = new HashSet<Object>();
        noPermRoles.addAll(allRolesId);
        noPermRoles.removeAll(hasPermRoles);
        return noPermRoles;
    }

    private static Map<Object, Set<Object>> getAdditionProjRoles(List<Long> orgIdList, List<String> excluprojStatus, boolean isExclusion, String userId) {
        HashMap<Object, Set<Object>> projRolesMap = new HashMap<Object, Set<Object>>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
        DynamicObject[] additionUser = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)"user,org,exclusionproj,roles,issubordinate,enable", (QFilter[])new QFilter[]{userFilter, enableFilter});
        HashSet exluProjs = new HashSet();
        Set<Object> addtionRolsesIds = new HashSet();
        HashSet allSubChargeOrgIds = new HashSet();
        HashMap orgRoles = new HashMap();
        if (additionUser.length > 0) {
            DynamicObject[] bdProjects;
            for (DynamicObject o : additionUser) {
                Object org = o.getDynamicObject("org").getPkValue();
                boolean issubordinate = o.getBoolean("issubordinate");
                List allSubordinateOrgs = new ArrayList<Long>();
                if (issubordinate) {
                    ArrayList<Long> orgList = new ArrayList<Long>();
                    orgList.add(Long.valueOf(org.toString()));
                    allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs(orgList, (boolean)true);
                    allSubChargeOrgIds.addAll(allSubordinateOrgs);
                } else {
                    Long orgId = Long.valueOf(org.toString());
                    allSubordinateOrgs.add(orgId);
                    allSubChargeOrgIds.add(orgId);
                }
                DynamicObjectCollection multiObjs = o.getDynamicObjectCollection("exclusionproj");
                Set excluprojIds = multiObjs.stream().map(pro -> pro.getDynamicObject(FBASEDATA_ID).getPkValue()).collect(Collectors.toSet());
                DynamicObjectCollection mutiRoleObjs = o.getDynamicObjectCollection("roles");
                addtionRolsesIds = mutiRoleObjs.stream().map(pro -> pro.getDynamicObject(FBASEDATA_ID).getPkValue()).collect(Collectors.toSet());
                exluProjs.addAll(excluprojIds);
                for (Long l : allSubordinateOrgs) {
                    orgRoles.put(l, addtionRolsesIds);
                }
            }
            QFilter orgFilter1 = new QFilter(DEPORG, "in", allSubChargeOrgIds);
            orgFilter1.and(ORG, "in", orgIdList);
            QFilter excluFilter1 = new QFilter("id", "not in", exluProjs);
            excluFilter1.and(STATUS, "=", (Object)StatusEnum.CHECKED.getValue());
            excluFilter1.and(ENABLE, "=", (Object)EnableEnum.ENABLE.getValue());
            if (excluprojStatus != null && excluprojStatus.size() > 0) {
                if (isExclusion) {
                    excluFilter1.and(PROSTATUS_NUMBER, "not in", excluprojStatus);
                } else {
                    excluFilter1.and(PROSTATUS_NUMBER, "in", excluprojStatus);
                }
            }
            for (DynamicObject bdProj : bdProjects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"id,name,department", (QFilter[])new QFilter[]{orgFilter1, excluFilter1})) {
                Long depOrgId = (Long)bdProj.getDynamicObject(DEPORG).getPkValue();
                Object projId = bdProj.getPkValue();
                Set orgRoleIds = (Set)orgRoles.get(depOrgId);
                HashSet projRoleIds = (HashSet)projRolesMap.get(projId);
                if (projRoleIds == null) {
                    projRoleIds = new HashSet();
                    projRolesMap.put(projId, projRoleIds);
                } else {
                    projRoleIds.clear();
                }
                projRoleIds.addAll(orgRoleIds);
            }
        }
        return projRolesMap;
    }

    private static Map<Object, Set<Object>> getTeamProjRoles(String userId) {
        DynamicObject[] projRoles;
        HashMap<Object, Set<Object>> projRolesMap = new HashMap<Object, Set<Object>>();
        QFilter filter = new QFilter(MEMBER, "=", (Object)userId);
        filter.and("project.status", "=", (Object)StatusEnum.CHECKED.getValue());
        filter.and("project.enable", "=", (Object)EnableEnum.ENABLE.getValue());
        for (DynamicObject obj : projRoles = BusinessDataServiceHelper.load((String)PMAS_NOWTEAM, (String)"project,member,role", (QFilter[])new QFilter[]{filter})) {
            if (obj.getDynamicObject(PROJECT) == null) continue;
            Object projId = obj.getDynamicObject(PROJECT).getPkValue();
            HashSet<Object> roles = (HashSet<Object>)projRolesMap.get(projId);
            if (roles == null) {
                roles = new HashSet<Object>();
                projRolesMap.put(projId, roles);
            }
            if (obj.getDynamicObject("role") == null) continue;
            roles.add(obj.getDynamicObject("role").getPkValue());
        }
        return projRolesMap;
    }

    public static String getPermNum(String entityNum, String operateNum) {
        Map<String, Object> permObj = ProPermissionHelper.getPermObj(entityNum, operateNum);
        return (String)permObj.get("permNumber");
    }

    public static String getPermName(String entityNum, String operateNum) {
        Map<String, Object> permObj = ProPermissionHelper.getPermObj(entityNum, operateNum);
        return (String)permObj.get("permName");
    }

    public static String getPermId(String entityNum, String operateNum) {
        Map<String, Object> permObj = ProPermissionHelper.getPermObj(entityNum, operateNum);
        return (String)permObj.get("id");
    }

    public static Map<String, Object> getPermObj(String entityNum, String operateNum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        for (Map operate : dataEntityOperate) {
            String operateKey = (String)operate.get("key");
            if (!operateKey.equals(operateNum)) continue;
            String permItemPk = (String)operate.get("permission");
            if (permItemPk == null) break;
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(permItemPk), (String)"perm_permitem");
            String permNumber = object.getString(NUMBER);
            String permName = object.getString("name");
            map.put("id", permItemPk);
            map.put("permNumber", permNumber);
            map.put("permName", permName);
            break;
        }
        return map;
    }

    public static boolean hasProjOperatePerm(String orgId, String formId, List<String> excluStatus, Object projectId, String operateKey) {
        Map<Object, String> entityPermProj;
        Set<Object> modifyPermProj;
        boolean hasePerm = true;
        if (excluStatus == null) {
            excluStatus = ExluproStatusInit;
        }
        if (!(modifyPermProj = (entityPermProj = ProPermissionHelper.getEntityPermProj(orgId, true, excluStatus, true, formId, operateKey)).keySet()).contains(Long.valueOf(projectId.toString()))) {
            hasePerm = false;
        }
        return hasePerm;
    }

    public static List<ComboItem> rebuildStatusComboItems(List<ComboItem> proStatusItems) {
        List<ComboItem> eabStatusItems;
        ArrayList<ComboItem> newStatusItems = new ArrayList<ComboItem>();
        if (proStatusItems == null || proStatusItems.isEmpty()) {
            return newStatusItems;
        }
        for (ComboItem comboItem : proStatusItems) {
            if (!"696207911730356224".equals(comboItem.getValue())) continue;
            newStatusItems.add(comboItem);
            break;
        }
        for (ComboItem comboItem : proStatusItems) {
            if (!"696208189016036352".equals(comboItem.getValue())) continue;
            newStatusItems.add(comboItem);
            break;
        }
        for (ComboItem comboItem : proStatusItems) {
            if (!"696208078613566464".equals(comboItem.getValue())) continue;
            newStatusItems.add(comboItem);
            break;
        }
        for (ComboItem comboItem : proStatusItems) {
            String id = comboItem.getValue();
            if ("696207911730356224".equals(id) || "696208189016036352".equals(id) || "696208078613566464".equals(id) || "696208292405629952".equals(id) || "696208443861947392".equals(id)) continue;
            newStatusItems.add(comboItem);
        }
        for (ComboItem comboItem : proStatusItems) {
            if (!"696208292405629952".equals(comboItem.getValue())) continue;
            newStatusItems.add(comboItem);
            break;
        }
        for (ComboItem comboItem : proStatusItems) {
            if (!"696208443861947392".equals(comboItem.getValue())) continue;
            newStatusItems.add(comboItem);
            break;
        }
        if ((eabStatusItems = ProPermissionHelper.buildeabStatusComboItems()) != null && !eabStatusItems.isEmpty()) {
            newStatusItems.addAll(eabStatusItems);
        }
        return newStatusItems;
    }

    public static List<Object> buildDefStatusComboItems(List<ComboItem> proStatusItems) {
        ArrayList<Object> def_statusItems = new ArrayList<Object>();
        for (ComboItem comboItem : proStatusItems) {
            if (ProjectStatusEnum.BUSSINESS_CLOSE.getName().equals(comboItem.getCaption().getLocaleValue()) || ProjectStatusEnum.FINANCIAL_CLOSE.getName().equals(comboItem.getCaption().getLocaleValue())) continue;
            if (ProjectStatusEnum.APPROVAL_SUCC.getName().equals(comboItem.getCaption().getLocaleValue())) {
                def_statusItems.add(comboItem.getValue());
                continue;
            }
            def_statusItems.add(comboItem.getValue());
        }
        return def_statusItems;
    }
}

