/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.Plugin;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ApprovalStatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ReportStatusEnum;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.StringUtils;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;

public class ProjectPermissionHelper {
    private static final Log LOG = LogFactory.getLog(ProjectPermissionHelper.class);
    public static final String PMASCREATEORGKEY = "pmascreateorg";
    private static final String FILTER_LIST_SIZE = "filterListSize";
    private static final String DEPARTMENTKEY = "department";
    public static final String PROJECT = "project";
    public static final String MEMBER = "member";
    public static final String PMAS_NOWTEAM = "pmas_nowteam";
    public static final String BD_PROJECT = "bd_project";
    public static final String FBASEDATA_ID = "fbasedataId";
    public static final String NUMBER = "number";
    public static final String PROJECT_PERM_LIST_CLASS_NAME = "kd.pmgt.pmbs.formplugin.permission.ProjectPermListPlugin";

    public static List<Long> getAllPermOrgsByPermItem(String orgViewType, List<Long> orgList, boolean isSubordinate, String userId, String appId, String entityNum, String permItemId) {
        if (isSubordinate) {
            orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(orgViewType), orgList, (boolean)isSubordinate);
        }
        List<Long> allPermOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem(orgViewType, userId, appId, entityNum, permItemId);
        if (orgList != null && !orgList.isEmpty()) {
            orgList.retainAll(allPermOrgList);
        }
        return orgList;
    }

    public static List<Long> getAllPermOrgsByPermItem(String orgViewType, String userId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(userId), (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            orgList.add(OrgUnitServiceHelper.getRootOrgId());
            return OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgList, (boolean)true);
        }
        return result.getHasPermOrgs();
    }

    public static List<Long> getAllOrgsByOrgseparate(String orgViewType, Long orgId, String userId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(userId), (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            orgList.add(OrgUnitServiceHelper.getRootOrgId());
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(orgViewType), orgList, (boolean)true);
        }
        String patternId = ProjectPermissionHelper.getPatternIdByParam(orgId, "orgseparate");
        return ProjectPermissionHelper.getAllSubOrgUnitsByPattern(patternId, Collections.singletonList(orgId), orgViewType);
    }

    public static List<Long> getAllPermOrgs(String orgViewType, String userId, String appId, String entityNum, String operateNum) {
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)appId)) {
            return orgList;
        }
        String appPk = BizAppServiceHelp.getAppIdByAppNumber((String)appId);
        Map<String, Object> permItem = ProjectPermissionHelper.getPermObj(entityNum, operateNum);
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(userId), (String)orgViewType, (String)appPk, (String)entityNum, (String)String.valueOf(permItem.get("id")));
        if (result.hasAllOrgPerm()) {
            orgList.add(OrgUnitServiceHelper.getRootOrgId());
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(orgViewType), orgList, (boolean)true);
        }
        return result.getHasPermOrgs();
    }

    public static String getPatternIdByParam(Long orgId, String quarantine) {
        String pattern = null;
        Object personSeparateParam = SystemParamHelper.getSystemParameter(quarantine, "pmbs", orgId);
        if (personSeparateParam != null) {
            if (personSeparateParam instanceof LinkedHashMap) {
                LinkedHashMap personParam = (LinkedHashMap)personSeparateParam;
                pattern = personParam.get("id").toString();
            } else if (personSeparateParam instanceof DynamicObject) {
                DynamicObject personParam = (DynamicObject)personSeparateParam;
                pattern = personParam.getString("id");
            }
        }
        return pattern;
    }

    public static Map<String, String> getBatchPatternIdByOrgIds(List<Long> orgIds, String quarantine, String orgViewType) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Map<String, Object> systemParamMap = SystemParamHelper.getBatchSystemParameterByOrgIds(quarantine, "pmbs", orgIds, orgViewType);
        if (!systemParamMap.isEmpty()) {
            Set<Map.Entry<String, Object>> entrySet = systemParamMap.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                LinkedHashMap personParam;
                String orgId = entry.getKey();
                Object separateParam = entry.getValue();
                String pattern = null;
                if (separateParam instanceof LinkedHashMap) {
                    personParam = (LinkedHashMap)separateParam;
                    pattern = personParam.get("id").toString();
                } else if (separateParam instanceof DynamicObject) {
                    personParam = (DynamicObject)separateParam;
                    pattern = personParam.getString("id");
                }
                if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty(pattern)) continue;
                parameterMap.put(orgId, pattern);
            }
        }
        return parameterMap;
    }

    public static List<Long> getAllSubOrgUnitsByPattern(String patternId, List<Long> orgUnitIds, String orgViewType) {
        List<Long> orgList = new ArrayList<Long>(10);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)patternId)) {
            return orgList;
        }
        HashSet<Long> patternOrgSet = new HashSet<Long>();
        ProjectPermissionHelper.getParentOrgUnitsByPattern(new HashSet<Long>(orgUnitIds), patternOrgSet, orgViewType, patternId);
        if (patternOrgSet.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", patternOrgSet);
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (orgs.length > 0) {
                orgList = Arrays.stream(orgs).map(org -> Long.parseLong(org.getPkValue().toString())).collect(Collectors.toList());
            }
        }
        if (orgList.size() > 0) {
            orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(orgViewType), orgList, (boolean)true);
        }
        return orgList;
    }

    public static void getParentOrgUnitsByPattern(Set<Long> orgIds, Set<Long> patternOrgSet, String orgViewType, String patternId) {
        String selectFields = "id,org.id,parent,org.orgpattern";
        QFilter qFilter = new QFilter("org.id", "in", orgIds);
        qFilter.and("view", "=", (Object)Long.parseLong(orgViewType));
        DynamicObjectCollection structures = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (structures.size() > 0) {
            Set orgIdsByPattern = structures.stream().filter(o -> o.getLong("org.orgpattern") == Long.parseLong(patternId)).map(o -> o.getLong("org.id")).collect(Collectors.toSet());
            if (orgIdsByPattern.size() > 0) {
                patternOrgSet.addAll(orgIdsByPattern);
            }
            if ((orgIds = structures.stream().filter(o -> o.getLong("org.orgpattern") != Long.parseLong(patternId)).map(o -> o.getLong("parent")).collect(Collectors.toSet())).size() > 0) {
                ProjectPermissionHelper.getParentOrgUnitsByPattern(orgIds, patternOrgSet, orgViewType, patternId);
            }
        }
    }

    public static void getOrgUnitsByPattern(String patternId, Long orgUnitId, Set<Long> orgSet) {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgUnitId, (String)"bos_org");
        if (org.getDynamicObject("orgpattern") != null && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)patternId, (CharSequence)org.getDynamicObject("orgpattern").getPkValue().toString())) {
            orgSet.add(Long.parseLong(org.getPkValue().toString()));
        } else {
            long parent;
            String selectFields = "id,org.id org,parent";
            QFilter qFilter = new QFilter("org.id", "=", (Object)orgUnitId);
            DynamicObjectCollection structures = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            if (structures.size() > 0 && ((DynamicObject)structures.get(0)).getLong("parent") != 0L && !orgSet.contains(parent = ((DynamicObject)structures.get(0)).getLong("parent"))) {
                ProjectPermissionHelper.getOrgUnitsByPattern(patternId, parent, orgSet);
            }
        }
    }

    public static List<Long> getAllPermOrgs(String userId, String appId, String entityNum, String operateNum) {
        return ProjectPermissionHelper.getAllPermOrgs("15", userId, appId, entityNum, operateNum);
    }

    public static List<ComboItem> buildProComboItems(List<Long> orgList, boolean isSubordinate, String entityNum, String operateNum) {
        DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatus(orgList, true, entityNum, operateNum, null);
        return ProjectPermissionHelper.loadProComboItems(projects);
    }

    public static DynamicObject[] getPermContract(List<Long> orgList, boolean isSubordinate, DynamicObject project, String entityNum, String operateNum) {
        QFilter filter = ProjectPermissionHelper.getPermContractFilter(orgList, isSubordinate, project, entityNum, operateNum);
        return BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"", (QFilter[])new QFilter[]{filter});
    }

    public static QFilter getPermContractFilter(List<Long> orgList, boolean isSubordinate, DynamicObject project, String entityNum, String operateNum) {
        QFilter filter;
        if (project == null) {
            filter = new QFilter("org", "in", orgList);
            String[] excludeStatusIds = new String[]{ProjectStatusEnum.FINANCIAL_CLOSE.getId()};
            DynamicObject[] filterProjects = ProjectPermissionHelper.getPermProjectByStatus(orgList, isSubordinate, entityNum, operateNum, excludeStatusIds);
            Set projectIds = Arrays.stream(filterProjects).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter projectFilter = new QFilter(PROJECT, "in", (Object)projectIds.toArray());
            filter.or(projectFilter);
        } else {
            filter = new QFilter(PROJECT, "=", project.getPkValue());
        }
        return filter;
    }

    public static List<ComboItem> buildProComboItemsNormal(List<Long> orgList, String entityNum, String operateNum) {
        DynamicObject[] projects = ProjectPermissionHelper.getPermProject(orgList);
        return ProjectPermissionHelper.loadProComboItems(projects);
    }

    public static List<ComboItem> loadProComboItems(DynamicObject[] projects) {
        List<ComboItem> combos = new ArrayList<ComboItem>(10);
        List projectList = Arrays.stream(projects).map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toList());
        if (projectList.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", projectList);
            combos = BuildCommonFilterList.buildComboItem(BD_PROJECT, qFilter);
        }
        return combos;
    }

    public static List<ComboItem> buildProManagerProItem(List<Long> orgIds, String userId) {
        DynamicObject[] projects = ProjectPermissionHelper.getTeamManagerProj(orgIds, userId);
        return ProjectPermissionHelper.loadProComboItems(projects);
    }

    public static DynamicObject[] getPermProject(List<Long> orgList) {
        String[] excludeStatusIds = new String[]{};
        return ProjectPermissionHelper.getPermProject(orgList, excludeStatusIds);
    }

    public static DynamicObject[] getPermProject(List<Long> orgList, String[] excludeStatusIds) {
        QFilter projectStageFilter = new QFilter("projectstage", "=", (Object)Long.valueOf(ProjectStageEnum.PROPOSALSTAGE_S.getId()));
        QFilter projectStatusFilter = new QFilter("projectstatus", "=", (Object)Long.valueOf(ProjectStatusEnum.APPROVAL_SUCC.getId()));
        projectStageFilter.and(projectStatusFilter);
        DynamicObject[] proStatusEntities = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)PROJECT, (QFilter[])new QFilter[]{projectStageFilter});
        Set proStatusProjectIds = Arrays.stream(proStatusEntities).map(it -> it.getDynamicObject(PROJECT)).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        ArrayList<QFilter> bdProjectFilters = new ArrayList<QFilter>(10);
        if (orgList != null && !orgList.isEmpty()) {
            QFilter orgFilter = new QFilter(PMASCREATEORGKEY, "in", orgList);
            bdProjectFilters.add(orgFilter);
        }
        QFilter proStatusDefaultFilter = new QFilter("prostatus", "!=", (Object)0);
        bdProjectFilters.add(proStatusDefaultFilter);
        QFilter proStatusProjectFilter = new QFilter("id", "in", proStatusProjectIds);
        bdProjectFilters.add(proStatusProjectFilter);
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"", (QFilter[])bdProjectFilters.toArray(new QFilter[0]));
        List projectIds = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        return (DynamicObject[])Arrays.stream(proStatusEntities).map(it -> it.getDynamicObject(PROJECT)).filter(Objects::nonNull).filter(it -> projectIds.contains(it.getPkValue())).toArray(DynamicObject[]::new);
    }

    public static DynamicObject[] getPermProjByOrgList(long orgid, String[] excludeStatusIds) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        orgIdList.add(orgid);
        return ProjectPermissionHelper.getPermProjByOrgList(orgIdList, excludeStatusIds);
    }

    public static DynamicObject[] getPermProjByOrgList(List<Long> orgIdList, String[] excludeStatusIds) {
        Map<Object, String> projects = ProjectPermissionHelper.getProjectWithNoRoles(orgIdList);
        return ProjectPermissionHelper.getPermProjectByStatus(projects.keySet(), excludeStatusIds);
    }

    private static Map<Object, String> getProjectWithNoRoles(List<Long> orgIdList) {
        HashMap<Object, String> projects = new HashMap<Object, String>(16);
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        Map<Object, String> chargerProject = ProjectPermissionHelper.getChargerProjectList(userId);
        projects.putAll(chargerProject);
        Map<Object, String> additionProject = ProjectPermissionHelper.getAdditionProjectByOrgList(orgIdList, userId);
        projects.putAll(additionProject);
        Map<Object, String> teamMemberProject = ProjectPermissionHelper.getTeamMemberProjByOrgList(orgIdList, userId);
        projects.putAll(teamMemberProject);
        return projects;
    }

    public static DynamicObject[] getPermProjectByStatus(List<Long> orgList, boolean isSubordinate, String entityNum, String operateNum) {
        String[] excludeStatusIds = new String[]{ProjectStatusEnum.BUSSINESS_CLOSE.getId(), ProjectStatusEnum.FINANCIAL_CLOSE.getId()};
        return ProjectPermissionHelper.getPermProjectByStatus(orgList, isSubordinate, entityNum, operateNum, excludeStatusIds);
    }

    public static DynamicObject[] getPermProjectByStatus(List<Long> orgList, boolean isSubordinate, String entityNum, String operateNum, String[] excludeStatusIds) {
        return ProjectPermissionHelper.getPermProjectByStatus(orgList, isSubordinate, entityNum, operateNum, excludeStatusIds, true);
    }

    public static DynamicObject[] getPermProjectByStatus(List<Long> orgList, boolean isSubordinate, String entityNum, String operateNum, String[] excludeStatusIds, boolean needCheckApprovalStatus) {
        DynamicObject[] permProjectArray;
        Map<Object, String> projectIds = ProjectPermissionHelper.getEntityPermProjByOrgList(orgList, isSubordinate, entityNum, operateNum);
        if (needCheckApprovalStatus) {
            DynamicObject[] permProjectByStatus = ProjectPermissionHelper.getPermProjectByStatus(projectIds.keySet(), excludeStatusIds);
            permProjectArray = ProjectPermissionHelper.getPermProjectByApproval(permProjectByStatus);
        } else {
            permProjectArray = ProjectPermissionHelper.getPermProjectByStatus(projectIds.keySet(), excludeStatusIds);
        }
        return permProjectArray;
    }

    public static DynamicObject[] getPermProjectByStatusAndOrg(Long orgId, boolean isSubordinate, String entityNum, String operateNum, String[] excludeStatusIds) {
        Map<Object, String> projectIds = ProjectPermissionHelper.getEntityPermProjByOrg(orgId, isSubordinate, entityNum, operateNum);
        DynamicObject[] permProjectByStatus = ProjectPermissionHelper.getPermProjectByStatus(projectIds.keySet(), excludeStatusIds);
        DynamicObject[] permProjectArray = ProjectPermissionHelper.getPermProjectByApproval(permProjectByStatus);
        return permProjectArray;
    }

    public static DynamicObject[] getPermProjectByApproval(DynamicObject[] permProjectByStatus) {
        Set projectIds = Arrays.stream(permProjectByStatus).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter projectIdsFilter = new QFilter("pro", "in", projectIds);
        projectIdsFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.Checked));
        String selectProperties = String.join((CharSequence)",", "needapproval", "approvalstatus", "isreport", "repaudstatus", "pro", "prostatus");
        DynamicObject[] proApprovalList = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)selectProperties, (QFilter[])projectIdsFilter.toArray());
        ArrayList<DynamicObject> projectList = new ArrayList<DynamicObject>();
        for (DynamicObject project : proApprovalList) {
            if (project.getBoolean("needapproval") && project.getBoolean("isreport") && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ApprovalStatusEnum.PASS.getValue(), (CharSequence)project.getString("approvalstatus")) && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ReportStatusEnum.PASS.getValue(), (CharSequence)project.getString("repaudstatus"))) {
                projectList.add(project.getDynamicObject("pro"));
                continue;
            }
            if (project.getBoolean("needapproval") && !project.getBoolean("isreport") && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ApprovalStatusEnum.PASS.getValue(), (CharSequence)project.getString("approvalstatus"))) {
                projectList.add(project.getDynamicObject("pro"));
                continue;
            }
            if (!project.getBoolean("needapproval") && project.getBoolean("isreport") && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ReportStatusEnum.PASS.getValue(), (CharSequence)project.getString("repaudstatus"))) {
                projectList.add(project.getDynamicObject("pro"));
                continue;
            }
            if (project.getBoolean("needapproval") || project.getBoolean("isreport")) continue;
            projectList.add(project.getDynamicObject("pro"));
        }
        return projectList.toArray(new DynamicObject[0]);
    }

    public static List<Object> getPMGTProjectIdList() {
        QFilter proApprovalFilter = new QFilter("pro", "!=", (Object)0L);
        DynamicObjectCollection proApprovalList = QueryServiceHelper.query((String)"pmas_pro_approval", (String)"pro", (QFilter[])proApprovalFilter.toArray());
        return proApprovalList.stream().filter(proApp -> proApp.get("pro") != null && proApp.getLong("pro") != 0L).map(proApp -> proApp.getLong("pro")).collect(Collectors.toList());
    }

    public static boolean checkProjectByApproval(DynamicObject project) {
        DynamicObject[] proApprovalList;
        QFilter proApprovalFilter = new QFilter("billstatus", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue()).and("pro", "=", project.getPkValue());
        String selectProperties = String.join((CharSequence)",", "needapproval", "approvalstatus", "isreport", "repaudstatus", "pro", "prostatus");
        for (DynamicObject proApproval : proApprovalList = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)selectProperties, (QFilter[])proApprovalFilter.toArray())) {
            if (proApproval.getBoolean("needapproval") && proApproval.getBoolean("isreport") && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ApprovalStatusEnum.PASS.getValue(), (CharSequence)proApproval.getString("approvalstatus")) && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ReportStatusEnum.PASS.getValue(), (CharSequence)proApproval.getString("repaudstatus"))) {
                return true;
            }
            if (proApproval.getBoolean("needapproval") && !proApproval.getBoolean("isreport") && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ApprovalStatusEnum.PASS.getValue(), (CharSequence)proApproval.getString("approvalstatus"))) {
                return true;
            }
            if (!proApproval.getBoolean("needapproval") && proApproval.getBoolean("isreport") && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ReportStatusEnum.PASS.getValue(), (CharSequence)proApproval.getString("repaudstatus"))) {
                return true;
            }
            if (proApproval.getBoolean("needapproval") || proApproval.getBoolean("isreport")) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject[] getPermProjectByStatus(Set<Object> projectIds, String[] excludeStatusIds) {
        QFilter filter4;
        projectIds = projectIds.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        List ids = projectIds.stream().map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
        LOG.info("ProjectPermissionHelper#getPermProjectByStatus#ids: {}", ids);
        Object[] pids = null;
        if (excludeStatusIds != null && excludeStatusIds.length > 0) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter projectFilter = new QFilter("id", "in", ids);
            filters.add(projectFilter);
            QFilter filter1 = new QFilter("prostatus", "not in", (Object)StringUtils.stringArrToLongArr(excludeStatusIds));
            filters.add(filter1);
            QFilter filter2 = new QFilter("prostatus", "!=", (Object)0);
            filters.add(filter2);
            DynamicObject[] projects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"", (QFilter[])filters.toArray(new QFilter[0]));
            if (projects.length < 1) {
                return projects;
            }
            pids = new Object[projects.length];
            for (int i = 0; i < projects.length; ++i) {
                pids[i] = projects[i].getPkValue();
            }
        }
        QFilter filter = new QFilter("projectstage", "=", (Object)Long.valueOf(ProjectStageEnum.PROPOSALSTAGE_S.getId()));
        QFilter filter3 = new QFilter("projectstatus", "=", (Object)Long.valueOf(ProjectStatusEnum.APPROVAL_SUCC.getId()));
        if (pids == null) {
            filter4 = new QFilter(PROJECT, "in", ids);
            filter.and(filter3).and(filter4);
        } else {
            filter4 = new QFilter(PROJECT, "in", pids);
            filter.and(filter3).and(filter4);
        }
        DynamicObject[] statgeEntries = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)PROJECT, (QFilter[])new QFilter[]{filter});
        DynamicObject[] filterProjects = new DynamicObject[]{};
        if (statgeEntries.length != 0) {
            filterProjects = new DynamicObject[statgeEntries.length];
            for (int i = 0; i < statgeEntries.length; ++i) {
                filterProjects[i] = statgeEntries[i].getDynamicObject(PROJECT);
            }
        }
        return filterProjects;
    }

    public static Set<Long> getPermProjectIds(String userId) {
        HashSet<Object> proIdSet = new HashSet<Object>(16);
        Map<Object, String> chargerProjectByOrgList = ProjectPermissionHelper.getChargerProjectList(userId);
        Map<Object, String> additionProjectByOrgList = ProjectPermissionHelper.getAdditionProjectByOrgList(null, userId);
        Map<Object, String> teamMemberProjectByOrgList = ProjectPermissionHelper.getTeamMemberProjByOrgList(null, userId);
        proIdSet.addAll(chargerProjectByOrgList.keySet());
        proIdSet.addAll(additionProjectByOrgList.keySet());
        proIdSet.addAll(teamMemberProjectByOrgList.keySet());
        return proIdSet.stream().map(o -> (Long)o).collect(Collectors.toSet());
    }

    public static Map<Object, String> getEntityPermProjByOrgList(List<Long> orgIdList, boolean isSubordinate, String entityNum, String operateNum) {
        HashMap<Object, String> projects = new HashMap<Object, String>(16);
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        Map<Object, String> chargerProjects = ProjectPermissionHelper.getChargerProjectList(userId);
        LOG.info("ProjectPermissionHelper#chargerProjects: {}", chargerProjects);
        Map<Object, String> teamAndAdditionProjects = ProjectPermissionHelper.getTeamAndAdditionProjectList(orgIdList, entityNum, operateNum, userId);
        LOG.info("ProjectPermissionHelper#teamAndAdditionProjects: {}", teamAndAdditionProjects);
        if (!chargerProjects.isEmpty()) {
            projects.putAll(chargerProjects);
        }
        projects.putAll(teamAndAdditionProjects);
        return projects;
    }

    public static Map<Object, String> getEntityPermProjByOrg(Long orgId, boolean isSubordinate, String entityNum, String operateNum) {
        HashMap<Object, String> projects = new HashMap<Object, String>(16);
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        Map<Object, String> chargerProjects = ProjectPermissionHelper.getChargerProjectList(orgId);
        LOG.info("ProjectPermissionHelper#chargerProjects: {}", chargerProjects);
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(orgId);
        Map<Object, String> teamAndAdditionProjects = ProjectPermissionHelper.getTeamAndAdditionProjectList(orgIdList, entityNum, operateNum, userId);
        LOG.info("ProjectPermissionHelper#teamAndAdditionProjects: {}", teamAndAdditionProjects);
        if (!chargerProjects.isEmpty()) {
            projects.putAll(chargerProjects);
        }
        projects.putAll(teamAndAdditionProjects);
        return projects;
    }

    private static Map<Object, String> getTeamAndAdditionProjectList(List<Long> orgIdList, String entityNum, String operateNum, String userId) {
        Map<Object, String> additionProject = ProjectPermissionHelper.getAdditionProjectByOrgList(orgIdList, userId);
        LOG.info("ProjectPermissionHelper#additionProject: {}", additionProject.keySet());
        Map<Object, String> teamMemberProject = ProjectPermissionHelper.getTeamMemberProjByOrgList(orgIdList, userId);
        LOG.info("ProjectPermissionHelper#teamMemberProject: {}", teamMemberProject.keySet());
        Map<Object, Set<Object>> teamProjectRoles = ProjectPermissionHelper.getTeamProjRoles(userId);
        Map<Object, Set<Object>> additionProjectRoles = ProjectPermissionHelper.getAdditionProjectRoles(orgIdList, userId);
        HashSet<Object> allRolesId = new HashSet<Object>(16);
        for (Map.Entry<Object, Set<Object>> entry : teamProjectRoles.entrySet()) {
            allRolesId.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<Object>> entry : additionProjectRoles.entrySet()) {
            allRolesId.addAll((Collection)entry.getValue());
        }
        String permNumber = ProjectPermissionHelper.getPermNum(entityNum, operateNum);
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)permNumber)) {
            HashSet<Object> noPermRoles = ProjectPermissionHelper.getNoPermRoles(entityNum, allRolesId, permNumber);
            ProjectPermissionHelper.filterProjectHasPerm(teamMemberProject, teamProjectRoles, noPermRoles);
            ProjectPermissionHelper.filterProjectHasPerm(additionProject, additionProjectRoles, noPermRoles);
        }
        HashMap<Object, String> teamAndAdditionProjects = new HashMap<Object, String>(teamMemberProject);
        teamAndAdditionProjects.putAll(additionProject);
        return teamAndAdditionProjects;
    }

    private static void filterProjectHasPerm(Map<Object, String> hasPermProject, Map<Object, Set<Object>> projectRoles, Set<Object> noPermRoles) {
        HashSet<Object> result = new HashSet<Object>(10);
        HashSet<Object> noPermProjects = new HashSet<Object>(10);
        for (Map.Entry<Object, Set<Object>> en : projectRoles.entrySet()) {
            Set<Object> roles = en.getValue();
            result.clear();
            result.addAll(roles);
            result.removeAll(noPermRoles);
            if (!result.isEmpty()) continue;
            noPermProjects.add(en.getKey());
        }
        hasPermProject.entrySet().removeIf(next -> noPermProjects.contains(next.getKey()));
    }

    public static DynamicObject[] getTeamManagerProj(List<Long> orgIds, String userId) {
        if (orgIds == null) {
            orgIds = new ArrayList<Long>(10);
        }
        QFilter filter = new QFilter(MEMBER, "=", kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)userId) ? Long.valueOf(Long.parseLong(userId)) : null);
        QFilter proStatusQFilter = new QFilter("project.prostatus.id", "not in", (Object)0);
        if (orgIds.size() > 0) {
            QFilter orgFilter = new QFilter("project.pmascreateorg", "in", orgIds);
            proStatusQFilter.and(orgFilter);
        }
        filter.and("ischarge", "=", (Object)"1");
        DynamicObject[] teamArray = BusinessDataServiceHelper.load((String)PMAS_NOWTEAM, (String)PROJECT, (QFilter[])new QFilter[]{filter, proStatusQFilter});
        if (teamArray == null || teamArray.length < 1) {
            return teamArray;
        }
        ArrayList<Object> projectIds = new ArrayList<Object>();
        for (DynamicObject team : teamArray) {
            DynamicObject project = team.getDynamicObject(PROJECT);
            if (project == null) continue;
            projectIds.add(project.getPkValue());
        }
        QFilter filter1 = new QFilter("projectstage", "=", (Object)Long.parseLong(ProjectStageEnum.PROPOSALSTAGE_S.getId()));
        QFilter filter3 = new QFilter("projectstatus", "=", (Object)Long.valueOf(ProjectStatusEnum.APPROVAL_SUCC.getId()));
        QFilter filter4 = new QFilter(PROJECT, "in", projectIds);
        filter1.and(filter3).and(filter4);
        DynamicObject[] statgeEntries = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)PROJECT, (QFilter[])new QFilter[]{filter1});
        DynamicObject[] filterProjects = new DynamicObject[]{};
        if (statgeEntries.length != 0) {
            filterProjects = new DynamicObject[statgeEntries.length];
            for (int i = 0; i < statgeEntries.length; ++i) {
                filterProjects[i] = statgeEntries[i].getDynamicObject(PROJECT);
            }
        }
        return filterProjects;
    }

    public static List<Object> getCustomFilterValue(List<Map<String, List<Object>>> customFilters, String fieldName) {
        List<Object> value = null;
        if (customFilters == null) {
            return value;
        }
        for (Map<String, List<Object>> entry : customFilters) {
            List<Object> field = entry.get("FieldName");
            if (field == null || field.isEmpty() || !fieldName.equals(field.get(0).toString())) continue;
            value = entry.get("Value");
            break;
        }
        return value;
    }

    private static Map<Object, String> getChargerProjectList(String userId) {
        Map<Object, String> chargeProMap = new HashMap<Object, String>(16);
        Set<Long> chargeOrgIds = ProjectPermissionHelper.getChargerOrgIds(userId);
        LOG.info("ProjectPermissionHelper#chargeOrgIds: {}", chargeOrgIds);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter depOrgFilter = new QFilter(DEPARTMENTKEY, "in", chargeOrgIds);
        qFilters.add(depOrgFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        qFilters.add(enableFilter);
        DynamicObjectCollection chargeProjects = QueryServiceHelper.query((String)BD_PROJECT, (String)"id,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (chargeProjects != null && !chargeProjects.isEmpty()) {
            chargeProMap = chargeProjects.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name"), (value1, value2) -> value1));
        }
        return chargeProMap;
    }

    private static Map<Object, String> getChargerProjectList(Long orgId) {
        Map<Object, String> chargeProMap = new HashMap<Object, String>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter depOrgFilter = new QFilter(DEPARTMENTKEY, "=", (Object)orgId);
        qFilters.add(depOrgFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        qFilters.add(enableFilter);
        DynamicObject[] chargeProjects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"id,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (chargeProjects != null && chargeProjects.length != 0) {
            chargeProMap = Stream.of(chargeProjects).collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name")));
        }
        return chargeProMap;
    }

    private static Map<Object, String> getAdditionProjectByOrgList(List<Long> orgList, String userId) {
        HashMap<Object, String> chargeProMap = new HashMap<Object, String>(16);
        HashSet<Long> allChargeSubordinateOrgSet = new HashSet<Long>(10);
        HashSet<Long> subordinateOrgIds = new HashSet<Long>(10);
        QFilter userFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String selectors = String.join((CharSequence)",", "org", "issubordinate", "excluprojstr", "rolesstr", "exclusionproj");
        DynamicObject[] perms = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)selectors, (QFilter[])new QFilter[]{userFilter, enableFilter});
        HashSet excludeProjectSet = new HashSet(10);
        for (DynamicObject obj : perms) {
            DynamicObjectCollection multiObjs = obj.getDynamicObjectCollection("exclusionproj");
            Object pkValue = obj.getDynamicObject("org").getPkValue();
            boolean objIsSubordinate = obj.getBoolean("issubordinate");
            Set excluProjIds = multiObjs.stream().map(pro -> pro.getDynamicObject(FBASEDATA_ID).getPkValue()).collect(Collectors.toSet());
            excludeProjectSet.addAll(excluProjIds);
            if (objIsSubordinate) {
                subordinateOrgIds.add(Long.valueOf(pkValue.toString()));
                continue;
            }
            allChargeSubordinateOrgSet.add(Long.valueOf(pkValue.toString()));
        }
        if (!subordinateOrgIds.isEmpty()) {
            List allSubOrgList = OrgServiceHelper.getAllSubordinateOrgs((String)"01", new ArrayList(subordinateOrgIds), (boolean)true);
            allChargeSubordinateOrgSet.addAll(allSubOrgList);
        }
        if (!allChargeSubordinateOrgSet.isEmpty()) {
            QFilter orgFilter1 = new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
            orgFilter1.and("enable", "=", (Object)EnableEnum.ENABLE.getValue());
            if (orgList != null && orgList.size() > 0) {
                orgFilter1.and(DEPARTMENTKEY, "in", orgList);
            }
            QFilter excluFilter1 = new QFilter("id", "not in", excludeProjectSet);
            DynamicObjectCollection permProjs = QueryServiceHelper.query((String)BD_PROJECT, (String)"id,name", (QFilter[])new QFilter[]{orgFilter1, excluFilter1});
            Map<Object, String> perProj = permProjs.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, key -> key.getString("name"), (value1, value2) -> value1));
            chargeProMap.putAll(perProj);
        }
        return chargeProMap;
    }

    public static List<Map<Long, String>> getProjectByProperMission(String userId) {
        List<Map<Long, String>> resultMapList = new ArrayList<Map<Long, String>>();
        HashSet<Long> allChargeSubordinateOrgSet = new HashSet<Long>(10);
        HashSet<Long> subordinateOrgIds = new HashSet<Long>(10);
        QFilter userFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String selectors = String.join((CharSequence)",", "org", "issubordinate", "excluprojstr", "rolesstr", "exclusionproj");
        DynamicObject[] perms = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)selectors, (QFilter[])new QFilter[]{userFilter, enableFilter});
        HashSet excludeProjectSet = new HashSet(10);
        for (DynamicObject obj : perms) {
            DynamicObjectCollection multiObjs = obj.getDynamicObjectCollection("exclusionproj");
            Object pkValue = obj.getDynamicObject("org").getPkValue();
            boolean objIsSubordinate = obj.getBoolean("issubordinate");
            Set excluProjIds = multiObjs.stream().map(pro -> pro.getDynamicObject(FBASEDATA_ID).getPkValue()).collect(Collectors.toSet());
            excludeProjectSet.addAll(excluProjIds);
            if (objIsSubordinate) {
                subordinateOrgIds.add(Long.valueOf(pkValue.toString()));
                continue;
            }
            allChargeSubordinateOrgSet.add(Long.valueOf(pkValue.toString()));
        }
        if (!subordinateOrgIds.isEmpty()) {
            List allSubOrgList = OrgServiceHelper.getAllSubordinateOrgs((String)"01", new ArrayList(subordinateOrgIds), (boolean)true);
            allChargeSubordinateOrgSet.addAll(allSubOrgList);
        }
        if (!allChargeSubordinateOrgSet.isEmpty()) {
            QFilter orgFilter1 = new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
            orgFilter1.and("enable", "=", (Object)EnableEnum.ENABLE.getValue()).and(DEPARTMENTKEY, "in", allChargeSubordinateOrgSet);
            QFilter excludeFilter = new QFilter("id", "not in", excludeProjectSet);
            DynamicObjectCollection permProjs = QueryServiceHelper.query((String)BD_PROJECT, (String)"id,name", (QFilter[])new QFilter[]{orgFilter1, excludeFilter});
            resultMapList = permProjs.stream().map(pro -> {
                HashMap<Long, String> map = new HashMap<Long, String>();
                map.put(pro.getLong("id"), pro.getString("name"));
                return map;
            }).collect(Collectors.toList());
        }
        return resultMapList;
    }

    public static Set<Long> getOrgListByProperMission(String userId) {
        DynamicObject[] perms;
        HashSet<Long> allChargeSubordinateOrgSet = new HashSet<Long>(10);
        HashSet<Long> subordinateOrgIds = new HashSet<Long>(10);
        QFilter userFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String selectors = String.join((CharSequence)",", "org", "issubordinate", "excluprojstr", "rolesstr", "exclusionproj");
        for (DynamicObject obj : perms = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)selectors, (QFilter[])new QFilter[]{userFilter, enableFilter})) {
            Object pkValue = obj.getDynamicObject("org").getPkValue();
            boolean objIsSubordinate = obj.getBoolean("issubordinate");
            if (objIsSubordinate) {
                subordinateOrgIds.add(Long.valueOf(pkValue.toString()));
                continue;
            }
            allChargeSubordinateOrgSet.add(Long.valueOf(pkValue.toString()));
        }
        if (!subordinateOrgIds.isEmpty()) {
            List allSubOrgList = OrgServiceHelper.getAllSubordinateOrgs((String)"01", new ArrayList(subordinateOrgIds), (boolean)true);
            allChargeSubordinateOrgSet.addAll(allSubOrgList);
        }
        return allChargeSubordinateOrgSet;
    }

    private static Map<Object, String> getTeamMemberProjByOrgList(List<Long> orgList, String userId) {
        HashMap<Object, String> chargeProMap = new HashMap<Object, String>(16);
        DynamicObject[] nowTeams = BusinessDataServiceHelper.load((String)PMAS_NOWTEAM, (String)PROJECT, (QFilter[])new QFilter[]{new QFilter(MEMBER, "=", (Object)Long.parseLong(userId))});
        if (nowTeams.length > 0) {
            for (DynamicObject nowTeam : nowTeams) {
                DynamicObject org;
                DynamicObject project = nowTeam.getDynamicObject(PROJECT);
                if (project == null || (org = project.getDynamicObject(PMASCREATEORGKEY)) == null || orgList != null && !orgList.isEmpty() && !orgList.contains(Long.parseLong(org.getPkValue().toString()))) continue;
                chargeProMap.put(project.getPkValue(), project.getLocaleString("name").getLocaleValue());
            }
        }
        return chargeProMap;
    }

    private static Map<Object, Set<Object>> getTeamProjRoles(String userId) {
        HashMap<Object, Set<Object>> projectRolesMap = new HashMap<Object, Set<Object>>(16);
        QFilter filter = new QFilter(MEMBER, "=", (Object)Long.parseLong(userId));
        filter.and("project.status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
        filter.and("project.enable", "=", (Object)EnableEnum.ENABLE.getValue());
        DynamicObjectCollection projectRoleList = QueryServiceHelper.query((String)PMAS_NOWTEAM, (String)"project,member,role", (QFilter[])new QFilter[]{filter});
        for (DynamicObject projectRole : projectRoleList) {
            Object projectId = projectRole.get(PROJECT);
            HashSet<Object> roles = (HashSet<Object>)projectRolesMap.get(projectId);
            if (roles == null || roles.isEmpty()) {
                roles = new HashSet<Object>(16);
                projectRolesMap.put(projectId, roles);
            }
            if (projectRole.get("role") == null) continue;
            roles.add(projectRole.get("role"));
        }
        return projectRolesMap;
    }

    private static Map<Object, Set<Object>> getAdditionProjectRoles(List<Long> orgIdList, String userId) {
        ConcurrentHashMap<Object, Set<Object>> proRolesMap = new ConcurrentHashMap<Object, Set<Object>>(16);
        QFilter userFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] additionUser = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)"user,org,exclusionproj,roles,issubordinate,enable", (QFilter[])new QFilter[]{userFilter, enableFilter});
        HashSet excludeProjectSet = new HashSet(10);
        ConcurrentHashMap orgRoles = new ConcurrentHashMap(16);
        if (additionUser.length > 0) {
            for (DynamicObject o2 : additionUser) {
                Object org = o2.getDynamicObject("org").getPkValue();
                boolean isSubordinate = o2.getBoolean("issubordinate");
                List allSubordinateOrgs = new ArrayList<Long>(10);
                if (isSubordinate) {
                    ArrayList<Long> orgList = new ArrayList<Long>(10);
                    orgList.add(Long.valueOf(org.toString()));
                    allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs(orgList, (boolean)true);
                } else {
                    Long orgLong = Long.valueOf(org.toString());
                    allSubordinateOrgs.add(orgLong);
                }
                DynamicObjectCollection multiObjs = o2.getDynamicObjectCollection("exclusionproj");
                Set excluprojIds = multiObjs.stream().map(pro -> pro.getDynamicObject(FBASEDATA_ID).getPkValue()).collect(Collectors.toSet());
                DynamicObjectCollection mutiRoleObjs = o2.getDynamicObjectCollection("roles");
                Set additionRoleIdSet = mutiRoleObjs.stream().map(pro -> pro.getDynamicObject(FBASEDATA_ID).getPkValue()).collect(Collectors.toSet());
                excludeProjectSet.addAll(excluprojIds);
                for (Long l : allSubordinateOrgs) {
                    orgRoles.put(l, additionRoleIdSet);
                }
            }
            QFilter orgFilter1 = new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
            orgFilter1.and("enable", "=", (Object)EnableEnum.ENABLE.getValue());
            orgFilter1.and(PMASCREATEORGKEY, "in", orgIdList);
            QFilter excludeFilter1 = new QFilter("id", "not in", excludeProjectSet);
            DynamicObjectCollection bdProjects = QueryServiceHelper.query((String)BD_PROJECT, (String)"id,name,department", (QFilter[])new QFilter[]{orgFilter1, excludeFilter1});
            int size = bdProjects.size();
            bdProjects.parallelStream().filter(o -> o.getLong(DEPARTMENTKEY) != 0L).forEach(bdProject -> {
                long depOrgId = bdProject.getLong(DEPARTMENTKEY);
                long proId = bdProject.getLong("id");
                Set orgRoleIds = (Set)orgRoles.get(depOrgId);
                HashSet proRoleIds = (HashSet)proRolesMap.get(proId);
                if (proRoleIds == null) {
                    proRoleIds = new HashSet(size);
                    proRolesMap.put(proId, proRoleIds);
                } else {
                    proRoleIds.clear();
                }
                if (orgRoleIds != null) {
                    proRoleIds.addAll(orgRoleIds);
                }
            });
        }
        return proRolesMap;
    }

    private static String getPermNum(String entityNum, String operateNum) {
        Map<String, Object> permObj = ProjectPermissionHelper.getPermObj(entityNum, operateNum);
        return (String)permObj.get("permNumber");
    }

    public static Map<String, Object> getPermObj(String entityNum, String operateNum) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        for (Map operate : dataEntityOperate) {
            String operateKey = (String)operate.get("key");
            if (!operateKey.equals(operateNum)) continue;
            String permItemPk = (String)operate.get("permission");
            if (permItemPk == null) break;
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)permItemPk, (String)"perm_permitem");
            String permNumber = object.getString(NUMBER);
            String permName = object.getString("name");
            map.put("id", permItemPk);
            map.put("permNumber", permNumber);
            map.put("permName", permName);
            break;
        }
        return map;
    }

    private static HashSet<Object> getNoPermRoles(String entityNum, HashSet<Object> allRolesId, String permNumber) {
        HashSet<Object> hasPermRoles = new HashSet<Object>(16);
        block0: for (Object id : allRolesId) {
            DynamicObject[] rightPermData;
            for (DynamicObject obj : rightPermData = PermissionServiceHelper.getRightPermDataByRoleId((String)id.toString())) {
                DynamicObjectCollection roleperms = obj.getDynamicObjectCollection("roleperm");
                if (roleperms == null) continue;
                for (DynamicObject perm : roleperms) {
                    DynamicObject entity = perm.getDynamicObject("entity");
                    DynamicObject perItem = perm.getDynamicObject("permitem");
                    String entityNumber = "";
                    String perItemNumber = "";
                    if (entity != null) {
                        entityNumber = entity.getString(NUMBER);
                    }
                    if (perItem != null) {
                        perItemNumber = perItem.getString(NUMBER);
                    }
                    if (!entityNumber.equals(entityNum) || !perItemNumber.equals(permNumber)) continue;
                    hasPermRoles.add(id);
                    continue block0;
                }
            }
        }
        LOG.info("ProjectPermissionHelper#hasPermRoles: {}", hasPermRoles);
        HashSet<Object> noPermRoles = new HashSet<Object>(16);
        noPermRoles.addAll(allRolesId);
        noPermRoles.removeAll(hasPermRoles);
        return noPermRoles;
    }

    private static Set<Long> getChargerOrgIds(String userId) {
        ArrayList<Long> userIdList = new ArrayList<Long>(10);
        userIdList.add(Long.valueOf(userId));
        List position = UserServiceHelper.getPosition(userIdList);
        HashSet<Long> charOrgIds = new HashSet<Long>(16);
        for (Object o : position) {
            ArrayList entries = (ArrayList)((HashMap)o).get("entryentity");
            if (entries == null) continue;
            List orgIds = entries.stream().filter(map -> {
                Boolean inCharge = (Boolean)map.get("isincharge");
                DynamicObject org = (DynamicObject)map.get("dpt");
                return org != null && inCharge != false;
            }).map(map -> (DynamicObject)map.get("dpt")).map(org -> Long.valueOf(org.getPkValue().toString())).collect(Collectors.toList());
            List allSubordinateOrgList = OrgServiceHelper.getAllSubordinateOrgs((String)"01", orgIds, (boolean)true);
            charOrgIds.addAll(allSubordinateOrgList);
        }
        return charOrgIds;
    }

    public static List<String> getCloudNumberListProjectRangeBySysParameter() {
        Object parameter = SystemParamHelper.getSystemParameter("pmgtprorange", "pmbs", RequestContext.get().getOrgId());
        List<String> cloudNumberList = new ArrayList<String>(10);
        if (parameter != null) {
            if (parameter instanceof MulBasedataDynamicObjectCollection) {
                MulBasedataDynamicObjectCollection proCloudRanges = (MulBasedataDynamicObjectCollection)parameter;
                cloudNumberList = proCloudRanges.stream().map(cloud -> cloud.getDynamicObject("fbasedataid").getString(NUMBER)).collect(Collectors.toList());
            } else if (parameter instanceof ArrayList) {
                ArrayList proCloudRanges = (ArrayList)parameter;
                for (LinkedHashMap cloud2 : proCloudRanges) {
                    String number = String.valueOf(((LinkedHashMap)cloud2.get("fbasedataid")).get(NUMBER));
                    cloudNumberList.add(number);
                }
            }
        }
        return cloudNumberList;
    }

    public static void buildProjectFilterBySysParameterAndSetCustomParam(List<QFilter> filterList, Map<String, Object> customParams) {
        List<String> cloudNumberList = ProjectPermissionHelper.getCloudNumberListProjectRangeBySysParameter();
        if (cloudNumberList.isEmpty()) {
            DynamicObject[] allCloud = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"number,name", (QFilter[])new QFilter[]{new QFilter(NUMBER, "!=", null)});
            cloudNumberList = Arrays.stream(allCloud).map(cloud -> cloud.getString(NUMBER)).collect(Collectors.toList());
        }
        List<Object> pmgtProjectIdList = ProjectPermissionHelper.getPMGTProjectIdList();
        LOG.info("buildProjectFilterBySysParameterAndSetCustomParam#pmgtProjectIdList:{}", pmgtProjectIdList);
        if (cloudNumberList.contains("PMGT")) {
            filterList.add(new QFilter("id", "in", pmgtProjectIdList));
        } else {
            filterList.add(new QFilter("id", "is null", null));
        }
        List otherCloudList = cloudNumberList.stream().filter(cloud -> !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)cloud, (CharSequence)"PMGT")).collect(Collectors.toList());
        QFilter otherCloudFilter = new QFilter("systemtype", "in", otherCloudList).and("id", "not in", pmgtProjectIdList);
        customParams.put("includeotherclouds", otherCloudFilter.toSerializedString());
        customParams.put(FILTER_LIST_SIZE, filterList.size());
    }

    public static List<ComboItem> buildProjectComboItemsBySysParameter(List<ComboItem> projectComboItems) {
        List projectId = projectComboItems.stream().filter(combo -> kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)combo.getValue())).map(combo -> Long.parseLong(combo.getValue())).collect(Collectors.toList());
        LOG.info("buildProjectComboItemsBySysParameter#projectId:{}", projectId);
        QFilter filter = new QFilter("id", "in", projectId);
        List<String> cloudNumberList = ProjectPermissionHelper.getCloudNumberListProjectRangeBySysParameter();
        if (cloudNumberList.isEmpty()) {
            DynamicObject[] allCloud = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"number,name", (QFilter[])new QFilter[]{new QFilter(NUMBER, "!=", null)});
            cloudNumberList = Arrays.stream(allCloud).map(cloud -> cloud.getString(NUMBER)).collect(Collectors.toList());
        }
        List<Object> pmgtProjectIdList = ProjectPermissionHelper.getPMGTProjectIdList();
        LOG.info("buildProjectComboItemsBySysParameter#pmgtProjectIdList:{}", pmgtProjectIdList);
        if (cloudNumberList.contains("PMGT")) {
            filter.and(new QFilter("id", "in", pmgtProjectIdList));
        } else {
            filter.and(new QFilter("id", "is null", null));
        }
        List otherCloudList = cloudNumberList.stream().filter(cloud -> !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)cloud, (CharSequence)"PMGT")).collect(Collectors.toList());
        QFilter otherCloudFilter = new QFilter("systemtype", "in", otherCloudList).and("id", "not in", pmgtProjectIdList);
        filter.or(otherCloudFilter);
        DynamicObject[] newProject = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"name,systemtype", (QFilter[])new QFilter[]{filter});
        LOG.info("buildProjectComboItemsBySysParameter#newProject:{}", Arrays.stream(newProject).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        return ProjectPermissionHelper.loadProComboItems(newProject);
    }

    public static <T extends AbstractFormPlugin> void validateFilterModeChange(T formPlugin) {
        IPageCache pageCache = formPlugin.getPageCache();
        ListCache listCache = new ListCache(pageCache);
        if (listCache.getFilterMode().isPresent()) {
            Integer newFilterMode = (Integer)listCache.getFilterMode().get();
            String oldFilterMode = pageCache.get("ProjectSysParamPermListPlugin_mode");
            if (oldFilterMode == null) {
                pageCache.put("ProjectSysParamPermListPlugin_mode", newFilterMode.toString());
            } else if (oldFilterMode.equals(newFilterMode.toString())) {
                pageCache.put("ProjectSysParamPermListPlugin_mode_isChange", "false");
            } else {
                pageCache.put("ProjectSysParamPermListPlugin_mode", newFilterMode.toString());
                pageCache.put("ProjectSysParamPermListPlugin_mode_isChange", "true");
            }
        }
    }

    public static <T extends AbstractFormPlugin> List<CommonFilterColumn> getProjectFilter(T formPlugin) {
        FilterContainer filterContainer = (FilterContainer)formPlugin.getControl("filtercontainerap");
        List filterControlList = filterContainer.getItems();
        FilterGridView filterGridView = (FilterGridView)filterControlList.stream().filter(control -> control instanceof FilterGridView).findAny().get();
        List items = filterGridView.getItems();
        List<CommonFilterColumn> projectItems = items.stream().filter(item -> kd.bos.dataentity.utils.StringUtils.equals((CharSequence)((CommonFilterColumn)item).getFilterField().getRefEntityId(), (CharSequence)BD_PROJECT)).map(item -> (CommonFilterColumn)item).collect(Collectors.toList());
        List projectFilterNameList = projectItems.stream().map(FilterColumn::getFilterFieldName).collect(Collectors.toList());
        formPlugin.getPageCache().put("projectFilterControlPageCache", SerializationUtils.toJsonString(projectFilterNameList));
        return projectItems;
    }

    public static <T extends AbstractFormPlugin> void setProjectFilterComboItems(T formPlugin) {
        List<CommonFilterColumn> items = ProjectPermissionHelper.getProjectFilter(formPlugin);
        for (CommonFilterColumn projectFilterItem : items) {
            List pluginList = formPlugin.getView().getFormShowParameter().getFormConfig().getPlugins();
            Optional<Plugin> projectPermPlugin = pluginList.stream().filter(plugin -> kd.bos.dataentity.utils.StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)PROJECT_PERM_LIST_CLASS_NAME)).findAny();
            if (!projectPermPlugin.isPresent()) {
                DynamicObject[] initProjects = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"name", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue())});
                projectFilterItem.setComboItems(ProjectPermissionHelper.loadProComboItems(initProjects));
            }
            List<ComboItem> projectComboItems = projectFilterItem.getComboItems();
            projectComboItems = ProjectPermissionHelper.buildProjectComboItemsBySysParameter(projectComboItems);
            List projectComboIdList = projectComboItems.stream().filter(combo -> kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)combo.getValue())).map(combo -> Long.parseLong(combo.getValue())).collect(Collectors.toList());
            formPlugin.getPageCache().put(projectFilterItem.getFilterFieldName(), SerializationUtils.toJsonString(projectComboIdList));
            projectFilterItem.setComboItems(projectComboItems);
        }
    }

    public static <T extends AbstractFormPlugin> void setProjectFilterDefValue(T formPlugin) {
        List<CommonFilterColumn> items = ProjectPermissionHelper.getProjectFilter(formPlugin);
        for (CommonFilterColumn projectFilterItem : items) {
            if (!projectFilterItem.isMustInput()) continue;
            List projectComboItems = projectFilterItem.getComboItems();
            ComboItem defaultCombo = projectComboItems.stream().filter(combo -> kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)combo.getValue()) && !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)combo.getValue(), (CharSequence)"0")).findAny().get();
            projectFilterItem.setDefaultValues(new Object[]{defaultCombo.getValue()});
        }
    }

    public static QFilter loadHasPermissionOrgByPattern(String orgViewType, String userId, String appId, String entityNum, String permItemId) {
        List<Long> orgList = ProjectPermissionHelper.getAllPermOrgsByPermItem(orgViewType, userId, appId, entityNum, permItemId);
        if (orgList.size() > 0) {
            String patternId = ProjectPermissionHelper.getPatternIdByParam(RequestContext.get().getOrgId(), "orgseparate");
            orgList = ProjectPermissionHelper.getAllSubOrgUnitsByPattern(patternId, orgList, orgViewType);
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (orgList.size() > 0 && !orgList.contains(rootOrgId)) {
            orgList = OrgTreeUtils.getParentByOrgIds(orgList, orgViewType);
        }
        QFilter qFilter = orgList.size() > 0 ? new QFilter("id", "in", orgList) : new QFilter("id", "=", (Object)0L);
        return qFilter;
    }
}

