/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class StageStatusHelper {
    private static final String PROJECTSTATUS = "bd_projectstatus";
    private static final String PROJECTSTAGE = "pmbs_projectstage";
    public static final String NUMBER = "number";

    public static void initProStatus(DynamicObject obj) {
        Object pkValue = obj.getPkValue();
        DynamicObject project = obj.getDynamicObject("pro");
        DynamicObject proKind = obj.getDynamicObject("kind");
        QFilter proKindFilter = new QFilter("projectkind", "=", proKind.getPkValue());
        DynamicObject[] proKindCtrlSettings = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"projectstageentry,projectstage", (QFilter[])new QFilter[]{proKindFilter});
        DynamicObjectCollection stageEntry = null;
        if (proKindCtrlSettings.length > 0) {
            stageEntry = proKindCtrlSettings[0].getDynamicObjectCollection("projectstageentry");
        }
        if (stageEntry != null && !stageEntry.isEmpty()) {
            ArrayList<DynamicObject> proStatusList = new ArrayList<DynamicObject>();
            for (DynamicObject entry : stageEntry) {
                DynamicObject proStatus = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_prostatus"));
                proStatus.set("proapproval", pkValue);
                proStatus.set("project", project != null ? project.getPkValue() : null);
                proStatus.set("projectstage", entry.getDynamicObject("projectstage").getPkValue());
                proStatus.set("stagename", (Object)entry.getDynamicObject("projectstage").getString("name"));
                proStatus.set("projectstatus", null);
                proStatus.set("statuspercent", null);
                proStatusList.add(proStatus);
            }
            SaveServiceHelper.save((DynamicObject[])proStatusList.toArray(new DynamicObject[0]));
        }
    }

    public static void changeStatusByApp(DynamicObject proApprove, ProjectStageEnum stage, ProjectStatusEnum status) {
        QFilter proStageFilter;
        QFilter projectApprovalFilter;
        DynamicObject[] stageStatus;
        DynamicObject proStage = null;
        if (stage != null) {
            proStage = BusinessDataServiceHelper.loadSingle((Object)stage.getId(), (String)PROJECTSTAGE);
        }
        DynamicObject proStatus = null;
        if (status != null) {
            proStatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        if ((stageStatus = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval, statuspercent", (QFilter[])new QFilter[]{projectApprovalFilter = new QFilter("proapproval", "=", proApprove.getPkValue()), proStageFilter = new QFilter("projectstage", "=", proStage == null ? null : proStage.getPkValue())})) != null && stageStatus.length > 0) {
            stageStatus[0].set("projectstatus", proStatus == null ? null : proStatus.getPkValue());
            stageStatus[0].set("statuspercent", (Object)StageStatusHelper.proStage2Percent(status));
            SaveServiceHelper.save((DynamicObject[])stageStatus);
        }
    }

    public static void relateProject(DynamicObject obj) {
        Object pkValue = obj.getPkValue();
        DynamicObject project = obj.getDynamicObject("pro");
        QFilter projectFilter = new QFilter("proapproval", "=", pkValue);
        DynamicObject[] stageStatusArray = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval, statuspercent", (QFilter[])new QFilter[]{projectFilter});
        if (stageStatusArray != null && stageStatusArray.length > 0) {
            for (DynamicObject stageStatus : stageStatusArray) {
                stageStatus.set("project", project.getPkValue());
            }
            SaveServiceHelper.save((DynamicObject[])stageStatusArray);
        }
    }

    public static void changeStatus(DynamicObject project, ProjectStageEnum stage, ProjectStatusEnum status) {
        StageStatusHelper.doChangeStatus(project, stage, status, true);
    }

    public static void changeStatus(DynamicObject project, ProjectStageEnum stage, ProjectStatusEnum status, boolean needUpdatePercent) {
        StageStatusHelper.doChangeStatus(project, stage, status, needUpdatePercent);
    }

    private static void doChangeStatus(DynamicObject project, ProjectStageEnum stage, ProjectStatusEnum status, boolean needUpdatePercent) {
        QFilter proStageFilter;
        QFilter projectFilter;
        DynamicObject[] stageStatus;
        DynamicObject prostage = null;
        if (stage != null) {
            prostage = BusinessDataServiceHelper.loadSingle((Object)stage.getId(), (String)PROJECTSTAGE);
        }
        DynamicObject proStatus = null;
        if (status != null) {
            proStatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        if ((stageStatus = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval, statuspercent", (QFilter[])new QFilter[]{projectFilter = new QFilter("project", "=", project.getPkValue()), proStageFilter = new QFilter("projectstage", "=", prostage == null ? null : prostage.getPkValue())})) != null && stageStatus.length > 0) {
            stageStatus[0].set("projectstatus", proStatus == null ? null : proStatus.getPkValue());
            if (needUpdatePercent) {
                stageStatus[0].set("statuspercent", (Object)StageStatusHelper.proStage2Percent(status));
                StageStatusHelper.updateWbsSchedule(project, stageStatus[0]);
            }
            SaveServiceHelper.save((DynamicObject[])stageStatus);
        }
    }

    public static void updateWbsSchedule(DynamicObject project, DynamicObject proStatus) {
        if (proStatus == null) {
            return;
        }
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter proStageFilter = new QFilter("projectstatus", "=", proStatus.getPkValue());
        String selectProperties = String.join((CharSequence)",", "schedule");
        DynamicObject wbs = BusinessDataServiceHelper.loadSingle((String)"pmbs_wbs", (String)selectProperties, (QFilter[])new QFilter[]{projectFilter, proStageFilter});
        if (wbs == null) {
            return;
        }
        wbs.set("schedule", (Object)proStatus.getBigDecimal("statuspercent"));
        SaveServiceHelper.update((DynamicObject)wbs);
    }

    public static BigDecimal proStage2Percent(ProjectStatusEnum status) {
        BigDecimal statusPercent = BigDecimal.ZERO;
        if (status != null) {
            statusPercent = status == ProjectStatusEnum.APPROVAL_SUCC || status == ProjectStatusEnum.BUSSINESS_CLOSE ? BigDecimal.valueOf(100L) : (status == ProjectStatusEnum.APPROVAL_IN ? BigDecimal.valueOf(50L) : BigDecimal.valueOf(30L));
        }
        return statusPercent;
    }

    @Deprecated
    public static void changeProStatus(DynamicObject project, ProjectStatusEnum status, String reason) {
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        StageStatusHelper.modifyStatus(project, reason, prostatus);
    }

    public static void changeProStatus(DynamicObject project, DynamicObject status, String reason) {
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getPkValue(), (String)PROJECTSTATUS);
        }
        StageStatusHelper.modifyStatus(project, reason, prostatus);
    }

    public static void modifyStatus(DynamicObject project, String reason, DynamicObject prostatus) {
        DynamicObject pro = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
        pro.set("prostatus", prostatus == null ? null : prostatus.getPkValue());
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pro});
            }
            catch (Exception e1) {
                h.markRollback();
                throw e1;
            }
        }
        QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
        DynamicObject[] projectApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,prostatus,changereason", (QFilter[])new QFilter[]{projectFilter});
        if (projectApp != null && projectApp.length > 0) {
            projectApp[0].set("prostatus", prostatus == null ? null : prostatus.getPkValue());
            projectApp[0].set("changereason", (Object)reason);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectApp[0]});
        }
    }

    public static void changeStatusList(List<DynamicObject> projectList, ProjectStageEnum stage, ProjectStatusEnum status) {
        DynamicObject prostage = null;
        if (stage != null) {
            prostage = BusinessDataServiceHelper.loadSingle((Object)stage.getId(), (String)PROJECTSTAGE);
        }
        DynamicObject proStatus = null;
        if (status != null) {
            proStatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        for (DynamicObject project : projectList) {
            QFilter proStageFilter;
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            DynamicObject[] stageStatus = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval, statuspercent", (QFilter[])new QFilter[]{projectFilter, proStageFilter = new QFilter("projectstage", "=", prostage == null ? null : prostage.getPkValue())});
            if (stageStatus == null || stageStatus.length <= 0) continue;
            stageStatus[0].set("projectstatus", proStatus == null ? null : proStatus.getPkValue());
            stageStatus[0].set("statuspercent", (Object)StageStatusHelper.proStage2Percent(status));
            SaveServiceHelper.save((DynamicObject[])stageStatus);
            StageStatusHelper.updateWbsSchedule(project, stageStatus[0]);
        }
    }

    public static void changeProStatusList(List<DynamicObject> projectList, ProjectStatusEnum status, String reason) {
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        for (DynamicObject project : projectList) {
            StageStatusHelper.modifyStatus(project, reason, prostatus);
        }
    }

    public static void afterUpdateStatusPercent(String currentFormId, DynamicObject projectStatus) {
        DynamicObject[] wbsArray;
        if (projectStatus == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)currentFormId)) {
            return;
        }
        BigDecimal statusPercent = projectStatus.getBigDecimal("statuspercent");
        QFilter projectFilter = new QFilter("project", "=", projectStatus.getDynamicObject("project").getPkValue());
        QFilter projectStatusFilter = new QFilter("projectstatus", "=", projectStatus.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        String selectProperties = String.join((CharSequence)",", "schedule");
        for (DynamicObject wbs : wbsArray = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)selectProperties, (QFilter[])new QFilter[]{projectFilter, projectStatusFilter, statusFilter})) {
            wbs.set("schedule", (Object)statusPercent);
        }
        if (wbsArray.length > 0) {
            SaveServiceHelper.update((DynamicObject[])wbsArray);
        }
    }

    public boolean statusPercentChanged(DynamicObject projectStatus, BigDecimal percent) {
        if (percent == null) {
            percent = BigDecimal.ZERO;
        }
        if (projectStatus != null) {
            return (projectStatus = BusinessDataServiceHelper.loadSingle((Object)projectStatus.getPkValue(), (String)"pmas_prostatus")).getBigDecimal("statuspercent").compareTo(percent) != 0;
        }
        return false;
    }
}

