/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.coderule.CodeRuleHelper;

public class SynFunSourceHelper {
    private static final Log logger = LogFactory.getLog(SynFunSourceHelper.class);

    public static void createFunSource(DynamicObject bill, Date year, String formId) {
        DynamicObjectCollection sourceCollection = null;
        BigDecimal sourceAmount = BigDecimal.ZERO;
        DynamicObject project = null;
        DynamicObject org = null;
        if ("pmas_pro_approval".equals(formId)) {
            sourceCollection = bill.getDynamicObjectCollection("fundsourceentry");
            sourceAmount = bill.getBigDecimal("sourceamount");
            project = bill.getDynamicObject("pro");
            org = bill.getDynamicObject("org");
        } else if ("pmim_invesclaimtrecord".equals(formId)) {
            sourceCollection = bill.getDynamicObjectCollection("investentry");
            sourceAmount = bill.getBigDecimal("entryinvestamt");
            project = bill.getDynamicObject("project");
            org = bill.getDynamicObject("specialorg");
        }
        if (sourceCollection != null && !sourceCollection.isEmpty() && sourceAmount.compareTo(BigDecimal.ZERO) != 0 && project != null) {
            BigDecimal curInvestamt;
            BigDecimal amount;
            DynamicObject source = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projfundsource"));
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            source.set("project", (Object)project);
            source.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s_\u8d44\u91d1\u6765\u6e90", (String)"SynFunSourceHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]), project.get("name")));
            source.set("org", (Object)org);
            source.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            source.set("projkind", project.get("group"));
            source.set("issys", (Object)DefaultEnum.YES.getValue());
            source.set("isvalid", (Object)DefaultEnum.YES.getValue());
            source.set("type", (Object)BillTypeEnum.NEW.getValue());
            source.set("version", (Object)1.0);
            if ("pmim_invesclaimtrecord".equals(formId)) {
                amount = sourceCollection.stream().map(obj -> obj.getBigDecimal("entryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                curInvestamt = sourceCollection.stream().map(obj -> obj.getBigDecimal("currententryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                source.set("totalamount", (Object)amount);
                source.set("curinvestamt", (Object)curInvestamt);
                DynamicObject approvePro = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "budgetperiod", "budgetproname", "budgetpronumber", "currencyfield"), (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()))});
                source.set("budgetperiod", approvePro.get("budgetperiod"));
                source.set("budgetproname", approvePro.get("budgetproname"));
                source.set("budgetpronumber", approvePro.get("budgetpronumber"));
                source.set("currency", approvePro.get("currencyfield"));
                source.set("createorg", (Object)org);
                DynamicObject investPlanBill = null;
                String billId = bill.getString("billid");
                if (QueryServiceHelper.exists((String)"pmim_investplanclaim", (Object)billId)) {
                    investPlanBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_investplanclaim");
                } else if (QueryServiceHelper.exists((String)"pmim_specialapproval", (Object)billId)) {
                    investPlanBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_specialapproval");
                }
                if (investPlanBill != null) {
                    source.set("creator", investPlanBill.get("creator"));
                    source.set("createtime", investPlanBill.get("createtime"));
                    source.set("modifier", investPlanBill.get("modifier"));
                    source.set("modifytime", (Object)investPlanBill.getDate("modifytime"));
                    if (!investPlanBill.getString("billstatus").equals(StatusEnum.CHECKED.getValue())) {
                        source.set("auditdate", (Object)new Date());
                        source.set("auditor", (Object)RequestContext.get().getCurrUserId());
                    } else {
                        source.set("auditdate", (Object)investPlanBill.getDate("auditdate"));
                        source.set("auditor", investPlanBill.get("auditor"));
                    }
                }
            } else {
                amount = sourceCollection.stream().map(obj -> obj.getBigDecimal("sumamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                curInvestamt = sourceCollection.stream().map(obj -> obj.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                source.set("totalamount", (Object)amount);
                source.set("curinvestamt", (Object)curInvestamt);
                source.set("createorg", bill.get("createorg"));
                source.set("budgetperiod", bill.get("budgetperiod"));
                source.set("budgetproname", bill.get("budgetproname"));
                source.set("budgetpronumber", bill.get("budgetpronumber"));
                source.set("currency", bill.get("currencyfield"));
                source.set("createtime", (Object)bill.getDate("auditdate"));
                source.set("creator", bill.get("creator"));
                source.set("auditor", bill.get("auditor"));
                source.set("auditdate", (Object)bill.getDate("auditdate"));
                source.set("modifier", bill.get("modifier"));
                source.set("modifytime", (Object)bill.getDate("modifytime"));
            }
            if (year != null) {
                LocalDate localDate = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    source.set("year", (Object)sdf.parse(localDate.getYear() + "-01-01"));
                }
                catch (ParseException e) {
                    logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e);
                }
            }
            if (org != null) {
                String billNo = CodeRuleHelper.getBillNo("pmas_projfundsource", source, org.getPkValue().toString());
                if (StringUtils.isEmpty((CharSequence)billNo)) {
                    billNo = project.get("number") + "_FUND";
                }
                source.set("billno", (Object)billNo);
            }
            DynamicObjectCollection funSourceCollection = source.getDynamicObjectCollection("fundentry");
            for (DynamicObject funSource : sourceCollection) {
                DynamicObject sourceEntry = funSourceCollection.addNew();
                if ("pmas_pro_approval".equals(formId)) {
                    sourceEntry.set("sourcetype", (Object)funSource.getDynamicObject("sourcetype"));
                    sourceEntry.set("amount", (Object)funSource.getBigDecimal("sumamount"));
                    sourceEntry.set("currententryamt", (Object)funSource.getBigDecimal("amount"));
                    sourceEntry.set("note", (Object)funSource.getString("funddescription"));
                    sourceEntry.set("formofinvest", (Object)funSource.getString("formofinvest"));
                    sourceEntry.set("investcurrency", (Object)funSource.getDynamicObject("currency"));
                    sourceEntry.set("scale", (Object)funSource.getBigDecimal("scale"));
                    continue;
                }
                sourceEntry.set("sourcetype", (Object)funSource.getDynamicObject("fundsourcetype"));
                sourceEntry.set("amount", (Object)funSource.getBigDecimal("entryamt"));
                sourceEntry.set("note", (Object)funSource.getString("comment"));
                sourceEntry.set("formofinvest", (Object)funSource.getString("formofinvest"));
                sourceEntry.set("investcurrency", (Object)funSource.getDynamicObject("investcurrency"));
                sourceEntry.set("scale", (Object)funSource.getBigDecimal("scale"));
                sourceEntry.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
        }
    }

    public static void deleteFunSource(DynamicObject project, Date yearPeriod) {
        HashSet deleteFunSources = new HashSet();
        LocalDate localDate = yearPeriod.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)localDate.getYear());
        qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        DynamicObject[] oldFunSources = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (oldFunSources.length > 0) {
            Arrays.stream(oldFunSources).forEach(item -> deleteFunSources.add(Long.parseLong(item.getPkValue().toString())));
        }
        QFilter idFilter = new QFilter("id", "in", deleteFunSources);
        DeleteServiceHelper.delete((String)"pmas_projfundsource", (QFilter[])idFilter.toArray());
    }
}

