/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.pmgt.pmbs.common.enums.DefaultEnum;

public class TextHelper {
    private static Pattern cellphonePattern = Pattern.compile("(1|861)([0-9])\\d{9}$*");
    private static Pattern telphonePattern = Pattern.compile("([0-9]{3,4}-)?([0-9]{7,8})");
    private static Pattern bankNumPattern = Pattern.compile("([1-9]{1})(([0-9])\\d{8,30})");
    private static Pattern chinesePattern = Pattern.compile("[\u4e00-\u9fa5]");

    public static String getPhoneNum(String text, DefaultEnum isCellphone) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        Matcher matcher = DefaultEnum.YES.getValue().equals(isCellphone.getValue()) ? cellphonePattern.matcher(text) : telphonePattern.matcher(text);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group()).append(',');
        }
        int len = sb.length();
        if (len > 0) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    public static String getPhoneNum(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        String phoneNum = TextHelper.getPhoneNum(text, DefaultEnum.YES);
        if (StringUtils.isBlank((CharSequence)phoneNum)) {
            phoneNum = TextHelper.getPhoneNum(text, DefaultEnum.NO);
        }
        return phoneNum;
    }

    public static String getAddress(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        String phoneNum = TextHelper.getPhoneNum(text);
        return text.replaceAll(phoneNum, "");
    }

    public static String getBankNum(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        Matcher matcher = bankNumPattern.matcher(text);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group()).append(',');
        }
        int len = sb.length();
        if (len > 0) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    public static String getBankName(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        String bankNum = TextHelper.getBankNum(text);
        return text.replaceAll(bankNum, "");
    }

    public static boolean containChinese(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return false;
        }
        Matcher matcher = chinesePattern.matcher(text);
        return matcher.find();
    }
}

