/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.budget;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import org.jetbrains.annotations.NotNull;

public class BudgetItemCheckHelper {
    private static final Log log = LogFactory.getLog(BudgetItemCheckHelper.class);

    @Deprecated
    public static boolean isPreparedToDelete(PerformBillInfo billInfo, DynamicObject contractBudget) {
        long contractId;
        long billId = billInfo.getId();
        if (billId == (contractId = Long.parseLong(billInfo.getContractId()))) {
            return true;
        }
        long budgetItemId = contractBudget.getDynamicObject("budgetitem").getLong("id");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_contracttpl");
        String payDirection = contract.getString("paydirection");
        String formId = StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "pmct_outcontract" : "pmct_incontract";
        boolean referenceByContract = BudgetItemCheckHelper.containsInContractBills(contract, budgetItemId, formId);
        formId = StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "pmct_outcontractrevision" : "pmct_incontractrevision";
        QFilter[] billFilters = BudgetItemCheckHelper.buildFilter(billInfo, formId);
        boolean referenceByRevisionBill = BudgetItemCheckHelper.containsRevisionContractBills(billFilters, budgetItemId, formId);
        formId = StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "pmct_outclaimbill" : "pmct_inclaimbill";
        billFilters = BudgetItemCheckHelper.buildFilter(billInfo, formId);
        boolean referenceByClaimBill = BudgetItemCheckHelper.containsClaimContractBills(billFilters, budgetItemId, formId);
        formId = StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "pmct_outaddagreement" : "pmct_inaddagreement";
        billFilters = BudgetItemCheckHelper.buildFilter(billInfo, formId);
        boolean referenceByAdditionBill = BudgetItemCheckHelper.containsInAdditionContractBills(billFilters, budgetItemId, formId);
        formId = StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "pmct_outcontract_settle" : "pmct_incontract_settle";
        billFilters = BudgetItemCheckHelper.buildFilter(billInfo, formId);
        boolean referenceBySettleBill = BudgetItemCheckHelper.containsSettleContractBills(billFilters, budgetItemId, formId);
        formId = StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "pmct_paymentapply" : "pmct_incomeapply";
        billFilters = BudgetItemCheckHelper.buildApplyFilter(billInfo, contract, formId);
        boolean referenceByApplyBill = BudgetItemCheckHelper.containsApplyBills(billFilters, budgetItemId, formId);
        log.info("isPreparedToDelete referenceByContract: {} ,referenceByRevisionBill: {}, referenceByClaimBill: {}, referenceByAdditionBill: {}, referenceBySettleBill: {}, referenceByApplyBill: {}", new Object[]{referenceByContract, referenceByRevisionBill, referenceByClaimBill, referenceByAdditionBill, referenceBySettleBill, referenceByApplyBill});
        return !referenceByContract && !referenceByRevisionBill && !referenceByClaimBill && !referenceByAdditionBill && !referenceBySettleBill && !referenceByApplyBill;
    }

    @NotNull
    private static QFilter[] buildFilter(PerformBillInfo billInfo, String currentFormId) {
        long billId = billInfo.getId();
        String formBillId = billInfo.getFormBillId();
        Long contractId = Long.parseLong(billInfo.getContractId());
        QFilter contractFilter = new QFilter("contract", "=", (Object)contractId);
        QFilter notCurrentBillFilter = new QFilter("id", "!=", (Object)billId);
        QFilter billStatusBillFilter = new QFilter("billstatus", "in", Arrays.asList(StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()));
        QFilter[] billFilters = StringUtils.equals((CharSequence)currentFormId, (CharSequence)formBillId) ? new QFilter[]{contractFilter, notCurrentBillFilter, billStatusBillFilter} : new QFilter[]{contractFilter, billStatusBillFilter};
        return billFilters;
    }

    @NotNull
    private static QFilter[] buildApplyFilter(PerformBillInfo billInfo, DynamicObject contract, String currentFormId) {
        long billId = billInfo.getId();
        String formBillId = billInfo.getContractId();
        QFilter projectFilter = new QFilter("project", "=", contract.getDynamicObject("project").getPkValue());
        QFilter notCurrentBillFilter = new QFilter("id", "!=", (Object)billId);
        QFilter billStatusBillFilter = new QFilter("billstatus", "in", Arrays.asList(StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()));
        QFilter[] billFilters = StringUtils.equals((CharSequence)currentFormId, (CharSequence)formBillId) ? new QFilter[]{projectFilter, notCurrentBillFilter, billStatusBillFilter} : new QFilter[]{projectFilter, billStatusBillFilter};
        return billFilters;
    }

    private static boolean containsInContractBills(DynamicObject contract, long budgetItemId, String formId) {
        String budgetItemProperty = BudgetItemCheckHelper.getBudgetItemPropertyInContract(contract);
        QFilter pkFilter = new QFilter("id", "=", contract.getPkValue());
        QFilter budgetItemIdFilter = new QFilter(budgetItemProperty, "=", (Object)budgetItemId);
        contract = BusinessDataServiceHelper.loadSingle((String)formId, (String)"", (QFilter[])new QFilter[]{pkFilter, budgetItemIdFilter});
        return contract != null;
    }

    private static boolean containsRevisionContractBills(QFilter[] billFilters, long budgetItemId, String formId) {
        DynamicObject[] contractRevisionBills;
        String selectProperties = "isbasedonlist";
        for (DynamicObject contractRevisionBill : contractRevisionBills = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])billFilters)) {
            QFilter idsFilter = new QFilter("id", "=", contractRevisionBill.getPkValue());
            String budgetItemProperty = BudgetItemCheckHelper.getBudgetItemPropertyInRevisionContract(contractRevisionBill);
            QFilter budgetItemIdFilter = new QFilter(budgetItemProperty, "=", (Object)budgetItemId);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)formId, (String)"", (QFilter[])new QFilter[]{idsFilter, budgetItemIdFilter});
            if (bill == null) continue;
            return true;
        }
        return false;
    }

    private static boolean containsClaimContractBills(QFilter[] billFilters, long budgetItemId, String formId) {
        DynamicObject[] claimBills;
        String selectProperties = "contract, contract.isonlist, isneedsettle";
        for (DynamicObject claimBill : claimBills = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])billFilters)) {
            QFilter idsFilter = new QFilter("id", "=", claimBill.getPkValue());
            String budgetItemProperty = BudgetItemCheckHelper.getBudgetItemPropertyInClaimContract(claimBill);
            QFilter budgetItemIdFilter = new QFilter(budgetItemProperty, "=", (Object)budgetItemId);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)formId, (String)"", (QFilter[])new QFilter[]{idsFilter, budgetItemIdFilter});
            if (bill == null) continue;
            return true;
        }
        return false;
    }

    private static boolean containsInAdditionContractBills(QFilter[] billFilters, long budgetItemId, String formId) {
        DynamicObject[] additionBills;
        String selectProperties = "contract, contract.isonlist";
        for (DynamicObject additionBill : additionBills = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])billFilters)) {
            QFilter idsFilter = new QFilter("id", "=", additionBill.getPkValue());
            String budgetItemProperty = BudgetItemCheckHelper.getBudgetItemPropertyInAdditionContract(additionBill);
            QFilter budgetItemIdFilter = new QFilter(budgetItemProperty, "=", (Object)budgetItemId);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)formId, (String)"", (QFilter[])new QFilter[]{idsFilter, budgetItemIdFilter});
            if (bill == null) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSettleContractBills(QFilter[] billFilters, long budgetItemId, String formId) {
        DynamicObject[] settleBills;
        String selectProperties = "contract, contract.isonlist";
        for (DynamicObject settleBill : settleBills = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])billFilters)) {
            QFilter idsFilter = new QFilter("id", "=", settleBill.getPkValue());
            QFilter budgetItemIdFilter = new QFilter("listmodelentry.listentry.outbudget", "=", (Object)budgetItemId).or(new QFilter("itementry.paybudgetitem", "=", (Object)budgetItemId)).or(new QFilter("payitemdetailentry.detailbudgetitem", "=", (Object)budgetItemId));
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)formId, (String)"", (QFilter[])new QFilter[]{idsFilter, budgetItemIdFilter});
            if (bill == null) continue;
            return true;
        }
        return false;
    }

    private static boolean containsApplyBills(QFilter[] billFilters, long budgetItemId, String formId) {
        DynamicObject[] applyBills;
        String selectProperties = "entryentity";
        for (DynamicObject applyBill : applyBills = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])billFilters)) {
            applyBill = BusinessDataServiceHelper.loadSingle((Object)applyBill.getPkValue(), (String)formId);
            String splitProperty = BudgetItemCheckHelper.getSplitPropertyInApplyContract(formId);
            int referenceCount = (int)applyBill.getDynamicObjectCollection("entryentity").stream().map(entity -> entity.getDynamicObjectCollection(splitProperty)).flatMap(Collection::stream).map(it -> it.getDynamicObject("budgetitem")).map(DataEntityBase::getPkValue).filter(Objects::nonNull).filter(pk -> Long.parseLong(pk.toString()) == budgetItemId).count();
            if (referenceCount <= 0) continue;
            return true;
        }
        return false;
    }

    private static String getBudgetItemPropertyInContract(DynamicObject bill) {
        boolean isOnList = bill.getBoolean("isonlist");
        if (isOnList) {
            return "listmodelentry.sublistentry.listingbudgetitem";
        }
        return "budgetitem";
    }

    private static String getBudgetItemPropertyInRevisionContract(DynamicObject bill) {
        boolean isOnList = bill.getBoolean("isbasedonlist");
        if (isOnList) {
            return "kapianentry.entryentity.listingbudgetitem";
        }
        return "budgetitem";
    }

    private static String getBudgetItemPropertyInClaimContract(DynamicObject bill) {
        boolean isOnList = bill.getDynamicObject("contract").getBoolean("isonlist");
        boolean isNeedSettle = bill.getBoolean("isneedsettle");
        if (isOnList && isNeedSettle) {
            return "kapianentry.entryentity.listingbudgetitem";
        }
        return "budgetitem";
    }

    private static String getSplitPropertyInApplyContract(String formId) {
        if ("pmct_paymentapply".equals(formId)) {
            return "payapplysplitentry";
        }
        return "inapplysplitentry";
    }

    private static String getBudgetItemPropertyInAdditionContract(DynamicObject bill) {
        boolean isOnList = bill.getDynamicObject("contract").getBoolean("isonlist");
        if (isOnList) {
            return "cardentry.entryentity.listingbudgetitem";
        }
        return "budgetitem";
    }
}

