/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.budget;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.PerformTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;

public class BudgetValidateAndUpdateHelper {
    private static final Log logger = LogFactory.getLog(BudgetValidateAndUpdateHelper.class);
    private static final String SUFFIX = "ex";

    public static BudgetValidateInfo validateBudgetAmountOnSubmit(Map<String, BigDecimal> proBudgetAmountMap, String contractId, PerformAmountTypeEnum performAmountType) {
        return BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmitAndUnSubmit(proBudgetAmountMap, contractId, performAmountType, false);
    }

    public static BudgetValidateInfo validateBudgetAmountOnUnSubmit(Map<String, BigDecimal> proBudgetAmountMap, String contractId, PerformAmountTypeEnum performAmountType) {
        return BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmitAndUnSubmit(proBudgetAmountMap, contractId, performAmountType, true);
    }

    public static BudgetValidateInfo validateBudgetAmountOnSubmitAndUnSubmit(Map<String, BigDecimal> proBudgetAmountMap, String contractId, PerformAmountTypeEnum performAmountType, boolean isDedcut) {
        if (proBudgetAmountMap != null && !proBudgetAmountMap.isEmpty()) {
            Map<String, DynamicObject> contractBudgetMap = BudgetValidateAndUpdateHelper.getContractBudgets(contractId, proBudgetAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>();
            HashMap<String, DynamicObject> proBudgetMap = new HashMap<String, DynamicObject>();
            BudgetValidateAndUpdateHelper.loadAllBudget(proBudgetMap, proBudgetAmountMap.keySet());
            String amountFormId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(performAmountType);
            for (Map.Entry<String, BigDecimal> amountEntry : proBudgetAmountMap.entrySet()) {
                BigDecimal budgetAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(amountEntry.getValue());
                budgetAmount = isDedcut ? budgetAmount.multiply(BigDecimal.valueOf(-1L)) : budgetAmount;
                DynamicObject contractBudget = contractBudgetMap.get(amountEntry.getKey());
                BigDecimal submitAmount = BigDecimal.ZERO;
                BigDecimal occupyAmount = BigDecimal.ZERO;
                if (contractBudget != null) {
                    submitAmount = contractBudget.getBigDecimal(amountFormId);
                    occupyAmount = contractBudget.getBigDecimal("occupyamt");
                }
                if (submitAmount.add(budgetAmount).compareTo(occupyAmount) <= 0) continue;
                updateBudgetAmountMap.put(amountEntry.getKey(), submitAmount.add(budgetAmount).subtract(occupyAmount));
            }
            return BudgetValidateAndUpdateHelper.validateProjectBudget(proBudgetAmountMap.keySet(), updateBudgetAmountMap, proBudgetMap);
        }
        return null;
    }

    public static BudgetValidateInfo validateBudgetAmountOnAuditAndUnaudit(Map<String, BigDecimal> budgetAmountMap, String contractId, long billId, String formBillId, PerformAmountTypeEnum performAmountType, boolean isDedcut) {
        if (budgetAmountMap != null && !budgetAmountMap.isEmpty()) {
            String amountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(performAmountType);
            Map<String, DynamicObject> contractBudgetMap = BudgetValidateAndUpdateHelper.getContractBudgets(contractId, budgetAmountMap.keySet());
            HashMap updateBudgetAmountMap = Maps.newHashMapWithExpectedSize((int)budgetAmountMap.size());
            HashMap<String, DynamicObject> budgetMap = new HashMap<String, DynamicObject>();
            BudgetValidateAndUpdateHelper.loadAllBudget(budgetMap, budgetAmountMap.keySet());
            for (Map.Entry<String, BigDecimal> amountEntry : budgetAmountMap.entrySet()) {
                DynamicObject contractBudget = contractBudgetMap.get(amountEntry.getKey());
                BigDecimal submitAmount = BigDecimal.ZERO;
                BigDecimal occupyAmount = BigDecimal.ZERO;
                if (contractBudget != null) {
                    submitAmount = contractBudget.getBigDecimal(amountId);
                    occupyAmount = contractBudget.getBigDecimal("occupyamt");
                }
                BigDecimal budgetAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(amountEntry.getValue());
                budgetAmount = isDedcut ? budgetAmount.multiply(BigDecimal.valueOf(-1L)) : budgetAmount;
                DynamicObject budgetPerform = (DynamicObject)budgetMap.get(amountEntry.getKey());
                DynamicObject entry = BudgetValidateAndUpdateHelper.getBillPerformEntry(budgetPerform, billId, contractId, BudgetValidateAndUpdateHelper.getBillType(formBillId));
                if (entry != null && !isDedcut) {
                    BigDecimal entryBillAmount = entry.getBigDecimal("billamt");
                    budgetAmount = budgetAmount.subtract(entryBillAmount);
                }
                if (submitAmount.add(budgetAmount).compareTo(occupyAmount) <= 0) continue;
                updateBudgetAmountMap.put(amountEntry.getKey(), submitAmount.add(budgetAmount).subtract(occupyAmount));
            }
            return BudgetValidateAndUpdateHelper.validateProjectBudget(budgetAmountMap.keySet(), updateBudgetAmountMap, budgetMap);
        }
        return null;
    }

    public static void updateBudgetOnSubmit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, PerformBillInfo billInfo) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            Map<String, DynamicObject> contractBudgets = BudgetValidateAndUpdateHelper.getContractBudgets(billInfo.getContractId(), projectAmountMap.keySet());
            HashMap<String, DynamicObject> newContractBudgets = new HashMap<String, DynamicObject>();
            HashMap<String, DynamicObject> projectBudgetPerformMap = new HashMap<String, DynamicObject>();
            BudgetValidateAndUpdateHelper.loadAllBudget(projectBudgetPerformMap, projectAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>();
            DynamicObject billType = BudgetValidateAndUpdateHelper.getBillType(billInfo.getFormBillId());
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                BigDecimal amountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractAmountMap.get(budgetItemId));
                DynamicObject contractBudget = contractBudgets.get(budgetItemId);
                DynamicObject budgetItem = (DynamicObject)newContractBudgets.get(budgetItemId);
                if (contractBudget == null && budgetItem != null) {
                    contractBudget = budgetItem;
                } else if (contractBudget == null) {
                    contractBudget = BudgetValidateAndUpdateHelper.newContractBudget(budgetItemId, billInfo.getContractId());
                    newContractBudgets.put(budgetItemId, contractBudget);
                }
                String submitAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(billInfo.getAmountType());
                BigDecimal submitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId));
                BigDecimal submitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId + SUFFIX));
                BigDecimal totalSubmitAmount = submitAmount.add(amount);
                BigDecimal totalSubmitAmountEx = submitAmountEx.add(amountEx);
                contractBudget.set(submitAmountId, (Object)totalSubmitAmount);
                contractBudget.set(submitAmountId + SUFFIX, (Object)totalSubmitAmountEx);
                DynamicObject projectBudget = (DynamicObject)projectBudgetPerformMap.get(budgetItemId);
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                DynamicObject performDetail = new DynamicObject(performEntry.getDynamicObjectType());
                if (billInfo.getContractCurrency() != null) {
                    performDetail.set("contractcurrency", (Object)billInfo.getContractCurrency());
                }
                BudgetValidateAndUpdateHelper.updatePerformDetail(performDetail, amount, amountEx, billType, StatusEnum.UNCHECKED.getValue(), PerformTypeEnum.NOTOCCUPY.getValue(), billInfo);
                performEntry.add((Object)performDetail);
                BigDecimal occupyAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("occupyamt"));
                PerformAmountTypeEnum occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByProjectBudget(projectBudget, billInfo.getContractId());
                if (totalSubmitAmount.compareTo(occupyAmount) > 0) {
                    contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                    contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                    BudgetValidateAndUpdateHelper.updatePerformType(performEntry, billInfo.getAmountType(), billInfo.getContractId(), 0L, null, false);
                    updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                } else if (totalSubmitAmount.compareTo(occupyAmount) < 0) {
                    String newOccupyAmountId;
                    occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByContractBudget(performEntry, contractBudget, billInfo.getAmountType(), billInfo.getFormBillId());
                    if (occupyAmountType != null) {
                        if (!StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)billInfo.getAmountType().getValue())) {
                            newOccupyAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(occupyAmountType);
                            totalSubmitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId));
                            totalSubmitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId + SUFFIX));
                        }
                        BudgetValidateAndUpdateHelper.updatePerformType(performEntry, occupyAmountType, billInfo.getContractId(), 0L, null, false);
                        contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                        contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                        updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                    } else {
                        if (occupyAmountType != null && !StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)billInfo.getAmountType().getValue())) {
                            newOccupyAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(occupyAmountType);
                            totalSubmitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId));
                            totalSubmitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId + SUFFIX));
                        }
                        BudgetValidateAndUpdateHelper.updatePerformType(performEntry, occupyAmountType, billInfo.getContractId(), 0L, null, false);
                        contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                        contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                        updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                    }
                }
                Object projectPk = projectBudget.getDynamicObject("project").getPkValue();
                QFilter projectFilter = new QFilter("pro", "=", projectPk);
                QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"currencyfield", (QFilter[])new QFilter[]{projectFilter, statusFilter});
                if (projectApproval != null) {
                    contractBudget.set("projectcurrency", (Object)projectApproval.getDynamicObject("currencyfield"));
                } else {
                    contractBudget.set("projectcurrency", (Object)billInfo.getContractCurrency());
                }
                contractBudget.set("contractcurrency", (Object)billInfo.getContractCurrency());
            }
            if (!updateBudgetAmountMap.isEmpty()) {
                BudgetValidateAndUpdateHelper.summaryOccupyAmountToParent(projectBudgetPerformMap, updateBudgetAmountMap);
            }
            if (!projectBudgetPerformMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetPerformMap.values().toArray(new DynamicObject[0]));
            }
            if (!contractBudgets.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])contractBudgets.values().toArray(new DynamicObject[0]));
            }
            if (!newContractBudgets.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])newContractBudgets.values().toArray(new DynamicObject[0]));
            }
        }
    }

    public static void updateBudgetOnUnsubmit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, PerformBillInfo billInfo) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            Map<String, DynamicObject> contractBudgets = BudgetValidateAndUpdateHelper.getContractBudgets(billInfo.getContractId(), projectAmountMap.keySet());
            logger.info("updateBudgetOnUnsubmit contractBudgets:{}", contractBudgets);
            ArrayList<DynamicObject> deleteContractBudgets = new ArrayList<DynamicObject>();
            HashMap<String, DynamicObject> projectBudgetMap = new HashMap<String, DynamicObject>();
            BudgetValidateAndUpdateHelper.loadAllBudget(projectBudgetMap, projectAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>();
            DynamicObject billType = BudgetValidateAndUpdateHelper.getBillType(billInfo.getFormBillId());
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                BigDecimal amountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractAmountMap.get(budgetItemId));
                DynamicObject contractBudget = contractBudgets.get(budgetItemId);
                logger.info("updateBudgetOnUnsubmit budgetItemId:{}", (Object)budgetItemId);
                if (contractBudget == null) continue;
                String submitAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(billInfo.getAmountType());
                BigDecimal submitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId));
                BigDecimal submitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId + SUFFIX));
                BigDecimal totalSubmitAmount = submitAmount.subtract(amount);
                BigDecimal totalSubmitAmountEx = submitAmountEx.subtract(amountEx);
                contractBudget.set(submitAmountId, (Object)totalSubmitAmount);
                contractBudget.set(submitAmountId + SUFFIX, (Object)totalSubmitAmountEx);
                BigDecimal occupyAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("occupyamt"));
                DynamicObject projectBudget = (DynamicObject)projectBudgetMap.get(budgetItemId);
                PerformAmountTypeEnum performAmountType = billInfo.getAmountType();
                PerformAmountTypeEnum occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByProjectBudget(projectBudget, billInfo.getContractId());
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                if (totalSubmitAmount.compareTo(occupyAmount) > 0) {
                    contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                    contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                    occupyAmountType = performAmountType;
                    updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                } else if (occupyAmountType != null && StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)billInfo.getAmountType().getValue())) {
                    occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByContractBudget(performEntry, contractBudget, billInfo.getAmountType(), billInfo.getFormBillId());
                    if (!StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)billInfo.getAmountType().getValue())) {
                        String newOccupyAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(occupyAmountType);
                        totalSubmitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId));
                        totalSubmitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId + SUFFIX));
                    }
                    contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                    contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                    updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                }
                BudgetValidateAndUpdateHelper.updatePerformType(performEntry, occupyAmountType, billInfo.getContractId(), billInfo.getId(), billType, true);
                BudgetValidateAndUpdateHelper.setToDeleteContBudget(deleteContractBudgets, contractBudget, performEntry);
            }
            if (!updateBudgetAmountMap.isEmpty()) {
                BudgetValidateAndUpdateHelper.summaryOccupyAmountToParent(projectBudgetMap, updateBudgetAmountMap);
            }
            if (!projectBudgetMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetMap.values().toArray(new DynamicObject[projectBudgetMap.size()]));
            }
            if (!contractBudgets.isEmpty()) {
                Collection<DynamicObject> contractBudgetList = contractBudgets.values();
                if (!deleteContractBudgets.isEmpty()) {
                    logger.info("unsubmit_contract_budget_need_to_be_delete: {}", deleteContractBudgets);
                    contractBudgetList.removeAll(deleteContractBudgets);
                    MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmbs_contractbudget");
                    DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])deleteContractBudgets.stream().map(DataEntityBase::getPkValue).toArray());
                }
                if (!contractBudgetList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])contractBudgetList.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    public static void updateBudgetOnAudit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, PerformBillInfo billInfo) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            Map<String, DynamicObject> contractBudgets = BudgetValidateAndUpdateHelper.getContractBudgets(billInfo.getContractId(), projectAmountMap.keySet());
            HashMap<String, DynamicObject> projectBudgetMap = new HashMap<String, DynamicObject>();
            BudgetValidateAndUpdateHelper.loadAllBudget(projectBudgetMap, projectAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>();
            DynamicObject billType = BudgetValidateAndUpdateHelper.getBillType(billInfo.getFormBillId());
            PerformAmountTypeEnum amountType = billInfo.getAmountType();
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                BigDecimal amountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractAmountMap.get(budgetItemId));
                DynamicObject contractBudget = contractBudgets.get(budgetItemId);
                if (contractBudget == null) continue;
                String submitAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(amountType);
                String auditAmountId = BudgetValidateAndUpdateHelper.getBudgetAuditAmountId(amountType);
                BigDecimal auditAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(auditAmountId));
                BigDecimal auditAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(auditAmountId + SUFFIX));
                contractBudget.set(auditAmountId, (Object)auditAmount.add(amount));
                contractBudget.set(auditAmountId + SUFFIX, (Object)auditAmountEx.add(amountEx));
                if (Arrays.asList(PerformAmountTypeEnum.INCOME.getValue(), PerformAmountTypeEnum.PAY.getValue()).contains(amountType.getValue())) {
                    BigDecimal payAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("performamt"));
                    BigDecimal payAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("performamtex"));
                    contractBudget.set("performamt", (Object)payAmount.add(amount));
                    contractBudget.set("performamtex", (Object)payAmountEx.add(amountEx));
                }
                BigDecimal occupyAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("occupyamt"));
                DynamicObject projectBudget = (DynamicObject)projectBudgetMap.get(budgetItemId);
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                DynamicObject performDetail = BudgetValidateAndUpdateHelper.getBillPerformEntry(projectBudget, billInfo, billType);
                BigDecimal submitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId));
                BigDecimal submitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId + SUFFIX));
                if (performDetail == null) {
                    performDetail = new DynamicObject(performEntry.getDynamicObjectType());
                    performEntry.add((Object)performDetail);
                } else {
                    submitAmount = submitAmount.subtract(BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(performDetail.getBigDecimal("billamt")));
                    submitAmountEx = submitAmountEx.subtract(BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(performDetail.getBigDecimal("billamtoncont")));
                }
                BigDecimal totalSubmitAmount = submitAmount.add(amount);
                BigDecimal totalSubmitAmountEx = submitAmountEx.add(amountEx);
                contractBudget.set(submitAmountId, (Object)totalSubmitAmount);
                contractBudget.set(submitAmountId + SUFFIX, (Object)totalSubmitAmountEx);
                PerformAmountTypeEnum occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByProjectBudget(projectBudget, billInfo.getContractId());
                String performType = occupyAmountType != null && StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)amountType.getValue()) ? PerformTypeEnum.OCCUPY.getValue() : PerformTypeEnum.NOTOCCUPY.getValue();
                BudgetValidateAndUpdateHelper.updatePerformDetail(performDetail, amount, amountEx, billType, StatusEnum.CHECKED.getValue(), performType, billInfo);
                if (totalSubmitAmount.compareTo(occupyAmount) > 0) {
                    contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                    contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                    BudgetValidateAndUpdateHelper.updatePerformType(performEntry, amountType, billInfo.getContractId(), 0L, null, false);
                    updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                    continue;
                }
                if (occupyAmountType == null || !StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)amountType.getValue()) || totalSubmitAmount.compareTo(occupyAmount) >= 0) continue;
                occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByContractBudget(performEntry, contractBudget, amountType, billInfo.getFormBillId());
                if (!StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)amountType.getValue())) {
                    String newOccupyAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(occupyAmountType);
                    totalSubmitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId));
                    totalSubmitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId + SUFFIX));
                    BudgetValidateAndUpdateHelper.updatePerformType(performEntry, occupyAmountType, billInfo.getContractId(), 0L, null, false);
                }
                contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
            }
            if (!updateBudgetAmountMap.isEmpty()) {
                BudgetValidateAndUpdateHelper.summaryOccupyAmountToParent(projectBudgetMap, updateBudgetAmountMap);
            }
            if (Arrays.asList(PerformAmountTypeEnum.ACTUAL_INCOME, PerformAmountTypeEnum.ACTUAL_PAY).contains((Object)amountType)) {
                BudgetValidateAndUpdateHelper.summaryActualAmountToParent(projectBudgetMap, projectAmountMap, false);
            }
            if (amountType != null && (StringUtils.equals((CharSequence)amountType.getValue(), (CharSequence)PerformAmountTypeEnum.PAY.getValue()) || StringUtils.equals((CharSequence)amountType.getValue(), (CharSequence)PerformAmountTypeEnum.INCOME.getValue()))) {
                BudgetValidateAndUpdateHelper.summaryPayAmountToParent(projectBudgetMap, projectAmountMap, false);
            }
            if (!projectBudgetMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetMap.values().toArray(new DynamicObject[projectBudgetMap.size()]));
            }
            if (!contractBudgets.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])contractBudgets.values().toArray(new DynamicObject[contractBudgets.size()]));
            }
        }
    }

    public static void updateBudgetOnUnaudit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, String formBillId, long billPk, String contractId, PerformAmountTypeEnum performAmountType) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            Map<String, DynamicObject> contractBudgets = BudgetValidateAndUpdateHelper.getContractBudgets(contractId, projectAmountMap.keySet());
            HashMap<String, DynamicObject> projectBudgetMap = new HashMap<String, DynamicObject>();
            BudgetValidateAndUpdateHelper.loadAllBudget(projectBudgetMap, projectAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>();
            ArrayList<DynamicObject> deleteContractBudgets = new ArrayList<DynamicObject>();
            DynamicObject billType = BudgetValidateAndUpdateHelper.getBillType(formBillId);
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                BigDecimal amountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractAmountMap.get(budgetItemId));
                DynamicObject contractBudget = contractBudgets.get(budgetItemId);
                if (contractBudget == null) continue;
                String submitAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(performAmountType);
                String auditAmountId = BudgetValidateAndUpdateHelper.getBudgetAuditAmountId(performAmountType);
                BigDecimal submitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId));
                BigDecimal submitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(submitAmountId + SUFFIX));
                BigDecimal auditAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(auditAmountId));
                BigDecimal auditAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(auditAmountId + SUFFIX));
                contractBudget.set(auditAmountId, (Object)auditAmount.subtract(amount));
                contractBudget.set(auditAmountId + SUFFIX, (Object)auditAmountEx.subtract(amountEx));
                BigDecimal totalSubmitAmount = submitAmount.subtract(amount);
                BigDecimal totalSubmitAmountEx = submitAmountEx.subtract(amountEx);
                contractBudget.set(submitAmountId, (Object)totalSubmitAmount);
                contractBudget.set(submitAmountId + SUFFIX, (Object)totalSubmitAmountEx);
                if (StringUtils.equals((CharSequence)performAmountType.getValue(), (CharSequence)PerformAmountTypeEnum.PAY.getValue()) || StringUtils.equals((CharSequence)performAmountType.getValue(), (CharSequence)PerformAmountTypeEnum.INCOME.getValue())) {
                    BigDecimal payAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("performamt"));
                    BigDecimal payAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("performamtex"));
                    contractBudget.set("performamt", (Object)payAmount.subtract(amount));
                    contractBudget.set("performamtex", (Object)payAmountEx.subtract(amountEx));
                }
                BigDecimal occupyAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("occupyamt"));
                DynamicObject projectBudget = (DynamicObject)projectBudgetMap.get(budgetItemId);
                PerformAmountTypeEnum occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByProjectBudget(projectBudget, contractId);
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                if (totalSubmitAmount.compareTo(occupyAmount) > 0) {
                    contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                    contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                    occupyAmountType = performAmountType;
                    updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                } else if (occupyAmountType != null && StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)performAmountType.getValue()) && totalSubmitAmount.compareTo(occupyAmount) < 0) {
                    occupyAmountType = BudgetValidateAndUpdateHelper.getOccupyTypeByContractBudget(performEntry, contractBudget, performAmountType, formBillId);
                    if (!StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)performAmountType.getValue())) {
                        String newOccupyAmountId = BudgetValidateAndUpdateHelper.getBudgetSubmitAmountId(occupyAmountType);
                        totalSubmitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId));
                        totalSubmitAmountEx = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal(newOccupyAmountId + SUFFIX));
                    }
                    contractBudget.set("occupyamt", (Object)totalSubmitAmount);
                    contractBudget.set("occupyamtex", (Object)totalSubmitAmountEx);
                    updateBudgetAmountMap.put(budgetItemId, totalSubmitAmount.subtract(occupyAmount));
                }
                BudgetValidateAndUpdateHelper.updatePerformType(performEntry, occupyAmountType, contractId, billPk, billType, true);
                BudgetValidateAndUpdateHelper.setToDeleteContBudget(deleteContractBudgets, contractBudget, performEntry);
            }
            if (!updateBudgetAmountMap.isEmpty()) {
                BudgetValidateAndUpdateHelper.summaryOccupyAmountToParent(projectBudgetMap, updateBudgetAmountMap);
            }
            if (Arrays.asList(PerformAmountTypeEnum.ACTUAL_INCOME, PerformAmountTypeEnum.ACTUAL_PAY).contains((Object)performAmountType)) {
                BudgetValidateAndUpdateHelper.summaryActualAmountToParent(projectBudgetMap, projectAmountMap, true);
            }
            if (performAmountType != null && (StringUtils.equals((CharSequence)performAmountType.getValue(), (CharSequence)PerformAmountTypeEnum.PAY.getValue()) || StringUtils.equals((CharSequence)performAmountType.getValue(), (CharSequence)PerformAmountTypeEnum.INCOME.getValue()))) {
                BudgetValidateAndUpdateHelper.summaryPayAmountToParent(projectBudgetMap, projectAmountMap, true);
            }
            if (!projectBudgetMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetMap.values().toArray(new DynamicObject[projectBudgetMap.size()]));
            }
            if (!contractBudgets.isEmpty()) {
                Collection<DynamicObject> contractBudgetList = contractBudgets.values();
                if (!deleteContractBudgets.isEmpty()) {
                    logger.info("unaudit_contract_budget_need_to_be_delete: {}", deleteContractBudgets);
                    contractBudgetList.removeAll(deleteContractBudgets);
                    MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmbs_contractbudget");
                    DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])deleteContractBudgets.stream().map(DataEntityBase::getPkValue).toArray());
                }
                if (!contractBudgetList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])contractBudgetList.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    private static void setToDeleteContBudget(List<DynamicObject> deleteContractBudgets, DynamicObject contractBudget, DynamicObjectCollection performEntry) {
        boolean isDeleteContBudget = true;
        if (performEntry != null && !performEntry.isEmpty()) {
            for (DynamicObject performEntryRow : performEntry) {
                if (!StringUtils.equals((CharSequence)contractBudget.getString("contract_id"), (CharSequence)performEntryRow.getString("contract_id"))) continue;
                isDeleteContBudget = false;
                break;
            }
        }
        if (isDeleteContBudget) {
            deleteContractBudgets.add(contractBudget);
        }
    }

    public static Map<String, DynamicObject> getContractBudgets(String contractId, Set<String> budgetIdSet) {
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contractId));
        filter.and(new QFilter("budgetitem", "in", budgetIdSet.stream().map(Long::parseLong).collect(Collectors.toSet())));
        String selectProperties = "contract, budgetitem, projectcurrency, contractcurrency, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex";
        DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObject> contractBudgetMap = new HashMap<String, DynamicObject>();
        if (contractBudgets != null && contractBudgets.length > 0) {
            for (DynamicObject contractBudget : contractBudgets) {
                DynamicObject budgetItem = contractBudget.getDynamicObject("budgetitem");
                if (budgetItem == null) continue;
                contractBudgetMap.put(budgetItem.getPkValue().toString(), contractBudget);
            }
        }
        return contractBudgetMap;
    }

    protected static PerformAmountTypeEnum getOccupyTypeByContractBudget(DynamicObjectCollection performEntry, DynamicObject contractBudget, PerformAmountTypeEnum performAmountType, String formBillId) {
        Object contractId;
        BigDecimal contractAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("contractsubmitamt"));
        BigDecimal settleAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("settlesubmitamt"));
        BigDecimal payApplyAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("payapplysubmitamt"));
        BigDecimal actualSubmitAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("actualsubmitamt"));
        Object contractObject = contractBudget.get("contract");
        Object object = contractId = contractObject instanceof DynamicObject ? ((DynamicObject)contractObject).getPkValue() : contractObject;
        String payDirection = QueryServiceHelper.exists((String)"pmct_contracttpl", (Object)contractId) ? BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_contracttpl").getString("paydirection") : ("pmct_outcontract".equalsIgnoreCase(formBillId) ? PayDirectionEnum.OUT.getValue() : PayDirectionEnum.IN.getValue());
        ContractBudgetAmount contractAmountObj = new ContractBudgetAmount(PerformAmountTypeEnum.CONTRACT, contractAmount);
        ContractBudgetAmount settleAmountObj = new ContractBudgetAmount(PerformAmountTypeEnum.SETTLE, settleAmount);
        ContractBudgetAmount payApplyAmountObj = new ContractBudgetAmount(BudgetValidateAndUpdateHelper.getApplyPerformAmountType(payDirection), payApplyAmount);
        ContractBudgetAmount actualAmountObj = new ContractBudgetAmount(BudgetValidateAndUpdateHelper.getActualPerformAmountType(payDirection), actualSubmitAmount);
        List<ContractBudgetAmount> contractAmountList = Arrays.asList(contractAmountObj, settleAmountObj, payApplyAmountObj, actualAmountObj);
        ContractBudgetAmount maxAmountObj = contractAmountList.stream().max(Comparator.comparing(ContractBudgetAmount::getAmount)).orElse(contractAmountObj);
        long maxValueCount = contractAmountList.stream().filter(obj -> obj.getAmount().compareTo(maxAmountObj.getAmount()) == 0).count();
        if (maxValueCount == 1L) {
            return maxAmountObj.getType();
        }
        List maxAmountObjList = contractAmountList.stream().filter(obj -> obj.getAmount().compareTo(maxAmountObj.getAmount()) == 0).collect(Collectors.toList());
        PerformAmountTypeEnum applyPerformAmountType = BudgetValidateAndUpdateHelper.getApplyPerformAmountType(payDirection);
        PerformAmountTypeEnum actualPerformAmountType = BudgetValidateAndUpdateHelper.getActualPerformAmountType(payDirection);
        Optional<ContractBudgetAmount> first = maxAmountObjList.stream().filter(o -> StringUtils.equals((CharSequence)o.getType().getValue(), (CharSequence)actualPerformAmountType.getValue())).findFirst();
        if (first.isPresent()) {
            return first.get().getType();
        }
        first = maxAmountObjList.stream().filter(o -> StringUtils.equals((CharSequence)o.getType().getValue(), (CharSequence)applyPerformAmountType.getValue())).findFirst();
        if (first.isPresent()) {
            return first.get().getType();
        }
        first = maxAmountObjList.stream().filter(o -> StringUtils.equals((CharSequence)o.getType().getValue(), (CharSequence)PerformAmountTypeEnum.SETTLE.getValue())).findFirst();
        if (first.isPresent()) {
            return first.get().getType();
        }
        return PerformAmountTypeEnum.CONTRACT;
    }

    private static PerformAmountTypeEnum getApplyPerformAmountType(String payDirection) {
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue()) ? PerformAmountTypeEnum.INCOME : PerformAmountTypeEnum.PAY;
    }

    private static PerformAmountTypeEnum getActualPerformAmountType(String payDirection) {
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue()) ? PerformAmountTypeEnum.ACTUAL_INCOME : PerformAmountTypeEnum.ACTUAL_PAY;
    }

    private static boolean isHasPerformEntryObj(DynamicObjectCollection performEntry, PerformAmountTypeEnum occupyType) {
        boolean hasPerformEntryObj = false;
        for (DynamicObject performEntryObj : performEntry) {
            String performAmtType = performEntryObj.getString("performamttype");
            if (!StringUtils.equals((CharSequence)performAmtType, (CharSequence)occupyType.getValue())) continue;
            hasPerformEntryObj = true;
            break;
        }
        return hasPerformEntryObj;
    }

    protected static PerformAmountTypeEnum getOccupyTypeByProjectBudget(DynamicObject projectBudget, String contractId) {
        DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
        for (DynamicObject entry : performEntry) {
            String entryContractId = entry.getString("contract_id");
            if (entryContractId == null || !StringUtils.equals((CharSequence)entryContractId, (CharSequence)contractId) || !StringUtils.equals((CharSequence)entry.getString("performtype"), (CharSequence)PerformTypeEnum.OCCUPY.getValue())) continue;
            return PerformAmountTypeEnum.getEnumByValue(entry.getString("performamttype"));
        }
        return null;
    }

    public static void updatePerformType(DynamicObjectCollection performEntry, PerformAmountTypeEnum performAmountType, String contractId, long billPk, DynamicObject billType, boolean isRemove) {
        if (performEntry != null && !performEntry.isEmpty()) {
            Iterator iterator = performEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                String entryContractId = entry.getString("contract_id");
                if (StringUtils.equals((CharSequence)contractId, (CharSequence)entryContractId) && performAmountType != null && StringUtils.equals((CharSequence)entry.getString("performamttype"), (CharSequence)performAmountType.getValue())) {
                    entry.set("performtype", (Object)PerformTypeEnum.OCCUPY.getValue());
                } else if (StringUtils.equals((CharSequence)contractId, (CharSequence)entryContractId) && performAmountType != null && !StringUtils.equals((CharSequence)entry.getString("performamttype"), (CharSequence)performAmountType.getValue())) {
                    entry.set("performtype", (Object)PerformTypeEnum.NOTOCCUPY.getValue());
                }
                long entryBillId = entry.getLong("billid");
                DynamicObject performBillType = entry.getDynamicObject("billtype");
                if (!isRemove || entryBillId != billPk || billType == null || performBillType == null || !billType.getPkValue().equals(performBillType.getPkValue()) || !StringUtils.equals((CharSequence)contractId, (CharSequence)entryContractId)) continue;
                iterator.remove();
            }
        }
    }

    protected static void updatePerformDetail(DynamicObject performDetail, BigDecimal amount, BigDecimal amountEx, DynamicObject billType, String billStatus, String performType, PerformBillInfo billInfo) {
        performDetail.set("billamt", (Object)amount);
        performDetail.set("billamtoncont", (Object)amountEx);
        performDetail.set("billcreatedate", (Object)billInfo.getCreateDate());
        performDetail.set("billcreator", (Object)billInfo.getCreator());
        performDetail.set("billauditdate", (Object)billInfo.getAuditDate());
        performDetail.set("billauditor", (Object)billInfo.getAuditor());
        performDetail.set("billid", (Object)billInfo.getId());
        performDetail.set("billname", (Object)billInfo.getBillName());
        performDetail.set("billno", (Object)billInfo.getBillNo());
        performDetail.set("billstatus", (Object)billStatus);
        performDetail.set("billtype", (Object)billType);
        performDetail.set("performtype", (Object)performType);
        performDetail.set("performamttype", (Object)billInfo.getAmountType().getValue());
        performDetail.set("contract", (Object)billInfo.getContractId());
        performDetail.set("contract_id", (Object)billInfo.getContractId());
    }

    public static DynamicObject newContractBudget(String budgetItemId, String contractId) {
        DynamicObject contractBudget = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractbudget"));
        contractBudget.set("budgetitem", (Object)budgetItemId);
        contractBudget.set("contract", (Object)contractId);
        return contractBudget;
    }

    public static BudgetValidateInfo validateProjectBudget(Set<String> proBudgetIds, Map<String, BigDecimal> updateBudgetAmountMap, Map<String, DynamicObject> proBudgetPerformMap) {
        if (!updateBudgetAmountMap.isEmpty()) {
            BudgetValidateAndUpdateHelper.summaryOccupyAmountToParent(proBudgetPerformMap, updateBudgetAmountMap);
            Map<DynamicObject, DynamicObject> resultMap = BudgetValidateAndUpdateHelper.checkOutOfControlBudgets(proBudgetPerformMap, proBudgetIds);
            if (resultMap.isEmpty()) {
                resultMap = BudgetValidateAndUpdateHelper.checkRemindBudgets(proBudgetPerformMap, proBudgetIds);
                if (resultMap.isEmpty()) {
                    return null;
                }
                return new BudgetValidateInfo(false, true, resultMap);
            }
            return new BudgetValidateInfo(true, false, resultMap);
        }
        return null;
    }

    protected static Map<DynamicObject, DynamicObject> checkOutOfControlBudgets(Map<String, DynamicObject> budgetMap, Set<String> budgetIds) {
        HashMap<DynamicObject, DynamicObject> result = new HashMap<DynamicObject, DynamicObject>(16);
        if (budgetIds != null && budgetMap != null) {
            for (String budgetId : budgetIds) {
                DynamicObject outOfControlBudget = BudgetValidateAndUpdateHelper.checkOutOfControlBudget(budgetMap, budgetId);
                if (outOfControlBudget == null) continue;
                result.put(budgetMap.get(budgetId), outOfControlBudget);
            }
        }
        return result;
    }

    protected static DynamicObject checkOutOfControlBudget(Map<String, DynamicObject> budgetMap, String budgetId) {
        DynamicObject budgetItem = budgetMap.get(budgetId);
        if (budgetItem == null) {
            return null;
        }
        if (BudgetValidateAndUpdateHelper.checkIsOutOfControl(budgetItem)) {
            return budgetItem;
        }
        if (budgetItem.getLong("parent") != 0L) {
            return BudgetValidateAndUpdateHelper.checkOutOfControlBudget(budgetMap, String.valueOf(budgetItem.getLong("parent")));
        }
        return null;
    }

    protected static boolean checkIsOutOfControl(DynamicObject budget) {
        BigDecimal occupyAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("occupyamt"));
        BigDecimal controlAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("controlamt"));
        if (controlAmount.compareTo(BigDecimal.ZERO) != 0) {
            return occupyAmount.compareTo(controlAmount) > 0;
        }
        BigDecimal controlRate = budget.getBigDecimal("controlrate");
        return occupyAmount.compareTo(controlAmount) > 0 && controlRate.compareTo(BigDecimal.ZERO) != 0;
    }

    protected static Map<DynamicObject, DynamicObject> checkRemindBudgets(Map<String, DynamicObject> budgetMap, Set<String> budgetIds) {
        HashMap<DynamicObject, DynamicObject> result = new HashMap<DynamicObject, DynamicObject>();
        if (budgetIds != null && budgetMap != null) {
            for (String budgetId : budgetIds) {
                DynamicObject remindBudget = BudgetValidateAndUpdateHelper.checkRemindBudget(budgetMap, budgetId);
                if (remindBudget == null) continue;
                result.put(budgetMap.get(budgetId), remindBudget);
            }
        }
        return result;
    }

    protected static DynamicObject checkRemindBudget(Map<String, DynamicObject> budgetMap, String budgetId) {
        DynamicObject budgetItem = budgetMap.get(budgetId);
        if (budgetItem == null) {
            return null;
        }
        if (BudgetValidateAndUpdateHelper.checkIsOutOfRemind(budgetItem)) {
            return budgetItem;
        }
        if (budgetItem.getLong("parent") != 0L) {
            return BudgetValidateAndUpdateHelper.checkRemindBudget(budgetMap, String.valueOf(budgetItem.getLong("parent")));
        }
        return null;
    }

    protected static boolean checkIsOutOfRemind(DynamicObject budget) {
        BigDecimal remindAmount;
        BigDecimal occupyAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("occupyamt"));
        return occupyAmount.compareTo(remindAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("remindamt"))) > 0 && remindAmount.compareTo(BigDecimal.ZERO) != 0;
    }

    public static void summaryOccupyAmountToParent(Map<String, DynamicObject> proBudgetPerformMap, Map<String, BigDecimal> updateBudgetAmountMap) {
        if (updateBudgetAmountMap != null && !updateBudgetAmountMap.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : updateBudgetAmountMap.entrySet()) {
                BigDecimal budgetAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(entry.getValue());
                BudgetValidateAndUpdateHelper.updateOccupyAmount(entry.getKey(), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    public static void summaryActualAmountToParent(Map<String, DynamicObject> proBudgetPerformMap, Map<String, BigDecimal> budgetAmountMap, boolean isDedcut) {
        if (budgetAmountMap != null && !budgetAmountMap.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : budgetAmountMap.entrySet()) {
                BigDecimal budgetAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(entry.getValue()).multiply(isDedcut ? BigDecimal.valueOf(-1L) : BigDecimal.ONE);
                BudgetValidateAndUpdateHelper.updateActualAmount(entry.getKey(), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    public static void summaryPayAmountToParent(Map<String, DynamicObject> budgetMap, Map<String, BigDecimal> budgetAmountMap, boolean isDedcut) {
        if (budgetAmountMap != null && !budgetAmountMap.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : budgetAmountMap.entrySet()) {
                BigDecimal budgetAmount = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(entry.getValue()).multiply(isDedcut ? BigDecimal.valueOf(-1L) : BigDecimal.ONE);
                BudgetValidateAndUpdateHelper.updatePayAmount(entry.getKey(), budgetAmount, budgetMap);
            }
        }
    }

    protected static void updatePayAmount(String budgetId, BigDecimal budgetAmount, Map<String, DynamicObject> budgetMap) {
        DynamicObject budget = budgetMap.get(budgetId);
        if (budget != null) {
            BigDecimal payAmt = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("performamt")).add(budgetAmount);
            budget.set("performamt", (Object)payAmt);
            long parentId = budget.getLong("parent");
            if (budgetMap.containsKey(String.valueOf(parentId))) {
                BudgetValidateAndUpdateHelper.updatePayAmount(String.valueOf(parentId), budgetAmount, budgetMap);
            }
        }
    }

    protected static void updateOccupyAmount(String budgetId, BigDecimal budgetAmount, Map<String, DynamicObject> proBudgetPerformMap) {
        DynamicObject proBudgetPerform = proBudgetPerformMap.get(budgetId);
        if (proBudgetPerform != null) {
            BigDecimal occupyAmt = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(proBudgetPerform.getBigDecimal("occupyamt")).add(budgetAmount);
            BigDecimal remainAmt = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(proBudgetPerform.getBigDecimal("remainamt")).subtract(budgetAmount);
            proBudgetPerform.set("occupyamt", (Object)occupyAmt);
            proBudgetPerform.set("remainamt", (Object)remainAmt);
            BigDecimal amount = proBudgetPerform.getBigDecimal("budgetamount");
            BigDecimal remainRate = BigDecimal.ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                remainRate = remainAmt.divide(amount, 10, RoundingMode.HALF_UP);
            }
            proBudgetPerform.set("remainrate", (Object)remainRate);
            long parentId = proBudgetPerform.getLong("parent");
            if (proBudgetPerformMap.containsKey(String.valueOf(parentId))) {
                BudgetValidateAndUpdateHelper.updateOccupyAmount(String.valueOf(parentId), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    protected static void updateActualAmount(String budgetId, BigDecimal budgetAmount, Map<String, DynamicObject> proBudgetPerformMap) {
        DynamicObject proBudgetPerform = proBudgetPerformMap.get(budgetId);
        if (proBudgetPerform != null) {
            BigDecimal actualAmt = BudgetValidateAndUpdateHelper.getDefaultZeroBigDecimal(proBudgetPerform.getBigDecimal("actualamt")).add(budgetAmount);
            proBudgetPerform.set("actualamt", (Object)actualAmt);
            long parentId = proBudgetPerform.getLong("parent");
            if (proBudgetPerformMap.containsKey(String.valueOf(parentId))) {
                BudgetValidateAndUpdateHelper.updateActualAmount(String.valueOf(parentId), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    public static void loadAllBudget(Map<String, DynamicObject> projectBudgetMap, Set<String> projectBudgetIds) {
        HashSet<String> parentBudgetIds = new HashSet<String>();
        Set<Long> budgetIdsSet = projectBudgetIds.stream().filter(o -> QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)o)).map(Long::parseLong).collect(Collectors.toSet());
        if (budgetIdsSet.size() > 0) {
            DynamicObject[] projectBudgets;
            for (DynamicObject projectBudget : projectBudgets = BusinessDataServiceHelper.load((Object[])budgetIdsSet.toArray(new Long[budgetIdsSet.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudget"))) {
                projectBudgetMap.put(projectBudget.getString("id"), projectBudget);
                long parentId = projectBudget.getLong("parent");
                String parentPk = String.valueOf(parentId);
                if (parentId == 0L || projectBudgetMap.get(parentPk) != null || projectBudgetIds.contains(parentPk)) continue;
                parentBudgetIds.add(parentPk);
            }
        }
        if (!parentBudgetIds.isEmpty()) {
            BudgetValidateAndUpdateHelper.loadAllBudget(projectBudgetMap, parentBudgetIds);
        }
    }

    protected static String getBudgetSubmitAmountId(PerformAmountTypeEnum performAmountType) {
        switch (performAmountType) {
            case SETTLE: {
                return "settlesubmitamt";
            }
            case INCOME: 
            case PAY: {
                return "payapplysubmitamt";
            }
            case ACTUAL_INCOME: 
            case ACTUAL_PAY: {
                return "actualsubmitamt";
            }
        }
        return "contractsubmitamt";
    }

    protected static String getBudgetAuditAmountId(PerformAmountTypeEnum performAmountType) {
        switch (performAmountType) {
            case SETTLE: {
                return "settleauditamt";
            }
            case INCOME: 
            case PAY: {
                return "payapplyauditamt";
            }
            case ACTUAL_INCOME: 
            case ACTUAL_PAY: {
                return "actualauditamt";
            }
        }
        return "contractauditamt";
    }

    public static DynamicObject getBillType(String formBillId) {
        QFilter filter = new QFilter("number", "=", (Object)formBillId);
        return BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"id,number,name,modeltype,bizappid", (QFilter[])new QFilter[]{filter});
    }

    protected static DynamicObject getBillPerformEntry(DynamicObject projectBudget, PerformBillInfo billInfo, DynamicObject billType) {
        DynamicObjectCollection performEntry;
        if (projectBudget != null && !(performEntry = projectBudget.getDynamicObjectCollection("performentry")).isEmpty()) {
            for (DynamicObject entry : performEntry) {
                long entryBillId = entry.getLong("billid");
                DynamicObject entryBillType = entry.getDynamicObject("billtype");
                String entryContractId = entry.getString("contract_id");
                long billPk = billInfo.getId();
                String contractId = billInfo.getContractId();
                if (entryBillId != billPk || billType == null || entryBillType == null || !billType.getPkValue().equals(entryBillType.getPkValue()) || !StringUtils.equals((CharSequence)contractId, (CharSequence)entryContractId)) continue;
                return entry;
            }
        }
        return null;
    }

    protected static DynamicObject getBillPerformEntry(DynamicObject projectBudget, long billPk, String contractId, DynamicObject billType) {
        DynamicObjectCollection performEntries;
        if (projectBudget != null && !(performEntries = projectBudget.getDynamicObjectCollection("performentry")).isEmpty()) {
            for (DynamicObject performEntry : performEntries) {
                long entryBillId = performEntry.getLong("billid");
                DynamicObject entryBillType = performEntry.getDynamicObject("billtype");
                String entryContractId = performEntry.getString("contract_id");
                if (entryBillId != billPk || billType == null || entryBillType == null || !billType.getPkValue().equals(entryBillType.getPkValue()) || !StringUtils.equals((CharSequence)contractId, (CharSequence)entryContractId) && !StringUtils.equals((CharSequence)performEntry.getString("performamttype"), (CharSequence)PerformAmountTypeEnum.OTHER.getValue())) continue;
                return performEntry;
            }
        }
        return null;
    }

    protected static DynamicObject getBillPerformEntry(DynamicObject projectBudget, long billPk, DynamicObject billType) {
        DynamicObjectCollection performEntry;
        if (projectBudget != null && !(performEntry = projectBudget.getDynamicObjectCollection("performentry")).isEmpty()) {
            for (DynamicObject entry : performEntry) {
                long entryBillId = entry.getLong("billid");
                DynamicObject entryBillType = entry.getDynamicObject("billtype");
                if (entryBillId != billPk || billType == null || entryBillType == null || !billType.getPkValue().equals(entryBillType.getPkValue())) continue;
                return entry;
            }
        }
        return null;
    }

    protected static BigDecimal getDefaultZeroBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public static BigDecimal getExchangeRate(DynamicObject contract, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = contract.getDynamicObject("currency");
        DynamicObject stdCurrency = contract.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return contract.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable(org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate(contractCurrency.getLong("id"), proCurrency.getLong("id"), exRateTable.getLong("id"), contract.getDate("createtime"));
        }
        return exchangeRate;
    }

    private static class ContractBudgetAmount {
        BigDecimal amount;
        PerformAmountTypeEnum type;

        public ContractBudgetAmount(PerformAmountTypeEnum type, BigDecimal amount) {
            this.type = type;
            this.amount = amount;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public PerformAmountTypeEnum getType() {
            return this.type;
        }
    }
}

