/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.budget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.PerformTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;

public class ProjectBudgetUpdateHelper {
    private static final Log logger = LogFactory.getLog(ProjectBudgetUpdateHelper.class);
    private static final String SUFFIX = "ex";

    public static void updateBudgetOnSubmit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, PerformBillInfo billInfo) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            HashMap<String, DynamicObject> projectBudgetPerformMap = new HashMap<String, DynamicObject>();
            ProjectBudgetUpdateHelper.loadAllBudget(projectBudgetPerformMap, projectAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>(projectAmountMap.size());
            DynamicObject billType = ProjectBudgetUpdateHelper.getBillType(billInfo.getFormBillId());
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                BigDecimal amountEx = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(contractAmountMap.get(budgetItemId));
                DynamicObject projectBudget = (DynamicObject)projectBudgetPerformMap.get(budgetItemId);
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                DynamicObject performDetail = new DynamicObject(performEntry.getDynamicObjectType());
                if (billInfo.getContractCurrency() != null) {
                    performDetail.set("contractcurrency", (Object)billInfo.getContractCurrency());
                }
                ProjectBudgetUpdateHelper.updatePerformDetail(performDetail, amount, amountEx, billType, StatusEnum.UNCHECKED.getValue(), PerformTypeEnum.NOTOCCUPY.getValue(), billInfo);
                performEntry.add((Object)performDetail);
                updateBudgetAmountMap.put(budgetItemId, amount);
            }
            if (!updateBudgetAmountMap.isEmpty()) {
                ProjectBudgetUpdateHelper.summaryOccupyAmountToParent(projectBudgetPerformMap, updateBudgetAmountMap);
            }
            if (!projectBudgetPerformMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetPerformMap.values().toArray(new DynamicObject[0]));
            }
        }
    }

    public static void updateBudgetOnUnsubmit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, PerformBillInfo billInfo) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            HashMap<String, DynamicObject> projectBudgetMap = new HashMap<String, DynamicObject>();
            ProjectBudgetUpdateHelper.loadAllBudget(projectBudgetMap, projectAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>(projectAmountMap.size());
            DynamicObject billType = ProjectBudgetUpdateHelper.getBillType(billInfo.getFormBillId());
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                DynamicObject projectBudget = (DynamicObject)projectBudgetMap.get(budgetItemId);
                PerformAmountTypeEnum occupyAmountType = ProjectBudgetUpdateHelper.getOccupyTypeByProjectBudget(projectBudget, billInfo.getContractId());
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                updateBudgetAmountMap.put(budgetItemId, amount.negate());
                ProjectBudgetUpdateHelper.updatePerformType(performEntry, occupyAmountType, billInfo.getContractId(), billInfo.getId(), billType, true);
            }
            if (!updateBudgetAmountMap.isEmpty()) {
                ProjectBudgetUpdateHelper.summaryOccupyAmountToParent(projectBudgetMap, updateBudgetAmountMap);
            }
            if (!projectBudgetMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetMap.values().toArray(new DynamicObject[0]));
            }
        }
    }

    public static void updateBudgetOnAudit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, PerformBillInfo billInfo) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            HashMap<String, DynamicObject> projectBudgetMap = new HashMap<String, DynamicObject>();
            ProjectBudgetUpdateHelper.loadAllBudget(projectBudgetMap, projectAmountMap.keySet());
            DynamicObject billType = ProjectBudgetUpdateHelper.getBillType(billInfo.getFormBillId());
            PerformAmountTypeEnum amountType = billInfo.getAmountType();
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                PerformAmountTypeEnum occupyAmountType;
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                BigDecimal amountEx = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(contractAmountMap.get(budgetItemId));
                DynamicObject projectBudget = (DynamicObject)projectBudgetMap.get(budgetItemId);
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                DynamicObject performDetail = ProjectBudgetUpdateHelper.getBillPerformEntry(projectBudget, billInfo.getId(), billType);
                if (performDetail == null) {
                    performDetail = new DynamicObject(performEntry.getDynamicObjectType());
                    performEntry.add((Object)performDetail);
                }
                String performType = (occupyAmountType = ProjectBudgetUpdateHelper.getOccupyTypeByProjectBudget(projectBudget, billInfo.getContractId())) != null && StringUtils.equals((CharSequence)occupyAmountType.getValue(), (CharSequence)amountType.getValue()) ? PerformTypeEnum.OCCUPY.getValue() : PerformTypeEnum.NOTOCCUPY.getValue();
                ProjectBudgetUpdateHelper.updatePerformDetail(performDetail, amount, amountEx, billType, StatusEnum.CHECKED.getValue(), performType, billInfo);
            }
            if (!projectBudgetMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetMap.values().toArray(new DynamicObject[projectBudgetMap.size()]));
            }
        }
    }

    public static void updateBudgetOnUnaudit(Map<String, BigDecimal> projectAmountMap, Map<String, BigDecimal> contractAmountMap, String formBillId, long billPk, String contractId, PerformAmountTypeEnum performAmountType) {
        if (projectAmountMap != null && contractAmountMap != null && !projectAmountMap.isEmpty() && !contractAmountMap.isEmpty()) {
            HashMap<String, DynamicObject> projectBudgetMap = new HashMap<String, DynamicObject>();
            ProjectBudgetUpdateHelper.loadAllBudget(projectBudgetMap, projectAmountMap.keySet());
            HashMap<String, BigDecimal> updateBudgetAmountMap = new HashMap<String, BigDecimal>(projectAmountMap.size());
            DynamicObject billType = ProjectBudgetUpdateHelper.getBillType(formBillId);
            for (Map.Entry<String, BigDecimal> projectAmountEntry : projectAmountMap.entrySet()) {
                String budgetItemId = projectAmountEntry.getKey();
                BigDecimal amount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(projectAmountEntry.getValue());
                DynamicObject projectBudget = (DynamicObject)projectBudgetMap.get(budgetItemId);
                PerformAmountTypeEnum occupyAmountType = ProjectBudgetUpdateHelper.getOccupyTypeByProjectBudget(projectBudget, contractId);
                DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
                updateBudgetAmountMap.put(budgetItemId, amount.negate());
                ProjectBudgetUpdateHelper.updatePerformType(performEntry, occupyAmountType, contractId, billPk, billType, true);
            }
            if (!updateBudgetAmountMap.isEmpty()) {
                ProjectBudgetUpdateHelper.summaryOccupyAmountToParent(projectBudgetMap, updateBudgetAmountMap);
                if (Arrays.asList(PerformAmountTypeEnum.ACTUAL_INCOME, PerformAmountTypeEnum.ACTUAL_PAY).contains((Object)performAmountType)) {
                    ProjectBudgetUpdateHelper.summaryActualAmountToParent(projectBudgetMap, updateBudgetAmountMap, false);
                }
            }
            if (performAmountType != null && StringUtils.equals((CharSequence)performAmountType.getValue(), (CharSequence)PerformAmountTypeEnum.PAY.getValue())) {
                ProjectBudgetUpdateHelper.summaryPayAmountToParent(projectBudgetMap, projectAmountMap, true);
            }
            if (!projectBudgetMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])projectBudgetMap.values().toArray(new DynamicObject[projectBudgetMap.size()]));
            }
        }
    }

    public static Map<String, DynamicObject> getContractBudgets(String contractId, Set<String> budgetIdSet) {
        if (StringUtils.isEmpty((CharSequence)contractId)) {
            return new HashMap<String, DynamicObject>(16);
        }
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contractId));
        filter.and(new QFilter("budgetitem", "in", budgetIdSet.stream().map(Long::parseLong).collect(Collectors.toSet())));
        String selectProperties = "contract, budgetitem, projectcurrency, contractcurrency, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex";
        DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObject> contractBudgetMap = new HashMap<String, DynamicObject>();
        if (contractBudgets != null && contractBudgets.length > 0) {
            for (DynamicObject contractBudget : contractBudgets) {
                DynamicObject budgetItem = contractBudget.getDynamicObject("budgetitem");
                if (budgetItem == null) continue;
                contractBudgetMap.put(budgetItem.getPkValue().toString(), contractBudget);
            }
        }
        return contractBudgetMap;
    }

    protected static PerformAmountTypeEnum getOccupyTypeByContractBudget(DynamicObjectCollection performEntry, DynamicObject contractBudget, PerformAmountTypeEnum performAmountType) {
        BigDecimal contractAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("contractsubmitamt"));
        BigDecimal settleAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("settlesubmitamt"));
        BigDecimal payApplyAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("payapplysubmitamt"));
        BigDecimal actualSubmitAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(contractBudget.getBigDecimal("actualsubmitamt"));
        Object contractObject = contractBudget.get("contract");
        Object contractId = contractObject instanceof DynamicObject ? ((DynamicObject)contractObject).getPkValue() : contractObject;
        String payDirection = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_contracttpl").getString("paydirection");
        ContractBudgetAmount contractAmountObj = new ContractBudgetAmount(PerformAmountTypeEnum.CONTRACT, contractAmount);
        ContractBudgetAmount settleAmountObj = new ContractBudgetAmount(PerformAmountTypeEnum.SETTLE, settleAmount);
        ContractBudgetAmount payApplyAmountObj = new ContractBudgetAmount(ProjectBudgetUpdateHelper.getApplyPerformAmountType(payDirection), payApplyAmount);
        ContractBudgetAmount actualAmountObj = new ContractBudgetAmount(ProjectBudgetUpdateHelper.getActualPerformAmountType(payDirection), actualSubmitAmount);
        List<ContractBudgetAmount> contractAmountList = Arrays.asList(contractAmountObj, settleAmountObj, payApplyAmountObj, actualAmountObj);
        ContractBudgetAmount maxAmountObj = contractAmountList.stream().max(Comparator.comparing(ContractBudgetAmount::getAmount)).orElse(contractAmountObj);
        long maxValueCount = contractAmountList.stream().filter(obj -> obj.getAmount().compareTo(maxAmountObj.getAmount()) == 0).count();
        if (maxValueCount == 1L) {
            return maxAmountObj.getType();
        }
        return performAmountType;
    }

    private static PerformAmountTypeEnum getApplyPerformAmountType(String payDirection) {
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue()) ? PerformAmountTypeEnum.INCOME : PerformAmountTypeEnum.PAY;
    }

    private static PerformAmountTypeEnum getActualPerformAmountType(String payDirection) {
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue()) ? PerformAmountTypeEnum.ACTUAL_INCOME : PerformAmountTypeEnum.ACTUAL_PAY;
    }

    private static boolean isHasPerformEntryObj(DynamicObjectCollection performEntry, PerformAmountTypeEnum occupyType) {
        boolean hasPerformEntryObj = false;
        for (DynamicObject performEntryObj : performEntry) {
            String performAmtType = performEntryObj.getString("performamttype");
            if (!StringUtils.equals((CharSequence)performAmtType, (CharSequence)occupyType.getValue())) continue;
            hasPerformEntryObj = true;
            break;
        }
        return hasPerformEntryObj;
    }

    protected static PerformAmountTypeEnum getOccupyTypeByProjectBudget(DynamicObject projectBudget, String contractId) {
        DynamicObjectCollection performEntry = projectBudget.getDynamicObjectCollection("performentry");
        for (DynamicObject entry : performEntry) {
            String entryContractId = entry.getString("contract_id");
            if (entryContractId == null || !StringUtils.equals((CharSequence)entryContractId, (CharSequence)contractId) || !StringUtils.equals((CharSequence)entry.getString("performtype"), (CharSequence)PerformTypeEnum.OCCUPY.getValue())) continue;
            return PerformAmountTypeEnum.getEnumByValue(entry.getString("performamttype"));
        }
        return null;
    }

    public static void updatePerformType(DynamicObjectCollection performEntry, PerformAmountTypeEnum performAmountType, String contractId, long billPk, DynamicObject billType, boolean isRemove) {
        if (performEntry != null && !performEntry.isEmpty()) {
            Iterator iterator = performEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                long entryBillId = entry.getLong("billid");
                DynamicObject performBillType = entry.getDynamicObject("billtype");
                if (!isRemove || entryBillId != billPk || billType == null || performBillType == null || !billType.getPkValue().equals(performBillType.getPkValue())) continue;
                iterator.remove();
            }
        }
    }

    protected static void updatePerformDetail(DynamicObject performDetail, BigDecimal amount, BigDecimal amountEx, DynamicObject billType, String billStatus, String performType, PerformBillInfo billInfo) {
        performDetail.set("billamt", (Object)amount);
        performDetail.set("billamtoncont", (Object)amountEx);
        performDetail.set("billcreatedate", (Object)billInfo.getCreateDate());
        performDetail.set("billcreator", (Object)billInfo.getCreator());
        performDetail.set("billauditdate", (Object)billInfo.getAuditDate());
        performDetail.set("billauditor", (Object)billInfo.getAuditor());
        performDetail.set("billid", (Object)billInfo.getId());
        performDetail.set("billname", (Object)billInfo.getBillName());
        performDetail.set("billno", (Object)billInfo.getBillNo());
        performDetail.set("billstatus", (Object)billStatus);
        performDetail.set("billtype", (Object)billType);
        performDetail.set("performtype", (Object)performType);
        performDetail.set("performamttype", (Object)billInfo.getAmountType().getValue());
        performDetail.set("contract", (Object)billInfo.getContractId());
        performDetail.set("contract_id", (Object)billInfo.getContractId());
    }

    public static DynamicObject newContractBudget(String budgetItemId, String contractId) {
        DynamicObject contractBudget = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractbudget"));
        contractBudget.set("budgetitem", (Object)budgetItemId);
        contractBudget.set("contract", (Object)contractId);
        return contractBudget;
    }

    public static BudgetValidateInfo validateProjectBudget(Set<String> proBudgetIds, Map<String, BigDecimal> updateBudgetAmountMap, Map<String, DynamicObject> proBudgetPerformMap) {
        if (!updateBudgetAmountMap.isEmpty()) {
            ProjectBudgetUpdateHelper.summaryOccupyAmountToParent(proBudgetPerformMap, updateBudgetAmountMap);
            Map<DynamicObject, DynamicObject> resultMap = ProjectBudgetUpdateHelper.checkOutOfControlBudgets(proBudgetPerformMap, proBudgetIds);
            if (resultMap.isEmpty()) {
                resultMap = ProjectBudgetUpdateHelper.checkRemindBudgets(proBudgetPerformMap, proBudgetIds);
                if (resultMap.isEmpty()) {
                    return null;
                }
                return new BudgetValidateInfo(false, true, resultMap);
            }
            return new BudgetValidateInfo(true, false, resultMap);
        }
        return null;
    }

    protected static Map<DynamicObject, DynamicObject> checkOutOfControlBudgets(Map<String, DynamicObject> budgetMap, Set<String> budgetIds) {
        HashMap<DynamicObject, DynamicObject> result = new HashMap<DynamicObject, DynamicObject>(16);
        if (budgetIds != null && budgetMap != null) {
            for (String budgetId : budgetIds) {
                DynamicObject outOfControlBudget = ProjectBudgetUpdateHelper.checkOutOfControlBudget(budgetMap, budgetId);
                if (outOfControlBudget == null) continue;
                result.put(budgetMap.get(budgetId), outOfControlBudget);
            }
        }
        return result;
    }

    protected static DynamicObject checkOutOfControlBudget(Map<String, DynamicObject> budgetMap, String budgetId) {
        DynamicObject budgetItem = budgetMap.get(budgetId);
        if (budgetItem == null) {
            return null;
        }
        if (ProjectBudgetUpdateHelper.checkIsOutOfControl(budgetItem)) {
            return budgetItem;
        }
        if (budgetItem.getLong("parent") != 0L) {
            return ProjectBudgetUpdateHelper.checkOutOfControlBudget(budgetMap, String.valueOf(budgetItem.getLong("parent")));
        }
        return null;
    }

    protected static boolean checkIsOutOfControl(DynamicObject budget) {
        BigDecimal controlAmount;
        BigDecimal occupyAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("occupyamt"));
        return occupyAmount.compareTo(controlAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("controlamt"))) > 0 && controlAmount.compareTo(BigDecimal.ZERO) != 0;
    }

    protected static Map<DynamicObject, DynamicObject> checkRemindBudgets(Map<String, DynamicObject> budgetMap, Set<String> budgetIds) {
        HashMap<DynamicObject, DynamicObject> result = new HashMap<DynamicObject, DynamicObject>();
        if (budgetIds != null && budgetMap != null) {
            for (String budgetId : budgetIds) {
                DynamicObject remindBudget = ProjectBudgetUpdateHelper.checkRemindBudget(budgetMap, budgetId);
                if (remindBudget == null) continue;
                result.put(budgetMap.get(budgetId), remindBudget);
            }
        }
        return result;
    }

    protected static DynamicObject checkRemindBudget(Map<String, DynamicObject> budgetMap, String budgetId) {
        DynamicObject budgetItem = budgetMap.get(budgetId);
        if (budgetItem == null) {
            return null;
        }
        if (ProjectBudgetUpdateHelper.checkIsOutOfRemind(budgetItem)) {
            return budgetItem;
        }
        if (budgetItem.getLong("parent") != 0L) {
            return ProjectBudgetUpdateHelper.checkRemindBudget(budgetMap, String.valueOf(budgetItem.getLong("parent")));
        }
        return null;
    }

    protected static boolean checkIsOutOfRemind(DynamicObject budget) {
        BigDecimal remindAmount;
        BigDecimal occupyAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("occupyamt"));
        return occupyAmount.compareTo(remindAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("remindamt"))) > 0 && remindAmount.compareTo(BigDecimal.ZERO) != 0;
    }

    public static void summaryOccupyAmountToParent(Map<String, DynamicObject> proBudgetPerformMap, Map<String, BigDecimal> updateBudgetAmountMap) {
        if (updateBudgetAmountMap != null && !updateBudgetAmountMap.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : updateBudgetAmountMap.entrySet()) {
                BigDecimal budgetAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(entry.getValue());
                ProjectBudgetUpdateHelper.updateOccupyAmount(entry.getKey(), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    public static void summaryActualAmountToParent(Map<String, DynamicObject> proBudgetPerformMap, Map<String, BigDecimal> updateBudgetAmountMap, boolean isDedcut) {
        if (updateBudgetAmountMap != null && !updateBudgetAmountMap.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : updateBudgetAmountMap.entrySet()) {
                BigDecimal budgetAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(entry.getValue()).multiply(isDedcut ? BigDecimal.valueOf(-1L) : BigDecimal.ONE);
                ProjectBudgetUpdateHelper.updateActualAmount(entry.getKey(), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    public static void summaryPayAmountToParent(Map<String, DynamicObject> budgetMap, Map<String, BigDecimal> budgetAmountMap, boolean isDedcut) {
        if (budgetAmountMap != null && !budgetAmountMap.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : budgetAmountMap.entrySet()) {
                BigDecimal budgetAmount = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(entry.getValue()).multiply(isDedcut ? BigDecimal.valueOf(-1L) : BigDecimal.ONE);
                ProjectBudgetUpdateHelper.updatePayAmount(entry.getKey(), budgetAmount, budgetMap);
            }
        }
    }

    protected static void updatePayAmount(String budgetId, BigDecimal budgetAmount, Map<String, DynamicObject> budgetMap) {
        DynamicObject budget = budgetMap.get(budgetId);
        if (budget != null) {
            BigDecimal payAmt = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(budget.getBigDecimal("performamt")).add(budgetAmount);
            budget.set("performamt", (Object)payAmt);
            long parentId = budget.getLong("parent");
            if (budgetMap.containsKey(String.valueOf(parentId))) {
                ProjectBudgetUpdateHelper.updatePayAmount(String.valueOf(parentId), budgetAmount, budgetMap);
            }
        }
    }

    protected static void updateOccupyAmount(String budgetId, BigDecimal budgetAmount, Map<String, DynamicObject> proBudgetPerformMap) {
        DynamicObject proBudgetPerform = proBudgetPerformMap.get(budgetId);
        if (proBudgetPerform != null) {
            BigDecimal occupyAmt = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(proBudgetPerform.getBigDecimal("occupyamt")).add(budgetAmount);
            BigDecimal remainAmt = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(proBudgetPerform.getBigDecimal("remainamt")).subtract(budgetAmount);
            proBudgetPerform.set("occupyamt", (Object)occupyAmt);
            proBudgetPerform.set("remainamt", (Object)remainAmt);
            BigDecimal amount = proBudgetPerform.getBigDecimal("budgetamount");
            BigDecimal remainRate = BigDecimal.ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                remainRate = remainAmt.divide(amount, 10, RoundingMode.HALF_UP);
            }
            proBudgetPerform.set("remainrate", (Object)remainRate);
            long parentId = proBudgetPerform.getLong("parent");
            if (proBudgetPerformMap.containsKey(String.valueOf(parentId))) {
                ProjectBudgetUpdateHelper.updateOccupyAmount(String.valueOf(parentId), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    protected static void updateActualAmount(String budgetId, BigDecimal budgetAmount, Map<String, DynamicObject> proBudgetPerformMap) {
        DynamicObject proBudgetPerform = proBudgetPerformMap.get(budgetId);
        if (proBudgetPerform != null) {
            BigDecimal actualAmt = ProjectBudgetUpdateHelper.getDefaultZeroBigDecimal(proBudgetPerform.getBigDecimal("actualamt")).add(budgetAmount);
            proBudgetPerform.set("actualamt", (Object)actualAmt);
            long parentId = proBudgetPerform.getLong("parent");
            if (proBudgetPerformMap.containsKey(String.valueOf(parentId))) {
                ProjectBudgetUpdateHelper.updateActualAmount(String.valueOf(parentId), budgetAmount, proBudgetPerformMap);
            }
        }
    }

    public static void loadAllBudget(Map<String, DynamicObject> projectBudgetMap, Set<String> projectBudgetIds) {
        HashSet<String> parentBudgetIds = new HashSet<String>();
        Set<Long> budgetIdsSet = projectBudgetIds.stream().filter(o -> QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)o)).map(Long::parseLong).collect(Collectors.toSet());
        if (budgetIdsSet.size() > 0) {
            DynamicObject[] projectBudgets;
            for (DynamicObject projectBudget : projectBudgets = BusinessDataServiceHelper.load((Object[])budgetIdsSet.toArray(new Long[budgetIdsSet.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudget"))) {
                projectBudgetMap.put(projectBudget.getString("id"), projectBudget);
                long parentId = projectBudget.getLong("parent");
                String parentPk = String.valueOf(parentId);
                if (parentId == 0L || projectBudgetMap.get(parentPk) != null || projectBudgetIds.contains(parentPk)) continue;
                parentBudgetIds.add(parentPk);
            }
        }
        if (!parentBudgetIds.isEmpty()) {
            ProjectBudgetUpdateHelper.loadAllBudget(projectBudgetMap, parentBudgetIds);
        }
    }

    protected static String getBudgetSubmitAmountId(PerformAmountTypeEnum performAmountType) {
        switch (performAmountType) {
            case SETTLE: {
                return "settlesubmitamt";
            }
            case INCOME: 
            case PAY: {
                return "payapplysubmitamt";
            }
            case ACTUAL_INCOME: 
            case ACTUAL_PAY: {
                return "actualsubmitamt";
            }
        }
        return "contractsubmitamt";
    }

    protected static String getBudgetAuditAmountId(PerformAmountTypeEnum performAmountType) {
        switch (performAmountType) {
            case SETTLE: {
                return "settleauditamt";
            }
            case INCOME: 
            case PAY: {
                return "payapplyauditamt";
            }
            case ACTUAL_INCOME: 
            case ACTUAL_PAY: {
                return "actualauditamt";
            }
        }
        return "contractauditamt";
    }

    public static DynamicObject getBillType(String formBillId) {
        QFilter filter = new QFilter("number", "=", (Object)formBillId);
        return BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"id,number,name,modeltype,bizappid", (QFilter[])new QFilter[]{filter});
    }

    protected static DynamicObject getBillPerformEntry(DynamicObject projectBudget, long billPk, DynamicObject billType) {
        DynamicObjectCollection performEntry;
        if (projectBudget != null && !(performEntry = projectBudget.getDynamicObjectCollection("performentry")).isEmpty()) {
            for (DynamicObject entry : performEntry) {
                long entryBillId = entry.getLong("billid");
                DynamicObject entryBillType = entry.getDynamicObject("billtype");
                if (entryBillId != billPk || billType == null || entryBillType == null || !billType.getPkValue().equals(entryBillType.getPkValue())) continue;
                return entry;
            }
        }
        return null;
    }

    protected static BigDecimal getDefaultZeroBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public static BigDecimal getExchangeRate(DynamicObject contract, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = contract.getDynamicObject("currency");
        DynamicObject stdCurrency = contract.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return contract.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable(org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate(contractCurrency.getLong("id"), proCurrency.getLong("id"), exRateTable.getLong("id"), contract.getDate("createtime"));
        }
        return exchangeRate;
    }

    private static class ContractBudgetAmount {
        BigDecimal amount;
        PerformAmountTypeEnum type;

        public ContractBudgetAmount(PerformAmountTypeEnum type, BigDecimal amount) {
            this.type = type;
            this.amount = amount;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public PerformAmountTypeEnum getType() {
            return this.type;
        }
    }
}

