/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.contract;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class TotalSettleAndRealAmountUtils {
    public static BigDecimal totalSettleOfTaxAmount(DynamicObject contract, DynamicObject period, DynamicObject contpartb) {
        BigDecimal totalsettleoftaxamount = BigDecimal.ZERO;
        if (null != contract) {
            DynamicObject[] settles;
            String direction = contract.getString("paydirection");
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("contract", "=", contract.getPkValue()));
            filterList.add(new QFilter("billstatus", "=", (Object)"C"));
            String formBillId = null;
            if (StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.IN.getValue())) {
                filterList.add(new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue()));
                formBillId = "pmct_incontract_settle";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.OUT.getValue())) {
                filterList.add(new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue()));
                formBillId = "pmct_outcontract_settle";
                if (contpartb != null && contract.getBoolean("ismulticontract")) {
                    filterList.add(new QFilter("contpartb", "=", contpartb.getPkValue()));
                }
            }
            if (null != period) {
                filterList.add(new QFilter("period.enddate", "<=", (Object)period.getDate("enddate")));
            }
            QFilter[] qFilters = new QFilter[filterList.size()];
            for (DynamicObject settle : settles = BusinessDataServiceHelper.load((String)formBillId, (String)"settleoftaxamount", (QFilter[])filterList.toArray(qFilters))) {
                BigDecimal settleBigDecimal = (BigDecimal)settle.get("settleoftaxamount");
                totalsettleoftaxamount = totalsettleoftaxamount.add(settleBigDecimal);
            }
        }
        return totalsettleoftaxamount;
    }

    public static BigDecimal totalRealOfTaxAmount(DynamicObject contract, DynamicObject period, DynamicObject contpartb) {
        BigDecimal totalrealoftaxamount;
        block11: {
            DynamicObject[] incomeRegisters;
            String direction;
            QFilter[] qFilters;
            ArrayList<QFilter> arrayList;
            block12: {
                totalrealoftaxamount = BigDecimal.ZERO;
                if (null == contract) break block11;
                arrayList = new ArrayList<QFilter>();
                arrayList.add(new QFilter("entryentity.entrycontract.id", "=", contract.getPkValue()));
                arrayList.add(new QFilter("billstatus", "=", (Object)"C"));
                if (null != period) {
                    arrayList.add(new QFilter("period.enddate", "<=", (Object)period.getDate("enddate")));
                }
                qFilters = new QFilter[arrayList.size()];
                direction = contract.getString("paydirection");
                incomeRegisters = null;
                if (!StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.IN.getValue())) break block12;
                for (DynamicObject incomeRegister : incomeRegisters = BusinessDataServiceHelper.load((String)"pmct_incomeregister", (String)"receiptoftaxamount,entryentity.entrycontract", (QFilter[])arrayList.toArray(qFilters))) {
                    DynamicObjectCollection incomeEntries = incomeRegister.getDynamicObjectCollection("entryentity");
                    for (DynamicObject incomeEntrie : incomeEntries) {
                        DynamicObject entrycontract = incomeEntrie.getDynamicObject("entrycontract");
                        BigDecimal settleBigDecimal = BigDecimal.ZERO;
                        if (contract.getPkValue().equals(entrycontract.getPkValue())) {
                            settleBigDecimal = incomeEntrie.getBigDecimal("receiptoftaxamount");
                        }
                        totalrealoftaxamount = totalrealoftaxamount.add(settleBigDecimal);
                    }
                }
                break block11;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.OUT.getValue())) break block11;
            if (contpartb != null && contract.getBoolean("ismulticontract")) {
                arrayList.add(new QFilter("entryentity.contpartb", "=", contpartb.getPkValue()));
            }
            for (DynamicObject incomeRegister : incomeRegisters = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)"thispaymentoftaxamount,entryentity.entrycontract,entryentity.contpartb", (QFilter[])arrayList.toArray(qFilters))) {
                DynamicObjectCollection incomeEntries = incomeRegister.getDynamicObjectCollection("entryentity");
                for (DynamicObject incomeEntry : incomeEntries) {
                    DynamicObject entrycontract = incomeEntry.getDynamicObject("entrycontract");
                    DynamicObject entrycontPartb = incomeEntry.getDynamicObject("contpartb");
                    BigDecimal settleBigDecimal = BigDecimal.ZERO;
                    if (contract.getPkValue().equals(entrycontract.getPkValue())) {
                        if (!contract.getBoolean("ismulticontract")) {
                            settleBigDecimal = incomeEntry.getBigDecimal("thispaymentoftaxamount");
                        } else if (contpartb != null && entrycontPartb != null && contpartb.getPkValue().equals(entrycontPartb.getPkValue())) {
                            settleBigDecimal = incomeEntry.getBigDecimal("thispaymentoftaxamount");
                        }
                    }
                    totalrealoftaxamount = totalrealoftaxamount.add(settleBigDecimal);
                }
            }
        }
        return totalrealoftaxamount;
    }

    public static BigDecimal totalApplyOfTaxAmount(DynamicObject contract, DynamicObject period, DynamicObject contPartB) {
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("entryentity.entrycontract.id", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        if (period != null) {
            filterList.add(new QFilter("period", "=", period.getPkValue()));
        }
        if (contract.getBoolean("ismulticontract") && contPartB != null) {
            filterList.add(new QFilter("entryentity.contpartb", "=", contPartB.getPkValue()));
        }
        QFilter[] qFilters = new QFilter[filterList.size()];
        String direction = contract.getString("paydirection");
        if (StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.OUT.getValue())) {
            DynamicObject[] payApplySingles;
            BigDecimal entryAmount;
            DynamicObject[] payApplies;
            for (DynamicObject payApply : payApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"applyoftaxamount,entryentity.entrycontract,entryentity.contpartb,entryentity.contpro", (QFilter[])filterList.toArray(qFilters))) {
                DynamicObjectCollection entries = payApply.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    DynamicObject entryContract = entry.getDynamicObject("entrycontract");
                    DynamicObject entryContPartB = entry.getDynamicObject("contpartb");
                    entryAmount = BigDecimal.ZERO;
                    if (contract != null && entryContract != null && contract.getPkValue().equals(entryContract.getPkValue())) {
                        if (!contract.getBoolean("ismulticontract")) {
                            entryAmount = entry.getBigDecimal("applyoftaxamount");
                        } else if (contPartB != null && entryContPartB != null && contPartB.getPkValue().equals(entryContPartB.getPkValue())) {
                            entryAmount = entry.getBigDecimal("applyoftaxamount");
                        }
                    }
                    amount = amount.add(entryAmount);
                }
            }
            filterList.clear();
            filterList.add(new QFilter("contract", "=", contract.getPkValue()));
            filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
            if (period != null) {
                filterList.add(new QFilter("period", "=", period.getPkValue()));
            }
            if (contract.getBoolean("ismulticontract") && contPartB != null) {
                filterList.add(new QFilter("supplier", "=", contPartB.getPkValue()));
            }
            qFilters = new QFilter[filterList.size()];
            for (DynamicObject payApplySingle : payApplySingles = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"contract,supplier,paydetailentry,curpayamtoftax", (QFilter[])filterList.toArray(qFilters))) {
                DynamicObjectCollection entries = payApplySingle.getDynamicObjectCollection("paydetailentry");
                DynamicObject singleContPartB = payApplySingle.getDynamicObject("supplier");
                if (contract.getBoolean("ismulticontract") && (!contract.getBoolean("ismulticontract") || contPartB == null || singleContPartB == null || !contPartB.getPkValue().equals(singleContPartB.getPkValue()))) continue;
                for (DynamicObject entry : entries) {
                    entryAmount = entry.getBigDecimal("curpayamtoftax");
                    amount = amount.add(entryAmount);
                }
            }
        } else {
            DynamicObject[] incomeApplys;
            for (DynamicObject incomeApply : incomeApplys = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"entryentity, entryentity.entrycontract,entryentity.contpro, entryentity.applyoftaxamount", (QFilter[])filterList.toArray(new QFilter[0]))) {
                DynamicObjectCollection incomeApplyEntryColl = incomeApply.getDynamicObjectCollection("entryentity");
                for (DynamicObject incomeApplyEntry : incomeApplyEntryColl) {
                    DynamicObject entryContract = incomeApplyEntry.getDynamicObject("entrycontract");
                    if (contract == null || entryContract == null || !contract.getPkValue().equals(entryContract.getPkValue())) continue;
                    amount = amount.add(incomeApplyEntry.getBigDecimal("applyoftaxamount"));
                }
            }
        }
        return amount;
    }
}

