/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.invoicecloud;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class InvoiceCloudConfigHelper {
    private static final Log log = LogFactory.getLog(InvoiceCloudConfigHelper.class);
    public static final String PREURL_TEST = "https://www.piaozone.com/test";
    public static final String PREURL = "https://www.piaozone.com";
    public static final String USERKEY_URL = "/m4/fpzs/getUserKey";
    public static final String VIEW_URL = "/m4/fpzs/web/v3";
    public static final String QUERY_BY_INVOICESERIAL_URL = "/m4/fpzs/expense/invoice/detail/query";

    public static boolean checkTest() {
        DynamicObject test = QueryServiceHelper.queryOne((String)"er_stdconfig", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"invoicecloud.not_prod").toArray());
        return test.get("value").equals("true");
    }

    public static String getEnv() {
        DynamicObject test = QueryServiceHelper.queryOne((String)"er_stdconfig", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"invoicecloud.not_prod").toArray());
        if (test.get("value").equals("true")) {
            return "test";
        }
        return "prod";
    }

    public static String getViewUrl() {
        if (InvoiceCloudConfigHelper.checkTest()) {
            return "https://www.piaozone.com/test/m4/fpzs/web/v3";
        }
        return "https://www.piaozone.com/m4/fpzs/web/v3";
    }

    public static String getQueryByInvoiceSerialNoUrl() {
        if (InvoiceCloudConfigHelper.checkTest()) {
            return "https://www.piaozone.com/test/m4/fpzs/expense/invoice/detail/query";
        }
        return "https://www.piaozone.com/m4/fpzs/expense/invoice/detail/query";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserKey(Map<String, Object> param) {
        String userKey;
        OutputStream os = null;
        FilterOutputStream dos = null;
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            String line;
            URL url = InvoiceCloudConfigHelper.checkTest() ? new URL("https://www.piaozone.com/test/m4/fpzs/getUserKey") : new URL("https://www.piaozone.com/m4/fpzs/getUserKey");
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setRequestProperty("Connection", "Keep-Alive");
            JSONObject requestParams = new JSONObject();
            requestParams.putAll(param);
            log.info("getUserKey\uff0curl:{}\uff0crequestParams:{}", (Object)url, (Object)requestParams);
            conn.connect();
            os = conn.getOutputStream();
            dos = new DataOutputStream(os);
            dos.write(requestParams.toString().getBytes(StandardCharsets.UTF_8));
            ((DataOutputStream)dos).flush();
            dos.close();
            is = conn.getInputStream();
            isr = new InputStreamReader(is);
            BufferedReader in = new BufferedReader(isr);
            StringBuilder resultSb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                resultSb.append(line);
            }
            String result = resultSb.toString();
            log.info("getUserKey:\uff0curl:{}\uff0cresult:{}", (Object)url, (Object)result);
            in.close();
            try {
                JSONObject obj = (JSONObject)JSONObject.parse((String)result);
                log.info("getUserKey:\uff0curl:{}\uff0cobj:JSON{}", (Object)url, (Object)obj);
                String errorCode = obj.getString("errcode");
                JSONObject data = obj.getJSONObject("data");
                if (!errorCode.equals("0000")) {
                    String string = result + "::conn::error";
                    return string;
                }
                userKey = data.getString("userKey");
            }
            catch (JSONException e) {
                String string = result + "::recieve::error";
                return string;
            }
        }
        catch (Exception e) {
            String string = e.getMessage() + "::error";
            return string;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return userKey;
    }

    public static DynamicObject getConfigByAws(DynamicObject company) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", company.getPkValue()), new QFilter("enable", "=", (Object)true)};
        String model = InvoiceCloudConfigHelper.getInvoiceControlModel();
        DynamicObject config = StringUtils.equals((CharSequence)"1", (CharSequence)model) ? QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"org,taxregnum,firmname,client_id,client_secret,encrypt_key,reimed_ci,namenotmatch_ci,taxnumnotmatch_ci,checknotpass_ci,buyernamele5_ci", (QFilter[])filters) : InvoiceCloudConfigHelper.getGroupCtrlConfig(Long.parseLong(company.getPkValue().toString()));
        if (config == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u3010%s\u3011\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceCloudConfigHelper_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]), company.getLocaleString("name").getLocaleValue()));
        }
        return config;
    }

    private static DynamicObject getGroupCtrlConfig(Long companyId) {
        QFilter enableQFilter;
        DynamicObject config = null;
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_bd_kdinvoicecloudcfgct", (Long)companyId);
        Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])new QFilter[]{baseDataFilter, enableQFilter = new QFilter("enable", "=", (Object)true)});
        if (configMap != null && !configMap.isEmpty()) {
            Collection configs = configMap.values();
            config = configs.stream().min((c1, c2) -> {
                Long createOrg1 = Long.parseLong(c1.getDynamicObject("createorg").getPkValue().toString());
                Long createOrg2 = Long.parseLong(c2.getDynamicObject("createorg").getPkValue().toString());
                if (Objects.equals(createOrg1, companyId) && !Objects.equals(createOrg2, companyId)) {
                    return -1;
                }
                if (Objects.equals(createOrg2, companyId) && !Objects.equals(createOrg1, companyId)) {
                    return 1;
                }
                String ctlStrategy1 = c1.getString("ctrlstrategy");
                String ctlStrategy2 = c2.getString("ctrlstrategy");
                if (StringUtils.equals((CharSequence)ctlStrategy1, (CharSequence)"7") && !StringUtils.equals((CharSequence)ctlStrategy2, (CharSequence)"7")) {
                    return -1;
                }
                if (StringUtils.equals((CharSequence)ctlStrategy2, (CharSequence)"7") && !StringUtils.equals((CharSequence)ctlStrategy1, (CharSequence)"7")) {
                    return 1;
                }
                Date modifyDate1 = c1.getDate("modifytime");
                Date modifyDate2 = c2.getDate("modifytime");
                return InvoiceCloudConfigHelper.dateCompare(modifyDate2, modifyDate1);
            }).orElse(null);
            if (config == null) {
                return null;
            }
            long id = config.getLong("id");
            log.info("getGroupCtrlConfig:id:{}", (Object)id);
            String taxRegNumStr = configs.stream().map(o -> (String)StringUtils.defaultIfBlank((CharSequence)o.getString("taxregnum"), (CharSequence)"")).collect(Collectors.joining("="));
            String firmNameStr = configs.stream().map(o -> (String)StringUtils.defaultIfBlank((CharSequence)o.getString("firmname"), (CharSequence)"")).collect(Collectors.joining("="));
            config.set("taxregnum", (Object)taxRegNumStr);
            config.set("firmname", (Object)firmNameStr);
        }
        return config;
    }

    public static List<Map<String, Object>> getConfigByInvoiceCloud(DynamicObject company) {
        ArrayList<Map<String, Object>> companyInfo = new ArrayList<Map<String, Object>>();
        String model = InvoiceCloudConfigHelper.getInvoiceControlModel();
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.equals((CharSequence)"1", (CharSequence)model)) {
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(company.getPkValue().toString())), new QFilter("enable", "=", (Object)true)};
            DynamicObject curOrgConfig = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"taxregnum,firmname", (QFilter[])filters);
            if (curOrgConfig != null) {
                map.put("name", curOrgConfig.getString("firmname"));
                map.put("taxNo", curOrgConfig.getString("taxregnum"));
                companyInfo.add(map);
            }
        } else {
            QFilter enableQFilter;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_bd_kdinvoicecloudcfgct", (Long)Long.parseLong(company.getPkValue().toString()));
            Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])new QFilter[]{baseDataFilter, enableQFilter = new QFilter("enable", "=", (Object)true)});
            if (configMap != null && !configMap.isEmpty()) {
                Collection configs = configMap.values();
                for (DynamicObject config : configs) {
                    map = new HashMap();
                    map.put("name", config.getString("firmname"));
                    map.put("taxNo", config.getString("taxregnum"));
                    companyInfo.add(map);
                }
            }
        }
        return companyInfo;
    }

    public static String getInvoiceControlModel() {
        String model = null;
        DynamicObject controlMode = QueryServiceHelper.queryOne((String)"er_stdconfig", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"invoicecloud.configpattern").toArray());
        if (controlMode != null) {
            model = controlMode.getString("value");
        }
        return model;
    }

    static int dateCompare(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        return d1.compareTo(d2);
    }
}

