/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.poi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.enums.ProjectTeamManTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;

public class POIHelper {
    private static final Log logger = LogFactory.getLog(POIHelper.class);
    public static final String COLUMNKEY = "columnKey";
    public static final String COLUMNNAME = "columnName";
    public static final String COLUMNUMBER = "columnNumber";
    public static final String MUSTFILL = "mustFill";
    public static final String CELLVALUE = "cellValue";

    public static List<String> getColumnKeys(JSONArray header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        ArrayList<String> columnKeys = new ArrayList<String>(10);
        for (Object columnObj : header) {
            JSONObject column = JSONObject.parseObject((String)columnObj.toString());
            columnKeys.add(column.getString(COLUMNKEY));
        }
        return columnKeys;
    }

    public static List<String> getColumnNames(JSONArray header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        ArrayList<String> columnNames = new ArrayList<String>(10);
        for (Object columnObj : header) {
            JSONObject column = JSONObject.parseObject((String)columnObj.toString());
            columnNames.add(column.getString(COLUMNNAME));
        }
        return columnNames;
    }

    public static List<String> getMustFillColumn(JSONArray header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        ArrayList<String> columnKeys = new ArrayList<String>(10);
        for (Object columnObj : header) {
            JSONObject column = JSONObject.parseObject((String)columnObj.toString());
            if (!column.getBooleanValue(MUSTFILL)) continue;
            columnKeys.add(column.getString(COLUMNKEY));
        }
        return columnKeys;
    }

    public static String exportExcel(String fileName, String sheetName, String[] header, String[] columnKey, List<String> mustFillColumn, JSONArray data) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        Row columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        HSSFCellStyle columnKeyHashCellCss = wb.createCellStyle();
        HSSFDataFormat columnKeyHashCellFormat = wb.createDataFormat();
        columnKeyHashCellCss.setDataFormat(columnKeyHashCellFormat.getFormat("@"));
        columnKeyHashCell.setCellStyle((CellStyle)columnKeyHashCellCss);
        columnKeyHashCell.setCellValue(POIHelper.stringArrayToHash(columnKey));
        Row columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        Row nameRow = sheet.createRow(2);
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell columnKeyCell = null;
        Cell nameCell = null;
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            columnKeyCell = columnKeyRow.createCell(i);
            columnKeyCell.setCellValue(columnKey[i]);
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i);
            if (mustFillColumn != null && mustFillColumn.contains(columnKey[i])) {
                HSSFCellStyle mustFillColumnStyle = wb.createCellStyle();
                mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
                mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                mustFillColumnStyle.setBorderTop(BorderStyle.THIN);
                mustFillColumnStyle.setBorderLeft(BorderStyle.THIN);
                mustFillColumnStyle.setBorderRight(BorderStyle.THIN);
                mustFillColumnStyle.setBorderBottom(BorderStyle.THIN);
                mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                mustFillColumnStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
                HSSFFont mheadFont = wb.createFont();
                mheadFont.setColor(IndexedColors.RED.getIndex());
                mustFillColumnStyle.setFont((Font)mheadFont);
                nameCell.setCellValue(header[i] + "*");
                nameCell.setCellStyle((CellStyle)mustFillColumnStyle);
                if (!"stafftype".equals(columnKey[i])) continue;
                CellRangeAddressList regions = new CellRangeAddressList(3, 1000, i, i);
                DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])ProjectTeamManTypeEnum.getManTypes());
                HSSFDataValidation data_validation_list = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
                sheet.addValidationData((DataValidation)data_validation_list);
                continue;
            }
            if ("stafftype".equals(columnKey[i])) {
                nameCell.setCellValue(header[i]);
                nameCell.setCellStyle((CellStyle)titleCellStyle);
                CellRangeAddressList regions = new CellRangeAddressList(3, 1000, i, i);
                DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])ProjectTeamManTypeEnum.getManTypes());
                HSSFDataValidation data_validation_list = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
                sheet.addValidationData((DataValidation)data_validation_list);
                continue;
            }
            nameCell.setCellValue(header[i]);
            nameCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                nameRow = sheet.createRow(i + 3);
                for (int j = 0; j < columnKey.length; ++j) {
                    nameCell = nameRow.createCell(j);
                    nameCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray importExcel(String url, String coulmnHashCode) {
        JSONArray jsonArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(url);
            HSSFWorkbook wb = null;
            try {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                wb = new HSSFWorkbook(fs);
                HSSFSheet sheet = wb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                HSSFRow columnKeyRow = sheet.getRow(1);
                HSSFRow headerRow = sheet.getRow(2);
                HSSFRow columnKeyHashRow = sheet.getRow(0);
                if (columnKeyHashRow == null || columnKeyHashRow.getCell(0) == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f\u3002", (String)"POIHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                String columnKeyHashCellValue = columnKeyHashRow.getCell(0).getStringCellValue();
                if (!StringUtils.equals((CharSequence)columnKeyHashCellValue, (CharSequence)coulmnHashCode)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f\u3002", (String)"POIHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 3; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    for (int i = 0; i < columnNum; ++i) {
                        HSSFRow irow = sheet.getRow(j);
                        JSONObject jsonObject = new JSONObject();
                        columnKeyRow.getCell(i).setCellType(CellType.STRING);
                        headerRow.getCell(i).setCellType(CellType.STRING);
                        jsonObject.put(COLUMNKEY, (Object)columnKeyRow.getCell(i).getStringCellValue());
                        jsonObject.put(COLUMNKEY, (Object)headerRow.getCell(i).getStringCellValue());
                        String value = "";
                        if (irow.getCell(i) != null) {
                            irow.getCell(i).setCellType(CellType.STRING);
                            value = irow.getCell(i).getStringCellValue();
                        }
                        jsonObject.put(CELLVALUE, (Object)value);
                        jsonRow.add((Object)jsonObject);
                    }
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            finally {
                if (wb != null) {
                    try {
                        wb.close();
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray importProjTeamExcel(String url, String coulmnHashCode) {
        JSONArray jsonArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            Workbook wb = null;
            try {
                wb = WorkbookFactory.create((InputStream)in);
                Sheet sheet = wb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                Row columnKeyRow = sheet.getRow(1);
                Row headerRow = sheet.getRow(2);
                Row columnKeyHashRow = sheet.getRow(0);
                if (columnKeyHashRow == null || columnKeyHashRow.getCell(0) == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f\u3002", (String)"POIHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                String columnKeyHashCellValue = columnKeyHashRow.getCell(0).getStringCellValue();
                if (!StringUtils.equals((CharSequence)columnKeyHashCellValue, (CharSequence)coulmnHashCode)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f\u3002", (String)"POIHelper_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 3; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    for (int i = 0; i < columnNum; ++i) {
                        Row irow = sheet.getRow(j);
                        JSONObject jsonObject = new JSONObject();
                        columnKeyRow.getCell(i).setCellType(CellType.STRING);
                        headerRow.getCell(i).setCellType(CellType.STRING);
                        jsonObject.put(COLUMNKEY, (Object)columnKeyRow.getCell(i).getStringCellValue());
                        jsonObject.put(COLUMNNAME, (Object)headerRow.getCell(i).getStringCellValue());
                        String value = "";
                        if (irow.getCell(i) != null) {
                            irow.getCell(i).setCellType(CellType.STRING);
                            value = irow.getCell(i).getStringCellValue();
                        }
                        jsonObject.put(CELLVALUE, (Object)value);
                        jsonRow.add((Object)jsonObject);
                    }
                    long count = jsonRow.stream().map(o -> !StringUtils.isBlank((CharSequence)((String)((JSONObject)o).get((Object)CELLVALUE)))).filter(aBoolean -> aBoolean == true).count();
                    if (count <= 0L) continue;
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            finally {
                if (wb != null) {
                    try {
                        wb.close();
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        return jsonArray;
    }

    public static String stringArrayToHash(String[] stringArray) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            str.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            str.append(',');
        }
        return String.valueOf(str.toString().hashCode());
    }

    public static List<String> getHeadByExcel(String url) {
        ArrayList<String> reurnArray = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(url);
            try {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                HSSFSheet sheet = wb.getSheetAt(0);
                HSSFRow columnKeyRow = sheet.getRow(0);
                int columnNum = columnKeyRow.getLastCellNum();
                for (int i = 0; i < columnNum; ++i) {
                    columnKeyRow.getCell(i).setCellType(CellType.STRING);
                    String headkey = columnKeyRow.getCell(i).getStringCellValue();
                    if ("".equals(columnKeyRow.getCell(i).getStringCellValue())) continue;
                    reurnArray.add(headkey);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return reurnArray;
    }
}

