/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.task;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;

public class PmpmTaskUtil {
    private static final String selectString = "id,parent,pretask,belongplantype,project,percent,completionstatus,realendtime,planstarttime,aimfinishtime,planendtime,absoluteduration,logical,relativeduration,comptimedeviation";

    public static void updateTaskStatusByIdSet(Set<Object> taskIdSet) {
        int compareResult;
        String completionStatus;
        int i;
        QFilter idFilter = new QFilter("id", "in", taskIdSet);
        Date nowDate = new Date();
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,completionstatus,percent,planstarttime,planendtime,realendtime", (QFilter[])new QFilter[]{idFilter});
        for (i = 0; i < taskArr.length; ++i) {
            Date planStartTime;
            completionStatus = taskArr[i].getString("completionstatus");
            if (!StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.UNSTART.getValue()) || (planStartTime = taskArr[i].getDate("planstarttime")) == null || (compareResult = DateUtil.compareByDay(planStartTime, nowDate)) == 1) continue;
            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
        }
        for (i = 0; i < taskArr.length; ++i) {
            Date planEndTime;
            completionStatus = taskArr[i].getString("completionstatus");
            if (!StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.PROGRESSING.getValue()) || (planEndTime = taskArr[i].getDate("planendtime")) == null || (compareResult = DateUtil.compareByDay(planEndTime, nowDate)) != -1) continue;
            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
        }
        PmpmTaskUtil.updateTaskStatusByPlanTime(taskArr);
        SaveServiceHelper.save((DynamicObject[])taskArr);
    }

    public static void autoUpdateUnStartToInProcess() {
        DynamicObject[] unStartTaskArr;
        ArrayList<DynamicObject> changedStatusTaskList = new ArrayList<DynamicObject>();
        Date nowDate = new Date();
        QFilter statusFilter = new QFilter("completionstatus", "=", (Object)CompletionStatusEnum.UNSTART.getValue());
        for (DynamicObject unStartTask : unStartTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,completionstatus,planstarttime", (QFilter[])new QFilter[]{statusFilter})) {
            int compareResult;
            Date planStartTime = unStartTask.getDate("planstarttime");
            if (planStartTime == null || (compareResult = DateUtil.compareByDay(planStartTime, nowDate)) == 1) continue;
            unStartTask.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
            changedStatusTaskList.add(unStartTask);
        }
        SaveServiceHelper.save((DynamicObject[])changedStatusTaskList.toArray(new DynamicObject[changedStatusTaskList.size()]));
    }

    public static void autoUpdateInProcessToOverdue() {
        DynamicObject[] inProcessTaskArr;
        ArrayList<DynamicObject> changedStatusTaskList = new ArrayList<DynamicObject>();
        Date nowDate = new Date();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(CompletionStatusEnum.PROGRESSING.getValue());
        statusList.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
        QFilter statusFilter = new QFilter("completionstatus", "in", statusList);
        for (DynamicObject inProcessTask : inProcessTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,completionstatus,planendtime", (QFilter[])new QFilter[]{statusFilter})) {
            int compareResult;
            Date planEndTime = inProcessTask.getDate("planendtime");
            if (planEndTime == null || (compareResult = DateUtil.compareByDay(planEndTime, nowDate)) != -1) continue;
            inProcessTask.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
            changedStatusTaskList.add(inProcessTask);
        }
        SaveServiceHelper.save((DynamicObject[])changedStatusTaskList.toArray(new DynamicObject[changedStatusTaskList.size()]));
    }

    public static Date getDateAfterAddDays(Object projectId, Date srcDate, int days) {
        if (projectId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"PmpmTaskUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        if (srcDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        List<DynamicObject> calList = PmpmTaskUtil.getCalendarList(projectId);
        return PmpmTaskUtil.getDateByCalList(calList, srcDate, days);
    }

    public static Date getDateAfterAddRelativeDays(Object projectId, Date srcDate, int relativeDays) {
        if (projectId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"PmpmTaskUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        if (srcDate == null) {
            return null;
        }
        if (relativeDays == 0) {
            return srcDate;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        List<DynamicObject> calList = PmpmTaskUtil.getCalendarList(projectId);
        return PmpmTaskUtil.getDateByCalListByRelative(calList, srcDate, relativeDays);
    }

    private static Date getDateByCalListByRelative(List<DynamicObject> calList, Date srcDate, int days) {
        if (calList != null && calList.size() > 0) {
            List<DynamicObject> projectCalendarDetailList = PmpmTaskUtil.getCalendarDetailList(calList);
            ArrayList<DynamicObject> workDateDetailList = new ArrayList<DynamicObject>();
            boolean srcDateIsWorkDay = false;
            if (days < 0) {
                for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                    String dateType = projectCalendarDetail.getString("datetype");
                    if (!StringUtils.equals((CharSequence)"1", (CharSequence)dateType)) continue;
                    Date workDate = projectCalendarDetail.getDate("workdate");
                    if (srcDate.compareTo(workDate) == 0) {
                        srcDateIsWorkDay = true;
                    }
                    if (workDate.compareTo(srcDate) > 0) continue;
                    workDateDetailList.add(projectCalendarDetail);
                }
                if (workDateDetailList.size() < Math.abs(days)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5728\u6839\u636e\u76f8\u5bf9\u5de5\u671f\u8ba1\u7b97\u82e5\u5e72\u5929\u540e\u7684\u65e5\u671f\u65f6\uff0c\u53d1\u73b0\u5de5\u4f5c\u65e5\u5386\u4e2d\uff0c\u5728%1$s\u7684%2$s\u5929\u540e\u7684\u65e5\u671f\uff0c\u4e0d\u5728\u65e5\u5386\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\u6709\u6548\u671f\u3002", (String)"PmpmTaskUtil_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]), srcDate.toString(), days);
                    throw new KDBizException(msg);
                }
                DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(workDateDetailList.size() + days);
                return aimCalendar.getDate("workdate");
            }
            for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                String dateType = projectCalendarDetail.getString("datetype");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)dateType)) continue;
                Date workDate = projectCalendarDetail.getDate("workdate");
                if (srcDate.compareTo(workDate) == 0) {
                    srcDateIsWorkDay = true;
                }
                if (workDate.compareTo(srcDate) < 0) continue;
                workDateDetailList.add(projectCalendarDetail);
            }
            if (!srcDateIsWorkDay) {
                --days;
            }
            if (workDateDetailList.size() < days + 1) {
                String msg = String.format(ResManager.loadKDString((String)"\u5728\u6839\u636e\u76f8\u5bf9\u5de5\u671f\u8ba1\u7b97\u82e5\u5e72\u5929\u540e\u7684\u65e5\u671f\u65f6\uff0c\u53d1\u73b0\u5de5\u4f5c\u65e5\u5386\u4e2d\uff0c\u5728%1$s\u7684%2$s\u5929\u540e\u7684\u65e5\u671f\uff0c\u4e0d\u5728\u65e5\u5386\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\u6709\u6548\u671f\u3002", (String)"PmpmTaskUtil_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]), srcDate.toString(), days);
                throw new KDBizException(msg);
            }
            DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(days);
            return aimCalendar.getDate("workdate");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    public static boolean checkDateIsWorkDay(Date date, Object id, int type) {
        boolean isWorkDay = false;
        List<Object> calList = new ArrayList();
        calList = type == 1 ? PmpmTaskUtil.getCalendarList(id) : PmpmTaskUtil.getCalListByOrg(id);
        List<DynamicObject> projectCalendarDetailList = PmpmTaskUtil.getCalendarDetailList(calList);
        for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
            Date workDate;
            String dateType = projectCalendarDetail.getString("datetype");
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)dateType) || date.compareTo(workDate = projectCalendarDetail.getDate("workdate")) != 0) continue;
            isWorkDay = true;
            return isWorkDay;
        }
        return isWorkDay;
    }

    public static Date getDateAfterAddDaysByOrg(Object orgId, Date srcDate, int days) {
        if (orgId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"PmpmTaskUtil_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        if (srcDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        List<DynamicObject> calList = PmpmTaskUtil.getCalListByOrg(orgId);
        return PmpmTaskUtil.getDateByCalList(calList, srcDate, days);
    }

    public static Date getDateAfterAddRelativeDaysByOrg(Object orgId, Date srcDate, int relativeDays) {
        if (orgId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"PmpmTaskUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        }
        if (srcDate == null) {
            return null;
        }
        if (relativeDays == 0) {
            return srcDate;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        List<DynamicObject> calList = PmpmTaskUtil.getCalListByOrg(orgId);
        return PmpmTaskUtil.getDateByCalListByRelative(calList, srcDate, relativeDays);
    }

    public static BigDecimal getAbsDurationByOrgId(Object orgId, Date beginDate, Date endDate) {
        List<DynamicObject> calList = PmpmTaskUtil.getCalListByOrg(orgId);
        return PmpmTaskUtil.getDaysByCalList(calList, beginDate, endDate);
    }

    private static List<DynamicObject> getCalListByOrg(Object orgId) {
        List<DynamicObject> calList = new ArrayList<DynamicObject>();
        QFilter orgFilter = new QFilter("org", "=", orgId);
        DynamicObject[] orgCalendarArr = BusinessDataServiceHelper.load((String)"pmpt_projworkcalendarset", (String)"id,project,org,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{orgFilter}, (String)"isindividuation desc");
        if (orgCalendarArr != null && orgCalendarArr.length > 0) {
            for (int i = 0; i < orgCalendarArr.length; ++i) {
                calList.add(orgCalendarArr[i]);
            }
        } else {
            List supOrg = OrgUnitServiceHelper.getSuperiorOrgs((String)"15", (long)Long.parseLong(orgId.toString()));
            if (supOrg != null && supOrg.size() > 0 && (Long)supOrg.get(0) != 0L) {
                calList = PmpmTaskUtil.getCalListByOrg(supOrg.get(0));
            } else {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                for (DynamicObject dynamicObject : orgCalendarArr = BusinessDataServiceHelper.load((String)"pmpt_projworkcalendarset", (String)"id,project,org,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"isindividuation desc")) {
                    calList.add(dynamicObject);
                }
            }
        }
        return calList;
    }

    private static List<DynamicObject> getCalendarList(Object projectId) {
        ArrayList<DynamicObject> calList;
        block9: {
            Map projectCalendarArr;
            block7: {
                block8: {
                    calList = new ArrayList<DynamicObject>();
                    QFilter projectFilter = new QFilter("project", "=", projectId);
                    projectCalendarArr = BusinessDataServiceHelper.loadFromCache((String)"pmpt_projworkcalendarset", (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{projectFilter}, (String)"isindividuation desc");
                    if (projectCalendarArr == null || projectCalendarArr.isEmpty()) break block7;
                    if (projectCalendarArr.size() != 2) break block8;
                    for (Map.Entry entry : projectCalendarArr.entrySet()) {
                        calList.add((DynamicObject)entry.getValue());
                    }
                    break block9;
                }
                if (projectCalendarArr.size() != 1) break block9;
                DynamicObject projectCal = null;
                for (Map.Entry entry : projectCalendarArr.entrySet()) {
                    projectCal = (DynamicObject)entry.getValue();
                }
                if (projectCal != null && !projectCal.getBoolean("isindividuation")) {
                    for (Map.Entry entry : projectCalendarArr.entrySet()) {
                        calList.add((DynamicObject)entry.getValue());
                    }
                } else {
                    QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                    DynamicObject[] defProjectCalendarArr = BusinessDataServiceHelper.load((String)"pmpt_projworkcalendarset", (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"isindividuation desc");
                    calList.add(projectCal);
                    for (DynamicObject dynamicObject : defProjectCalendarArr) {
                        calList.add(dynamicObject);
                    }
                }
                break block9;
            }
            QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
            projectCalendarArr = BusinessDataServiceHelper.loadFromCache((String)"pmpt_projworkcalendarset", (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"isindividuation desc");
            for (Map.Entry entry : projectCalendarArr.entrySet()) {
                calList.add((DynamicObject)entry.getValue());
            }
        }
        return calList;
    }

    public static BigDecimal getAbsDuration(Object projectId, Date beginDate, Date endDate) {
        List<DynamicObject> calList = PmpmTaskUtil.getCalendarList(projectId);
        return PmpmTaskUtil.getDaysByCalList(calList, beginDate, endDate);
    }

    private static Date getDateByCalList(List<DynamicObject> calList, Date srcDate, int days) {
        if (calList != null && calList.size() > 0) {
            List<DynamicObject> projectCalendarDetailList = PmpmTaskUtil.getCalendarDetailList(calList);
            ArrayList<DynamicObject> workDateDetailList = new ArrayList<DynamicObject>();
            if (days < 0) {
                for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                    Date workDate;
                    String dateType = projectCalendarDetail.getString("datetype");
                    if (!StringUtils.equals((CharSequence)"1", (CharSequence)dateType) || (workDate = projectCalendarDetail.getDate("workdate")).compareTo(srcDate) > 0) continue;
                    workDateDetailList.add(projectCalendarDetail);
                }
                if (workDateDetailList.size() < Math.abs(days)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5728\u6839\u636e\u7edd\u5bf9\u5de5\u671f\u8ba1\u7b97\u82e5\u5e72\u5929\u540e\u7684\u65e5\u671f\u65f6\uff0c\u53d1\u73b0\u5de5\u4f5c\u65e5\u5386\u4e2d\uff0c\u5728%1$s\u7684%2$s\u5929\u540e\u7684\u65e5\u671f\uff0c\u4e0d\u5728\u65e5\u5386\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\u6709\u6548\u671f\u3002", (String)"PmpmTaskUtil_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]), srcDate.toString(), days);
                    throw new KDBizException(msg);
                }
                DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(workDateDetailList.size() + days);
                return aimCalendar.getDate("workdate");
            }
            for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                Date workDate;
                String dateType = projectCalendarDetail.getString("datetype");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)dateType) || (workDate = projectCalendarDetail.getDate("workdate")).compareTo(srcDate) < 0) continue;
                workDateDetailList.add(projectCalendarDetail);
            }
            if (workDateDetailList.size() < days + 1) {
                String msg = String.format(ResManager.loadKDString((String)"\u5728\u6839\u636e\u7edd\u5bf9\u5de5\u671f\u8ba1\u7b97\u82e5\u5e72\u5929\u540e\u7684\u65e5\u671f\u65f6\uff0c\u53d1\u73b0\u5de5\u4f5c\u65e5\u5386\u4e2d\uff0c\u5728%1$s\u7684%2$s\u5929\u540e\u7684\u65e5\u671f\uff0c\u4e0d\u5728\u65e5\u5386\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\u6709\u6548\u671f\u3002", (String)"PmpmTaskUtil_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]), srcDate.toString(), days);
                throw new KDBizException(msg);
            }
            DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(days);
            return aimCalendar.getDate("workdate");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    private static BigDecimal getDaysByCalList(List<DynamicObject> calList, Date beginDate, Date endDate) {
        ArrayList<DynamicObject> workDateDetailList = new ArrayList<DynamicObject>();
        if (calList != null && calList.size() > 0) {
            List<DynamicObject> projectCalendarDetailList = PmpmTaskUtil.getCalendarDetailList(calList);
            if (projectCalendarDetailList.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            }
            boolean endDateIsWorkDay = false;
            boolean beginDateIsWorkDay = false;
            for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                String dateType = projectCalendarDetail.getString("datetype");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)dateType)) continue;
                Date workDate = projectCalendarDetail.getDate("workdate");
                if (workDate.compareTo(endDate) == 0) {
                    endDateIsWorkDay = true;
                }
                if (workDate.compareTo(endDate) >= 0) break;
                if (workDate.compareTo(beginDate) < 0) continue;
                workDateDetailList.add(projectCalendarDetail);
            }
            if (workDateDetailList.size() == 0 && !endDateIsWorkDay && !beginDateIsWorkDay) {
                return BigDecimal.ZERO;
            }
            if (workDateDetailList.size() == 0 && endDateIsWorkDay) {
                return BigDecimal.ZERO;
            }
            if (workDateDetailList.size() <= 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5728\u83b7\u53d6\u65f6\u95f4%1$s\u4e0e%2$s\u4e4b\u95f4\u7684\u76f8\u5dee\u5929\u6570\u65f6\uff0c\u53d1\u73b0\u4e24\u65e5\u671f\u4e4b\u95f4\u6ca1\u6709\u5de5\u4f5c\u65e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PmpmTaskUtil_5", (String)"pmgt-pmbs-common", (Object[])new Object[0]), beginDate.toString(), endDate.toString());
                throw new KDBizException(msg);
            }
            if (!endDateIsWorkDay) {
                return BigDecimal.valueOf(workDateDetailList.size()).subtract(BigDecimal.ONE);
            }
            return BigDecimal.valueOf(workDateDetailList.size());
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    public static BigDecimal getDaysBetweenTwoDate(Object projectId, Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        if (beginDate.compareTo(endDate) < 0) {
            return PmpmTaskUtil.getAbsDuration(projectId, beginDate, endDate);
        }
        if (beginDate.compareTo(endDate) > 0) {
            return BigDecimal.ZERO.subtract(PmpmTaskUtil.getAbsDuration(projectId, endDate, beginDate));
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getDaysBetweenTwoDateByOrg(Object orgId, Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        if (beginDate.compareTo(endDate) < 0) {
            return PmpmTaskUtil.getAbsDurationByOrgId(orgId, beginDate, endDate);
        }
        if (beginDate.compareTo(endDate) > 0) {
            return BigDecimal.ZERO.subtract(PmpmTaskUtil.getAbsDurationByOrgId(orgId, endDate, beginDate));
        }
        return BigDecimal.ZERO;
    }

    public static String updateResultDoc(String resultDoc, int flag, int number) {
        String[] docNumArr = resultDoc.split("/");
        if (docNumArr.length != 2) {
            return resultDoc;
        }
        if (flag == 0) {
            String xString = docNumArr[0];
            String newString = xString.replaceFirst("\\d+", String.valueOf(number));
            return newString + "/" + docNumArr[1];
        }
        String xString = docNumArr[1];
        String newString = xString.replaceFirst("\\d+", String.valueOf(number));
        return docNumArr[0] + "/" + newString;
    }

    public static void updateReferTaskTime(DynamicObject Task) {
        DynamicObject project = Task.getDynamicObject("project");
        QFilter projectFilter = null;
        if (project != null) {
            projectFilter = new QFilter("project", "=", project.getPkValue());
        }
        QFilter notAuditFilter = new QFilter("status", "!=", (Object)"C");
        DynamicObject[] referTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)selectString, (QFilter[])new QFilter[]{projectFilter, notAuditFilter});
        PmpmTaskUtil.updataAfterTaskTime(referTaskArr, Task);
        PmpmTaskUtil.updateParentTaskTime(referTaskArr, Task);
        PmpmTaskUtil.updateTaskStatusByPlanTime(referTaskArr);
        SaveServiceHelper.save((DynamicObject[])referTaskArr);
    }

    public static void updateSamePlanReferTaskTime(DynamicObject task) {
        DynamicObject project = task.getDynamicObject("project");
        QFilter projectFilter = null;
        if (project != null) {
            projectFilter = new QFilter("project", "=", project.getPkValue());
        }
        QFilter planFilter = null;
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            String planType = belongPlanType.getString("plantype");
            String plans = task.getString("plans");
            JSONObject planObject = JSONObject.parseObject((String)plans);
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)planType)) {
                planFilter = new QFilter("plans", "like", (Object)("%" + planObject.getString("mainproplanid") + "%")).and(new QFilter("belongplantype.plantype", "=", belongPlanType.get("plantype")));
            } else if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType)) {
                planFilter = new QFilter("plans", "like", (Object)("%" + planObject.getString("majorproplanid") + "%")).and(new QFilter("belongplantype.plantype", "=", belongPlanType.get("plantype")));
            } else if (StringUtils.equals((CharSequence)PlanTypeEnum.DEPTPLAN.getValue(), (CharSequence)planType)) {
                planFilter = new QFilter("plans", "like", (Object)("%" + planObject.getString("deptplanid") + "%")).and(new QFilter("belongplantype.plantype", "=", belongPlanType.get("plantype")));
            } else if (StringUtils.equals((CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue(), (CharSequence)planType)) {
                planFilter = new QFilter("plans", "like", (Object)("%" + planObject.getString("privateplanid") + "%")).and(new QFilter("belongplantype.plantype", "=", belongPlanType.get("plantype")));
            }
        }
        DynamicObject[] referTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)selectString, (QFilter[])new QFilter[]{projectFilter, planFilter});
        PmpmTaskUtil.updataAfterTaskTime(referTaskArr, task);
        PmpmTaskUtil.updateParentTaskTime(referTaskArr, task);
        SaveServiceHelper.save((DynamicObject[])referTaskArr);
    }

    public static void updataAfterTaskTime(DynamicObject[] referTaskArr, DynamicObject currentTask) {
        for (int i = 0; i < referTaskArr.length; ++i) {
            DynamicObject preTaskOfReferTask = referTaskArr[i].getDynamicObject("pretask");
            if (preTaskOfReferTask == null) continue;
            Object preTaskId = preTaskOfReferTask.getPkValue();
            if (!currentTask.getPkValue().equals(preTaskId)) continue;
            PmpmTaskUtil.updateTimeByLogicAndPreTask(referTaskArr[i], currentTask);
            if (PmpmTaskUtil.needToUpdateParentTime(referTaskArr[i])) {
                PmpmTaskUtil.updateParentTaskTime(referTaskArr, referTaskArr[i]);
            }
            PmpmTaskUtil.updataAfterTaskTime(referTaskArr, referTaskArr[i]);
        }
    }

    public static boolean needToUpdateParentTime(DynamicObject currentTask) {
        boolean flag = false;
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask != null) {
            Date afterUpdatePlanStartTime = currentTask.getDate("planstarttime");
            Date afterUpdatePlanEndTime = currentTask.getDate("planendtime");
            Date parentTaskPlanStartTime = parentTask.getDate("planstarttime");
            Date parentTaskPlanEndTime = parentTask.getDate("planendtime");
            if (afterUpdatePlanStartTime != null && parentTaskPlanStartTime == null || afterUpdatePlanEndTime != null && parentTaskPlanEndTime == null) {
                flag = true;
                return flag;
            }
            if (afterUpdatePlanStartTime != null && parentTaskPlanStartTime != null && afterUpdatePlanEndTime != null && parentTaskPlanEndTime != null && (afterUpdatePlanStartTime.before(parentTaskPlanStartTime) || afterUpdatePlanEndTime.after(parentTaskPlanEndTime))) {
                flag = true;
            }
        }
        return flag;
    }

    public static void updateTimeByLogicAndPreTask(DynamicObject currentTask, DynamicObject preTask) {
        Date planStartTime = preTask.getDate("planstarttime");
        Date planEndTime = preTask.getDate("planendtime");
        String logical = currentTask.getString("logical");
        DynamicObject proejct = currentTask.getDynamicObject("project");
        int relativeduration = currentTask.getInt("relativeduration");
        if (++relativeduration < 0) {
            --relativeduration;
        }
        if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
            if (proejct != null) {
                Date newAfterTaskPlanStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays(proejct.getPkValue(), planStartTime, relativeduration);
                if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planstarttime", newAfterTaskPlanStartTime)) {
                    currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
                }
                BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
                Date newAfterTaskPlanEndTime = PmpmTaskUtil.getDateAfterAddDays(proejct.getPkValue(), newAfterTaskPlanStartTime, absDuration.intValue() - 1);
                if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planendtime", newAfterTaskPlanEndTime)) {
                    currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
                }
                BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate(proejct.getPkValue(), newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime"));
                currentTask.set("comptimedeviation", (Object)days);
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
            if (proejct != null) {
                Date newAfterTaskPlanEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays(proejct.getPkValue(), planStartTime, relativeduration);
                if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planendtime", newAfterTaskPlanEndTime)) {
                    currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
                }
                BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate(proejct.getPkValue(), newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime"));
                currentTask.set("comptimedeviation", (Object)days);
                BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
                Date newAfterTaskPlanStartTime = PmpmTaskUtil.getDateAfterAddDays(proejct.getPkValue(), newAfterTaskPlanEndTime, -absDuration.intValue());
                if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planstarttime", newAfterTaskPlanStartTime)) {
                    currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
                }
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
            if (proejct != null) {
                Date newAfterTaskPlanStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays(proejct.getPkValue(), planEndTime, relativeduration);
                if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planstarttime", newAfterTaskPlanStartTime)) {
                    currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
                }
                BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
                Date newAfterTaskPlanEndTime = PmpmTaskUtil.getDateAfterAddDays(proejct.getPkValue(), newAfterTaskPlanStartTime, absDuration.intValue() - 1);
                if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planendtime", newAfterTaskPlanEndTime)) {
                    currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
                }
                BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate(proejct.getPkValue(), newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime"));
                currentTask.set("comptimedeviation", (Object)days);
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) && proejct != null) {
            Date newAfterTaskPlanEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays(proejct.getPkValue(), planEndTime, relativeduration);
            if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planendtime", newAfterTaskPlanEndTime)) {
                currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
            }
            BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate(proejct.getPkValue(), newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime"));
            currentTask.set("comptimedeviation", (Object)days);
            BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
            Date newAfterTaskPlanStartTime = PmpmTaskUtil.getDateAfterAddDays(proejct.getPkValue(), newAfterTaskPlanEndTime, -absDuration.intValue());
            if (!PmpmTaskUtil.newCheckOutMainTaskTime(currentTask, "planstarttime", newAfterTaskPlanStartTime)) {
                currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
            }
        }
    }

    public static void updateParentTaskTime(DynamicObject[] referTaskArr, DynamicObject currentTask) {
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask == null) {
            return;
        }
        for (int i = 0; i < referTaskArr.length; ++i) {
            if (!parentTask.getPkValue().equals(referTaskArr[i].getPkValue())) continue;
            DynamicObject currentTaskBelongPlanType = currentTask.getDynamicObject("belongplantype");
            DynamicObject parentTaskBelongPlanType = referTaskArr[i].getDynamicObject("belongplantype");
            if (currentTaskBelongPlanType != null && parentTaskBelongPlanType != null && StringUtils.equals((CharSequence)currentTaskBelongPlanType.getString("plantype"), (CharSequence)PlanTypeEnum.MAJORPLAN.getValue()) && StringUtils.equals((CharSequence)parentTaskBelongPlanType.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
                return;
            }
            List<Date> timeList = PmpmTaskUtil.getTimeListBySameParent(parentTask, referTaskArr);
            if (timeList == null || timeList.size() == 0) continue;
            PmpmTaskUtil.updateParentTaskTimeByTime(referTaskArr[i], timeList.get(0), timeList.get(1));
            PmpmTaskUtil.updataAfterTaskTime(referTaskArr, referTaskArr[i]);
            PmpmTaskUtil.updateParentTaskTime(referTaskArr, referTaskArr[i]);
        }
    }

    private static List<Date> getTimeListBySameParent(DynamicObject parentTask, DynamicObject[] referTaskArr) {
        ArrayList<Date> timeList = new ArrayList<Date>();
        boolean changeFlag = false;
        Date firstStartTime = null;
        Date lastEndTime = null;
        for (int i = 0; i < referTaskArr.length; ++i) {
            DynamicObject parentTaskOfReferTask = referTaskArr[i].getDynamicObject("parent");
            if (parentTaskOfReferTask == null) continue;
            Object parentId = parentTaskOfReferTask.getPkValue();
            if (!parentTask.getPkValue().equals(parentId)) continue;
            Date planStartTime = referTaskArr[i].getDate("planstarttime");
            Date planEndTime = referTaskArr[i].getDate("planendtime");
            if (planStartTime != null && (firstStartTime == null || planStartTime.before(firstStartTime))) {
                firstStartTime = planStartTime;
                changeFlag = true;
            }
            if (planEndTime == null || lastEndTime != null && !planEndTime.after(lastEndTime)) continue;
            lastEndTime = planEndTime;
            changeFlag = true;
        }
        if (changeFlag) {
            timeList.add(firstStartTime);
            timeList.add(lastEndTime);
        }
        return timeList;
    }

    public static void updateParentTaskTimeByTime(DynamicObject parentTask, Date startTime, Date endTime) {
        DynamicObject project = parentTask.getDynamicObject("project");
        if (project != null) {
            parentTask.set("planstarttime", (Object)startTime);
            parentTask.set("planendtime", (Object)endTime);
            Date parentAimEndTime = parentTask.getDate("aimfinishtime");
            if (parentAimEndTime == null) {
                parentTask.set("aimfinishtime", (Object)endTime);
            }
            BigDecimal absDays = PmpmTaskUtil.getDaysBetweenTwoDate(project.getPkValue(), startTime, endTime);
            parentTask.set("absoluteduration", (Object)absDays.add(BigDecimal.ONE));
            BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate(project.getPkValue(), endTime, parentTask.getDate("aimfinishtime"));
            parentTask.set("comptimedeviation", (Object)days);
        }
    }

    public static void updateParentTaskTimeByCurrentTask(DynamicObject parentTask, DynamicObject currentTask) {
        DynamicObject project = currentTask.getDynamicObject("project");
        Date afterUpdatePlanStartTime = currentTask.getDate("planstarttime");
        Date afterUpdatePlanEndTime = currentTask.getDate("planendtime");
        Date parentTaskPlanStartTime = parentTask.getDate("planstarttime");
        Date parentTaskPlanEndTime = parentTask.getDate("planendtime");
        if (afterUpdatePlanStartTime != null && (parentTaskPlanStartTime == null || afterUpdatePlanStartTime.before(parentTaskPlanStartTime)) && project != null) {
            parentTask.set("planstarttime", (Object)afterUpdatePlanStartTime);
            BigDecimal absDuration = parentTask.getBigDecimal("absoluteduration");
            Date newAfterTaskPlanEndTime = PmpmTaskUtil.getDateAfterAddDays(project.getPkValue(), afterUpdatePlanStartTime, absDuration.intValue() - 1);
            parentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
            BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate(project.getPkValue(), newAfterTaskPlanEndTime, parentTask.getDate("aimfinishtime"));
            parentTask.set("comptimedeviation", (Object)days);
        }
        if (afterUpdatePlanEndTime != null && (parentTaskPlanEndTime == null || afterUpdatePlanEndTime.after(parentTaskPlanEndTime)) && project != null) {
            parentTask.set("planendtime", (Object)afterUpdatePlanEndTime);
            if (parentTask.getDate("aimfinishtime") == null) {
                parentTask.set("aimfinishtime", (Object)afterUpdatePlanEndTime);
            }
            BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate(project.getPkValue(), afterUpdatePlanEndTime, parentTask.getDate("aimfinishtime"));
            parentTask.set("comptimedeviation", (Object)days);
            Date afterTaskPlanStartTime = parentTask.getDate("planstarttime");
            BigDecimal absDuration = PmpmTaskUtil.getDaysBetweenTwoDate(project.getPkValue(), afterTaskPlanStartTime, afterUpdatePlanEndTime);
            parentTask.set("absoluteduration", (Object)absDuration.add(BigDecimal.ONE));
        }
    }

    private static List<DynamicObject> updateAllTaskEndTimeByProjectWhenCalChange(Object projectId, int prior) {
        DynamicObject[] taskArr = null;
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("C");
        statusList.add("B");
        QFilter statusFilter = new QFilter("status", "not in", statusList);
        ArrayList<DynamicObject> afterUpdateEndTimeTaskList = new ArrayList<DynamicObject>();
        if (projectId != null && StringUtils.equals((CharSequence)projectId.toString(), (CharSequence)"0")) {
            QFilter isProjectFilter = new QFilter("project", "!=", (Object)0L);
            taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,level,parent,pretask,project,belongplantype,completionstatus,planstarttime,planendtime,absoluteduration,logical,relativeduration,comptimedeviation", (QFilter[])new QFilter[]{isProjectFilter, statusFilter});
        } else {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,level,parent,pretask,project,belongplantype,completionstatus,planstarttime,planendtime,aimfinishtime,absoluteduration,logical,relativeduration,comptimedeviation", (QFilter[])new QFilter[]{projectFilter, statusFilter});
        }
        if (prior == 1) {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
                Date planEndTime = PmpmTaskUtil.getDateAfterAddDays(projectId, planStartTime, absoluteDuration.intValue() - 1);
                task.set("planendtime", (Object)planEndTime);
                Date aimEndTime = task.getDate("aimfinishtime");
                BigDecimal compTimeDeviation = PmpmTaskUtil.getDaysBetweenTwoDate(projectId, planEndTime, aimEndTime);
                task.set("comptimedeviation", (Object)compTimeDeviation);
                afterUpdateEndTimeTaskList.add(task);
            }
        } else {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                Date planEndTime = task.getDate("planendtime");
                BigDecimal absDuration = PmpmTaskUtil.getDaysBetweenTwoDate(projectId, planStartTime, planEndTime);
                task.set("absoluteduration", (Object)absDuration.add(BigDecimal.ONE));
                afterUpdateEndTimeTaskList.add(task);
            }
        }
        return afterUpdateEndTimeTaskList;
    }

    private static List<DynamicObject> updateAllTaskEndTime(DynamicObject[] taskArr, int prior) {
        ArrayList<DynamicObject> afterUpdateEndTimeTaskList = new ArrayList<DynamicObject>();
        if (prior == 1) {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
                DynamicObject project = task.getDynamicObject("project");
                if (project == null) continue;
                Date planEndTime = PmpmTaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absoluteDuration.intValue() - 1);
                task.set("planendtime", (Object)planEndTime);
                Date aimEndTime = task.getDate("aimfinishtime");
                BigDecimal compTimeDeviation = PmpmTaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planEndTime, aimEndTime);
                task.set("comptimedeviation", (Object)compTimeDeviation);
                afterUpdateEndTimeTaskList.add(task);
            }
        } else {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                Date planEndTime = task.getDate("planendtime");
                DynamicObject project = task.getDynamicObject("project");
                if (project == null) continue;
                BigDecimal absDuration = PmpmTaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planStartTime, planEndTime);
                task.set("absoluteduration", (Object)absDuration.add(BigDecimal.ONE));
                afterUpdateEndTimeTaskList.add(task);
            }
        }
        return afterUpdateEndTimeTaskList;
    }

    public static void updateTimeWhenCalChange(Object projectId, int prior) {
        List<DynamicObject> afterUpdateEndTimeTaskList = PmpmTaskUtil.updateAllTaskEndTimeByProjectWhenCalChange(projectId, prior);
        DynamicObject[] afterUpdateEndTimeTaskArr = afterUpdateEndTimeTaskList.toArray(new DynamicObject[afterUpdateEndTimeTaskList.size()]);
        if (prior == 2) {
            SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
            return;
        }
        for (int i = 0; i < afterUpdateEndTimeTaskList.size(); ++i) {
            PmpmTaskUtil.updataAfterTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i]);
            PmpmTaskUtil.updateParentTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i]);
        }
        SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
    }

    public static void updateTimeWhenOrgCalChange(Object orgId, int prior) {
        PmpmTaskUtil.updateTimeByOrg(Long.valueOf(String.valueOf(orgId)), prior);
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(Long.valueOf(String.valueOf(orgId)));
        List directSubOrgList = OrgUnitServiceHelper.getSubOrgLimitLevel(orgList, (int)1, (boolean)false);
        if (directSubOrgList != null && directSubOrgList.size() > 0) {
            ArrayList<Long> noCalOrgList = new ArrayList<Long>();
            for (Long directSubOrg : directSubOrgList) {
                QFilter orgFilter = new QFilter("org", "=", (Object)directSubOrg);
                boolean isExist = QueryServiceHelper.exists((String)"pmpt_projworkcalendarset", (QFilter[])new QFilter[]{orgFilter});
                if (isExist) continue;
                noCalOrgList.add(directSubOrg);
            }
            for (Long noCalOrg : noCalOrgList) {
                PmpmTaskUtil.updateTimeWhenOrgCalChange(noCalOrg, prior);
            }
        }
    }

    private static void updateTimeByOrg(Long orgId, int prior) {
        Set<Object> taskIdSet = PmpmTaskUtil.getTaskIdSetByOrgId(orgId);
        PmpmTaskUtil.updateDeptTaskTime(taskIdSet, prior, orgId);
    }

    public static void updateDeptTaskTime(Set<Object> taskIdSet, int prior, Long orgId) {
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((Object[])taskIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmpm_task"));
        ArrayList<DynamicObject> afterUpdateEndTimeTaskList = new ArrayList<DynamicObject>();
        if (prior == 1) {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
                Date planEndTime = PmpmTaskUtil.getDateAfterAddDaysByOrg(orgId, planStartTime, absoluteDuration.intValue() - 1);
                task.set("planendtime", (Object)planEndTime);
                Date aimEndTime = task.getDate("aimfinishtime");
                BigDecimal compTimeDeviation = PmpmTaskUtil.getDaysBetweenTwoDateByOrg(orgId, planEndTime, aimEndTime);
                task.set("comptimedeviation", (Object)compTimeDeviation);
                afterUpdateEndTimeTaskList.add(task);
            }
        } else {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                Date planEndTime = task.getDate("planendtime");
                BigDecimal absDuration = PmpmTaskUtil.getDaysBetweenTwoDateByOrg(orgId, planStartTime, planEndTime);
                task.set("absoluteduration", (Object)absDuration.add(BigDecimal.ONE));
                afterUpdateEndTimeTaskList.add(task);
            }
        }
        SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskList.toArray(new DynamicObject[afterUpdateEndTimeTaskList.size()]));
    }

    public static void updateTimeWhenDefaultCalChange(int prior) {
        PmpmTaskUtil.updateProjectTaskTime(prior);
        Long rootOrg = OrgUnitServiceHelper.getRootOrgId();
        PmpmTaskUtil.updateTimeWhenOrgCalChange(rootOrg, prior);
    }

    public static void updateProjectTaskTime(int prior) {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("C");
        statusList.add("B");
        QFilter statusFilter = new QFilter("status", "not in", statusList);
        DynamicObject[] projCalArr = BusinessDataServiceHelper.load((String)"pmpt_projworkcalendarset", (String)"id,project", (QFilter[])new QFilter[]{new QFilter("project", "!=", (Object)0L)});
        HashSet<Object> hasCalProjectIdSet = new HashSet<Object>();
        for (DynamicObject projCal : projCalArr) {
            DynamicObject project = projCal.getDynamicObject("project");
            if (project == null) continue;
            hasCalProjectIdSet.add(project.getPkValue());
        }
        QFilter projectNotInCalFilter = new QFilter("project", "not in", hasCalProjectIdSet);
        QFilter projectNotNullFilter = new QFilter("project", "!=", (Object)0L);
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,level,parent,pretask,project,belongplantype,completionstatus,planstarttime,planendtime,absoluteduration,logical,relativeduration,comptimedeviation,aimfinishtime", (QFilter[])new QFilter[]{projectNotInCalFilter, projectNotNullFilter, statusFilter});
        List<DynamicObject> afterUpdateEndTimeTaskList = PmpmTaskUtil.updateAllTaskEndTime(taskArr, prior);
        DynamicObject[] afterUpdateEndTimeTaskArr = afterUpdateEndTimeTaskList.toArray(new DynamicObject[afterUpdateEndTimeTaskList.size()]);
        if (prior == 2) {
            SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
            return;
        }
        for (int i = 0; i < afterUpdateEndTimeTaskList.size(); ++i) {
            PmpmTaskUtil.updataAfterTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i]);
            PmpmTaskUtil.updateParentTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i]);
        }
        SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
    }

    public static Set<Object> getTaskIdSetByOrgId(Object orgId) {
        DynamicObject[] presonPlanArr;
        DynamicObject task;
        HashSet<Object> taskIdSet = new HashSet<Object>();
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"C");
        QFilter orgFilter = new QFilter("org", "=", orgId);
        DynamicObject[] deptPlanArr = BusinessDataServiceHelper.load((String)"pmpm_deptplan", (String)"id,org,billstatus,taskentity,taskentity.isimport,taskentity.taskid,taskentity.taskname,taskentity.taskname.project", (QFilter[])new QFilter[]{billStatusFilter, orgFilter});
        if (deptPlanArr != null && deptPlanArr.length > 0) {
            for (DynamicObject deptPlan : deptPlanArr) {
                DynamicObjectCollection taskEntryCol = deptPlan.getDynamicObjectCollection("taskentity");
                if (taskEntryCol == null || taskEntryCol.size() <= 0) continue;
                for (DynamicObject taskEntry : taskEntryCol) {
                    DynamicObject project;
                    boolean isImport = taskEntry.getBoolean("isimport");
                    if (isImport || (task = taskEntry.getDynamicObject("taskname")) == null || (project = task.getDynamicObject("project")) != null) continue;
                    taskIdSet.add(taskEntry.get("taskid"));
                }
            }
        }
        if ((presonPlanArr = BusinessDataServiceHelper.load((String)"pmpm_personplan", (String)"id,org,billstatus,entryentity,entryentity.task,entryentity.taskname,entryentity.taskname.status", (QFilter[])new QFilter[]{billStatusFilter, orgFilter})) != null && presonPlanArr.length > 0) {
            for (DynamicObject personPlan : presonPlanArr) {
                DynamicObjectCollection taskEntryCol = personPlan.getDynamicObjectCollection("entryentity");
                if (taskEntryCol == null || taskEntryCol.size() <= 0) continue;
                for (DynamicObject dynamicObject : taskEntryCol) {
                    String status;
                    task = dynamicObject.getDynamicObject("task");
                    if (task == null || StringUtils.equals((CharSequence)"C", (CharSequence)(status = task.getString("status")))) continue;
                    taskIdSet.add(task.getPkValue());
                }
            }
        }
        return taskIdSet;
    }

    public static Set<Object> getParentAndAfterTaskIdSet(DynamicObject currentTask) {
        HashSet<Object> idSet = new HashSet<Object>();
        DynamicObject project = currentTask.getDynamicObject("project");
        QFilter projectFilter = null;
        if (project != null) {
            projectFilter = new QFilter("project", "=", project.getPkValue());
        }
        DynamicObject[] sameProjectTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name,parent,pretask", (QFilter[])new QFilter[]{projectFilter});
        PmpmTaskUtil.getAfterTaskIdSet(sameProjectTaskArr, idSet, currentTask);
        PmpmTaskUtil.getParentIdSet(sameProjectTaskArr, idSet, currentTask);
        return idSet;
    }

    private static void getParentIdSet(DynamicObject[] referTaskArr, Set<Object> idSet, DynamicObject currentTask) {
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask == null) {
            return;
        }
        for (int i = 0; i < referTaskArr.length; ++i) {
            if (!parentTask.getPkValue().equals(referTaskArr[i].getPkValue())) continue;
            idSet.add(referTaskArr[i].getPkValue());
            PmpmTaskUtil.getAfterTaskIdSet(referTaskArr, idSet, referTaskArr[i]);
            if (referTaskArr[i].getDynamicObject("parent") == null) continue;
            PmpmTaskUtil.getParentIdSet(referTaskArr, idSet, referTaskArr[i]);
        }
    }

    private static void getAfterTaskIdSet(DynamicObject[] referTaskArr, Set<Object> idSet, DynamicObject currentTask) {
        for (int i = 0; i < referTaskArr.length; ++i) {
            DynamicObject preTaskOfReferTask = referTaskArr[i].getDynamicObject("pretask");
            if (preTaskOfReferTask == null) continue;
            Object preTaskId = preTaskOfReferTask.getPkValue();
            if (!currentTask.getPkValue().equals(preTaskId)) continue;
            idSet.add(referTaskArr[i].getPkValue());
            if (referTaskArr[i].getDynamicObject("parent") != null) {
                PmpmTaskUtil.getParentIdSet(referTaskArr, idSet, referTaskArr[i]);
            }
            PmpmTaskUtil.getAfterTaskIdSet(referTaskArr, idSet, referTaskArr[i]);
        }
    }

    public static void cleanPreTaskAndLogicalWhereDelTask(Object taskId) {
        QFilter preTaskFilter = new QFilter("pretask", "=", taskId);
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name,pretask,logical", (QFilter[])new QFilter[]{preTaskFilter});
        if (taskArr != null && taskArr.length > 0) {
            for (int i = 0; i < taskArr.length; ++i) {
                taskArr[i].set("pretask", null);
                taskArr[i].set("logical", null);
            }
            SaveServiceHelper.save((DynamicObject[])taskArr);
        }
    }

    public static void cleanParentPreTaskAndlogical(DynamicObject task) {
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        String planType = belongPlanType.getString("plantype");
        DynamicObject parent = task.getDynamicObject("parent");
        if (parent != null) {
            DynamicObject newParent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmpm_task");
            DynamicObject parentBelongPlanType = newParent.getDynamicObject("belongplantype");
            String parentPlanType = parentBelongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.MAJORPLAN.getValue()) && StringUtils.equals((CharSequence)parentPlanType, (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
                return;
            }
            if (newParent.get("pretask") != null || StringUtils.isNotBlank((CharSequence)newParent.getString("logical"))) {
                newParent.set("pretask", null);
                newParent.set("logical", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newParent});
            }
        }
    }

    public static void clenParentPreTaskAndLogical(DynamicObjectCollection taskCol) {
        if (taskCol == null || taskCol.size() == 0) {
            return;
        }
        HashSet<Object> parentIdSet = new HashSet<Object>();
        for (DynamicObject dynamicObject : taskCol) {
            DynamicObject parent = dynamicObject.getDynamicObject("parent");
            if (parent == null) continue;
            parentIdSet.add(parent.getPkValue());
        }
        QFilter idFilter = new QFilter("id", "in", parentIdSet);
        DynamicObject[] parentArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name,pretask,logical", (QFilter[])new QFilter[]{idFilter});
        ArrayList<DynamicObject> newParentList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < parentArr.length; ++i) {
            if (parentArr[i].get("pretask") != null || StringUtils.isNotBlank((CharSequence)parentArr[i].getString("logical"))) {
                parentArr[i].set("pretask", null);
                parentArr[i].set("logical", null);
            }
            newParentList.add(parentArr[i]);
        }
        if (newParentList != null && newParentList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newParentList.toArray(new DynamicObject[newParentList.size()]));
        }
    }

    public static List<DynamicObject> getCalendarDetailList(List<DynamicObject> calList) {
        ArrayList<DynamicObject> projectCalendarDetailList = new ArrayList<DynamicObject>();
        HashSet<Date> individuationDate = new HashSet<Date>();
        for (int i = 0; i < calList.size(); ++i) {
            Date workDate;
            DynamicObjectCollection dateEntry;
            DynamicObject projectCalendar = calList.get(i);
            Boolean isIndividuation = projectCalendar.getBoolean("isindividuation");
            if (isIndividuation.booleanValue()) {
                dateEntry = projectCalendar.getDynamicObjectCollection("dateentry");
                for (DynamicObject dynamicObject : dateEntry) {
                    workDate = dynamicObject.getDate("workdate");
                    individuationDate.add(workDate);
                    projectCalendarDetailList.add(dynamicObject);
                }
                continue;
            }
            dateEntry = projectCalendar.getDynamicObjectCollection("dateentry");
            for (DynamicObject dynamicObject : dateEntry) {
                workDate = dynamicObject.getDate("workdate");
                if (individuationDate.contains(workDate)) continue;
                projectCalendarDetailList.add(dynamicObject);
            }
        }
        Collections.sort(projectCalendarDetailList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date date2;
                Date date1 = o1.getDate("workdate");
                if (date1.after(date2 = o2.getDate("workdate"))) {
                    return 1;
                }
                if (date1.equals(date2)) {
                    return 0;
                }
                return -1;
            }
        });
        return projectCalendarDetailList;
    }

    public static Calendar getFirstDayByOrg(Object orgId) {
        if (orgId != null) {
            DynamicObject orgWorkCal = PmpmTaskUtil.getOrgCalHead(orgId);
            if (orgWorkCal == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u7ea7\u548c\u4e0a\u7ea7\u5747\u672a\u8bbe\u7f6e\u90e8\u95e8\u65e5\u5386\uff0c\u4e5f\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_6", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            }
            int yearFrom = orgWorkCal.getInt("expiringyearfrom");
            int monthFrom = orgWorkCal.getInt("expiringmonthfrom");
            Calendar firstDay = Calendar.getInstance();
            firstDay.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
            return firstDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmpmTaskUtil_7", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    private static DynamicObject getOrgCalHead(Object orgId) {
        String selectCalString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        QFilter orgFilter = new QFilter("org", "=", orgId);
        QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
        DynamicObject orgWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectCalString, (QFilter[])new QFilter[]{orgFilter, isIndividuationFilter});
        if (orgWorkCal == null) {
            List supOrg = OrgUnitServiceHelper.getSuperiorOrgs((String)"15", (long)Long.parseLong(orgId.toString()));
            if (supOrg != null && supOrg.size() > 0 && (Long)supOrg.get(0) != 0L) {
                return PmpmTaskUtil.getOrgCalHead(supOrg.get(0));
            }
            QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
            orgWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectCalString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
            return orgWorkCal;
        }
        return orgWorkCal;
    }

    public static Calendar getEndDayByOrg(Object orgId) {
        if (orgId != null) {
            DynamicObject orgWorkCal = PmpmTaskUtil.getOrgCalHead(orgId);
            if (orgWorkCal == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u7ea7\u548c\u4e0a\u7ea7\u5747\u672a\u8bbe\u7f6e\u90e8\u95e8\u65e5\u5386\uff0c\u4e5f\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_6", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
            }
            int yearTo = orgWorkCal.getInt("expiringyearto");
            int monthTo = orgWorkCal.getInt("expiringmonthto");
            Calendar endDay = Calendar.getInstance();
            endDay.set(yearTo, monthTo - 1, 1, 0, 0, 0);
            endDay.set(yearTo, monthTo - 1, endDay.getActualMaximum(5), 0, 0, 0);
            return endDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmpmTaskUtil_7", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    public static Calendar getFirstDayByProject(Object projectId) {
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (projectId != null) {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
            }
            int yearFrom = projWorkCal.getInt("expiringyearfrom");
            int monthFrom = projWorkCal.getInt("expiringmonthfrom");
            Calendar firstDay = Calendar.getInstance();
            firstDay.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
            return firstDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"PmpmTaskUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    public static Calendar getEndDayByProject(Object projectId) {
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (projectId != null) {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
            }
            int yearTo = projWorkCal.getInt("expiringyearto");
            int monthTo = projWorkCal.getInt("expiringmonthto");
            Calendar endDay = Calendar.getInstance();
            endDay.set(yearTo, monthTo - 1, 1, 0, 0, 0);
            endDay.set(yearTo, monthTo - 1, endDay.getActualMaximum(5), 0, 0, 0);
            return endDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"PmpmTaskUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    public static boolean checkBeforeBeginTimeByHeadData(DynamicObject task, Date time) {
        if (time == null) {
            return false;
        }
        Calendar theTime = Calendar.getInstance();
        theTime.setTime(time);
        DynamicObject project = task.getDynamicObject("project");
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (project != null) {
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
            }
            int yearFrom = projWorkCal.getInt("expiringyearfrom");
            int monthFrom = projWorkCal.getInt("expiringmonthfrom");
            Calendar firstDay = Calendar.getInstance();
            firstDay.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
            return theTime.before(firstDay);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u6ca1\u6709\u6302\u5728\u9879\u76ee\u4e0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmpmTaskUtil_8", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    public static boolean checkAfterEndTimeByHeadData(DynamicObject task, Date time) {
        if (time == null) {
            return false;
        }
        Calendar theTime = Calendar.getInstance();
        theTime.setTime(time);
        DynamicObject project = task.getDynamicObject("project");
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (project != null) {
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u4e14\u6ca1\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"PmpmTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                }
            }
            int yearTo = projWorkCal.getInt("expiringyearto");
            int monthTo = projWorkCal.getInt("expiringmonthto");
            Calendar endDay = Calendar.getInstance();
            endDay.set(yearTo, monthTo - 1, 1, 0, 0, 0);
            endDay.set(yearTo, monthTo - 1, endDay.getActualMaximum(5), 0, 0, 0);
            return theTime.after(endDay);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u6ca1\u6709\u6302\u5728\u9879\u76ee\u4e0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmpmTaskUtil_8", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
    }

    public static DynamicObject getNearestMainPlanParentTask(DynamicObject task) {
        DynamicObject currentTask = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)"pmpm_task");
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask != null) {
            DynamicObject newParentTask = BusinessDataServiceHelper.loadSingle((Object)parentTask.getPkValue(), (String)"pmpm_task");
            DynamicObject parentBelongPlanType = newParentTask.getDynamicObject("belongplantype");
            if (parentBelongPlanType != null) {
                String planType = parentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)planType)) {
                    return newParentTask;
                }
            }
            currentTask = PmpmTaskUtil.getNearestMainPlanParentTask(parentTask);
        }
        return currentTask;
    }

    public static boolean newCheckOutMainTaskTime(DynamicObject task, String timeField, Date newTime) {
        if (newTime == null) {
            return false;
        }
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            boolean isFromDB;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (isFromDB = task.getDataEntityState().getFromDatabase()) && (sourceParentBelongPlanType = (sourceParentTask = PmpmTaskUtil.getNearestMainPlanParentTask(task)).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PmpmTaskUtil_9", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PmpmTaskUtil_10", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
                    }
                }
            }
        }
        return false;
    }

    public static void updateDelTaskByPlanWhenAudit(Object planId) {
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"pmpm_projectplan");
        DynamicObject preChangePlan = plan.getDynamicObject("prechangeplan");
        if (preChangePlan != null) {
            DynamicObjectCollection prePlanTaskEntry;
            HashSet<String> thisPlanTaskIdSet = new HashSet<String>();
            HashSet<String> prePlanTaskIdSet = new HashSet<String>();
            DynamicObjectCollection taskEntry = plan.getDynamicObjectCollection("taskentity");
            if (taskEntry != null) {
                for (Object task : taskEntry) {
                    thisPlanTaskIdSet.add(task.getString("taskid"));
                }
            }
            if ((prePlanTaskEntry = (preChangePlan = BusinessDataServiceHelper.loadSingle((Object)preChangePlan.getPkValue(), (String)"pmpm_projectplan")).getDynamicObjectCollection("taskentity")) != null) {
                for (DynamicObject task : prePlanTaskEntry) {
                    prePlanTaskIdSet.add(task.getString("taskid"));
                }
            }
            prePlanTaskIdSet.removeAll(thisPlanTaskIdSet);
            DynamicObject[] delTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,sourcetask,status", (QFilter[])new QFilter[]{new QFilter("id", "in", prePlanTaskIdSet)});
            if (delTaskArr != null && delTaskArr.length > 0) {
                for (int i = 0; i < delTaskArr.length; ++i) {
                    delTaskArr[i].set("status", (Object)"D");
                }
                SaveServiceHelper.save((DynamicObject[])delTaskArr);
            }
        }
    }

    public static void updateTaskStatusByPlanTime(DynamicObject[] taskArr) {
        Date nowDate = new Date();
        for (int i = 0; i < taskArr.length; ++i) {
            String completeStatus = taskArr[i].getString("completionstatus");
            Date planEndTime = taskArr[i].getDate("planendtime");
            Date planStartTime = taskArr[i].getDate("planstarttime");
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.UNSTART.getValue(), (CharSequence)completeStatus)) {
                int compareResult = DateUtil.compareByDay(planStartTime, nowDate);
                if (compareResult == 1) continue;
                compareResult = DateUtil.compareByDay(planEndTime, nowDate);
                if (compareResult == -1) {
                    taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                    continue;
                }
                taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.PROGRESSING.getValue(), (CharSequence)completeStatus) || StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completeStatus) || StringUtils.equals((CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue(), (CharSequence)completeStatus)) {
                BigDecimal percent = taskArr[i].getBigDecimal("percent");
                if (percent != null && percent.compareTo(BigDecimal.ZERO) > 0) {
                    QFilter lasestFilter = new QFilter("latest", "=", (Object)"1");
                    QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
                    QFilter taskFilter = new QFilter("task", "=", taskArr[i].getPkValue());
                    DynamicObject taskReport = BusinessDataServiceHelper.loadSingle((String)"pmpm_taskreport", (String)"id,completetime", (QFilter[])new QFilter[]{lasestFilter, auditFilter, taskFilter});
                    if (taskReport == null) continue;
                    Date completeTime = taskReport.getDate("completetime");
                    int compareResult = DateUtil.compareByDay(completeTime, planEndTime);
                    if (compareResult > 0) {
                        compareResult = DateUtil.compareByDay(planEndTime, nowDate);
                        if (compareResult == -1) {
                            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                            continue;
                        }
                        taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.ESTIMATEDELAY.getValue());
                        continue;
                    }
                    taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                    continue;
                }
                int compareResult = DateUtil.compareByDay(planStartTime, nowDate);
                if (compareResult != 1) {
                    compareResult = DateUtil.compareByDay(planEndTime, nowDate);
                    if (compareResult == -1) {
                        taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                        continue;
                    }
                    taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                    continue;
                }
                taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                continue;
            }
            if (!StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completeStatus) && !StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completeStatus)) continue;
            Date realEndTime = taskArr[i].getDate("realendtime");
            int compareResult = DateUtil.compareByDay(planEndTime, realEndTime);
            if (compareResult == -1) {
                taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
                continue;
            }
            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
        }
    }
}

