/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.common.utils.task;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.ORM;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;

public class PmptTaskUtil {
    public static DynamicObject createNewTaskReportByTask(DynamicObject task) {
        DynamicObject taskReport = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmpt_taskreport"));
        ORM orm = ORM.create();
        Long id = orm.genLongId("pmpt_taskreport");
        taskReport.set("id", (Object)id);
        taskReport.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        String userId = RequestContext.get().getUserId();
        taskReport.set("creator", (Object)userId);
        taskReport.set("modifier", (Object)userId);
        taskReport.set("auditor", (Object)userId);
        Date date = DateUtil.getCurrentDate();
        taskReport.set("createtime", (Object)date);
        taskReport.set("modifytime", (Object)date);
        taskReport.set("auditdate", (Object)date);
        taskReport.set("iscomplete", (Object)Boolean.TRUE);
        taskReport.set("completetime", (Object)task.getDate("realendtime"));
        taskReport.set("task", task.getPkValue());
        taskReport.set("percent", (Object)100);
        taskReport.set("reportdesc", (Object)ResManager.loadKDString((String)"\u7763\u5bfc\u4efb\u52a1\u5b8c\u6210\u3002", (String)"PmptTaskUtil_0", (String)"pmgt-pmbs-common", (Object[])new Object[0]));
        String name = RequestContext.get().getUserName();
        DynamicObject responsiblePerson = task.getDynamicObject("responsibleperson");
        DynamicObject cooperationPerson = task.getDynamicObject("cooperationperson");
        DynamicObject sharer = task.getDynamicObject("sharer");
        if (null != responsiblePerson && StringUtils.equals((CharSequence)responsiblePerson.getString("id"), (CharSequence)userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u4e3b\u8d23\u4eba\uff09", (String)"PmptTaskUtil_1", (String)"pmgt-pmbs-common", (Object[])new Object[0]), name));
        } else if (null != cooperationPerson && StringUtils.equals((CharSequence)cooperationPerson.getString("id"), (CharSequence)userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u534f\u529e\u4eba\uff09", (String)"PmptTaskUtil_2", (String)"pmgt-pmbs-common", (Object[])new Object[0]), name));
        } else if (null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u5171\u4eab\u4eba\uff09", (String)"PmptTaskUtil_3", (String)"pmgt-pmbs-common", (Object[])new Object[0]), name));
        } else {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u6279\u91cf\u6807\u6ce8\u4eba\uff09", (String)"PmptTaskUtil_4", (String)"pmgt-pmbs-common", (Object[])new Object[0]), name));
        }
        DynamicObjectCollection taskcg = task.getDynamicObjectCollection("taskresultdocentry");
        DynamicObjectCollection taskReportEntry = taskReport.getDynamicObjectCollection("achieveentity");
        if (null != taskcg) {
            long[] cgEntryIds = DB.genLongIds((String)"t_pmpt_taskreportdoc", (int)taskcg.size());
            for (int i = 0; i < taskcg.size(); ++i) {
                DynamicObject cgEntry = new DynamicObject(taskReportEntry.getDynamicObjectType());
                taskReport.getDataEntityType().getPrimaryKey().setValueFast((Object)cgEntry, (Object)cgEntryIds[i]);
                cgEntry.set("seq", (Object)(i + 1));
                cgEntry.set("resultname", ((DynamicObject)taskcg.get(i)).get("resultname"));
                cgEntry.set("force", ((DynamicObject)taskcg.get(i)).get("force"));
                cgEntry.set("desc", ((DynamicObject)taskcg.get(i)).get("resultdescription"));
                cgEntry.set("frequency", ((DynamicObject)taskcg.get(i)).get("frequency"));
                cgEntry.set("resultid", ((DynamicObject)taskcg.get(i)).getPkValue());
                taskReportEntry.add(i, cgEntry);
            }
        }
        return taskReport;
    }
}

