/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.mservice.impl.budget;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.pmgt.pmbs.common.budget.BudgetParam;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateBean;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateResult;
import kd.pmgt.pmbs.mservice.impl.budget.BudgetSupportServiceImpl;

public class BudgetBizServiceImpl {
    public void updateBudget(BudgetParam budgetParam) {
        new BudgetSupportServiceImpl(budgetParam).updateBudget();
    }

    public void returnBudget(Map<String, Object> budgetUpdateParam) {
        new BudgetSupportServiceImpl(null).returnBudget(budgetUpdateParam);
    }

    public BudgetValidateResult validateBudget(BudgetParam budgetParam) {
        List<BudgetValidateBean> validateBeanList = new BudgetSupportServiceImpl(budgetParam).validateBudget();
        return this.analysisValidateInfo(validateBeanList);
    }

    protected BudgetValidateResult analysisValidateInfo(List<BudgetValidateBean> validateBeanList) {
        BudgetValidateResult budgetValidateResult = new BudgetValidateResult();
        StringBuilder msg = new StringBuilder();
        boolean strongControl = false;
        boolean weakControl = false;
        for (BudgetValidateBean validate : validateBeanList) {
            if (!validate.isBudgetCtrl()) continue;
            if (!strongControl) {
                strongControl = validate.isStrongControl();
            }
            if (weakControl) continue;
            weakControl = validate.isWeakControl();
        }
        budgetValidateResult.setOutOfRemind(weakControl);
        budgetValidateResult.setOutOfControl(strongControl);
        ArrayList<String> tipList = new ArrayList<String>();
        if (strongControl) {
            for (BudgetValidateBean validate : validateBeanList) {
                if (!validate.isBudgetCtrl() || !validate.isStrongControl() || tipList.contains(validate.getResultMsg())) continue;
                tipList.add(validate.getResultMsg());
                msg.append(validate.getResultMsg());
                msg.append("\r\n");
            }
        } else if (weakControl) {
            for (BudgetValidateBean validate : validateBeanList) {
                if (!validate.isBudgetCtrl() || !validate.isWeakControl() || tipList.contains(validate.getResultMsg())) continue;
                tipList.add(validate.getResultMsg());
                msg.append(validate.getResultMsg());
                msg.append("\r\n");
            }
        }
        budgetValidateResult.setMsg(msg.toString());
        return budgetValidateResult;
    }
}

