/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.mservice.impl.budget;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.budget.ProjectCloudFunctionHelper;
import kd.pmgt.pmbs.common.budget.BudgetParam;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateResult;
import kd.pmgt.pmbs.mservice.budget.ProjectBudgetService;
import kd.pmgt.pmbs.mservice.impl.budget.BudgetBizServiceImpl;

public class ProjectBudgetServiceImpl
implements ProjectBudgetService {
    private static final Log logger = LogFactory.getLog(ProjectBudgetServiceImpl.class);

    public Object validateBudget(DynamicObject bill, String operation) {
        BudgetValidateResult result = new BudgetValidateResult();
        BudgetParam budgetParam = this.initBudgetParam(bill, operation);
        if (budgetParam == null) {
            result.setOutOfControl(false);
            result.setOutOfRemind(false);
            return result;
        }
        result = new BudgetBizServiceImpl().validateBudget(budgetParam);
        return result;
    }

    public Object updateBudget(DynamicObject bill, String operation) {
        try (TXHandle h = TX.requiresNew();){
            BudgetParam budgetUpdateParam = this.initBudgetParam(bill, operation);
            if (budgetUpdateParam == null) {
                Object var6_9 = null;
                return var6_9;
            }
            try {
                new BudgetBizServiceImpl().updateBudget(budgetUpdateParam);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        return null;
    }

    public Object returnBudget(DynamicObject bill, Long projectId, Long proBudgetId, Long entryId, BigDecimal amount, Date period) {
        try (TXHandle h = TX.requiresNew();){
            HashMap<String, Object> budgetUpdateParam = new HashMap<String, Object>();
            String entityNumber = bill.getDataEntityType().getName();
            QFilter filter = new QFilter("fieldtable", "=", (Object)entityNumber);
            DynamicObject[] regBillData = BusinessDataServiceHelper.load((String)"pmbs_structofbill", (String)"", (QFilter[])new QFilter[]{filter});
            if (regBillData == null || regBillData.length == 0) {
                Object var13_16 = null;
                return var13_16;
            }
            ProjectCloudFunctionHelper projectCloudFunctionHelper = new ProjectCloudFunctionHelper();
            DynamicObject[] regBillDataInfo = BusinessDataServiceHelper.load((Object[])Arrays.stream(regBillData).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_structofbill"));
            DynamicObject regBillInfo = null;
            int matchCount = 0;
            for (DynamicObject reg : regBillDataInfo) {
                String formulaJson = reg.getString("formulajson");
                if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
                    Boolean result = projectCloudFunctionHelper.checkFunctionCondition(formulaJson, bill);
                    if (!result.booleanValue()) continue;
                    regBillInfo = reg;
                    ++matchCount;
                    continue;
                }
                regBillInfo = reg;
                ++matchCount;
            }
            if (regBillInfo == null) {
                DynamicObject[] dynamicObjectArray = null;
                return dynamicObjectArray;
            }
            try {
                if (matchCount > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5728\u63a7\u5236\u5355\u636e\u6ce8\u518c\u4e2d\u5b58\u5728\u591a\u4e2a\u7b26\u5408\u51c6\u5165\u6761\u4ef6\u7684\u914d\u7f6e\u3002", (String)"ProjectBudgetServiceImpl_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]), bill.getDynamicObjectType().getDisplayName().getLocaleValue()));
                }
                String budgetTarget = regBillInfo.getString("controltarget");
                budgetUpdateParam.put("budgetTarget", budgetTarget);
                budgetUpdateParam.put("bill", bill);
                budgetUpdateParam.put("projectId", projectId);
                budgetUpdateParam.put("proBudgetId", proBudgetId);
                budgetUpdateParam.put("entryId", entryId);
                budgetUpdateParam.put("amount", amount);
                budgetUpdateParam.put("period", period);
                new BudgetBizServiceImpl().returnBudget(budgetUpdateParam);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        return null;
    }

    public BudgetParam initBudgetParam(DynamicObject entity, String operationKey) {
        String entityNumber = entity.getDataEntityType().getName();
        QFilter filter = new QFilter("fieldtable", "=", (Object)entityNumber);
        DynamicObject[] regBillData = BusinessDataServiceHelper.load((String)"pmbs_structofbill", (String)"", (QFilter[])new QFilter[]{filter});
        if (regBillData == null || regBillData.length == 0) {
            return null;
        }
        ProjectCloudFunctionHelper projectCloudFunctionHelper = new ProjectCloudFunctionHelper();
        DynamicObject[] regBillDataInfo = BusinessDataServiceHelper.load((Object[])Arrays.stream(regBillData).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_structofbill"));
        DynamicObject regBillInfo = null;
        int matchCount = 0;
        for (DynamicObject reg : regBillDataInfo) {
            String formulaJson = reg.getString("formulajson");
            if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
                String formId;
                if (formulaJson.contains("GetSrcEntityNumber()") && !QueryServiceHelper.exists((String)(formId = entity.getDynamicObjectType().getName()), (Object)entity.getPkValue())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7684\u9884\u7b97\u6ce8\u518c\u542f\u52a8\u6761\u4ef6\u5b58\u5728\u201c\u83b7\u53d6\u6e90\u5355\u5b9e\u4f53\u6807\u8bc6\u201d\uff0c\u9700\u5148\u4fdd\u5b58\u3002", (String)"ProjectBudgetServiceImpl_4", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
                }
                Boolean result = projectCloudFunctionHelper.checkFunctionCondition(formulaJson, entity);
                if (!result.booleanValue()) continue;
                regBillInfo = reg;
                ++matchCount;
                continue;
            }
            regBillInfo = reg;
            ++matchCount;
        }
        if (regBillInfo == null) {
            return null;
        }
        if (matchCount > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5728\u63a7\u5236\u5355\u636e\u6ce8\u518c\u4e2d\u5b58\u5728\u591a\u4e2a\u7b26\u5408\u51c6\u5165\u6761\u4ef6\u7684\u914d\u7f6e\u3002", (String)"ProjectBudgetServiceImpl_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]), entity.getDynamicObjectType().getDisplayName().getLocaleValue()));
        }
        List fieldTypeEnums = BillFieldTypeEnum.getEnumsByType((String)"field");
        filter = new QFilter("fieldtable", "=", (Object)entityNumber).and("bizunitid", "=", regBillInfo.getPkValue()).and("type", "in", fieldTypeEnums.stream().map(BillFieldTypeEnum::getNumber).collect(Collectors.toSet()));
        DynamicObject[] regData = BusinessDataServiceHelper.load((String)"pmbs_bgcontrolbizreg", (String)"", (QFilter[])new QFilter[]{filter});
        if (regData == null || regData.length == 0) {
            return null;
        }
        DynamicObject[] bgControlBizRegArray = BusinessDataServiceHelper.load((Object[])Arrays.stream(regData).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bgcontrolbizreg"));
        Operation entityOperation = null;
        if (operationKey != null) {
            entityOperation = this.getEntityOperation(entity, operationKey);
        }
        String budgetAction = this.getBudgetAction(entityNumber, operationKey);
        return new BudgetParam(regBillInfo, bgControlBizRegArray, entity, entityOperation, budgetAction);
    }

    private Operation getEntityOperation(DynamicObject entity, String operationKey) {
        Operation op = new Operation();
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entity.getDynamicObjectType().getName());
        for (Map item : dataEntityOperate) {
            String opKey = item.get("key").toString();
            if (!operationKey.equalsIgnoreCase(opKey)) continue;
            LocaleString opName = new LocaleString();
            Object name = item.get("name");
            if (name instanceof LinkedHashMap) {
                LinkedHashMap nameMap = (LinkedHashMap)name;
                for (Map.Entry it : nameMap.entrySet()) {
                    String langKey = (String)it.getKey();
                    opName.setItem(langKey, it.getValue());
                }
            }
            op.setKey(opKey);
            op.setName(opName);
            break;
        }
        return op;
    }

    protected String getBudgetAction(String entityNumber, String operationKey) {
        if ("queryProjectBudget".equalsIgnoreCase(operationKey)) {
            QFilter objectTypeFilter = new QFilter("objecttype", "=", (Object)entityNumber);
            DynamicObject opBizRuleSet = BusinessDataServiceHelper.loadSingle((String)"bos_opbizruleset", (String)"", (QFilter[])new QFilter[]{objectTypeFilter});
            if (opBizRuleSet == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u672a\u8fdb\u884c\u9884\u7b97\u6ce8\u518c\u914d\u7f6e\uff0c\u65e0\u6cd5\u8fdb\u884c\u9884\u7b97\u67e5\u770b\u3002\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\u3002", (String)"ProjectBudgetServiceImpl_2", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
            }
            return operationKey;
        }
        QFilter objectTypeFilter = new QFilter("objecttype", "=", (Object)entityNumber);
        QFilter operationFilter = new QFilter("entryentity.operationkey", "=", (Object)operationKey);
        QFilter opBizRuleFilter = new QFilter("opbizrule", "in", Arrays.asList("requestProjectBudget", "execProjectBudget", "returnProjectBudget", "clearProjectBudget", "returnAndClearProjectBudget", "requestAndExecProjectBudget"));
        DynamicObject opBizRuleSet = BusinessDataServiceHelper.loadSingle((String)"bos_opbizruleset", (String)"opbizrule", (QFilter[])new QFilter[]{objectTypeFilter, operationFilter, opBizRuleFilter});
        if (opBizRuleSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9884\u7b97\u6263\u51cf\u64cd\u4f5c\u3002", (String)"ProjectBudgetServiceImpl_1", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return opBizRuleSet.getString("opbizrule");
    }
}

