/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.mservice.impl.budget;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.business.budget.ProjectBudgetUpdateServiceImpl;
import kd.pmgt.pmbs.business.budget.ProjectBudgetValidateServiceImpl;
import kd.pmgt.pmbs.common.budget.BudgetParam;
import kd.pmgt.pmbs.common.budget.BudgetRegValue;
import kd.pmgt.pmbs.common.budget.CommonBudgetParam;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateBean;
import kd.pmgt.pmbs.mservice.impl.budget.AbstractBudgetControlHandler;

public class ProjectBudgetSupportServiceImpl
extends AbstractBudgetControlHandler {
    private static final Log logger = LogFactory.getLog(ProjectBudgetSupportServiceImpl.class);

    public ProjectBudgetSupportServiceImpl(CommonBudgetParam commonBudgetParam, List<BudgetRegValue> budgetRegValues) {
        this.commonBudgetParam = commonBudgetParam;
        this.budgetRegValues = budgetRegValues;
    }

    @Override
    public void updateBudget() {
        ProjectBudgetUpdateServiceImpl projectBudgetService = new ProjectBudgetUpdateServiceImpl();
        BudgetParam budgetParam = (BudgetParam)this.commonBudgetParam;
        String controlTarget = budgetParam.regBillInfo.getString("controltarget");
        BudgetControlTargetEnum controlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)controlTarget);
        if (controlTargetEnum.getValue().equalsIgnoreCase(BudgetControlTargetEnum.BUDGETOCCUPY.getValue())) {
            switch (budgetParam.budgetAction) {
                case "requestProjectBudget": {
                    projectBudgetService.occupyOccupy(budgetParam);
                    break;
                }
                case "execProjectBudget": {
                    projectBudgetService.occupyEffect(budgetParam);
                    break;
                }
                case "returnProjectBudget": {
                    projectBudgetService.occupyReturn(budgetParam);
                    break;
                }
                case "clearProjectBudget": {
                    projectBudgetService.occupyRelease(budgetParam);
                    break;
                }
                case "requestAndExecProjectBudget": {
                    projectBudgetService.occupyOccupy(budgetParam);
                    projectBudgetService.occupyEffect(budgetParam);
                    break;
                }
                case "returnAndClearProjectBudget": {
                    projectBudgetService.occupyReturn(budgetParam);
                    projectBudgetService.occupyRelease(budgetParam);
                    break;
                }
            }
        } else if (controlTargetEnum.getValue().equalsIgnoreCase(BudgetControlTargetEnum.BUDGETUSE.getValue())) {
            switch (budgetParam.budgetAction) {
                case "requestProjectBudget": {
                    projectBudgetService.executeOccupy(budgetParam);
                    break;
                }
                case "execProjectBudget": {
                    projectBudgetService.executeEffect(budgetParam);
                    break;
                }
                case "returnProjectBudget": {
                    projectBudgetService.executeReturn(budgetParam);
                    break;
                }
                case "clearProjectBudget": {
                    projectBudgetService.executeRelease(budgetParam);
                    break;
                }
                case "requestAndExecProjectBudget": {
                    projectBudgetService.executeOccupy(budgetParam);
                    projectBudgetService.executeEffect(budgetParam);
                    break;
                }
                case "returnAndClearProjectBudget": {
                    projectBudgetService.executeReturn(budgetParam);
                    projectBudgetService.executeRelease(budgetParam);
                    break;
                }
            }
        } else {
            switch (budgetParam.budgetAction) {
                case "requestProjectBudget": {
                    projectBudgetService.occupyOccupy(budgetParam);
                    projectBudgetService.occupyEffect(budgetParam);
                    projectBudgetService.executeOccupy(budgetParam);
                    break;
                }
                case "execProjectBudget": {
                    projectBudgetService.executeEffect(budgetParam);
                    break;
                }
                case "returnProjectBudget": {
                    projectBudgetService.executeReturn(budgetParam);
                    break;
                }
                case "clearProjectBudget": {
                    projectBudgetService.executeRelease(budgetParam);
                    projectBudgetService.occupyReturn(budgetParam);
                    projectBudgetService.occupyRelease(budgetParam);
                    break;
                }
                case "requestAndExecProjectBudget": {
                    projectBudgetService.occupyOccupy(budgetParam);
                    projectBudgetService.occupyEffect(budgetParam);
                    projectBudgetService.executeOccupy(budgetParam);
                    projectBudgetService.executeEffect(budgetParam);
                    break;
                }
                case "returnAndClearProjectBudget": {
                    projectBudgetService.executeReturn(budgetParam);
                    projectBudgetService.executeRelease(budgetParam);
                    projectBudgetService.occupyReturn(budgetParam);
                    projectBudgetService.occupyRelease(budgetParam);
                    break;
                }
            }
        }
    }

    @Override
    public void returnBudget(Map<String, Object> budgetUpdateParam) {
        Object budgetTarget = budgetUpdateParam.get("budgetTarget");
        if (budgetTarget == null) {
            return;
        }
        ProjectBudgetUpdateServiceImpl projectBudgetService = new ProjectBudgetUpdateServiceImpl();
        BudgetControlTargetEnum controlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)budgetTarget.toString());
        if (controlTargetEnum.getValue().equalsIgnoreCase(BudgetControlTargetEnum.BUDGETOCCUPY.getValue())) {
            projectBudgetService.executeReturnOccupyBudget(budgetUpdateParam);
        } else if (controlTargetEnum.getValue().equalsIgnoreCase(BudgetControlTargetEnum.BUDGETUSE.getValue())) {
            projectBudgetService.executeReturnUsageBudget(budgetUpdateParam);
        } else {
            projectBudgetService.executeReturnOccupyBudget(budgetUpdateParam);
            projectBudgetService.executeReturnUsageBudget(budgetUpdateParam);
        }
    }

    @Override
    protected List<BudgetValidateBean> validateBudget() {
        List<Object> validateBeanList = new ArrayList<BudgetValidateBean>();
        ProjectBudgetValidateServiceImpl projectBudgetValidateService = new ProjectBudgetValidateServiceImpl();
        BudgetParam budgetParam = (BudgetParam)this.commonBudgetParam;
        String controlTarget = budgetParam.regBillInfo.getString("controltarget");
        BudgetControlTargetEnum controlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)controlTarget);
        if (controlTargetEnum.getValue().equalsIgnoreCase(BudgetControlTargetEnum.BUDGETOCCUPY.getValue())) {
            switch (budgetParam.budgetAction) {
                case "requestProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkOccupyBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
                case "execProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkOccupyBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
                case "requestAndExecProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkOccupyBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
            }
        } else if (controlTargetEnum.getValue().equalsIgnoreCase(BudgetControlTargetEnum.BUDGETUSE.getValue())) {
            switch (budgetParam.budgetAction) {
                case "requestProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkAvailableBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
                case "execProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkAvailableBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
                case "requestAndExecProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkAvailableBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
            }
        } else {
            switch (budgetParam.budgetAction) {
                case "requestProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkOccupyBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
                case "execProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkAvailableBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
                case "requestAndExecProjectBudget": {
                    validateBeanList = projectBudgetValidateService.checkAvailableBalance((BudgetParam)this.commonBudgetParam);
                    break;
                }
            }
        }
        return validateBeanList;
    }
}

