/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.mservice.impl.invoicecloud;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.business.invoicecloud.IFrameParam;
import kd.pmgt.pmbs.business.invoicecloud.ImportInvoiceParam;
import kd.pmgt.pmbs.business.invoicecloud.exception.InvoiceCloudException;
import kd.pmgt.pmbs.common.utils.invoicecloud.InvoiceCloudConfigHelper;
import kd.pmgt.pmbs.common.utils.invoicecloud.MD5;
import kd.pmgt.pmbs.mservice.impl.invoicecloud.InvoiceForPCService;

public class InvoiceForPCServiceImpl
implements InvoiceForPCService {
    private static final Log log = LogFactory.getLog(InvoiceForPCServiceImpl.class);
    private static final Random rand = new SecureRandom();

    public IFrameParam getFrameParam(ImportInvoiceParam params, IFormView formView) throws InvoiceCloudException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        DynamicObject cfg = params.getInvoiceCloudConfig();
        Map<String, String> urlParams = this.getInvoicePCPageCommonParams(cfg, timestamp);
        urlParams.put("billNumber", params.getBillNo());
        urlParams.put("serialNo", "0");
        urlParams.put("ticketParam", "11111");
        urlParams.put("indexType", "kingdeecq000");
        urlParams.put("bxd_key", (String)StringUtils.defaultIfBlank((CharSequence)params.getBillId(), (CharSequence)"0"));
        urlParams.put("linkKey", linkKey);
        urlParams.put("gridParam", "1111");
        String companyName = (String)StringUtils.defaultIfBlank((CharSequence)params.getOrg().getLocaleString("name").getLocaleValue(), (CharSequence)"no company name");
        try {
            urlParams.put("ghf_mc", URLEncoder.encode(companyName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.info("getFrameParam:companyName [{}]", (Object)companyName);
        }
        String trdURL = InvoiceCloudConfigHelper.getViewUrl();
        String url = trdURL + "?" + this.transferMapToUrlParam(urlParams);
        log.info("getFrameParam:url: {}", (Object)url);
        Map<String, String> requestParams = this.getInvoicePCPageSocketParams(cfg, timestamp, linkKey, formView.getPageId());
        requestParams.put("actionType", "selectInvoice");
        String socketUrl = this.getCtxPath() + "/ws.html?" + this.transferMapToUrlParam(requestParams);
        log.info("getFrameParam:socketUrl: {}", (Object)socketUrl);
        IFrameParam iframeParam = new IFrameParam();
        iframeParam.setUrl(url);
        iframeParam.setSocketUrl(socketUrl);
        return iframeParam;
    }

    private Map<String, String> getInvoicePCPageSocketParams(DynamicObject cfg, String timestamp, String linkKey, String pageId) {
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String client_id = cfg.getString("client_id");
        String client_secret = cfg.getString("client_secret");
        String taxRegNum = cfg.getString("taxregnum");
        HashMap<String, String> urlParams = new HashMap<String, String>(10);
        urlParams.put("timestamp", String.valueOf(timestamp));
        urlParams.put("client_id", client_id);
        urlParams.put("tin", taxRegNum);
        String rawSign = client_id + client_secret + timestamp;
        urlParams.put("sign", MD5.md5crypt((String)rawSign));
        urlParams.put("eid", userId);
        urlParams.put("pageid", pageId);
        urlParams.put("clientType", "pc");
        urlParams.put("linkKey", linkKey);
        urlParams.put("env", InvoiceCloudConfigHelper.getEnv());
        return urlParams;
    }

    private String getCtxPath() {
        return RequestContext.get().getClientFullContextPath() + "invoicecloud";
    }

    private Map<String, String> getInvoicePCPageCommonParams(DynamicObject cfg, String timestamp) {
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String client_id = cfg.getString("client_id");
        String client_secret = cfg.getString("client_secret");
        String taxRegNum = cfg.getString("taxregnum");
        HashMap<String, String> urlParams = new HashMap<String, String>(10);
        urlParams.put("timestamp", timestamp);
        urlParams.put("client_id", client_id);
        urlParams.put("tin", taxRegNum);
        String rawSign = client_id + client_secret + taxRegNum + userId + timestamp;
        urlParams.put("sign", MD5.md5crypt((String)rawSign));
        urlParams.put("eid", userId);
        urlParams.put("random", String.valueOf(rand.nextInt(Integer.MAX_VALUE)));
        return urlParams;
    }

    private String transferMapToUrlParam(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
    }
}

